/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.app.ExpansionChange;
import org.systemsbiology.biotapestry.app.PopupTree;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.BuildInstructionInstance;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotif;
import org.systemsbiology.biotapestry.cmd.DialogBuiltMotifPair;
import org.systemsbiology.biotapestry.cmd.DialogBuiltProtoMotif;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.ModificationCommands;
import org.systemsbiology.biotapestry.cmd.NavTreeChangeCmd;
import org.systemsbiology.biotapestry.cmd.OldPadMapper;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.cmd.PropChangeCmd;
import org.systemsbiology.biotapestry.cmd.TimeCourseChangeCmd;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FullGenomeHierarchyOracle;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.NavTreeChange;
import org.systemsbiology.biotapestry.timeCourse.GroupUsage;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseChange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.DataLocator;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.InstanceEngine;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutDerivation;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LayoutRubberStamper;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.ui.RectangularTreeEngine;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.dialogs.DevelopmentSpecDialog;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.ui.layouts.GenomeSubset;
import org.systemsbiology.biotapestry.ui.layouts.NetModuleLinkExtractor;
import org.systemsbiology.biotapestry.ui.layouts.SpecialtyLayoutEngine;
import org.systemsbiology.biotapestry.ui.layouts.StackedBlockLayout;
import org.systemsbiology.biotapestry.util.AffineCombination;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.BackgroundWorker;
import org.systemsbiology.biotapestry.util.BackgroundWorkerClient;
import org.systemsbiology.biotapestry.util.BackgroundWorkerControlManager;
import org.systemsbiology.biotapestry.util.BackgroundWorkerOwner;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.ModelNodeIDPair;
import org.systemsbiology.biotapestry.util.NodeRegionModelNameTuple;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.systemsbiology.biotapestry.util.UndoSupport;
import org.systemsbiology.biotapestry.util.Vector2D;

public class ToolCommands {
    JFrame topWindow_;
    UndoManager undom_;
    CommonView suw_;
    private static final int ENTRY_MAP_ONLY_ = 0;
    private static final int SOURCE_MAP_ONLY_ = 1;
    private static final int ENTRY_AND_SOURCE_MAPS_ = 2;

    public ToolCommands(JFrame topWindow, CommonView suw, UndoManager undo) {
        this.topWindow_ = topWindow;
        this.undom_ = undo;
        this.suw_ = suw;
    }

    public boolean addNewQPCRGenesToRootInstances(SUPanel sup, Point2D center, Dimension size, int sliceMode, FontRenderContext frc) {
        if (sliceMode == -1) {
            return false;
        }
        ModificationCommands mc = new ModificationCommands();
        Map globalPadNeeds = mc.getGlobalNetModuleLinkPadNeeds(frc);
        UndoSupport support = new UndoSupport(this.undom_, "undo.addNewQPCRGenesToRootInstances");
        Object mcev = null;
        Object gcev = null;
        Database db = Database.getDB();
        Genome dbg = db.getGenome();
        TimeCourseData tcd = db.getTimeCourseData();
        List sugg = tcd.getRootInstanceSuggestions(sliceMode, null);
        NavTree nt = db.getNavTree();
        JTree tree = this.suw_.getTree();
        DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)dtm.getRoot();
        HashMap newNodeTypes = new HashMap();
        HashMap instanceContents = new HashMap();
        Iterator sit = sugg.iterator();
        while (sit.hasNext()) {
            TimeCourseData.RootInstanceSuggestions ris = (TimeCourseData.RootInstanceSuggestions)sit.next();
            String nextKey = db.getNextKey();
            GenomeInstance gi = new GenomeInstance(ris.heavyToString(), nextKey, null);
            GenomeChange gc = gi.setTimes(ris.minTime, ris.maxTime);
            db.addGenomeInstanceExistingLabel(nextKey, gi);
            String nextloKey = db.getNextKey();
            Layout lo = new Layout(nextloKey, nextKey);
            db.addLayout(nextloKey, lo);
            NavTreeChange ntc = nt.addNode(ris.heavyToString(), null, nextKey);
            dtm.nodeStructureChanged(rootNode);
            HashMap<String, Set> regions = new HashMap<String, Set>();
            instanceContents.put(nextKey, regions);
            int count = 0;
            Iterator rit = ris.regions.iterator();
            while (rit.hasNext()) {
                String region = (String)rit.next();
                Point2D.Double groupCenter = new Point2D.Double(400.0 * (double)(++count), 500.0);
                String regionKey = this.buildRegion(gi, lo, region, groupCenter, support);
                HashSet regionMembers = new HashSet();
                Iterator tiit = ris.times.iterator();
                while (tiit.hasNext()) {
                    int time = (Integer)tiit.next();
                    tcd.getExpressedGenes(region, time, 2, regionMembers);
                }
                Set newNodeIDs = this.processExpressedGenes(regionMembers, newNodeTypes, support);
                regions.put(regionKey, newNodeIDs);
            }
        }
        DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(0);
        Object[] tn = rootChild.getPath();
        TreePath tp = new TreePath(tn);
        tree.expandPath(tp);
        tree.setSelectionPath(tp);
        RectangularTreeEngine ce = new RectangularTreeEngine();
        String[] positions = ce.layout(newNodeTypes.keySet(), dbg.getID(), false);
        String genomeKey = dbg.getID();
        int posNum = positions.length;
        for (int i = 0; i < posNum; ++i) {
            String geneID = positions[i];
            boolean first = true;
            NodeProperties np = null;
            Iterator loit = db.getLayoutIterator();
            while (loit.hasNext()) {
                Layout lo = (Layout)loit.next();
                String loTarg = lo.getTarget();
                if (!loTarg.equals(genomeKey)) continue;
                int nodeType = (Integer)newNodeTypes.get(geneID);
                if (first) {
                    Point2D loc = ce.placePoint(i, positions, center, size, 0);
                    np = new NodeProperties(lo, nodeType, geneID, loc.getX(), loc.getY(), false);
                    first = false;
                }
                Layout.PropChange[] lpc = new Layout.PropChange[]{lo.setNodeProperties(geneID, new NodeProperties(np, lo, nodeType))};
                if (lpc[0] == null) continue;
                PropChangeCmd pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
                LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
                support.addEvent(lcev);
            }
        }
        AddCommands ac = new AddCommands(this.topWindow_, this.undom_);
        Layout lo = db.getLayout(new LayoutManager().getLayout(genomeKey));
        Iterator giit = instanceContents.keySet().iterator();
        while (giit.hasNext()) {
            String gikey = (String)giit.next();
            GenomeInstance gi = (GenomeInstance)db.getGenome(gikey);
            HashMap regions = (HashMap)instanceContents.get(gikey);
            Iterator reit = regions.keySet().iterator();
            while (reit.hasNext()) {
                String grKey = (String)reit.next();
                Group group = gi.getGroup(grKey);
                HashSet nodes = (HashSet)regions.get(grKey);
                Iterator nit = nodes.iterator();
                while (nit.hasNext()) {
                    String nodeID = (String)nit.next();
                    DBGene gene = (DBGene)dbg.getGene(GenomeItemInstance.getBaseID(nodeID));
                    if (gene == null) continue;
                    ac.propagateNode(true, gi, gene, lo, new Vector2D(0.0, 0.0), group, support);
                }
            }
        }
        InstanceEngine ie = new InstanceEngine();
        giit = instanceContents.keySet().iterator();
        while (giit.hasNext()) {
            PropChangeCmd pcc;
            Layout.PropChange[] lpc;
            Point2D oldPos;
            String gikey = (String)giit.next();
            GenomeInstance gi = (GenomeInstance)db.getGenome(gikey);
            HashMap regions = (HashMap)instanceContents.get(gikey);
            Map giPositions = ie.layout(regions, gikey);
            HashMap<String, ArrayList<Point2D>> groupPoints = new HashMap<String, ArrayList<Point2D>>();
            Layout logi = db.getLayout(new LayoutManager().getLayout(gikey));
            Layout.PadNeedsForLayout loPadNeeds = (Layout.PadNeedsForLayout)globalPadNeeds.get(logi.getName());
            Iterator nit = giPositions.keySet().iterator();
            while (nit.hasNext()) {
                String nKey = (String)nit.next();
                Point2D newPos = (Point2D)giPositions.get(nKey);
                Group grp = gi.getGroupForNode(nKey, 0);
                if (grp == null) continue;
                String grid = grp.getID();
                ArrayList<Point2D> points = (ArrayList<Point2D>)groupPoints.get(grid);
                if (points == null) {
                    points = new ArrayList<Point2D>();
                    groupPoints.put(grid, points);
                }
                points.add(newPos);
                oldPos = logi.getNodeProperties(nKey).getLocation();
                lpc = new Layout.PropChange[]{logi.moveNode(nKey, gi, newPos.getX() - oldPos.getX(), newPos.getY() - oldPos.getY(), loPadNeeds)};
                if (lpc[0] == null) continue;
                pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
            }
            Iterator gpit = groupPoints.keySet().iterator();
            while (gpit.hasNext()) {
                String grid = (String)gpit.next();
                List points = (List)groupPoints.get(grid);
                HashSet pointSet = new HashSet(points);
                Point2D newPos = AffineCombination.combination(pointSet, 10.0);
                oldPos = logi.getGroupProperties(grid).getLabelLocation();
                lpc = new Layout.PropChange[]{logi.moveGroup(grid, gi, newPos.getX() - oldPos.getX(), newPos.getY() - oldPos.getY())};
                if (lpc[0] == null) continue;
                pcc = new PropChangeCmd(lpc);
                support.addEdit(pcc);
            }
        }
        mc.repairNetModuleLinkPadsGlobally(globalPadNeeds, frc, false, support);
        sup.fixCenterPoint(true, support, false);
        support.finish();
        return true;
    }

    public int getSliceMode(JFrame topWindow) {
        ResourceManager rMan = ResourceManager.getManager();
        Vector<ChoiceContent> choices = new Vector<ChoiceContent>();
        ChoiceContent defaultSlice = new ChoiceContent(rMan.getString("sliceMode.byRegions"), 1);
        choices.add(defaultSlice);
        choices.add(new ChoiceContent(rMan.getString("sliceMode.byTimes"), 0));
        Object[] choicesArray = choices.toArray();
        ChoiceContent sliceChoice = (ChoiceContent)JOptionPane.showInputDialog(topWindow, rMan.getString("sliceMode.chooseSlice"), rMan.getString("sliceMode.chooseSliceTitle"), 3, null, choicesArray, defaultSlice);
        if (sliceChoice == null) {
            return -1;
        }
        return sliceChoice.val;
    }

    public boolean buildOutModelTreeForNetworkBuild(Point2D center, Dimension size, FontRenderContext frc, SUPanel panel, boolean doSums, int sliceMode, Map neighbors, Map modelToSuggestion, UndoSupport support) {
        NavTreeChange ntc;
        if (sliceMode == -1) {
            return false;
        }
        ResourceManager rMan = ResourceManager.getManager();
        AddCommands ac = new AddCommands(this.topWindow_, this.undom_);
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        List sugg = tcd.getRootInstanceSuggestions(sliceMode, neighbors);
        NavTree nt = db.getNavTree();
        JTree tree = this.suw_.getTree();
        DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)dtm.getRoot();
        ArrayList<NavTreeChange> ntcs = new ArrayList<NavTreeChange>();
        ExpansionChange ec = ((PopupTree)tree).doUndoExpansionChange(support, true);
        Iterator sit = sugg.iterator();
        while (sit.hasNext()) {
            TimeCourseData.RootInstanceSuggestions ris = (TimeCourseData.RootInstanceSuggestions)sit.next();
            String nextKey = db.getNextKey();
            GenomeInstance gi = new GenomeInstance(ris.heavyToString(), nextKey, null);
            modelToSuggestion.put(nextKey, ris);
            gi.setTimes(ris.minTime, ris.maxTime);
            DatabaseChange dc = db.addGenomeInstanceExistingLabel(nextKey, gi);
            support.addEdit(new DatabaseChangeCmd(dc));
            String nextloKey = db.getNextKey();
            Layout lo = new Layout(nextloKey, nextKey);
            dc = db.addLayout(nextloKey, lo);
            support.addEdit(new DatabaseChangeCmd(dc));
            nt.setSkipFlag(2);
            ntc = nt.addNode(ris.heavyToString(), null, nextKey);
            nt.setSkipFlag(0);
            support.addEdit(new NavTreeChangeCmd(ntc));
            ntcs.add(ntc);
            int count = 0;
            Iterator rit = ris.regions.iterator();
            ArrayList<String> addedRegions = new ArrayList<String>();
            while (rit.hasNext()) {
                String region = (String)rit.next();
                Point2D.Double groupCenter = new Point2D.Double(400.0 * (double)(++count), 500.0);
                addedRegions.add(this.buildRegion(gi, lo, region, groupCenter, support));
            }
            String dipName = null;
            DynamicInstanceProxy dipS = null;
            if (doSums) {
                nextKey = db.getNextKey();
                String sumFormat = rMan.getString("toolCmd.summedFormat");
                dipName = MessageFormat.format(sumFormat, ris.heavyToString());
                dipS = new DynamicInstanceProxy(dipName, nextKey, gi, true, ris.minTime, ris.maxTime);
                dc = db.addDynamicProxyExistingLabel(nextKey, dipS);
                support.addEdit(new DatabaseChangeCmd(dc));
                new DataLocator(panel).setTitleLocation(support, gi.getID(), dipName);
                List newNodes = dipS.getProxiedKeys();
                if (newNodes.size() != 1) {
                    throw new IllegalStateException();
                }
                String key = (String)newNodes.iterator().next();
                ntc = nt.addNode(dipS.getProxiedInstanceName(key), gi.getID(), key);
                support.addEdit(new NavTreeChangeCmd(ntc));
                ntcs.add(ntc);
                Iterator arit = addedRegions.iterator();
                while (arit.hasNext()) {
                    String regionKey = (String)arit.next();
                    this.autoAddGroupToDynamicInstance(ac, (GenomeInstance)db.getGenome(key), regionKey, support);
                }
            }
            nextKey = db.getNextKey();
            TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
            String displayUnits = tad.unitDisplayString();
            String perTimeFormat = rMan.getString("toolCmd.perTimeFormat");
            dipName = MessageFormat.format(perTimeFormat, ris.heavyToString(), displayUnits);
            GenomeInstance par = dipS == null ? gi : dipS.getAnInstance();
            DynamicInstanceProxy dipH = new DynamicInstanceProxy(dipName, nextKey, par, false, ris.minTime, ris.maxTime);
            dc = db.addDynamicProxyExistingLabel(nextKey, dipH);
            support.addEdit(new DatabaseChangeCmd(dc));
            new DataLocator(panel).setTitleLocation(support, gi.getID(), dipName);
            GenomeInstance parent = dipH.getVfgParent();
            String parentID = parent.getID();
            ntc = nt.addProxyNode(dipName, parentID, nextKey);
            support.addEdit(new NavTreeChangeCmd(ntc));
            ntcs.add(ntc);
            DynamicGenomeInstance anInstance = dipH.getAnInstance();
            Iterator arit = addedRegions.iterator();
            while (arit.hasNext()) {
                String regionKey = (String)arit.next();
                this.autoAddGroupToDynamicInstance(ac, anInstance, regionKey, support);
            }
        }
        if (sugg.size() > 0) {
            nt.setSkipFlag(2);
            dtm.nodeStructureChanged(rootNode);
            nt.setSkipFlag(0);
        }
        nt.setSkipFlag(2);
        List nonleafPaths = nt.getAllPathsToNonLeaves();
        Iterator nlpit = nonleafPaths.iterator();
        while (nlpit.hasNext()) {
            TreePath tp = (TreePath)nlpit.next();
            tree.expandPath(tp);
        }
        DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(0);
        Object[] tn = rootChild.getPath();
        TreePath tp = new TreePath(tn);
        tree.setSelectionPath(tp);
        nt.setSkipFlag(0);
        int ntcSize = ntcs.size();
        if (ntcSize > 0) {
            ntc = (NavTreeChange)ntcs.get(0);
            ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
            ec.selected = nt.mapAPath(ec.selected, ntc, true);
            ntc = (NavTreeChange)ntcs.get(ntcSize - 1);
            ((PopupTree)tree).doRedoExpansionChange(support, ntc, true);
        }
        Database.getDB().clearAllDynamicProxyCaches();
        return true;
    }

    private void autoAddGroupToDynamicInstance(AddCommands ac, GenomeInstance gi, String startID, UndoSupport support) {
        GenomeInstance parent = gi.getVfgParent();
        int genCount = parent.getGeneration();
        String inherit = Group.buildInheritedID(startID, genCount);
        Group subsetGroup = parent.getGroup(inherit);
        ac.addNewGroupToSubsetInstance(gi.getID(), subsetGroup, support);
    }

    public boolean propagateRootUsingExpressionData(SUPanel sup, Point2D center, Dimension size, FontRenderContext frc, LayoutOptions options, Map globalPadNeeds, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac) {
        try {
            Database db = Database.getDB();
            DBGenome dbg = (DBGenome)db.getGenome();
            Layout lor = db.getLayout(new LayoutManager().getLayout(dbg.getID()));
            TimeCourseData tcd = db.getTimeCourseData();
            List sugg = tcd.getRootInstanceSuggestions(0, null);
            Map regAndTimes = tcd.getRegionsWithMinTimes();
            DevelopmentSpecDialog dsd = new DevelopmentSpecDialog(this.topWindow_, regAndTimes);
            dsd.show();
            if (!dsd.haveResult()) {
                return false;
            }
            LayoutRubberStamper lrs = new LayoutRubberStamper();
            AddCommands ac = new AddCommands(this.topWindow_, this.undom_);
            NavTree nt = db.getNavTree();
            JTree tree = this.suw_.getTree();
            DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)dtm.getRoot();
            Iterator sit = sugg.iterator();
            while (sit.hasNext()) {
                TimeCourseData.RootInstanceSuggestions ris = (TimeCourseData.RootInstanceSuggestions)sit.next();
                String nextKey = db.getNextKey();
                GenomeInstance gi = new GenomeInstance(ris.heavyToString(), nextKey, null);
                db.addGenomeInstanceExistingLabel(nextKey, gi);
                String nextloKey = db.getNextKey();
                Layout lo = new Layout(nextloKey, nextKey);
                db.addLayout(nextloKey, lo);
                NavTreeChange ntc = nt.addNode(ris.heavyToString(), null, nextKey);
                dtm.nodeStructureChanged(rootNode);
                HashMap regions = new HashMap();
                Iterator rit = ris.regions.iterator();
                while (rit.hasNext()) {
                    int order;
                    int groupCount;
                    Layout.PropChange lpc;
                    String region = (String)rit.next();
                    String regionKey = dbg.getNextKey();
                    Group newGroup = new Group(regionKey, region);
                    GenomeChange gc = gi.addGroupWithExistingLabel(newGroup);
                    if (gc != null) {
                        GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                        support.addEdit(gcc);
                    }
                    if ((lpc = lo.setGroupProperties(regionKey, new GroupProperties(groupCount = gi.groupCount(), regionKey, lo, center, order = lo.getTopGroupOrder() + 1))) != null) {
                        PropChangeCmd pcc = new PropChangeCmd(new Layout.PropChange[]{lpc});
                        support.addEdit(pcc);
                    }
                    HashSet regionMembers = new HashSet();
                    Iterator tiit = ris.times.iterator();
                    while (tiit.hasNext()) {
                        int time = (Integer)tiit.next();
                        tcd.getExpressedGenes(region, time, 2, regionMembers);
                    }
                    Iterator anit = dbg.getAllNodeIterator();
                    while (anit.hasNext()) {
                        Node node = (Node)anit.next();
                        List dataKeys = tcd.getTimeCourseTCMDataKeysWithDefault(node.getID());
                        if (dataKeys == null) continue;
                        Iterator dkit = dataKeys.iterator();
                        while (dkit.hasNext()) {
                            TimeCourseData.TCMapping tcm = (TimeCourseData.TCMapping)dkit.next();
                            if (!regionMembers.contains(tcm.name)) continue;
                            ac.propagateNodeNoLayout(node.getNodeType() == 4, gi, (DBNode)node, newGroup, support, null);
                        }
                    }
                    Iterator lit = dbg.getLinkageIterator();
                    GenomeInstance.GroupTuple grpTup = new GenomeInstance.GroupTuple(regionKey, regionKey);
                    while (lit.hasNext()) {
                        int trgInst;
                        Linkage link = (Linkage)lit.next();
                        String src = link.getSource();
                        String trg = link.getTarget();
                        int srcInst = gi.getInstanceForNodeInGroup(src, regionKey);
                        if (srcInst == -1 || (trgInst = gi.getInstanceForNodeInGroup(trg, regionKey)) == -1) continue;
                        ac.propagateLinkageNoLayout(gi, (DBLinkage)link, dbg, lor, grpTup, support, null);
                    }
                }
                DatabaseChange dc = db.startLayoutUndoTransaction(nextloKey);
                Layout origLayout = new Layout(lo);
                try {
                    lrs.rubberStampLayout(lor, dbg, lo, gi, options, frc, new Layout.OverlayKeySet(), null, monitor, null, origLayout, false, startFrac, maxFrac, null, globalPadNeeds);
                }
                catch (AsynchExitRequestException ex) {
                    db.rollbackLayoutUndoTransaction(dc);
                    throw ex;
                }
                dc = db.finishLayoutUndoTransaction(dc);
                support.addEdit(new DatabaseChangeCmd(dc));
            }
            DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(0);
            Object[] tn = rootChild.getPath();
            TreePath tp = new TreePath(tn);
            tree.expandPath(tp);
            tree.setSelectionPath(tp);
            sup.fixCenterPoint(true, support, false);
        }
        catch (AsynchExitRequestException ex) {
            support.rollback();
            return false;
        }
        return true;
    }

    public boolean propagateRootUsingInstructions(String genomeID, List createdPairs, Point2D center, Dimension size, FontRenderContext frc, UndoSupport support, LayoutOptions options, BTProgressMonitor monitor, Map subsetCache, Map subsetRegionCache, LegacyInstanceIdMapper liidm, Map nodeIDMap, Map globalPadNeeds, boolean keepLayout, boolean hideNodeNames, double startFrac, double maxFrac) throws AsynchExitRequestException {
        BuildInstructionInstance bii;
        FullGenomeHierarchyOracle fgho = new FullGenomeHierarchyOracle();
        Map allKeys = fgho.fullModuleKeysPerLayout();
        Database db = Database.getDB();
        DBGenome dbg = (DBGenome)db.getGenome();
        GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
        if (gi.isEmpty()) {
            keepLayout = false;
        }
        String loKey = new LayoutManager().getLayout(genomeID);
        Layout lo = db.getLayout(loKey);
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)allKeys.get(loKey);
        Map moduleShapeRecovery = lo.getModuleShapeParams(loModKeys, frc, center);
        InstanceInstructionSet iis = db.getInstanceInstructionSet(genomeID);
        AddCommands ac = new AddCommands(this.topWindow_, this.undom_);
        HashMap<String, String> legacyGroups = new HashMap<String, String>();
        Iterator git = gi.getGroupIterator();
        while (git.hasNext()) {
            Group grp = (Group)git.next();
            legacyGroups.put(grp.getName(), grp.getID());
        }
        HashSet<String> crossRegion = new HashSet<String>();
        Iterator lit = gi.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            if (!gi.isCrossRegionLink(linkID)) continue;
            crossRegion.add(linkID);
        }
        liidm.recordLegacyInstancesForRegions(dbg, gi);
        Map savedRegionBounds = keepLayout ? this.saveRegionBounds(gi, lo, frc) : null;
        lo = new Layout(lo);
        GenomeInstance oldGi = (GenomeInstance)gi.clone();
        support.addEdit(new DatabaseChangeCmd(db.dropInstanceNetworkOnly(genomeID)));
        gi = (GenomeInstance)db.getGenome(genomeID);
        Iterator iit = iis.getInstructionIterator();
        HashSet<String> regions = new HashSet<String>();
        while (iit.hasNext()) {
            BuildInstructionInstance bii2 = (BuildInstructionInstance)iit.next();
            regions.add(bii2.getSourceRegionID());
            if (!bii2.hasTargetRegionID()) continue;
            regions.add(bii2.getTargetRegionID());
        }
        HashMap<String, String> regionMap = new HashMap<String, String>();
        subsetRegionCache.put(gi.getID(), regionMap);
        HashMap<String, GroupProperties> stashGrpProp = new HashMap<String, GroupProperties>();
        HashMap<String, String> newToOldRegionMap = new HashMap<String, String>();
        Iterator rit = regions.iterator();
        while (rit.hasNext()) {
            GenomeChange gc;
            String region = (String)rit.next();
            InstanceInstructionSet.RegionInfo ri = iis.getRegionForAbbreviation(region);
            String gid = (String)legacyGroups.get(ri.name);
            String regionKey = gid == null ? dbg.getNextKey() : gid;
            Group newGroup = new Group(regionKey, ri.name);
            regionMap.put(region, regionKey);
            if (gid != null) {
                newToOldRegionMap.put(regionKey, gid);
            }
            if (gi.getGroup(newGroup.getID()) == null && (gc = gi.addGroupWithExistingLabel(newGroup)) != null) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                support.addEdit(gcc);
            }
            if (keepLayout && gid != null) continue;
            int groupCount = gi.groupCount();
            stashGrpProp.put(regionKey, new GroupProperties(groupCount, regionKey, center, 0));
        }
        liidm.setRegionMapping(newToOldRegionMap);
        HashMap instructionCache = new HashMap();
        subsetCache.put(gi.getID(), instructionCache);
        HashMap instanceMap = new HashMap();
        HashMap linkInstanceMap = new HashMap();
        Layout lor = db.getLayout(new LayoutManager().getLayout(dbg.getID()));
        iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            bii = (BuildInstructionInstance)iit.next();
            this.processInstruction(bii, createdPairs, dbg, gi, oldGi, regionMap, instanceMap, linkInstanceMap, lor, ac, support, instructionCache, liidm, true);
        }
        iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            bii = (BuildInstructionInstance)iit.next();
            this.processInstruction(bii, createdPairs, dbg, gi, oldGi, regionMap, instanceMap, linkInstanceMap, lor, ac, support, instructionCache, liidm, false);
        }
        HashMap keyMap = new HashMap();
        HashMap modIDMap = new HashMap();
        HashMap modLinkIDMap = new HashMap();
        Map allKeysWithEmpties = fgho.fullModuleKeysPerLayout(true);
        Layout.OverlayKeySet loModKeysWithEmpties = (Layout.OverlayKeySet)allKeysWithEmpties.get(loKey);
        lo.fillOverlayIdentityMaps(loModKeysWithEmpties, keyMap, modIDMap, modLinkIDMap);
        this.recoverMappedOverlaysForInstance(gi, oldGi, liidm.getInstanceNodeMapping(), newToOldRegionMap);
        Layout newLayout = db.getLayout(loKey);
        DatabaseChange dc = db.startLayoutUndoTransaction(loKey);
        try {
            HashMap ilm = liidm.getInstanceLinkMapping();
            if (keepLayout) {
                ilm = new HashMap(ilm);
                Iterator ilmkit = liidm.getInstanceLinkMapping().keySet().iterator();
                while (ilmkit.hasNext()) {
                    String linkID = (String)ilmkit.next();
                    if (!crossRegion.contains(linkID)) continue;
                    ilm.remove(linkID);
                }
            }
            Map specials = keepLayout ? lo.rememberSpecialLinks(gi) : null;
            HashMap rememberProps = new HashMap();
            newLayout.transferLayoutFromLegacy(liidm.getInstanceNodeMapping(), ilm, newToOldRegionMap, keyMap, modLinkIDMap, null, lo, !keepLayout, rememberProps, gi, frc);
            Iterator sgpit = stashGrpProp.keySet().iterator();
            while (sgpit.hasNext()) {
                String regionKey = (String)sgpit.next();
                GroupProperties gp = (GroupProperties)stashGrpProp.get(regionKey);
                if (gp.getLayer() != 0) {
                    throw new IllegalStateException();
                }
                int order = newLayout.getTopGroupOrder() + 1;
                gp.setOrder(order);
                newLayout.setGroupProperties(regionKey, gp);
            }
            LayoutRubberStamper lrs = new LayoutRubberStamper();
            lrs.rubberStampLayout(lor, dbg, newLayout, gi, options, frc, loModKeys, moduleShapeRecovery, monitor, savedRegionBounds, lo, keepLayout, startFrac, maxFrac, rememberProps, globalPadNeeds);
            if (specials != null) {
                newLayout.restoreSpecialLinks(specials, gi);
            }
            if (hideNodeNames) {
                newLayout.hideAllMinorNodeNames();
            }
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            this.fixNodeLengths(gi, support);
            if (nodeIDMap != null) {
                Iterator anit = gi.getAllNodeIterator();
                String modelID = gi.getID();
                String modelName = DataUtil.normKey(gi.getName());
                while (anit.hasNext()) {
                    Node node = (Node)anit.next();
                    String nodeID = node.getID();
                    Group grp = gi.getGroupForNode(nodeID, 1);
                    String grpName = grp.getInheritedTrueName(gi);
                    NodeRegionModelNameTuple tup = new NodeRegionModelNameTuple(node.getName(), grpName, modelName);
                    ModelNodeIDPair pair = new ModelNodeIDPair(modelID, nodeID);
                    nodeIDMap.put(tup, pair);
                }
            }
            return true;
        }
        catch (AsynchExitRequestException ex) {
            db.rollbackLayoutUndoTransaction(dc);
            throw ex;
        }
    }

    public Map buildSdcCache(FontRenderContext frc, Map globalKeys) {
        HashMap<String, Layout.SupplementalDataCoords> retval = new HashMap<String, Layout.SupplementalDataCoords>();
        LayoutManager lm = new LayoutManager();
        Database db = Database.getDB();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (!gi.isRootInstance()) continue;
            String genomeID = gi.getID();
            String loKey = lm.getLayout(genomeID);
            Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)globalKeys.get(loKey);
            Layout lo = db.getLayout(loKey);
            Layout.SupplementalDataCoords sdc = lo.getSupplementalCoords(gi, frc, loModKeys);
            retval.put(genomeID, sdc);
        }
        return retval;
    }

    public void processSdcCache(FontRenderContext frc, Map sdcCache, Map globalKeys, UndoSupport support) {
        LayoutManager lm = new LayoutManager();
        Database db = Database.getDB();
        Iterator sdit = sdcCache.keySet().iterator();
        while (sdit.hasNext()) {
            String genomeID = (String)sdit.next();
            GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
            Layout.SupplementalDataCoords sdc = (Layout.SupplementalDataCoords)sdcCache.get(genomeID);
            String loKey = lm.getLayout(genomeID);
            DatabaseChange dc = db.startLayoutUndoTransaction(loKey);
            Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)globalKeys.get(loKey);
            Layout lo = db.getLayout(loKey);
            lo.applySupplementalDataCoords(sdc, gi, frc, loModKeys);
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
        }
    }

    public boolean populateSubsetUsingInstructions(String genomeID, List createdPairs, UndoSupport support, LegacyInstanceIdMapper liidm, Map nodeIDMap, Map subsetCache, Map subsetRegionCache) {
        Database db = Database.getDB();
        InstanceInstructionSet iis = db.getInstanceInstructionSet(genomeID);
        if (iis == null) {
            return true;
        }
        GenomeInstance gi = (GenomeInstance)db.getGenome(genomeID);
        AddCommands ac = new AddCommands(this.topWindow_, this.undom_);
        GenomeInstance rootInstance = gi.getVfgParentRoot();
        GenomeInstance parent = gi.getVfgParent();
        GenomeInstance oldGi = (GenomeInstance)gi.clone();
        support.addEdit(new DatabaseChangeCmd(db.dropInstanceNetworkOnly(genomeID)));
        gi = (GenomeInstance)db.getGenome(genomeID);
        Iterator iit = iis.getInstructionIterator();
        HashSet<String> regions = new HashSet<String>();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            regions.add(bii.getSourceRegionID());
            if (!bii.hasTargetRegionID()) continue;
            regions.add(bii.getTargetRegionID());
        }
        Map regionMap = (Map)subsetRegionCache.get(rootInstance.getID());
        Iterator rit = regions.iterator();
        while (rit.hasNext()) {
            String region = (String)rit.next();
            String useGroup = (String)regionMap.get(region);
            int generation = gi.getGeneration() - 1;
            Group parentGroup = parent.getGroup(Group.buildInheritedID(useGroup, generation));
            ac.addNewGroupToSubsetInstance(genomeID, parentGroup, support);
        }
        this.recoverMappedOverlaysForInstance(gi, oldGi, liidm.getInstanceNodeMapping(), liidm.getRegionMapping());
        Map instructionCache = (Map)subsetCache.get(rootInstance.getID());
        iit = iis.getInstructionIterator();
        while (iit.hasNext()) {
            BuildInstructionInstance bii = (BuildInstructionInstance)iit.next();
            this.processInstructionForSubset(bii, gi, parent, ac, support, instructionCache);
        }
        if (nodeIDMap != null) {
            Iterator anit = gi.getAllNodeIterator();
            String modelID = gi.getID();
            String modelName = DataUtil.normKey(gi.getName());
            while (anit.hasNext()) {
                Node node = (Node)anit.next();
                String nodeID = node.getID();
                Group grp = gi.getGroupForNode(nodeID, 1);
                String grpName = grp.getInheritedTrueName(gi);
                NodeRegionModelNameTuple tup = new NodeRegionModelNameTuple(node.getName(), grpName, modelName);
                ModelNodeIDPair pair = new ModelNodeIDPair(modelID, nodeID);
                nodeIDMap.put(tup, pair);
            }
        }
        return true;
    }

    private void processInstruction(BuildInstructionInstance bii, List createdPairs, DBGenome dbg, GenomeInstance gi, GenomeInstance oldGi, Map regionMap, Map instanceMap, Map linkInstanceMap, Layout lor, AddCommands ac, UndoSupport support, Map instructionCache, LegacyInstanceIdMapper liidm, boolean existingOnly) {
        String baseID = bii.getBaseID();
        HashMap<GenomeInstance.GroupTuple, SubsetCacheValues> tupleMap = (HashMap<GenomeInstance.GroupTuple, SubsetCacheValues>)instructionCache.get(baseID);
        if (tupleMap == null) {
            tupleMap = new HashMap<GenomeInstance.GroupTuple, SubsetCacheValues>();
            instructionCache.put(baseID, tupleMap);
        }
        HashSet srcRegionNodes = new HashSet();
        HashSet targRegionNodes = new HashSet();
        HashMap linkTupleMap = new HashMap();
        Iterator nmit = createdPairs.iterator();
        while (nmit.hasNext()) {
            NodeInstance ni;
            GenomeInstance.GroupTuple tuple;
            DialogBuiltMotifPair dbmp = (DialogBuiltMotifPair)nmit.next();
            String dbmpID = dbmp.instructionID;
            if (!dbmpID.equals(baseID)) continue;
            srcRegionNodes.clear();
            targRegionNodes.clear();
            DialogBuiltMotif dbm = dbmp.real;
            boolean sourceOnly = !dbm.hasTarget();
            dbm.getRegionAssignments(srcRegionNodes, targRegionNodes, linkTupleMap);
            String srcReg = bii.getSourceRegionID();
            String trgReg = null;
            if (sourceOnly) {
                tuple = new GenomeInstance.GroupTuple(srcReg, srcReg);
            } else {
                trgReg = bii.getTargetRegionID();
                tuple = new GenomeInstance.GroupTuple(srcReg, trgReg);
            }
            SubsetCacheValues scv = (SubsetCacheValues)tupleMap.get(tuple);
            if (scv == null) {
                scv = new SubsetCacheValues();
                tupleMap.put(tuple, scv);
            }
            String srcRegKey = (String)regionMap.get(srcReg);
            Iterator snit = srcRegionNodes.iterator();
            while (snit.hasNext()) {
                String srcNodeID = (String)snit.next();
                String legacyInstance = liidm.getLegacyInstanceForRegion(srcNodeID, srcRegKey);
                if (legacyInstance == null && existingOnly || legacyInstance != null && !existingOnly) continue;
                String instanceID = this.getInstanceForRegion(srcRegKey, srcNodeID, instanceMap);
                if (instanceID == null) {
                    Node node = dbg.getNode(srcNodeID);
                    Group region = gi.getGroup(srcRegKey);
                    ni = ac.propagateOldOrNewNodeNoLayout(node.getNodeType() == 4, gi, oldGi, (DBNode)node, region, support, legacyInstance);
                    if (node.getNodeType() == 4) {
                        scv.genes.add(ni.getID());
                    } else {
                        scv.nodes.add(ni.getID());
                    }
                    this.recordInstanceForRegion(srcRegKey, srcNodeID, ni.getInstance(), instanceMap);
                    liidm.recordInstanceForRegion(srcRegKey, srcNodeID, ni.getInstance());
                    continue;
                }
                NodeInstance ni2 = (NodeInstance)gi.getNode(GenomeItemInstance.getCombinedID(srcNodeID, instanceID));
                if (ni2.getNodeType() == 4) {
                    scv.genes.add(ni2.getID());
                    continue;
                }
                scv.nodes.add(ni2.getID());
            }
            if (sourceOnly) break;
            String trgRegKey = (String)regionMap.get(trgReg);
            Iterator tnit = targRegionNodes.iterator();
            while (tnit.hasNext()) {
                String trgNodeID = (String)tnit.next();
                String legacyInstance = liidm.getLegacyInstanceForRegion(trgNodeID, trgRegKey);
                if (legacyInstance == null && existingOnly || legacyInstance != null && !existingOnly) continue;
                String instanceID = this.getInstanceForRegion(trgRegKey, trgNodeID, instanceMap);
                if (instanceID == null) {
                    Node node = dbg.getNode(trgNodeID);
                    Group region = gi.getGroup(trgRegKey);
                    NodeInstance ni3 = ac.propagateOldOrNewNodeNoLayout(node.getNodeType() == 4, gi, oldGi, (DBNode)node, region, support, legacyInstance);
                    if (node.getNodeType() == 4) {
                        scv.genes.add(ni3.getID());
                    } else {
                        scv.nodes.add(ni3.getID());
                    }
                    this.recordInstanceForRegion(trgRegKey, trgNodeID, ni3.getInstance(), instanceMap);
                    liidm.recordInstanceForRegion(trgRegKey, trgNodeID, ni3.getInstance());
                    continue;
                }
                ni = (NodeInstance)gi.getNode(GenomeItemInstance.getCombinedID(trgNodeID, instanceID));
                if (ni.getNodeType() == 4) {
                    scv.genes.add(ni.getID());
                    continue;
                }
                scv.nodes.add(ni.getID());
            }
            Iterator kit = linkTupleMap.keySet().iterator();
            while (kit.hasNext()) {
                String legacyInstance;
                String linkID = (String)kit.next();
                int tupType = (Integer)linkTupleMap.get(linkID);
                GenomeInstance.GroupTuple grpTup = null;
                switch (tupType) {
                    case 0: {
                        grpTup = new GenomeInstance.GroupTuple(srcRegKey, srcRegKey);
                        break;
                    }
                    case 1: {
                        grpTup = new GenomeInstance.GroupTuple(srcRegKey, trgRegKey);
                        break;
                    }
                    case 2: {
                        grpTup = new GenomeInstance.GroupTuple(trgRegKey, trgRegKey);
                        break;
                    }
                    case 3: {
                        grpTup = new GenomeInstance.GroupTuple(trgRegKey, srcRegKey);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                if ((legacyInstance = liidm.getLegacyInstanceForRegionTuple(linkID, srcRegKey, trgRegKey)) == null && existingOnly || legacyInstance != null && !existingOnly) continue;
                String linkInstanceID = this.getLinkInstanceForRegionTuple(grpTup, linkID, linkInstanceMap);
                if (linkInstanceID == null) {
                    Linkage link = dbg.getLinkage(linkID);
                    LinkageInstance newLink = ac.propagateOldOrNewLinkageNoLayout(gi, oldGi, (DBLinkage)link, dbg, lor, grpTup, support, legacyInstance);
                    scv.links.add(newLink.getID());
                    this.recordLinkInstanceForRegionTuple(grpTup, linkID, newLink.getInstance(), linkInstanceMap);
                    liidm.recordInstanceForRegionTuple(srcRegKey, trgRegKey, linkID, newLink.getInstance());
                    continue;
                }
                LinkageInstance newLink = (LinkageInstance)gi.getLinkage(GenomeItemInstance.getCombinedID(linkID, linkInstanceID));
                scv.links.add(newLink.getID());
            }
            break block6;
        }
    }

    private void processInstructionForSubset(BuildInstructionInstance bii, GenomeInstance gi, GenomeInstance parent, AddCommands ac, UndoSupport support, Map instructionCache) {
        int i;
        GenomeInstance.GroupTuple tuple;
        boolean sourceOnly;
        String key = gi.getID();
        String baseID = bii.getBaseID();
        Map tupleMap = (Map)instructionCache.get(baseID);
        if (tupleMap == null) {
            throw new IllegalStateException();
        }
        String srcReg = bii.getSourceRegionID();
        boolean bl = sourceOnly = !bii.hasTargetRegionID();
        if (sourceOnly) {
            tuple = new GenomeInstance.GroupTuple(srcReg, srcReg);
        } else {
            String trgReg = bii.getTargetRegionID();
            tuple = new GenomeInstance.GroupTuple(srcReg, trgReg);
        }
        SubsetCacheValues scv = (SubsetCacheValues)tupleMap.get(tuple);
        int size = scv.nodes.size();
        for (i = 0; i < size; ++i) {
            String nodeID = (String)scv.nodes.get(i);
            NodeInstance ni = (NodeInstance)parent.getNode(nodeID);
            ac.addNewNodeToSubsetInstance(key, ni, support);
        }
        size = scv.genes.size();
        for (i = 0; i < size; ++i) {
            String geneID = (String)scv.genes.get(i);
            GeneInstance gene = (GeneInstance)parent.getNode(geneID);
            ac.addNewNodeToSubsetInstance(key, gene, support);
        }
        size = scv.links.size();
        for (i = 0; i < size; ++i) {
            String linkID = (String)scv.links.get(i);
            LinkageInstance li = (LinkageInstance)parent.getLinkage(linkID);
            ac.addNewLinkToSubsetInstance(key, li, support);
        }
    }

    public LinkRouter.RoutingResult buildRootFromInstructions(List instructions, Point2D center, Dimension size, FontRenderContext frc, boolean keepLayout, boolean hideNames, LayoutOptions options, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac, List createdPairs, Map newNodeToOldNode, Map newLinksToOldLinks, int dataDeletionAnswer, Map nodeIDMap, String dbGenomeCSVName, Map globalPadNeeds) throws AsynchExitRequestException {
        Database db = Database.getDB();
        DatabaseChange dc = db.setBuildInstructions(instructions);
        support.addEdit(new DatabaseChangeCmd(dc));
        return this.buildRootFromInstructionsNoRootInstall(instructions, center, size, frc, keepLayout, hideNames, options, support, monitor, startFrac, maxFrac, createdPairs, newNodeToOldNode, newLinksToOldLinks, dataDeletionAnswer, nodeIDMap, dbGenomeCSVName, globalPadNeeds);
    }

    public LinkRouter.RoutingResult buildRootFromInstructionsNoRootInstall(List instructions, Point2D center, Dimension size, FontRenderContext frc, boolean keepLayout, boolean hideNames, LayoutOptions options, UndoSupport support, BTProgressMonitor monitor, double startFrac, double maxFrac, List createdPairs, Map newNodeToOldNode, Map newLinksToOldLinks, int dataDeletionAnswer, Map nodeIDMap, String dbGenomeCSVName, Map globalPadNeeds) throws AsynchExitRequestException {
        LinkRouter.RoutingResult layoutResult;
        Object mcev = null;
        FullGenomeHierarchyOracle fgho = new FullGenomeHierarchyOracle();
        Map globalKeys = fgho.fullModuleKeysPerLayout();
        int iSize = instructions.size();
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        boolean wasEmpty = genome.isEmpty();
        String loKey = new LayoutManager().getLayout(genome.getID());
        Layout lo = db.getLayout(loKey);
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)globalKeys.get(loKey);
        Layout.PadNeedsForLayout localPadNeeds = (Layout.PadNeedsForLayout)globalPadNeeds.get(loKey);
        Layout.SupplementalDataCoords sdc = lo.getSupplementalCoords(genome, frc, loModKeys);
        Map moduleShapeRecovery = lo.getModuleShapeParams(loModKeys, frc, center);
        ArrayList protoPairs = new ArrayList();
        HashMap typeTracker = new HashMap();
        for (int i = 0; i < iSize; ++i) {
            BuildInstruction bc = (BuildInstruction)instructions.get(i);
            try {
                bc.addMotifs(protoPairs, typeTracker);
                continue;
            }
            catch (IllegalStateException isex) {
                for (int j = 0; j <= i; ++j) {
                    BuildInstruction bcx = (BuildInstruction)instructions.get(j);
                    System.err.println(bcx);
                }
            }
        }
        OldPadMapper oldPads = keepLayout ? new OldPadMapper() : null;
        this.extractDialogBuiltMotifs(genome, protoPairs, oldPads);
        HashSet deadNodes = new HashSet();
        HashSet deadLinks = new HashSet();
        this.collectUnusedItems(genome, protoPairs, deadNodes, deadLinks);
        DeleteCommands delc = new DeleteCommands(this.topWindow_, this.undom_);
        delc.deleteNodesAndLinksFromModel(deadNodes, deadLinks, genome.getID(), support, dataDeletionAnswer, true);
        lo = new Layout(lo);
        DBGenome oldGenome = (DBGenome)genome.clone();
        Map oldTypes = keepLayout ? null : this.rememberTypes(genome);
        support.addEdit(new DatabaseChangeCmd(db.dropRootNetworkOnly()));
        genome = (DBGenome)db.getGenome();
        if (newNodeToOldNode == null) {
            newNodeToOldNode = new HashMap();
        }
        if (newLinksToOldLinks == null) {
            newLinksToOldLinks = new HashMap();
        }
        HashMap newTypesByID = new HashMap();
        HashMap padConstraints = new HashMap();
        ArrayList newMotifs = new ArrayList();
        if (createdPairs == null) {
            createdPairs = new ArrayList();
        }
        AddCommands ac = new AddCommands(this.topWindow_, this.undom_);
        this.buildItemsFromMotifs(genome, oldGenome, protoPairs, createdPairs, newNodeToOldNode, newLinksToOldLinks, newTypesByID, newMotifs, ac, oldPads, padConstraints, support);
        if (monitor != null && !monitor.keepGoing()) {
            throw new AsynchExitRequestException();
        }
        HashMap keyMap = new HashMap();
        HashMap modIDMap = new HashMap();
        HashMap modLinkIDMap = new HashMap();
        Map allKeysWithEmpties = fgho.fullModuleKeysPerLayout(true);
        Layout.OverlayKeySet loModKeysWithEmpties = (Layout.OverlayKeySet)allKeysWithEmpties.get(loKey);
        lo.fillOverlayIdentityMaps(loModKeysWithEmpties, keyMap, modIDMap, modLinkIDMap);
        this.recoverMappedOverlays(genome, oldGenome, newNodeToOldNode);
        HashMap rememberLinkProps = new HashMap();
        Layout newLayout = db.getLayout(loKey);
        DatabaseChange dc = db.startLayoutUndoTransaction(loKey);
        newLayout.transferLayoutFromLegacy(newNodeToOldNode, newLinksToOldLinks, null, keyMap, modLinkIDMap, null, lo, !keepLayout, rememberLinkProps, oldGenome, frc);
        dc = db.finishLayoutUndoTransaction(dc);
        support.addEdit(new DatabaseChangeCmd(dc));
        HashMap<String, String> colorMap = new HashMap<String, String>();
        Iterator nit = newNodeToOldNode.keySet().iterator();
        while (nit.hasNext()) {
            String key = (String)nit.next();
            String oldNode = (String)newNodeToOldNode.get(key);
            NodeProperties np = lo.getNodeProperties(oldNode);
            String oldColor = np.getColorName();
            colorMap.put(key, oldColor);
            if (keepLayout) continue;
            newTypesByID.put(key, oldTypes.get(oldNode));
        }
        HashSet<String> nonLegacyLinks = new HashSet<String>();
        Iterator n2okit = newLinksToOldLinks.keySet().iterator();
        while (n2okit.hasNext()) {
            String key = (String)n2okit.next();
            if (newLinksToOldLinks.get(key) != null && keepLayout) continue;
            nonLegacyLinks.add(key);
        }
        if (keepLayout && !wasEmpty) {
            layoutResult = ac.autoLayoutHierarchical(center, newTypesByID, nonLegacyLinks, size, genome, support, frc, newMotifs, true, colorMap, padConstraints, options, monitor, startFrac, maxFrac, sdc, rememberLinkProps);
            this.fixNodeLengths(genome, support);
        } else {
            ac.junkLayout(genome, newLayout, support, frc);
            LayoutOptionsManager lom = LayoutOptionsManager.getMgr();
            StackedBlockLayout specLayout = new StackedBlockLayout();
            StackedBlockLayout.StackedBlockLayoutParams params = lom.getStackedBlockLayoutParams();
            GenomeSubset subset = new GenomeSubset(genome.getID(), center);
            ArrayList<GenomeSubset> sList = new ArrayList<GenomeSubset>();
            sList.add(subset);
            NetModuleLinkExtractor.SubsetAnalysis sa = new NetModuleLinkExtractor().analyzeForMods(sList, null);
            SpecialtyLayoutEngine sle = new SpecialtyLayoutEngine(sList, newLayout, specLayout, sa, center, ac, params, true, hideNames);
            sle.setModuleRecoveryData(localPadNeeds, moduleShapeRecovery);
            layoutResult = sle.specialtyLayout(support, monitor, 0.0, 1.0);
        }
        support.addEvent(new ModelChangeEvent(genome.getID(), 1));
        support.addEvent(new LayoutChangeEvent(newLayout.getName(), 1));
        if (nodeIDMap != null) {
            Iterator anit = genome.getAllNodeIterator();
            String modelID = genome.getID();
            String modelName = dbGenomeCSVName;
            while (anit.hasNext()) {
                Node node = (Node)anit.next();
                String nodeID = node.getID();
                NodeRegionModelNameTuple tup = new NodeRegionModelNameTuple(node.getName(), null, modelName);
                ModelNodeIDPair pair = new ModelNodeIDPair(modelID, nodeID);
                nodeIDMap.put(tup, pair);
            }
        }
        return layoutResult;
    }

    private void recoverMappedOverlays(DBGenome genome, DBGenome oldGenome, Map newNodeToOldNode) {
        HashMap<String, String> oldNodeToNew = new HashMap<String, String>();
        Iterator nmit = newNodeToOldNode.keySet().iterator();
        while (nmit.hasNext()) {
            String newNode = (String)nmit.next();
            String oldNode = (String)newNodeToOldNode.get(newNode);
            if (oldNode == null) continue;
            oldNodeToNew.put(oldNode, newNode);
        }
        genome.recoverMappedModuleMembers(oldGenome, oldNodeToNew);
    }

    private void recoverMappedOverlaysForInstance(GenomeInstance genome, GenomeInstance oldGenome, Map newNodeToOldNode, Map newGroupToOldGroup) {
        HashMap<String, String> oldNodeToNew = new HashMap<String, String>();
        Iterator nmit = newNodeToOldNode.keySet().iterator();
        while (nmit.hasNext()) {
            String newNode = (String)nmit.next();
            String oldNode = (String)newNodeToOldNode.get(newNode);
            if (oldNode == null) continue;
            oldNodeToNew.put(oldNode, newNode);
        }
        HashMap<String, String> oldGroupToNew = new HashMap<String, String>();
        Iterator ngit = newGroupToOldGroup.keySet().iterator();
        while (ngit.hasNext()) {
            String newGrp = (String)ngit.next();
            String oldGrp = (String)newGroupToOldGroup.get(newGrp);
            if (oldGrp == null) continue;
            oldGroupToNew.put(oldGrp, newGrp);
        }
        genome.recoverMappedModuleMembers(oldGenome, oldNodeToNew, oldGroupToNew);
    }

    private void fixNodeLengths(Genome genome, UndoSupport support) {
        Iterator nit = genome.getAllNodeIterator();
        while (nit.hasNext()) {
            GenomeChange gc;
            Node node = (Node)nit.next();
            String nodeID = node.getID();
            int currPads = node.getPadCount();
            PadCalculatorToo.PadResult padreq = genome.getNodePadRequirements(node);
            if (padreq.landing <= currPads || (gc = node.getNodeType() == 4 ? genome.changeGeneSize(nodeID, padreq.landing) : genome.changeNodeSize(nodeID, padreq.landing)) == null) continue;
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
    }

    public void doStatusAnnouncements(LinkRouter.RoutingResult layoutResult, JFrame topWindow) {
        int allLayoutProblems;
        boolean isHeadless = MainCommands.getCmds().isHeadless();
        if ((layoutResult.linkResult & 1) != 0) {
            ResourceManager rMan = ResourceManager.getManager();
            if ((layoutResult.colorResult & 1) != 0) {
                String src1 = "";
                String src2 = "";
                if (layoutResult.collisionSrc1 != null) {
                    src1 = layoutResult.collisionSrc1;
                }
                if (layoutResult.collisionSrc2 != null) {
                    src2 = layoutResult.collisionSrc2;
                }
                if (src1.trim().equals("")) {
                    src1 = rMan.getString("tip.noname");
                }
                if (src2.trim().equals("")) {
                    src2 = rMan.getString("tip.noname");
                }
                String format = rMan.getString("autoLayout.colorProblemCollide");
                String srcMsg = MessageFormat.format(format, src1, src2);
                if (isHeadless) {
                    System.err.println(srcMsg);
                } else {
                    srcMsg = UiUtil.convertMessageToHtml(srcMsg);
                    JOptionPane.showMessageDialog(topWindow, srcMsg, rMan.getString("autoLayout.colorProblemTitle"), 2);
                }
            }
            if ((layoutResult.colorResult & 2) != 0) {
                if (isHeadless) {
                    System.err.println(rMan.getString("autoLayout.colorProblemReassign"));
                } else {
                    JOptionPane.showMessageDialog(topWindow, rMan.getString("autoLayout.colorProblemReassign"), rMan.getString("autoLayout.colorProblemTitle"), 2);
                }
            }
            if ((layoutResult.colorResult & 4) != 0) {
                if (isHeadless) {
                    System.err.println(rMan.getString("autoLayout.colorProblemTooFew"));
                } else {
                    JOptionPane.showMessageDialog(topWindow, rMan.getString("autoLayout.colorProblemTooFew"), rMan.getString("autoLayout.colorProblemTitle"), 2);
                }
            }
        }
        if ((layoutResult.linkResult & (allLayoutProblems = 14)) != 0) {
            ResourceManager rMan = ResourceManager.getManager();
            if (isHeadless) {
                System.err.println(rMan.getString("autoLayout.layoutProblem"));
            } else {
                String msg = "";
                if ((layoutResult.linkResult & 2) != 0) {
                    msg = rMan.getString("autoLayout.layoutProblem");
                } else if ((layoutResult.linkResult & 4) != 0) {
                    msg = rMan.getString("autoLayout.layoutProblemHalted");
                } else if ((layoutResult.linkResult & 8) != 0) {
                    msg = rMan.getString("autoLayout.layoutProblemOverlaid");
                }
                msg = UiUtil.convertMessageToHtml(msg);
                JOptionPane.showMessageDialog(topWindow, msg, rMan.getString("autoLayout.layoutProblemTitle"), 2);
            }
        }
    }

    public LinkRouter.RoutingResult squashGenome(Layout lo, Genome genome, Set groups, FontRenderContext frc, Point2D wsCenter, double fracH, double fracV, UndoSupport support, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.1;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.9;
        ModificationCommands mc = new ModificationCommands();
        Layout.PadNeedsForLayout padNeeds = mc.getLocalNetModuleLinkPadNeeds(frc, genome.getID());
        Database db = Database.getDB();
        DatabaseChange dc = db.startLayoutUndoTransaction(lo.getName());
        try {
            boolean orphanedPadsOnly;
            Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
            Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)allKeys.get(lo.getName());
            Point2D center = lo.getLayoutCenterAllOverlays(frc, loModKeys);
            if (center == null) {
                center = wsCenter;
            }
            Layout.SupplementalDataCoords sdc = lo.getSupplementalCoordsAllOverlays(genome, frc, loModKeys);
            Map moduleShapeRecovery = lo.getModuleShapeParams(loModKeys, frc, center);
            lo.dropUselessCorners(genome, frc, null, null, startFrac, eFrac1, monitor);
            Map specials = null;
            if (genome instanceof DBGenome) {
                TreeSet useEmptyRows = new TreeSet();
                TreeSet useEmptyCols = new TreeSet();
                lo.chooseCompressionRows(genome, frc, fracV, fracH, null, false, loModKeys, useEmptyRows, useEmptyCols, monitor);
                lo.compress(genome, useEmptyRows, useEmptyCols, null, null, null, null, monitor, eFrac1, endFrac);
                orphanedPadsOnly = true;
            } else {
                specials = lo.rememberSpecialLinks(genome);
                LayoutRubberStamper lrs = new LayoutRubberStamper();
                lrs.compressRootInstanceLayout(lo, (GenomeInstance)genome, groups, fracV, fracH, frc, padNeeds, loModKeys, moduleShapeRecovery, options, monitor, eFrac1, endFrac);
                orphanedPadsOnly = false;
            }
            if (center != null) {
                lo.recenterLayout(center, genome, frc, true, true, true, null, null, null, loModKeys, orphanedPadsOnly ? null : padNeeds);
            }
            lo.applySupplementalDataCoords(sdc, genome, frc, loModKeys);
            if (specials != null) {
                lo.restoreSpecialLinks(specials, genome);
            }
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            mc.repairNetModuleLinkPadsLocally(padNeeds, frc, genome.getID(), orphanedPadsOnly, support);
            LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
            support.addEvent(lcev);
            return new LinkRouter.RoutingResult();
        }
        catch (AsynchExitRequestException ex) {
            db.rollbackLayoutUndoTransaction(dc);
            throw ex;
        }
    }

    public LinkRouter.RoutingResult expandGenome(Layout lo, Genome genome, Set groups, SUPanel sup, FontRenderContext frc, Point2D wsCenter, double fracH, double fracV, UndoSupport support, LayoutOptions options, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        double fullFrac = endFrac - startFrac;
        double frac1 = fullFrac * 0.1;
        double eFrac1 = startFrac + frac1;
        double frac2 = fullFrac * 0.9;
        ModificationCommands mc = new ModificationCommands();
        Layout.PadNeedsForLayout padNeeds = mc.getLocalNetModuleLinkPadNeeds(frc, genome.getID());
        Database db = Database.getDB();
        DatabaseChange dc = db.startLayoutUndoTransaction(lo.getName());
        try {
            boolean orphanedPadsOnly;
            Map allKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
            Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)allKeys.get(lo.getName());
            Point2D center = lo.getLayoutCenterAllOverlays(frc, loModKeys);
            if (center == null) {
                center = wsCenter;
            }
            Layout.SupplementalDataCoords sdc = lo.getSupplementalCoordsAllOverlays(genome, frc, loModKeys);
            Map moduleShapeRecovery = lo.getModuleShapeParams(loModKeys, frc, center);
            lo.dropUselessCorners(genome, frc, null, null, startFrac, eFrac1, monitor);
            Map specials = null;
            if (genome instanceof DBGenome) {
                TreeSet useExpandRows = new TreeSet();
                TreeSet useExpandCols = new TreeSet();
                lo.chooseExpansionRows(genome, frc, fracV, fracH, null, loModKeys, useExpandRows, useExpandCols, false, monitor);
                lo.expand(genome, useExpandRows, useExpandCols, 1, false, frc, null, null, null, monitor, eFrac1, endFrac);
                orphanedPadsOnly = true;
            } else {
                specials = lo.rememberSpecialLinks(genome);
                LayoutRubberStamper lrs = new LayoutRubberStamper();
                lrs.expandRootInstanceLayout(lo, (GenomeInstance)genome, groups, fracV, fracH, frc, padNeeds, loModKeys, moduleShapeRecovery, options, monitor, eFrac1, endFrac);
                orphanedPadsOnly = true;
            }
            if (center != null) {
                lo.recenterLayout(center, genome, frc, true, true, true, null, null, null, loModKeys, orphanedPadsOnly ? null : padNeeds);
            }
            lo.applySupplementalDataCoords(sdc, genome, frc, loModKeys);
            if (specials != null) {
                lo.restoreSpecialLinks(specials, genome);
            }
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            mc.repairNetModuleLinkPadsLocally(padNeeds, frc, genome.getID(), orphanedPadsOnly, support);
            sup.fixCenterPoint(true, support, false);
            LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
            support.addEvent(lcev);
            return new LinkRouter.RoutingResult();
        }
        catch (AsynchExitRequestException ex) {
            db.rollbackLayoutUndoTransaction(dc);
            throw ex;
        }
    }

    public LinkRouter.RoutingResult synchronizeAllLayouts(DBGenome dbg, FontRenderContext frc, UndoSupport support, LayoutOptions options, Point2D center, boolean directCopy, boolean keepGroups, boolean switchPads, List targets, BTProgressMonitor monitor) throws AsynchExitRequestException {
        Map globalModKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Map globalPadNeeds = new ModificationCommands().getGlobalNetModuleLinkPadNeeds(frc);
        HashMap<String, HashSet<String>> grpsForModel = new HashMap<String, HashSet<String>>();
        int numTargs = targets.size();
        for (int i = 0; i < numTargs; ++i) {
            AddCommands.SuperAddPair sap = (AddCommands.SuperAddPair)targets.get(i);
            HashSet<String> grps = (HashSet<String>)grpsForModel.get(sap.genomeID);
            if (grps == null) {
                grps = new HashSet<String>();
                grpsForModel.put(sap.genomeID, grps);
            }
            grps.add(sap.groupID);
        }
        Set doModels = grpsForModel.keySet();
        if (switchPads) {
            this.syncAllLinkPads(support, grpsForModel);
        }
        LayoutRubberStamper lrs = new LayoutRubberStamper();
        Database db = Database.getDB();
        LayoutManager lm = new LayoutManager();
        Layout lor = db.getLayout(lm.getLayout(dbg.getID()));
        Map rootRemember = lor.buildRememberProps(dbg, frc);
        Map rootSpecials = lor.rememberSpecialLinks(dbg);
        int instanceCount = 0;
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (gi.getVfgParent() != null) continue;
            ++instanceCount;
        }
        double currStart = 0.0;
        double perInstance = 1.0 / (double)instanceCount;
        double currFinal = currStart + perInstance;
        LinkRouter.RoutingResult finalRes = new LinkRouter.RoutingResult();
        iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            String gid;
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (monitor != null && !monitor.keepGoing()) {
                throw new AsynchExitRequestException();
            }
            if (!gi.isRootInstance() || !doModels.contains(gid = gi.getID())) continue;
            Set doGrps = (Set)grpsForModel.get(gid);
            String loKey = lm.getLayout(gid);
            Layout lo = db.getLayout(loKey);
            Layout origLayout = new Layout(lo);
            Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)globalModKeys.get(loKey);
            Layout.SupplementalDataCoords sdc = null;
            if (!directCopy) {
                sdc = lo.getSupplementalCoords(gi, frc, loModKeys);
            }
            Layout.PadNeedsForLayout padFixups = lo.findAllNetModuleLinkPadRequirements(frc);
            Map moduleShapeRecovery = lo.getModuleShapeParams(loModKeys, frc, center);
            Map savedRegionBounds = keepGroups ? this.saveRegionBounds(gi, lo, frc) : null;
            DatabaseChange dc = db.startLayoutUndoTransaction(loKey);
            try {
                Map rememberProps = lo.buildInheritedRememberProps(rootRemember, gi);
                Map specials = lo.buildInheritedSpecialLinks(rootSpecials, gi);
                if (directCopy || keepGroups) {
                    lo.dropNodeAndLinkProperties(gi, frc);
                } else {
                    lo.dropProperties(gi, frc);
                }
                LinkRouter.RoutingResult rr = lrs.synchronizeToRootLayout(lor, dbg, lo, gi, options, frc, loModKeys, moduleShapeRecovery, monitor, savedRegionBounds, origLayout, directCopy, keepGroups, currStart, currFinal, rememberProps, doGrps, globalPadNeeds);
                finalRes.merge(rr);
                if (!directCopy) {
                    lo.applySupplementalDataCoords(sdc, gi, frc, loModKeys);
                }
                if (specials != null) {
                    lo.restoreSpecialLinks(specials, gi);
                }
                Map orpho = lo.orphansOnlyForAll(false);
                lo.repairAllNetModuleLinkPadRequirements(frc, padFixups, orpho);
                dc = db.finishLayoutUndoTransaction(dc);
                support.addEdit(new DatabaseChangeCmd(dc));
                currStart = currFinal;
                currFinal = currStart + perInstance;
            }
            catch (AsynchExitRequestException ex) {
                db.rollbackLayoutUndoTransaction(dc);
                throw ex;
            }
        }
        return finalRes;
    }

    public LinkRouter.RoutingResult synchronizeRootLayoutFromChildren(DBGenome dbg, Layout lor, FontRenderContext frc, UndoSupport support, LayoutDerivation ld, Point2D center, BTProgressMonitor monitor, double startFrac, double maxFrac) throws AsynchExitRequestException {
        LayoutRubberStamper lrs = new LayoutRubberStamper();
        Database db = Database.getDB();
        String lorKey = lor.getName();
        Map rootRemember = lor.buildRememberProps(dbg, frc);
        Map rootSpecials = lor.rememberSpecialLinks(dbg);
        Layout.PadNeedsForLayout padFixups = lor.findAllNetModuleLinkPadRequirements(frc);
        Map globalModKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)globalModKeys.get(lorKey);
        Map moduleShapeRecovery = lor.getModuleShapeParams(loModKeys, frc, center);
        LinkRouter.RoutingResult rr = null;
        DatabaseChange dc = null;
        if (support != null) {
            dc = db.startLayoutUndoTransaction(lorKey);
        }
        try {
            rr = lrs.upwardCopy(lor, dbg, ld, frc, rootRemember, this, loModKeys, moduleShapeRecovery, monitor, startFrac, maxFrac, support);
            if (rootRemember != null) {
                lor.restoreLabelLocations(rootRemember, dbg, frc, null);
            }
            if (rootSpecials != null) {
                lor.restoreSpecialLinks(rootSpecials, dbg);
            }
            if (support != null) {
                dc = db.finishLayoutUndoTransaction(dc);
                support.addEdit(new DatabaseChangeCmd(dc));
            }
        }
        catch (AsynchExitRequestException ex) {
            if (support != null) {
                db.rollbackLayoutUndoTransaction(dc);
            }
            throw ex;
        }
        ModificationCommands mc = new ModificationCommands();
        mc.repairNetModuleLinkPadsLocally(padFixups, frc, dbg.getID(), false, support);
        return rr;
    }

    public void upwardSyncAllLinkPads(DBGenome dbg, PadCalculatorToo.UpwardPadSyncData upsd, UndoSupport support, boolean forcePads, Set orphanedLinks) {
        PadCalculatorToo pcalc = new PadCalculatorToo();
        HashMap launchDirections = new HashMap();
        HashMap landDirections = new HashMap();
        pcalc.getDirections(upsd, dbg, launchDirections, landDirections, forcePads, orphanedLinks);
        GenomeChange[] gca = dbg.installPadChanges(launchDirections, landDirections);
        if (support != null && gca != null) {
            boolean doEvent = false;
            for (int i = 0; i < gca.length; ++i) {
                if (gca[i] == null) continue;
                GenomeChangeCmd gcc = new GenomeChangeCmd(gca[i]);
                support.addEdit(gcc);
                doEvent = true;
            }
            if (doEvent) {
                support.addEvent(new ModelChangeEvent(dbg.getID(), 1));
            }
        }
    }

    public boolean alignAllLayouts(boolean doMatchups, boolean doCentering, boolean skipOverlays, SUPanel sup, FontRenderContext frc) {
        Map allKeys = skipOverlays ? null : new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        UndoSupport support = new UndoSupport(this.undom_, "undo.alignAllLayouts");
        Database db = Database.getDB();
        Genome dbg = db.getGenome();
        LayoutManager lm = new LayoutManager();
        String lorKey = lm.getLayout(dbg.getID());
        Layout lor = db.getLayout(lorKey);
        Layout.OverlayKeySet lorModKeys = skipOverlays ? null : (Layout.OverlayKeySet)allKeys.get(lorKey);
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (gi.getVfgParent() != null) continue;
            String gid = gi.getID();
            String loKey = lm.getLayout(gid);
            Layout lo = db.getLayout(loKey);
            DatabaseChange dc = db.startLayoutUndoTransaction(loKey);
            Layout.OverlayKeySet loModKeys = skipOverlays ? null : (Layout.OverlayKeySet)allKeys.get(loKey);
            lo.alignToLayout(lor, frc, doMatchups, loModKeys, lorModKeys, null);
            dc = db.finishLayoutUndoTransaction(dc);
            support.addEdit(new DatabaseChangeCmd(dc));
            LayoutChangeEvent lcev = new LayoutChangeEvent(lo.getName(), 1);
            support.addEvent(lcev);
        }
        if (doCentering) {
            sup.fixCenterPoint(true, support, false);
        }
        support.finish();
        return true;
    }

    public boolean centerLayout(Genome genome, Point2D newCenter, FontRenderContext frc) {
        Map globalKeys = new FullGenomeHierarchyOracle().fullModuleKeysPerLayout();
        UndoSupport support = new UndoSupport(this.undom_, "undo.centerCurrentLayout");
        LayoutManager lm = new LayoutManager();
        Database db = Database.getDB();
        String loKey = lm.getLayout(genome.getID());
        Layout lor = db.getLayout(loKey);
        Layout.OverlayKeySet loModKeys = (Layout.OverlayKeySet)globalKeys.get(loKey);
        DatabaseChange dc = db.startLayoutUndoTransaction(loKey);
        lor.recenterLayout(newCenter, genome, frc, true, true, true, null, null, null, loModKeys, null);
        dc = db.finishLayoutUndoTransaction(dc);
        support.addEdit(new DatabaseChangeCmd(dc));
        LayoutChangeEvent lcev = new LayoutChangeEvent(lor.getName(), 1);
        support.addEvent(lcev);
        support.finish();
        return true;
    }

    private Set processExpressedGenes(Set expressed, HashMap newNodeTypes, UndoSupport support) {
        HashSet<String> retval = new HashSet<String>();
        Database db = Database.getDB();
        DBGenome dbg = (DBGenome)db.getGenome();
        TimeCourseData tcd = db.getTimeCourseData();
        Iterator exit = expressed.iterator();
        while (exit.hasNext()) {
            String nodeID;
            String name = (String)exit.next();
            Set inverses = tcd.getTimeCourseDataKeyInverses(name);
            if (!inverses.isEmpty()) {
                retval.addAll(inverses);
                continue;
            }
            DBGene oldGene = dbg.getGeneWithName(name);
            Set oldNodes = dbg.getNodesWithName(name);
            int onSize = oldNodes.size();
            if (oldGene != null) {
                nodeID = oldGene.getID();
                if (tcd.haveDataForNode(nodeID)) continue;
                retval.add(nodeID);
            } else if (onSize != 0) {
                DBNode oldNode;
                if (onSize != 1 || tcd.haveDataForNode(nodeID = (oldNode = (DBNode)oldNodes.iterator().next()).getID())) continue;
                retval.add(nodeID);
            } else {
                nodeID = dbg.getNextKey();
                retval.add(nodeID);
                DBGene newGene = new DBGene(name, nodeID);
                GenomeChange gc = dbg.addGeneWithExistingLabel(newGene);
                newNodeTypes.put(nodeID, new Integer(4));
                if (gc != null) {
                    GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                    support.addEdit(gcc);
                }
            }
            ArrayList<TimeCourseData.TCMapping> targIDs = new ArrayList<TimeCourseData.TCMapping>();
            targIDs.add(new TimeCourseData.TCMapping(name));
            TimeCourseChange tcc = tcd.addTimeCourseTCMMap(nodeID, targIDs, true);
            if (tcc == null) continue;
            support.addEdit(new TimeCourseChangeCmd(tcc, false));
        }
        return retval;
    }

    private void syncAllLinkPads(UndoSupport support, Map groupsForModel) {
        Database db = Database.getDB();
        Set models = groupsForModel == null ? null : groupsForModel.keySet();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            GenomeInstance rootGi = gi.getVfgParentRoot();
            HashSet<String> useGroups = null;
            if (rootGi == null) {
                rootGi = gi;
                HashSet<String> hashSet = useGroups = groupsForModel == null ? null : (HashSet<String>)groupsForModel.get(rootGi.getID());
            }
            if (models != null && !models.contains(rootGi.getID())) continue;
            if (models != null && useGroups == null) {
                Set needGroups = (Set)groupsForModel.get(rootGi.getID());
                int genCount = gi.getGeneration();
                useGroups = new HashSet<String>();
                Iterator grit = needGroups.iterator();
                while (grit.hasNext()) {
                    String groupID = (String)grit.next();
                    String baseGrpID = Group.getBaseID(groupID);
                    String inherit = Group.buildInheritedID(baseGrpID, genCount);
                    useGroups.add(inherit);
                }
            }
            GenomeChange[] changes = gi.syncAllLinkagePads(useGroups);
            int numCh = changes.length;
            for (int i = 0; i < numCh; ++i) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(changes[i]);
                support.addEdit(gcc);
            }
            support.addEvent(new ModelChangeEvent(gi.getID(), 1));
        }
        db.clearAllDynamicProxyCaches();
    }

    private String buildRegion(GenomeInstance gi, Layout lo, String region, Point2D groupCenter, UndoSupport support) {
        int order;
        int groupCount;
        Layout.PropChange lpc;
        String groupKey = gi.getGenome().getNextKey();
        Group newGroup = new Group(groupKey, region);
        GenomeChange gc = gi.addGroupWithExistingLabel(newGroup);
        if (gc != null) {
            GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
            support.addEdit(gcc);
        }
        if ((lpc = lo.setGroupProperties(groupKey, new GroupProperties(groupCount = gi.groupCount(), groupKey, lo, groupCenter, order = lo.getTopGroupOrder() + 1))) != null) {
            PropChangeCmd pcc = new PropChangeCmd(new Layout.PropChange[]{lpc});
            support.addEdit(pcc);
        }
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        ArrayList<GroupUsage> mapped = new ArrayList<GroupUsage>();
        mapped.add(new GroupUsage(region, null));
        TimeCourseChange tcc = tcd.setTimeCourseGroupMap(groupKey, mapped, true);
        if (tcc != null) {
            support.addEdit(new TimeCourseChangeCmd(tcc, false));
        }
        return groupKey;
    }

    private void buildItemsFromMotifs(DBGenome genome, DBGenome oldGenome, List pairList, List createdPairs, Map newNodeToOldNode, Map newLinksToOldLinks, Map newTypesByID, List newMotifs, AddCommands ac, OldPadMapper opm, Map padConstraintSaver, UndoSupport support) {
        DialogBuiltMotifPair existingPair;
        DialogBuiltMotifPair createdPair;
        int i;
        int size = pairList.size();
        for (i = 0; i < size; ++i) {
            DialogBuiltMotifPair existingPair2 = (DialogBuiltMotifPair)pairList.get(i);
            DialogBuiltMotifPair createdPair2 = new DialogBuiltMotifPair();
            createdPair2.instructionID = existingPair2.instructionID;
            createdPair2.proto = (DialogBuiltProtoMotif)existingPair2.proto.clone();
            createdPair2.real = existingPair2.real.emptyCopy();
            createdPairs.add(createdPair2);
        }
        for (i = 0; i < size; ++i) {
            createdPair = (DialogBuiltMotifPair)createdPairs.get(i);
            existingPair = (DialogBuiltMotifPair)pairList.get(i);
            createdPair.proto.generateRealMotif(genome, oldGenome, createdPair, existingPair.real, createdPairs, pairList, newNodeToOldNode, newLinksToOldLinks, newTypesByID, ac, opm, padConstraintSaver, support, true);
            newMotifs.add(createdPair.real);
        }
        for (i = 0; i < size; ++i) {
            createdPair = (DialogBuiltMotifPair)createdPairs.get(i);
            existingPair = (DialogBuiltMotifPair)pairList.get(i);
            createdPair.proto.generateRealMotif(genome, oldGenome, createdPair, existingPair.real, createdPairs, pairList, newNodeToOldNode, newLinksToOldLinks, newTypesByID, ac, opm, padConstraintSaver, support, false);
            newMotifs.add(createdPair.real);
        }
    }

    private boolean extractDialogBuiltMotifs(DBGenome genome, List protoPairs, OldPadMapper oldPads) {
        boolean retval = false;
        int size = protoPairs.size();
        for (int j = 0; j < size; ++j) {
            DialogBuiltMotifPair pair = (DialogBuiltMotifPair)protoPairs.get(j);
            DialogBuiltProtoMotif dbpm = pair.proto;
            int srcType = dbpm.getSourceType();
            String srcName = dbpm.getSourceName();
            Node oldNode = DialogBuiltProtoMotif.nodeMatchingNameAndType(genome, srcName, srcType);
            if (oldNode != null) {
                retval = true;
            }
            dbpm.patternMatchMotif(genome, oldNode, pair, protoPairs, oldPads);
        }
        return retval;
    }

    private void collectUnusedItems(Genome genome, List protoPairs, Set deadNodes, Set deadLinks) {
        HashSet liveNodes = new HashSet();
        HashSet liveLinks = new HashSet();
        int size = protoPairs.size();
        for (int j = 0; j < size; ++j) {
            DialogBuiltMotifPair pair = (DialogBuiltMotifPair)protoPairs.get(j);
            DialogBuiltMotif dbm = pair.real;
            dbm.getExistingNodesAndLinks(liveNodes, liveLinks);
        }
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            Node node = (Node)git.next();
            String nid = node.getID();
            if (liveNodes.contains(nid)) continue;
            deadNodes.add(nid);
        }
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nid = node.getID();
            if (liveNodes.contains(nid)) continue;
            deadNodes.add(nid);
        }
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String lid = link.getID();
            if (liveLinks.contains(lid)) continue;
            deadLinks.add(lid);
        }
    }

    private Map rememberTypes(DBGenome genome) {
        Node node;
        HashMap<String, Integer> retval = new HashMap<String, Integer>();
        Iterator nit = genome.getGeneIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            retval.put(node.getID(), new Integer(node.getNodeType()));
        }
        nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            retval.put(node.getID(), new Integer(node.getNodeType()));
        }
        return retval;
    }

    private String getInstanceForRegion(String regionID, String nodeID, Map instanceMap) {
        List riList = (List)instanceMap.get(nodeID);
        if (riList == null) {
            return null;
        }
        int regNum = riList.size();
        for (int i = 0; i < regNum; ++i) {
            RegionInstance ri = (RegionInstance)riList.get(i);
            if (!ri.regionID.equals(regionID)) continue;
            return ri.instance;
        }
        return null;
    }

    private void recordInstanceForRegion(String regionID, String nodeID, String instance, Map instanceMap) {
        ArrayList<RegionInstance> riList = (ArrayList<RegionInstance>)instanceMap.get(nodeID);
        if (riList == null) {
            riList = new ArrayList<RegionInstance>();
            instanceMap.put(nodeID, riList);
        }
        riList.add(new RegionInstance(regionID, instance));
    }

    private String getLinkInstanceForRegionTuple(GenomeInstance.GroupTuple grpTup, String linkID, Map instanceMap) {
        List riList = (List)instanceMap.get(linkID);
        if (riList == null) {
            return null;
        }
        int regNum = riList.size();
        for (int i = 0; i < regNum; ++i) {
            RegionTupleInstance ri = (RegionTupleInstance)riList.get(i);
            if (!ri.srcRegionID.equals(grpTup.getSourceGroup()) || !ri.targRegionID.equals(grpTup.getTargetGroup())) continue;
            return ri.instance;
        }
        return null;
    }

    private void recordLinkInstanceForRegionTuple(GenomeInstance.GroupTuple grpTup, String linkID, String instance, Map instanceMap) {
        ArrayList<RegionTupleInstance> riList = (ArrayList<RegionTupleInstance>)instanceMap.get(linkID);
        if (riList == null) {
            riList = new ArrayList<RegionTupleInstance>();
            instanceMap.put(linkID, riList);
        }
        riList.add(new RegionTupleInstance(grpTup.getSourceGroup(), grpTup.getTargetGroup(), instance));
    }

    private Map saveRegionBounds(GenomeInstance gi, Layout lo, FontRenderContext frc) {
        HashMap<String, Rectangle> retval = new HashMap<String, Rectangle>();
        Iterator git = gi.getGroupIterator();
        GroupFree rend = new GroupFree();
        while (git.hasNext()) {
            Group group = (Group)git.next();
            String groupRef = group.getID();
            GroupProperties gp = lo.getGroupProperties(groupRef);
            if (gp.getLayer() != 0) continue;
            Rectangle bounds = lo.getLayoutBoundsForGroup(gi, group, frc, true);
            retval.put(groupRef, bounds);
        }
        return retval;
    }

    private static class SubsetCacheValues {
        ArrayList nodes = new ArrayList();
        ArrayList genes = new ArrayList();
        ArrayList links = new ArrayList();

        SubsetCacheValues() {
        }

        public String toString() {
            return "SubsetCacheValues: nodes = " + this.nodes + " genes = " + this.genes + " links = " + this.links;
        }
    }

    public static class LegacyInstanceIdMapper {
        private Map rootNodeMap_;
        private Map rootLinkMap_;
        private Map regionKeyMap_;
        private Map legacyNodeInstanceMap_;
        private Map legacyLinkInstanceMap_;
        private Map instanceNodeMap_;
        private Map instanceLinkMap_;

        public LegacyInstanceIdMapper(Map rootNodeMap, Map rootLinkMap) {
            this.rootNodeMap_ = rootNodeMap;
            this.rootLinkMap_ = rootLinkMap;
            this.regionKeyMap_ = new HashMap();
            this.legacyNodeInstanceMap_ = new HashMap();
            this.legacyLinkInstanceMap_ = new HashMap();
            this.instanceNodeMap_ = new HashMap();
            this.instanceLinkMap_ = new HashMap();
        }

        void setRegionMapping(Map newToOldRegionMap) {
            this.regionKeyMap_ = newToOldRegionMap;
        }

        Map getRegionMapping() {
            return this.regionKeyMap_;
        }

        Map getInstanceNodeMapping() {
            return this.instanceNodeMap_;
        }

        Map getInstanceLinkMapping() {
            return this.instanceLinkMap_;
        }

        void recordLegacyInstancesForRegions(DBGenome dbg, GenomeInstance gi) {
            HashMap<String, String> regionForInstance = new HashMap<String, String>();
            Iterator git = gi.getGroupIterator();
            while (git.hasNext()) {
                Group grp = (Group)git.next();
                String regionID = grp.getID();
                Iterator mit = grp.getMemberIterator();
                while (mit.hasNext()) {
                    GroupMember gm = (GroupMember)mit.next();
                    String gmID = gm.getID();
                    String instanceID = Integer.toString(GenomeItemInstance.getInstanceID(gmID));
                    String baseID = GenomeItemInstance.getBaseID(gmID);
                    ArrayList<RegionInstance> riList = (ArrayList<RegionInstance>)this.legacyNodeInstanceMap_.get(baseID);
                    if (riList == null) {
                        riList = new ArrayList<RegionInstance>();
                        this.legacyNodeInstanceMap_.put(baseID, riList);
                    }
                    riList.add(new RegionInstance(regionID, instanceID));
                    regionForInstance.put(gmID, regionID);
                }
            }
            Iterator lit = gi.getLinkageIterator();
            while (lit.hasNext()) {
                LinkageInstance link = (LinkageInstance)lit.next();
                String srcID = link.getSource();
                String trgID = link.getTarget();
                String srcRegion = (String)regionForInstance.get(srcID);
                String trgRegion = (String)regionForInstance.get(trgID);
                String linkID = link.getID();
                String instanceID = Integer.toString(GenomeItemInstance.getInstanceID(linkID));
                String baseID = GenomeItemInstance.getBaseID(linkID);
                ArrayList<RegionTupleInstance> riList = (ArrayList<RegionTupleInstance>)this.legacyLinkInstanceMap_.get(baseID);
                if (riList == null) {
                    riList = new ArrayList<RegionTupleInstance>();
                    this.legacyLinkInstanceMap_.put(baseID, riList);
                }
                riList.add(new RegionTupleInstance(srcRegion, trgRegion, instanceID));
            }
        }

        String getLegacyInstanceForRegion(String nodeID, String newRegKey) {
            String oldKey = (String)this.regionKeyMap_.get(newRegKey);
            if (oldKey == null) {
                return null;
            }
            List riList = (List)this.legacyNodeInstanceMap_.get(nodeID);
            if (riList == null) {
                return null;
            }
            int regNum = riList.size();
            for (int i = 0; i < regNum; ++i) {
                RegionInstance ri = (RegionInstance)riList.get(i);
                if (!ri.regionID.equals(oldKey)) continue;
                return ri.instance;
            }
            return null;
        }

        void recordInstanceForRegion(String regionID, String nodeID, String instance) {
            String legacyNodeID = (String)this.rootNodeMap_.get(nodeID);
            String legacyInstance = this.getLegacyInstanceForRegion(nodeID, regionID);
            if (legacyNodeID == null || legacyInstance == null) {
                return;
            }
            String oldCombined = GenomeItemInstance.getCombinedID(legacyNodeID, legacyInstance);
            String newCombined = GenomeItemInstance.getCombinedID(nodeID, instance);
            this.instanceNodeMap_.put(newCombined, oldCombined);
        }

        String getLegacyInstanceForRegionTuple(String linkID, String srcRegionID, String trgRegionID) {
            String oldSrcKey = (String)this.regionKeyMap_.get(srcRegionID);
            if (oldSrcKey == null) {
                return null;
            }
            List riList = (List)this.legacyLinkInstanceMap_.get(linkID);
            if (riList == null) {
                return null;
            }
            int regNum = riList.size();
            for (int i = 0; i < regNum; ++i) {
                RegionTupleInstance rti = (RegionTupleInstance)riList.get(i);
                if (!rti.srcRegionID.equals(srcRegionID) || !rti.targRegionID.equals(trgRegionID)) continue;
                return rti.instance;
            }
            return null;
        }

        void recordInstanceForRegionTuple(String srcRegionID, String trgRegionID, String linkID, String instance) {
            String legacyLinkID = (String)this.rootLinkMap_.get(linkID);
            String legacyInstance = this.getLegacyInstanceForRegionTuple(linkID, srcRegionID, trgRegionID);
            if (legacyLinkID == null || legacyInstance == null) {
                return;
            }
            String oldCombined = GenomeItemInstance.getCombinedID(legacyLinkID, legacyInstance);
            String newCombined = GenomeItemInstance.getCombinedID(linkID, instance);
            this.instanceLinkMap_.put(newCombined, oldCombined);
        }
    }

    private static class RegionTupleInstance {
        String srcRegionID;
        String targRegionID;
        String instance;

        RegionTupleInstance(String srcRegionID, String targRegionID, String instance) {
            this.srcRegionID = srcRegionID;
            this.targRegionID = targRegionID;
            this.instance = instance;
        }
    }

    private static class RegionInstance {
        String regionID;
        String instance;

        RegionInstance(String regionID, String instance) {
            this.regionID = regionID;
            this.instance = instance;
        }

        public String toString() {
            return "RegionInstance: " + this.regionID + " " + this.instance;
        }
    }

    private static class UpwardLayoutSynchRunner
    extends BackgroundWorker {
        private DBGenome genome_;
        private Layout lor_;
        private FontRenderContext frc_;
        private UndoSupport support_;
        private LayoutDerivation ld_;
        private ToolCommands tc_;
        private Point2D center_;

        public UpwardLayoutSynchRunner(DBGenome dbg, Layout lor, FontRenderContext frc, UndoSupport support, LayoutDerivation ld, Point2D center, ToolCommands tc) {
            super(new LinkRouter.RoutingResult());
            this.genome_ = dbg;
            this.lor_ = lor;
            this.frc_ = frc;
            this.support_ = support;
            this.ld_ = ld;
            this.tc_ = tc;
            this.center_ = center;
        }

        public Object runCore() throws AsynchExitRequestException {
            LinkRouter.RoutingResult result = this.tc_.synchronizeRootLayoutFromChildren(this.genome_, this.lor_, this.frc_, this.support_, this.ld_, this.center_, this, 0.0, 1.0);
            Database.getDB().clearAllDynamicProxyCaches();
            return result;
        }

        public Object postRunCore() {
            return null;
        }
    }

    public static class UpwardLayoutSynch
    implements BackgroundWorkerOwner {
        private BackgroundWorkerControlManager cView_;
        private JFrame myTopWindow_;
        private UndoManager myUndom_;
        private boolean cancelled_;

        public void synchronizeRootLayoutFromChildrenAsynch(DBGenome dbg, Layout lor, FontRenderContext frc, UndoSupport support, LayoutDerivation ld, Point2D center, BackgroundWorkerControlManager cView, JFrame myTopWindow, UndoManager undo) {
            this.cView_ = cView;
            this.myTopWindow_ = myTopWindow;
            this.myUndom_ = undo;
            this.cancelled_ = false;
            ToolCommands tc = new ToolCommands(this.myTopWindow_, null, this.myUndom_);
            UpwardLayoutSynchRunner runner = new UpwardLayoutSynchRunner(dbg, lor, frc, support, ld, center, tc);
            BackgroundWorkerClient bwc = new BackgroundWorkerClient(this, runner, this.myTopWindow_, this.cView_, "linkLayout.waitTitle", "linkLayout.wait", support, true);
            runner.setClient(bwc);
            bwc.launchWorker();
        }

        public boolean handleRemoteException(Exception remoteEx) {
            return false;
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void handleCancellation() {
            this.cancelled_ = true;
        }

        public boolean wasCancelled() {
            return this.cancelled_;
        }

        public void cleanUpPostRepaint(Object result) {
            ToolCommands tc = new ToolCommands(this.myTopWindow_, null, this.myUndom_);
            tc.doStatusAnnouncements((LinkRouter.RoutingResult)result, this.myTopWindow_);
        }
    }
}

