/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.app.NavigationChange;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NavigationChangeCmd;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.cmd.UserTreePathChangeCmd;
import org.systemsbiology.biotapestry.cmd.UserTreePathControllerChange;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.OverlayDisplayChange;
import org.systemsbiology.biotapestry.nav.UserTreePath;
import org.systemsbiology.biotapestry.nav.UserTreePathChange;
import org.systemsbiology.biotapestry.nav.UserTreePathManager;
import org.systemsbiology.biotapestry.nav.UserTreePathStop;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class UserTreePathController {
    public static final String INSERT_START = "insertStart";
    public static final String INSERT_END = "insertEnd";
    public static final String INSERT_AFTER_CURRENT = "insertAfterCurrent";
    private static final int NO_STOP_CHANGE_ = 0;
    private static final int STOP_MOD_ = 1;
    private static final int STOP_DROP_ = 2;
    private static final int MODEL_CHECK_ = 0;
    private static final int OVERLAY_CHECK_ = 1;
    private static final int MODULE_CHECK_ = 2;
    private NavTree navTree_;
    private JTree jtree_;
    private CommonView suw_;
    private String currPathKey_;
    private int currStopIndex_;
    private String lastPathKey_;
    private HashMap lastStop_;
    private PathNavigationInfo pendingNavInfo_;
    private boolean pendingNavProcessed_;
    private MainCommands mcmd_;

    public UserTreePathController(CommonView suw, MainCommands mcmd) {
        this.suw_ = suw;
        this.mcmd_ = mcmd;
        this.pendingNavInfo_ = null;
        this.pendingNavProcessed_ = false;
        this.lastStop_ = new HashMap();
        this.clearControllerState();
    }

    public void clearControllerState() {
        this.currPathKey_ = null;
        this.currStopIndex_ = -1;
        this.lastPathKey_ = null;
        this.lastStop_.clear();
    }

    public boolean currentModelMatchesState() {
        if (this.currPathKey_ == null) {
            return true;
        }
        if (this.currStopIndex_ == -1) {
            return false;
        }
        UserTreePathManager utpm = UserTreePathManager.getMgr();
        UserTreePath currPath = utpm.getPath(this.currPathKey_);
        UserTreePathStop stop = currPath.getStop(this.currStopIndex_);
        return this.currentModelMatchesStop(stop);
    }

    public boolean currentModelMatchesStop(UserTreePathStop stop) {
        TaggedSet stopModules;
        SUPanel sup = this.suw_.getSUPanel();
        String genomeKey = sup.getGenome();
        if (!stop.getGenomeID().equals(genomeKey)) {
            return false;
        }
        String currOverlay = sup.getCurrentOverlay();
        String stopOverlay = stop.getOverlay();
        if (stopOverlay == null) {
            return currOverlay == null;
        }
        if (!stopOverlay.equals(currOverlay)) {
            return false;
        }
        TaggedSet currModules = sup.getCurrentNetModules();
        if (!currModules.equals(stopModules = stop.getModules())) {
            return false;
        }
        TaggedSet currReveal = NetOverlayController.normalizedRevealedModules(genomeKey, currOverlay, currModules, sup.getRevealedModules());
        TaggedSet stopReveal = stop.getRevealed();
        return currReveal.equals(stopReveal);
    }

    public int currentModelOnCurrentPath() {
        if (this.currPathKey_ == null) {
            return -1;
        }
        UserTreePathManager utpm = UserTreePathManager.getMgr();
        UserTreePath currPath = utpm.getPath(this.currPathKey_);
        int maxBelow = Integer.MIN_VALUE;
        int minAtOrAbove = Integer.MAX_VALUE;
        boolean haveAMatch = false;
        int stopCount = this.getStopCount();
        for (int i = 0; i < stopCount; ++i) {
            UserTreePathStop stop = currPath.getStop(i);
            if (!this.currentModelMatchesStop(stop)) continue;
            if (i < this.currStopIndex_) {
                maxBelow = i;
                haveAMatch = true;
                continue;
            }
            minAtOrAbove = i;
            haveAMatch = true;
            break;
        }
        if (!haveAMatch) {
            return Integer.MIN_VALUE;
        }
        if (maxBelow == Integer.MIN_VALUE) {
            return minAtOrAbove;
        }
        if (minAtOrAbove == Integer.MAX_VALUE) {
            return maxBelow;
        }
        int diffBelow = this.currStopIndex_ - maxBelow;
        int diffAbove = minAtOrAbove - this.currStopIndex_;
        return diffBelow < diffAbove ? maxBelow : minAtOrAbove;
    }

    public Integer getLastStop(String pathKey) {
        if (pathKey.equals(this.currPathKey_)) {
            return new Integer(this.currStopIndex_);
        }
        return (Integer)this.lastStop_.get(pathKey);
    }

    public boolean syncPathControls(NavigationChange nc) {
        UserTreePathStop stop;
        UserTreePath currPath;
        if (this.currentModelMatchesState()) {
            return false;
        }
        nc.oldUserPathKey = this.currPathKey_;
        nc.oldUserPathStop = this.currStopIndex_;
        UserTreePathManager utpm = UserTreePathManager.getMgr();
        nc.odc = new OverlayDisplayChange();
        if (this.currPathKey_ != null && this.currStopIndex_ != -1) {
            currPath = utpm.getPath(this.currPathKey_);
            stop = currPath.getStop(this.currStopIndex_);
            nc.odc.oldGenomeID = stop.getGenomeID();
            nc.odc.oldOvrKey = stop.getOverlay();
            nc.odc.oldModKeys = (TaggedSet)stop.getModules().clone();
            nc.odc.oldRevealedKeys = (TaggedSet)stop.getRevealed().clone();
        } else {
            nc.odc.oldGenomeID = this.suw_.getSUPanel().getGenome();
            nc.odc.oldOvrKey = null;
            nc.odc.oldModKeys = new TaggedSet();
            nc.odc.oldRevealedKeys = new TaggedSet();
        }
        int newStop = this.currentModelOnCurrentPath();
        if (newStop == -1 || newStop == Integer.MIN_VALUE) {
            this.lastStop_.put(this.currPathKey_, new Integer(this.currStopIndex_));
            this.lastPathKey_ = this.currPathKey_;
            this.currPathKey_ = null;
            this.currStopIndex_ = -1;
        } else {
            this.currStopIndex_ = newStop;
        }
        nc.userPathSelection = false;
        nc.userPathSync = true;
        nc.newUserPathKey = this.currPathKey_;
        nc.newUserPathStop = this.currStopIndex_;
        if (this.currPathKey_ != null && this.currStopIndex_ != -1) {
            currPath = utpm.getPath(this.currPathKey_);
            stop = currPath.getStop(this.currStopIndex_);
            nc.odc.newGenomeID = stop.getGenomeID();
            nc.odc.newOvrKey = stop.getOverlay();
            nc.odc.newModKeys = (TaggedSet)stop.getModules().clone();
            nc.odc.newRevealedKeys = (TaggedSet)stop.getRevealed().clone();
        } else {
            nc.odc.newGenomeID = this.suw_.getSUPanel().getGenome();
            nc.odc.newOvrKey = null;
            nc.odc.newModKeys = new TaggedSet();
            nc.odc.newRevealedKeys = new TaggedSet();
        }
        int currPathIndex = this.currPathKey_ == null ? -1 : utpm.getPathIndex(this.currPathKey_);
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
        return true;
    }

    public void setCurrentPath(String pathKey) {
        if (this.currPathKey_ != null) {
            this.lastStop_.put(this.currPathKey_, new Integer(this.currStopIndex_));
        }
        this.setCurrentPath(pathKey, null, null, null, null);
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public void setTreeObjects(NavTree navTree, JTree jtree) {
        this.navTree_ = navTree;
        this.jtree_ = jtree;
    }

    public void pathBackward() {
        int stopCount = this.getStopCount();
        if (stopCount > 0 && this.currStopIndex_ > 0) {
            PathNavigationInfo pni = new PathNavigationInfo();
            pni.support = new UndoSupport(this.suw_.getUndoManager(), "undo.treePathBackward");
            pni.nav = new NavigationChange();
            pni.nav.commonView = this.suw_;
            pni.nav.userPathSelection = true;
            pni.nav.userPathSync = false;
            UserTreePathManager mgr = UserTreePathManager.getMgr();
            UserTreePath currPath = mgr.getPath(this.currPathKey_);
            pni.nav.oldUserPathKey = this.currPathKey_;
            pni.nav.newUserPathKey = this.currPathKey_;
            pni.nav.odc = new OverlayDisplayChange();
            UserTreePathStop stop = currPath.getStop(this.currStopIndex_);
            pni.nav.odc.oldGenomeID = stop.getGenomeID();
            pni.nav.odc.oldOvrKey = stop.getOverlay();
            pni.nav.odc.oldModKeys = (TaggedSet)stop.getModules().clone();
            pni.nav.odc.oldRevealedKeys = (TaggedSet)stop.getRevealed().clone();
            pni.nav.oldUserPathStop = this.currStopIndex_--;
            pni.nav.newUserPathStop = this.currStopIndex_;
            stop = currPath.getStop(this.currStopIndex_);
            pni.nav.odc.newGenomeID = stop.getGenomeID();
            pni.nav.odc.newOvrKey = stop.getOverlay();
            pni.nav.odc.newModKeys = (TaggedSet)stop.getModules().clone();
            pni.nav.odc.newRevealedKeys = (TaggedSet)stop.getRevealed().clone();
            this.selectTreePath(stop.getGenomeID(), stop.getOverlay(), stop.getModules(), stop.getRevealed(), pni);
        }
    }

    public void pathForward() {
        int stopCount = this.getStopCount();
        if (stopCount > 0 && this.currStopIndex_ < stopCount - 1) {
            PathNavigationInfo pni = new PathNavigationInfo();
            pni.support = new UndoSupport(this.suw_.getUndoManager(), "undo.treePathForward");
            pni.nav = new NavigationChange();
            pni.nav.commonView = this.suw_;
            pni.nav.userPathSelection = true;
            pni.nav.userPathSync = false;
            UserTreePathManager mgr = UserTreePathManager.getMgr();
            UserTreePath currPath = mgr.getPath(this.currPathKey_);
            pni.nav.oldUserPathKey = this.currPathKey_;
            pni.nav.newUserPathKey = this.currPathKey_;
            pni.nav.odc = new OverlayDisplayChange();
            UserTreePathStop stop = currPath.getStop(this.currStopIndex_);
            pni.nav.odc.oldGenomeID = stop.getGenomeID();
            pni.nav.odc.oldOvrKey = stop.getOverlay();
            pni.nav.odc.oldModKeys = (TaggedSet)stop.getModules().clone();
            pni.nav.odc.oldRevealedKeys = (TaggedSet)stop.getRevealed().clone();
            pni.nav.oldUserPathStop = this.currStopIndex_++;
            pni.nav.newUserPathStop = this.currStopIndex_;
            stop = currPath.getStop(this.currStopIndex_);
            pni.nav.odc.newGenomeID = stop.getGenomeID();
            pni.nav.odc.newOvrKey = stop.getOverlay();
            pni.nav.odc.newModKeys = (TaggedSet)stop.getModules().clone();
            pni.nav.odc.newRevealedKeys = (TaggedSet)stop.getRevealed().clone();
            this.selectTreePath(stop.getGenomeID(), stop.getOverlay(), stop.getModules(), stop.getRevealed(), pni);
        }
    }

    public boolean hasAPath() {
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        return mgr.getPathCount() > 0;
    }

    public boolean canGoForward() {
        int stopCount = this.getStopCount();
        return this.pathIsSelected() && stopCount > 0 && this.currStopIndex_ < stopCount - 1;
    }

    public boolean canGoBackward() {
        int stopCount = this.getStopCount();
        return this.pathIsSelected() && stopCount > 0 && this.currStopIndex_ > 0;
    }

    public boolean pathIsSelected() {
        return this.currPathKey_ != null;
    }

    public boolean pathHasAStop() {
        int stopCount = this.getStopCount();
        return this.pathIsSelected() && stopCount > 0;
    }

    public boolean pathHasOnlyOneStop() {
        int stopCount = this.getStopCount();
        return this.pathIsSelected() && stopCount == 1;
    }

    public String getLastPath() {
        return this.currPathKey_ != null ? this.currPathKey_ : this.lastPathKey_;
    }

    public void addAStop(String addToPathKey, String insertMode) {
        int newIndexVal;
        SUPanel sup = this.suw_.getSUPanel();
        String key = sup.getGenome();
        String ovrKey = sup.getCurrentOverlay();
        TaggedSet mods = sup.getCurrentNetModules();
        TaggedSet revs = sup.getRevealedModules();
        ArrayList<UserTreePathChangeCmd> postNavs = new ArrayList<UserTreePathChangeCmd>();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        UserTreePath targetPath = mgr.getPath(addToPathKey);
        if (insertMode.equals(INSERT_START)) {
            newIndexVal = 0;
        } else if (insertMode.equals(INSERT_END)) {
            newIndexVal = targetPath.getStopCount();
        } else if (insertMode.equals(INSERT_AFTER_CURRENT)) {
            Integer lastStopVal = this.getLastStop(addToPathKey);
            newIndexVal = lastStopVal == null ? targetPath.getStopCount() : lastStopVal + 1;
        } else {
            throw new IllegalArgumentException();
        }
        UserTreePathChange change = mgr.addPathStop(addToPathKey, key, newIndexVal, ovrKey, mods, revs);
        UndoSupport support = new UndoSupport(this.suw_.getUndoManager(), "undo.treePathAddStop");
        postNavs.add(new UserTreePathChangeCmd(change));
        this.setCurrentPath(addToPathKey, new Integer(newIndexVal), support, postNavs, null);
        this.mcmd_.updateUserPathActions();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public void addAPath(String newName) {
        SUPanel sup = this.suw_.getSUPanel();
        String key = sup.getGenome();
        String ovrKey = sup.getCurrentOverlay();
        TaggedSet mods = sup.getCurrentNetModules();
        TaggedSet revs = sup.getRevealedModules();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        UserTreePathChange change = mgr.addPath(newName, ++currPathIndex);
        UndoSupport support = new UndoSupport(this.suw_.getUndoManager(), "undo.treePathCreate");
        UserTreePathChangeCmd utpcc = new UserTreePathChangeCmd(change);
        support.addEdit(utpcc);
        this.lastPathKey_ = this.currPathKey_;
        this.currPathKey_ = mgr.getPathKey(currPathIndex);
        this.currStopIndex_ = -1;
        change = mgr.addPathStop(this.currPathKey_, key, ++this.currStopIndex_, ovrKey, mods, revs);
        utpcc = new UserTreePathChangeCmd(change);
        support.addEdit(utpcc);
        support.finish();
        this.mcmd_.updateUserPathActions();
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public void deleteCurrentPath() {
        OverlayDisplayChange odc = this.stashForDeletion();
        ArrayList<UserTreePathChangeCmd> postNavs = new ArrayList<UserTreePathChangeCmd>();
        String key = this.suw_.getSUPanel().getGenome();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        UserTreePathChange change = mgr.deletePath(this.currPathKey_);
        this.lastStop_.remove(this.currPathKey_);
        currPathIndex = currPathIndex == -1 ? -1 : currPathIndex - 1;
        UndoSupport support = new UndoSupport(this.suw_.getUndoManager(), "undo.treePathDelete");
        postNavs.add(new UserTreePathChangeCmd(change));
        String newKey = currPathIndex == -1 ? null : mgr.getPathKey(currPathIndex);
        this.setCurrentPath(newKey, null, support, postNavs, odc);
        this.mcmd_.updateUserPathActions();
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    private OverlayDisplayChange stashForDeletion() {
        OverlayDisplayChange retval = new OverlayDisplayChange();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        if (this.currPathKey_ != null && this.currStopIndex_ != -1 && mgr.getPath(this.currPathKey_) != null) {
            UserTreePath currPath = mgr.getPath(this.currPathKey_);
            UserTreePathStop stop = currPath.getStop(this.currStopIndex_);
            retval.oldGenomeID = stop.getGenomeID();
            retval.oldOvrKey = stop.getOverlay();
            retval.oldModKeys = (TaggedSet)stop.getModules().clone();
            retval.oldRevealedKeys = (TaggedSet)stop.getRevealed().clone();
        } else {
            retval.oldGenomeID = this.suw_.getSUPanel().getGenome();
            retval.oldOvrKey = null;
            retval.oldModKeys = new TaggedSet();
            retval.oldRevealedKeys = new TaggedSet();
        }
        return retval;
    }

    public void deleteCurrentStop() {
        String pathKey;
        OverlayDisplayChange odc = this.stashForDeletion();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        int stopCount = this.getStopCount();
        boolean deletePathToo = stopCount == 1;
        ArrayList<UserTreePathChangeCmd> postNavs = new ArrayList<UserTreePathChangeCmd>();
        UserTreePathChange change = mgr.deletePathStop(this.currPathKey_, this.currStopIndex_);
        UndoSupport support = new UndoSupport(this.suw_.getUndoManager(), "undo.treePathDeleteStop");
        postNavs.add(new UserTreePathChangeCmd(change));
        int newStopIndexVal = this.currStopIndex_ == 0 && stopCount > 1 ? 0 : this.currStopIndex_ - 1;
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        String string = pathKey = currPathIndex == -1 || this.currStopIndex_ == -1 ? null : this.currPathKey_;
        if (deletePathToo) {
            UserTreePathChange change2 = mgr.deletePath(this.currPathKey_);
            postNavs.add(new UserTreePathChangeCmd(change2));
            this.lastStop_.remove(this.currPathKey_);
            currPathIndex = currPathIndex == -1 ? -1 : currPathIndex - 1;
            newStopIndexVal = -1;
            pathKey = null;
        }
        Integer newStopIndex = new Integer(newStopIndexVal);
        this.setCurrentPath(pathKey, newStopIndex, support, postNavs, odc);
        this.mcmd_.updateUserPathActions();
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public UserTreePathControllerChange recordStateForUndo(boolean doUndo) {
        UserTreePathControllerChange retval = new UserTreePathControllerChange();
        retval.forUndo = doUndo;
        retval.currPathKey = this.currPathKey_;
        retval.lastPathKey = this.lastPathKey_;
        retval.currStopIndex = this.currStopIndex_;
        retval.lastStop = (HashMap)this.lastStop_.clone();
        return retval;
    }

    public UserTreePathChange[] dropStopsOnModel(String modelKey) {
        return this.stopDropperCore(modelKey, null, null, 0);
    }

    public UserTreePathChange[] dropStopsOnOverlay(String modelKey, String ovrKey) {
        return this.stopDropperCore(modelKey, ovrKey, null, 1);
    }

    public UserTreePathChange[] dropOrChangeStopsOnModules(String modelKey, String ovrKey, String modKey) {
        return this.stopDropperCore(modelKey, ovrKey, modKey, 2);
    }

    private int stopDropperTest(UserTreePathStop currStop, String modelKey, String ovrKey, String modKey, int forWhat) {
        if (!currStop.getGenomeID().equals(modelKey)) {
            return 0;
        }
        if (forWhat == 0) {
            return 2;
        }
        String currStopOverlay = currStop.getOverlay();
        if (currStopOverlay == null || !currStopOverlay.equals(ovrKey)) {
            return 0;
        }
        if (forWhat == 1) {
            return 2;
        }
        if (forWhat != 2) {
            throw new IllegalArgumentException();
        }
        TaggedSet tset = currStop.getModules();
        boolean contains = tset.set.contains(modKey);
        if (!contains) {
            return 0;
        }
        return tset.set.size() == 1 ? 2 : 1;
    }

    private UserTreePathChange[] stopDropperCore(String modelKey, String ovrKey, String modKey, int forWhat) {
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        ArrayList<UserTreePathChange> postNavs = new ArrayList<UserTreePathChange>();
        int pathNum = mgr.getPathCount();
        int pathIndex = 0;
        while (pathIndex < pathNum) {
            String pathKey = mgr.getPathKey(pathIndex);
            UserTreePath currPath = mgr.getPath(pathKey);
            int stopNum = currPath.getStopCount();
            int stopIndex = 0;
            while (stopIndex < stopNum) {
                UserTreePathStop currStop = currPath.getStop(stopIndex);
                int doWhat = this.stopDropperTest(currStop, modelKey, ovrKey, modKey, forWhat);
                if (doWhat == 2) {
                    postNavs.add(mgr.deletePathStop(pathKey, stopIndex));
                    this.fixupLastStops(pathKey, stopIndex);
                    if (pathKey.equals(this.currPathKey_)) {
                        if (stopIndex == this.currStopIndex_) {
                            this.currPathKey_ = null;
                            this.lastPathKey_ = null;
                            this.currStopIndex_ = -1;
                        } else if (stopIndex < this.currStopIndex_) {
                            --this.currStopIndex_;
                        }
                    }
                    --stopNum;
                    continue;
                }
                if (doWhat == 1) {
                    postNavs.add(mgr.dropPathStopModule(pathKey, stopIndex, modKey));
                    ++stopIndex;
                    continue;
                }
                ++stopIndex;
            }
            if (stopNum == 0) {
                postNavs.add(mgr.deletePath(pathKey));
                this.lastStop_.remove(pathKey);
                if (pathKey.equals(this.currPathKey_)) {
                    this.currPathKey_ = null;
                    this.lastPathKey_ = null;
                    this.currStopIndex_ = -1;
                }
                --pathNum;
                continue;
            }
            ++pathIndex;
        }
        this.mcmd_.updateUserPathActions();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
        return postNavs.toArray(new UserTreePathChange[postNavs.size()]);
    }

    private void fixupLastStops(String pathKey, int deletedStop) {
        if (pathKey == null) {
            return;
        }
        Integer stopNum = (Integer)this.lastStop_.get(pathKey);
        if (stopNum == null) {
            return;
        }
        int stopNumVal = stopNum;
        if (stopNumVal == deletedStop) {
            this.lastStop_.remove(pathKey);
        } else if (stopNumVal > deletedStop) {
            this.lastStop_.put(pathKey, new Integer(stopNumVal - 1));
        }
    }

    public UserTreePathChange[] replaceStopsOnModel(String oldModelKey, String newModelKey) {
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        ArrayList<UserTreePathChange> postNavs = new ArrayList<UserTreePathChange>();
        int pathNum = mgr.getPathCount();
        for (int i = 0; i < pathNum; ++i) {
            String pathKey = mgr.getPathKey(i);
            UserTreePath currPath = mgr.getPath(pathKey);
            int stopNum = currPath.getStopCount();
            for (int j = 0; j < stopNum; ++j) {
                UserTreePathStop currStop = currPath.getStop(j);
                if (!currStop.getGenomeID().equals(oldModelKey)) continue;
                postNavs.add(mgr.replacePathStop(pathKey, j, newModelKey));
            }
        }
        return postNavs.toArray(new UserTreePathChange[postNavs.size()]);
    }

    public PathNavigationInfo getPendingNavUndo() {
        this.pendingNavProcessed_ = true;
        return this.pendingNavInfo_;
    }

    public void changeUndo(NavigationChange undo) {
        if (!undo.userPathSelection && !undo.userPathSync) {
            return;
        }
        this.changeGuts(undo.oldUserPathKey, undo.oldUserPathStop);
    }

    public void changeRedo(NavigationChange redo) {
        if (!redo.userPathSelection && !redo.userPathSync) {
            return;
        }
        this.changeGuts(redo.newUserPathKey, redo.newUserPathStop);
    }

    private int getStopCount() {
        if (this.currPathKey_ == null) {
            return 0;
        }
        UserTreePathManager utpm = UserTreePathManager.getMgr();
        UserTreePath currPath = utpm.getPath(this.currPathKey_);
        return currPath.getStopCount();
    }

    private void changeGuts(String userPathKey, int userPathStop) {
        this.lastPathKey_ = null;
        this.currPathKey_ = userPathKey;
        this.currStopIndex_ = userPathStop;
        this.mcmd_.updateUserPathActions();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public void pathChangeUndo(UserTreePathChange undo) {
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        mgr.changeUndo(undo);
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.updateUserPathActions();
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public void pathChangeRedo(UserTreePathChange redo) {
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        mgr.changeRedo(redo);
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.updateUserPathActions();
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public void controllerChangeUndo(UserTreePathControllerChange undo) {
        if (undo.forUndo) {
            this.restoreStateForUndo(undo);
        }
    }

    public void controllerChangeRedo(UserTreePathControllerChange undo) {
        if (!undo.forUndo) {
            this.restoreStateForUndo(undo);
        }
    }

    private void restoreStateForUndo(UserTreePathControllerChange undo) {
        this.currPathKey_ = undo.currPathKey;
        this.lastPathKey_ = undo.lastPathKey;
        this.currStopIndex_ = undo.currStopIndex;
        this.lastStop_ = (HashMap)undo.lastStop.clone();
        UserTreePathManager mgr = UserTreePathManager.getMgr();
        int currPathIndex = this.currPathKey_ == null ? -1 : mgr.getPathIndex(this.currPathKey_);
        this.mcmd_.updateUserPathActions();
        this.mcmd_.setCurrentUserPath(currPathIndex + 1);
    }

    public static Vector insertionOptions() {
        Vector<ObjChoiceContent> retval = new Vector<ObjChoiceContent>();
        ResourceManager rMan = ResourceManager.getManager();
        retval.add(new ObjChoiceContent(rMan.getString("pathInsertOptions.insertAfterCurrent"), INSERT_AFTER_CURRENT));
        retval.add(new ObjChoiceContent(rMan.getString("pathInsertOptions.insertEnd"), INSERT_END));
        retval.add(new ObjChoiceContent(rMan.getString("pathInsertOptions.insertStart"), INSERT_START));
        return retval;
    }

    public static ObjChoiceContent choiceForOption(String option) {
        ResourceManager rMan = ResourceManager.getManager();
        return new ObjChoiceContent(rMan.getString("pathInsertOptions." + option), option);
    }

    private void setCurrentPath(String pathKey, Integer newStopIndex, UndoSupport support, List postNavs, OverlayDisplayChange precalcOdc) {
        UserTreePath currPath;
        PathNavigationInfo pni = new PathNavigationInfo();
        UndoSupport undoSupport = pni.support = support == null ? new UndoSupport(this.suw_.getUndoManager(), "undo.chooseTreePath") : support;
        if (postNavs != null) {
            pni.setAllPostNavs(postNavs);
        }
        pni.nav = new NavigationChange();
        pni.nav.commonView = this.suw_;
        pni.nav.userPathSelection = true;
        pni.nav.userPathSync = false;
        pni.nav.oldUserPathKey = this.currPathKey_;
        pni.nav.oldUserPathStop = this.currStopIndex_;
        UserTreePathManager utpm = UserTreePathManager.getMgr();
        if (precalcOdc != null) {
            pni.nav.odc = precalcOdc;
        } else {
            pni.nav.odc = new OverlayDisplayChange();
            if (this.currPathKey_ != null && this.currStopIndex_ != -1) {
                currPath = utpm.getPath(this.currPathKey_);
                UserTreePathStop stop = currPath.getStop(this.currStopIndex_);
                pni.nav.odc.oldGenomeID = stop.getGenomeID();
                pni.nav.odc.oldOvrKey = stop.getOverlay();
                pni.nav.odc.oldModKeys = (TaggedSet)stop.getModules().clone();
                pni.nav.odc.oldRevealedKeys = (TaggedSet)stop.getRevealed().clone();
            } else {
                pni.nav.odc.oldGenomeID = this.suw_.getSUPanel().getGenome();
                pni.nav.odc.oldOvrKey = null;
                pni.nav.odc.oldModKeys = new TaggedSet();
                pni.nav.odc.oldRevealedKeys = new TaggedSet();
            }
        }
        this.lastPathKey_ = pathKey;
        if (pathKey == null) {
            this.currPathKey_ = null;
            this.currStopIndex_ = -1;
            pni.nav.newUserPathKey = this.currPathKey_;
            pni.nav.newUserPathStop = this.currStopIndex_;
            pni.nav.odc.newGenomeID = this.suw_.getSUPanel().getGenome();
            pni.nav.odc.newOvrKey = null;
            pni.nav.odc.newModKeys = new TaggedSet();
            pni.nav.odc.newRevealedKeys = new TaggedSet();
            NavigationChangeCmd ncc = new NavigationChangeCmd(pni.nav);
            pni.support.addEdit(ncc);
            pni.finish();
            return;
        }
        this.currPathKey_ = pathKey;
        currPath = utpm.getPath(this.currPathKey_);
        int currStopCount = currPath.getStopCount();
        pni.nav.newUserPathKey = this.currPathKey_;
        if (currStopCount > 0) {
            Integer lastStopForPath;
            this.currStopIndex_ = newStopIndex == null ? ((lastStopForPath = (Integer)this.lastStop_.get(this.currPathKey_)) == null ? 0 : lastStopForPath) : newStopIndex;
            pni.nav.newUserPathStop = this.currStopIndex_;
            UserTreePathStop stop = currPath.getStop(this.currStopIndex_);
            pni.nav.odc.newGenomeID = stop.getGenomeID();
            pni.nav.odc.newOvrKey = stop.getOverlay();
            pni.nav.odc.newModKeys = (TaggedSet)stop.getModules().clone();
            pni.nav.odc.newRevealedKeys = (TaggedSet)stop.getRevealed().clone();
            this.selectTreePath(stop.getGenomeID(), stop.getOverlay(), stop.getModules(), stop.getRevealed(), pni);
        } else {
            pni.nav.newUserPathStop = this.currStopIndex_ = -1;
            pni.nav.odc.newGenomeID = this.suw_.getSUPanel().getGenome();
            pni.nav.odc.newOvrKey = null;
            pni.nav.odc.newModKeys = new TaggedSet();
            pni.nav.odc.newRevealedKeys = new TaggedSet();
            NavigationChangeCmd ncc = new NavigationChangeCmd(pni.nav);
            pni.support.addEdit(ncc);
            pni.finish();
        }
    }

    private void selectTreePath(String modelKey, String ovrKey, TaggedSet modules, TaggedSet revealed, PathNavigationInfo pni) {
        this.pendingNavInfo_ = pni;
        this.pendingNavProcessed_ = false;
        TreePath tp = this.navTree_.getStartupSelection(modelKey);
        StartupView suv = new StartupView(modelKey, ovrKey, modules, revealed);
        suv.installInTree(this.suw_, false, this.navTree_, this.jtree_);
        if (!this.pendingNavProcessed_) {
            NavigationChangeCmd ncc = new NavigationChangeCmd(pni.nav);
            pni.support.addEdit(ncc);
            pni.finish();
        }
        this.pendingNavInfo_ = null;
        this.pendingNavProcessed_ = false;
    }

    public static class PathNavigationInfo {
        public UndoSupport support;
        public NavigationChange nav;
        private List postNavs;

        public void finish() {
            if (this.postNavs != null) {
                Iterator pnit = this.postNavs.iterator();
                while (pnit.hasNext()) {
                    UserTreePathChangeCmd cc = (UserTreePathChangeCmd)pnit.next();
                    if (cc == null) continue;
                    this.support.addEdit(cc);
                }
            }
            this.support.finish();
        }

        public void addPostNav(UserTreePathChangeCmd cc) {
            if (this.postNavs == null) {
                this.postNavs = new ArrayList();
            }
            this.postNavs.add(cc);
        }

        public void setAllPostNavs(List postNavs) {
            this.postNavs = postNavs;
        }
    }
}

