/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.cmd;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.systemsbiology.biotapestry.cmd.ZoomChangeTracker;
import org.systemsbiology.biotapestry.cmd.ZoomTarget;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class ZoomCommandSupport {
    private ZoomTarget sup_;
    private JScrollPane jsp_;
    private double[] zoomVals_ = new double[]{0.06, 0.12, 0.2, 0.25, 0.33, 0.38, 0.44, 0.5, 0.62, 0.67, 0.75, 0.85, 1.0, 1.25, 1.5, 2.0};
    private int currZoomIndex_ = 5;
    private static final double SMALL_MODEL_CUSTOM_ZOOM_ = 0.03;
    private double customZoom_ = 0.03;
    private static final int NEW_MODEL_INDEX_ = 8;
    private int newModelIndex_ = 8;
    private Dimension currViewSize_;
    private double currViewXFrac_;
    private double currViewYFrac_;
    private ZoomChangeTracker tracker_;
    private Rectangle2D currClipRect_;

    public ZoomCommandSupport(ZoomChangeTracker tracker) {
        this.tracker_ = tracker;
    }

    public Rectangle2D getCurrClipRect() {
        return this.currClipRect_;
    }

    public void setCustomZoomPoints(double[] customZoomVals, int startIndex, int newModelIndex) {
        this.zoomVals_ = customZoomVals;
        this.currZoomIndex_ = startIndex;
        this.newModelIndex_ = newModelIndex;
    }

    public void registerScrollPaneAndZoomTarget(JScrollPane jsp, ZoomTarget sup) {
        this.jsp_ = jsp;
        this.sup_ = sup;
        jsp.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                try {
                    ZoomCommandSupport.this.handlePanelResize();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ChangeListener barChange = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                try {
                    ZoomCommandSupport.this.trackScrollBars();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        };
        JScrollBar vsb = jsp.getVerticalScrollBar();
        vsb.getModel().addChangeListener(barChange);
        JScrollBar hsb = jsp.getHorizontalScrollBar();
        hsb.getModel().addChangeListener(barChange);
    }

    private ZoomResult calcOptimalZoom(Rectangle chosen) {
        int retval;
        double modelWidth;
        double zoom;
        double modelHeight;
        int i;
        Dimension allDim = this.jsp_.getViewport().getExtentSize();
        Dimension dim = chosen == null ? this.sup_.getBasicSize(true, false, 1) : new Dimension(chosen.width, chosen.height);
        int vIndex = -1;
        int hIndex = -1;
        for (i = 0; i < this.zoomVals_.length && (modelHeight = (double)dim.height * (zoom = this.zoomVals_[i])) <= (double)allDim.height; ++i) {
            ++vIndex;
        }
        for (i = 0; i < this.zoomVals_.length && (modelWidth = (double)dim.width * (zoom = this.zoomVals_[i])) <= (double)allDim.width; ++i) {
            ++hIndex;
        }
        int n = retval = vIndex < hIndex ? vIndex : hIndex;
        if (retval == -1) {
            double vZoom = (double)allDim.height / (double)dim.height;
            double hZoom = (double)allDim.width / (double)dim.width;
            return new ZoomResult(vZoom > hZoom ? hZoom : vZoom);
        }
        retval = retval > this.zoomVals_.length - 1 ? this.zoomVals_.length - 1 : retval;
        return new ZoomResult(retval);
    }

    private void doZoom(double newZoomVal, double oldZoomVal) {
        Dimension vDim = this.scrollDims();
        JViewport view = this.jsp_.getViewport();
        Point viewPos = view.getViewPosition();
        Dimension viewDim = view.getExtentSize();
        int vCenter = viewPos.y + viewDim.height / 2;
        int hCenter = viewPos.x + viewDim.width / 2;
        Point2D worldCenter = this.sup_.viewToWorld(new Point(hCenter, vCenter));
        this.sup_.setWideZoomFactor(newZoomVal, vDim);
        Point newCenter = this.sup_.pointToViewport(new Point((int)Math.round(worldCenter.getX()), (int)Math.round(worldCenter.getY())));
        this.viewportUpdate(newCenter, vDim);
    }

    private Dimension scrollDims() {
        JScrollBar vsb = this.jsp_.getVerticalScrollBar();
        JScrollBar hsb = this.jsp_.getHorizontalScrollBar();
        int vAmt = vsb.getVisibleAmount();
        int hAmt = hsb.getVisibleAmount();
        return new Dimension(hAmt, vAmt);
    }

    private void viewportToCenter(double zoomVal) {
        Dimension vDim = this.scrollDims();
        this.sup_.setWideZoomFactor(zoomVal, vDim);
        Point pt = this.sup_.getCenterPoint();
        this.viewportUpdate(pt, vDim);
    }

    private Point boundedViewPos(Point center, Dimension vDim, JViewport view) {
        int newV = center.y - vDim.height / 2;
        int newH = center.x - vDim.width / 2;
        return this.doBounding(newH, newV, view);
    }

    private Point doBounding(int newH, int newV, JViewport view) {
        Dimension allDim = view.getViewSize();
        Dimension viewDim = view.getExtentSize();
        int delH = allDim.width - viewDim.width;
        int delV = allDim.height - viewDim.height;
        if (newH < 0) {
            newH = 0;
        } else if (delH > 0 && newH > delH) {
            newH = delH;
        }
        if (newV < 0) {
            newV = 0;
        } else if (delV > 0 && newV > delV) {
            newV = delV;
        }
        return new Point(newH, newV);
    }

    private void viewportUpdate(Point center, Dimension vDim) {
        JViewport view = this.jsp_.getViewport();
        view.setViewSize(this.sup_.getPreferredSize());
        view.setViewPosition(this.boundedViewPos(center, vDim, view));
        view.invalidate();
        this.jsp_.validate();
    }

    private double getCurrentZoom() {
        return this.currZoomIndex_ == -1 ? this.customZoom_ : this.zoomVals_[this.currZoomIndex_];
    }

    public void bumpZoomWrapper(char direction) {
        double oldZoomVal = this.getCurrentZoom();
        this.bumpZoom(direction);
        double newZoomVal = this.getCurrentZoom();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
        this.doZoom(newZoomVal, oldZoomVal);
    }

    public void setZoomIndex(int index) {
        double oldZoomVal = this.getCurrentZoom();
        this.setCurrentZoom(new ZoomResult(index));
        double newZoomVal = this.getCurrentZoom();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
        this.doZoom(newZoomVal, oldZoomVal);
    }

    private void bumpZoom(char direction) {
        if (this.currZoomIndex_ < -1 || this.currZoomIndex_ >= this.zoomVals_.length) {
            return;
        }
        if (direction == '+') {
            if (this.zoomIsWide()) {
                this.setCurrentZoom(new ZoomResult(0));
            } else {
                if (this.zoomIsMax()) {
                    return;
                }
                this.setCurrentZoom(new ZoomResult(this.currZoomIndex_ + 1));
            }
        } else {
            if (this.zoomIsWide()) {
                return;
            }
            if (this.currZoomIndex_ == 0) {
                ZoomResult zr = this.calcOptimalZoom(null);
                if (!zr.doCustom) {
                    Dimension vDim = this.scrollDims();
                    double workspaceZoom = this.sup_.getWorkspaceZoom(vDim, 0.95);
                    if (workspaceZoom >= this.zoomVals_[0]) {
                        workspaceZoom = 0.03;
                    }
                    this.setCurrentZoom(new ZoomResult(workspaceZoom));
                } else {
                    this.setCurrentZoom(zr);
                }
            } else {
                this.setCurrentZoom(new ZoomResult(this.currZoomIndex_ - 1));
            }
        }
    }

    public boolean zoomIsWide() {
        return this.currZoomIndex_ == -1;
    }

    public boolean zoomIsFirstDefined() {
        return this.currZoomIndex_ == 0;
    }

    public boolean zoomIsMax() {
        return this.currZoomIndex_ == this.zoomVals_.length - 1;
    }

    public void setCurrentZoomForNewModel() {
        this.setCurrentZoom(new ZoomResult(this.newModelIndex_));
        this.sup_.fixCenterPoint(true, null, false);
        this.viewportToCenter(this.getCurrentZoom());
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    private void setCurrentZoom(ZoomResult zres) {
        if (zres.doCustom) {
            this.customZoom_ = zres.customZoom;
            this.currZoomIndex_ = -1;
        } else {
            this.currZoomIndex_ = zres.index;
            this.customZoom_ = 0.03;
        }
    }

    public void zoomToWorksheetCenter() {
        ZoomResult zres = this.calcOptimalZoom(null);
        this.setCurrentZoom(zres);
        this.viewportToCenter(this.getCurrentZoom());
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    public void zoomToFullWorksheet() {
        Rectangle wsBounds = this.sup_.getWorkspaceBounds();
        ZoomResult zres = this.calcOptimalZoom(wsBounds);
        this.setCurrentZoom(zres);
        this.viewportToCenter(this.getCurrentZoom());
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    public void zoomToRectangle(Rectangle zoomRect) {
        this.zoomToSelectedGuts(zoomRect);
    }

    public void zoomToSelected() {
        Rectangle selected = this.sup_.getSelectedBounds();
        this.zoomToSelectedGuts(selected);
    }

    public void centerOnRectangle(Rectangle centerRect) {
        this.centerOnSelectedGuts(centerRect);
    }

    public void centerOnSelected() {
        Rectangle selected = this.sup_.getSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    private void zoomToSelectedGuts(Rectangle selected) {
        if (selected == null) {
            this.zoomToModel();
            return;
        }
        Rectangle wsBounds = this.sup_.getWorkspaceBounds();
        Rectangle union = wsBounds.union(selected);
        if (!union.equals(wsBounds)) {
            Point2D cent = this.sup_.getRawCenterPoint();
            selected = this.centeredUnion(union, cent);
        }
        Dimension vDim = this.scrollDims();
        ZoomResult zres = this.calcOptimalZoom(selected);
        this.setCurrentZoom(zres);
        this.sup_.setWideZoomFactor(this.getCurrentZoom(), vDim);
        int x = selected.x + selected.width / 2;
        int y = selected.y + selected.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    private void centerOnSelectedGuts(Rectangle selected) {
        if (selected == null) {
            this.zoomToModel();
            return;
        }
        Rectangle wsBounds = this.sup_.getWorkspaceBounds();
        Rectangle union = wsBounds.union(selected);
        if (!union.equals(wsBounds)) {
            Point2D cent = this.sup_.getRawCenterPoint();
            selected = this.centeredUnion(union, cent);
        }
        Dimension vDim = this.scrollDims();
        int x = selected.x + selected.width / 2;
        int y = selected.y + selected.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(true);
        }
    }

    public void zoomToNextSelected() {
        this.sup_.incrementToNextSelection();
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.zoomToSelectedGuts(selected);
    }

    public void centerToNextSelected() {
        this.sup_.incrementToNextSelection();
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    public void zoomToPreviousSelected() {
        this.sup_.decrementToPreviousSelection();
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.zoomToSelectedGuts(selected);
    }

    public void centerToPreviousSelected() {
        this.sup_.decrementToPreviousSelection();
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    public void zoomToCurrentSelected() {
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.zoomToSelectedGuts(selected);
    }

    public void centerToCurrentSelected() {
        Rectangle selected = this.sup_.getCurrentSelectedBounds();
        this.centerOnSelectedGuts(selected);
    }

    public void zoomToRect(Rectangle bounds) {
        Rectangle wsBounds = this.sup_.getWorkspaceBounds();
        Rectangle union = wsBounds.union(bounds);
        if (!union.equals(wsBounds)) {
            Point2D cent = this.sup_.getRawCenterPoint();
            bounds = this.centeredUnion(union, cent);
        }
        Dimension vDim = this.scrollDims();
        ZoomResult zres = this.calcOptimalZoom(bounds);
        this.setCurrentZoom(zres);
        this.sup_.setWideZoomFactor(this.getCurrentZoom(), vDim);
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    private Rectangle centeredUnion(Rectangle union, Point2D center) {
        int cenX = (int)Math.round(center.getX());
        int cenY = (int)Math.round(center.getY());
        int delmx = cenX - union.x;
        int delmy = cenY - union.y;
        int delpx = union.x + union.width - cenX;
        int delpy = union.y + union.height - cenY;
        int rX = delpx > delmx ? cenX - delpx : cenX - delmx;
        int rW = delpx > delmx ? 2 * delpx : 2 * delmx;
        int rY = delpy > delmy ? cenY - delpy : cenY - delmy;
        int rH = delpy > delmy ? 2 * delpy : 2 * delmy;
        return new Rectangle(rX, rY, rW, rH);
    }

    public void zoomToModel() {
        Rectangle bounds = this.sup_.getCurrentBasicBounds(true, false, 1);
        Rectangle wsBounds = this.sup_.getWorkspaceBounds();
        Rectangle union = wsBounds.union(bounds);
        if (!union.equals(wsBounds)) {
            Point2D cent = this.sup_.getRawCenterPoint();
            bounds = this.centeredUnion(union, cent);
        }
        ZoomResult zres = this.calcOptimalZoom(bounds);
        Dimension vDim = this.scrollDims();
        this.setCurrentZoom(zres);
        this.sup_.setWideZoomFactor(this.getCurrentZoom(), vDim);
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    public void zoomToAllModels() {
        Rectangle bounds = this.sup_.getAllModelBounds();
        Rectangle wsBounds = this.sup_.getWorkspaceBounds();
        Rectangle union = wsBounds.union(bounds);
        if (!union.equals(wsBounds)) {
            Point2D cent = this.sup_.getRawCenterPoint();
            bounds = this.centeredUnion(union, cent);
        }
        ZoomResult zres = this.calcOptimalZoom(bounds);
        Dimension vDim = this.scrollDims();
        this.setCurrentZoom(zres);
        this.sup_.setWideZoomFactor(this.getCurrentZoom(), vDim);
        int x = bounds.x + bounds.width / 2;
        int y = bounds.y + bounds.height / 2;
        Point pt = new Point(x, y);
        pt = this.sup_.pointToViewport(pt);
        this.viewportUpdate(pt, vDim);
        this.sup_.repaint();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(false);
        }
    }

    public void handlePanelResize() {
        JViewport view = this.jsp_.getViewport();
        Dimension viewExtent = view.getExtentSize();
        Dimension viewSize = view.getViewSize();
        int currX = (int)Math.round(this.currViewXFrac_ * (double)viewSize.width - (double)viewExtent.width / 2.0);
        int currY = (int)Math.round(this.currViewYFrac_ * (double)viewSize.height - (double)viewExtent.height / 2.0);
        view.setViewPosition(this.doBounding(currX, currY, view));
        this.sup_.adjustWideZoomForSize(this.scrollDims());
        this.currViewSize_ = viewExtent;
        this.currClipRect_ = view.getViewRect();
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(true);
        }
    }

    public void trackScrollBars() {
        JViewport view = this.jsp_.getViewport();
        Dimension viewExtent = view.getExtentSize();
        if (this.currViewSize_ == null) {
            this.currViewSize_ = viewExtent;
        }
        if (viewExtent.equals(this.currViewSize_)) {
            Point viewPos = view.getViewPosition();
            int currX = viewPos.x + viewExtent.width / 2;
            int currY = viewPos.y + viewExtent.height / 2;
            Dimension viewSize = view.getViewSize();
            this.currViewXFrac_ = (double)currX / (double)viewSize.width;
            this.currViewYFrac_ = (double)currY / (double)viewSize.height;
            this.currClipRect_ = view.getViewRect();
        }
        if (this.tracker_ != null) {
            this.tracker_.zoomStateChanged(true);
        }
    }

    private class ZoomResult {
        boolean doCustom;
        int index;
        double customZoom;

        ZoomResult(int index) {
            this.doCustom = false;
            this.index = index;
        }

        ZoomResult(double customZoom) {
            this.doCustom = true;
            this.customZoom = customZoom;
        }

        public String toString() {
            return this.doCustom ? "ZoomResult customZoom = " + this.customZoom : "ZoomResult indexed zoom = " + this.index;
        }
    }
}

