/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.awt.Color;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.GlobalChange;
import org.systemsbiology.biotapestry.ui.NamedColor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.UniqueLabeller;

public class ColorGenerator {
    private UniqueLabeller colorLabels_;
    private Map colors_;
    private String[] geneCol_ = new String[]{"EX-blue", "EX-orange", "EX-dark-cyan", "EX-red", "EX-dark-orange", "EX-dark-gray-purple", "EX-cyan", "EX-yellow-orange", "EX-pure-blue", "EX-dark-yellow-green", "EX-dark-magenta", "EX-dark-green", "EX-blue-magenta", "EX-yellow-green", "EX-magenta", "EX-green", "EX-yellow", "EX-purple", "EX-dark-purple", "EX-dark-red", "EX-pale-green", "EX-pale-blue", "EX-dark-tan", "EX-pale-blue-magenta", "EX-pale-yellow orange", "EX-medium-magenta", "EX-pale-red", "EX-pale-cyan", "EX-pale-yellow-green", "EX-pale-purple", "EX-pale-magenta", "EX-pale-red-orange"};

    public ColorGenerator() {
        this.colorLabels_ = new UniqueLabeller();
        this.colorLabels_.addExistingLabel("zz_newColor_0");
        this.colors_ = new HashMap();
    }

    public void newColorModel() {
        this.buildDefaultColors();
    }

    public void dropColors() {
        this.colorLabels_ = new UniqueLabeller();
        this.colorLabels_.addExistingLabel("zz_newColor_0");
        this.colors_.clear();
        this.buildDefaultColors();
    }

    public Color getColor(String colorKey) {
        return ((NamedColor)this.colors_.get((Object)colorKey)).color;
    }

    public NamedColor getNamedColor(String colorKey) {
        return (NamedColor)this.colors_.get(colorKey);
    }

    public GlobalChange updateColors(Map namedColors) {
        GlobalChange retval = new GlobalChange();
        retval.origColors = this.deepCopyColorMap(this.colors_);
        this.colors_ = this.deepCopyColorMap(namedColors);
        retval.newColors = this.deepCopyColorMap(namedColors);
        return retval;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        this.writeColors(out, ind);
    }

    public String getNextColorLabel() {
        return this.colorLabels_.getNextLabel();
    }

    public void setColor(String itemId, NamedColor color) {
        this.colorLabels_.addExistingLabel(itemId);
        this.colors_.put(itemId, color);
    }

    public Iterator getColorKeys() {
        return this.colors_.keySet().iterator();
    }

    public List getGeneColorsAsList() {
        return Arrays.asList(this.geneCol_);
    }

    public void changeUndo(GlobalChange undo) {
        if (undo.origColors != null || undo.newColors != null) {
            this.colorChangeUndo(undo);
        }
    }

    public void changeRedo(GlobalChange undo) {
        if (undo.origColors != null || undo.newColors != null) {
            this.colorChangeRedo(undo);
        }
    }

    public Set cannotDeleteColors() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("white");
        retval.add("black");
        retval.add("yellowGreen");
        retval.add("inactiveYellowGreen");
        retval.add("lightBlue");
        retval.add("inactiveLightBlue");
        retval.add("lightOrange");
        retval.add("inactiveLightOrange");
        retval.add("lightGreen");
        retval.add("inactiveLightGreen");
        retval.add("lightPurple");
        retval.add("inactiveLightPurple");
        retval.add("lightGray");
        retval.add("inactiveLightGray");
        int size = this.geneCol_.length;
        for (int i = 0; i < size; ++i) {
            retval.add(this.geneCol_[i]);
        }
        return retval;
    }

    public String activeColorCycle(int i) {
        switch (i %= 5) {
            case 0: {
                return "lightGreen";
            }
            case 1: {
                return "yellowGreen";
            }
            case 2: {
                return "lightOrange";
            }
            case 3: {
                return "lightPurple";
            }
            case 4: {
                return "lightGray";
            }
        }
        throw new IllegalStateException();
    }

    public String distinctActiveColor() {
        return "lightBlue";
    }

    public String distinctInactiveColor() {
        return "inactiveLightBlue";
    }

    public String inactiveColorCycle(int i) {
        switch (i %= 5) {
            case 0: {
                return "inactiveLightGreen";
            }
            case 1: {
                return "inactiveYellowGreen";
            }
            case 2: {
                return "inactiveLightOrange";
            }
            case 3: {
                return "inactiveLightPurple";
            }
            case 4: {
                return "inactiveLightGray";
            }
        }
        throw new IllegalStateException();
    }

    public String getGeneColor(int i) {
        return this.geneCol_[i];
    }

    public int getNumColors() {
        return this.geneCol_.length;
    }

    private void buildDefaultColors() {
        this.colors_ = new HashMap();
        this.colors_.put("inactiveLightBlue", new NamedColor("inactiveLightBlue", new Color(235, 235, 250), "Very Light Blue"));
        this.colorLabels_.addExistingLegacyLabel("inactiveLightBlue");
        this.colors_.put("white", new NamedColor("white", new Color(255, 255, 255), "White"));
        this.colorLabels_.addExistingLegacyLabel("white");
        this.colors_.put("inactiveLightPurple", new NamedColor("inactiveLightPurple", new Color(245, 229, 240), "Very Light Purple"));
        this.colorLabels_.addExistingLegacyLabel("inactiveLightPurple");
        this.colors_.put("lightBlue", new NamedColor("lightBlue", new Color(220, 220, 240), "Light Blue"));
        this.colorLabels_.addExistingLegacyLabel("lightBlue");
        this.colors_.put("black", new NamedColor("black", new Color(0, 0, 0), "Black"));
        this.colorLabels_.addExistingLegacyLabel("black");
        this.colors_.put("inactiveLightOrange", new NamedColor("inactiveLightOrange", new Color(255, 230, 200), "Very Light Orange"));
        this.colorLabels_.addExistingLegacyLabel("inactiveLightOrange");
        this.colors_.put("lightGray", new NamedColor("lightGray", new Color(240, 240, 240), "Light Gray"));
        this.colorLabels_.addExistingLegacyLabel("lightGray");
        this.colors_.put("darkGray", new NamedColor("darkGray", new Color(150, 150, 150), "Dark Gray"));
        this.colorLabels_.addExistingLegacyLabel("darkGray");
        this.colors_.put("inactiveYellowGreen", new NamedColor("inactiveYellowGreen", new Color(255, 255, 220), "Light Yellow Green"));
        this.colorLabels_.addExistingLegacyLabel("inactiveYellowGreen");
        this.colors_.put("yellowGreen", new NamedColor("yellowGreen", new Color(246, 249, 170), "Yellow Green"));
        this.colorLabels_.addExistingLegacyLabel("yellowGreen");
        this.colors_.put("inactiveLightGreen", new NamedColor("inactiveLightGreen", new Color(230, 255, 220), "Very Light Green"));
        this.colorLabels_.addExistingLegacyLabel("inactiveLightGreen");
        this.colors_.put("lightGreen", new NamedColor("lightGreen", new Color(214, 239, 209), "Light Green"));
        this.colorLabels_.addExistingLegacyLabel("lightGreen");
        this.colors_.put("lightOrange", new NamedColor("lightOrange", new Color(244, 211, 170), "Light Orange"));
        this.colorLabels_.addExistingLegacyLabel("lightOrange");
        this.colors_.put("inactiveLightGray", new NamedColor("inactiveLightGray", new Color(245, 245, 245), "Very Light Gray"));
        this.colorLabels_.addExistingLegacyLabel("inactiveLightGray");
        this.colors_.put("lightPurple", new NamedColor("lightPurple", new Color(235, 219, 229), "Light Purple"));
        this.colorLabels_.addExistingLegacyLabel("lightPurple");
        List geneColors = this.buildGeneColors();
        int geneColSize = geneColors.size();
        for (int i = 0; i < geneColSize; ++i) {
            NamedColor col = (NamedColor)geneColors.get(i);
            this.colors_.put(col.key, col);
            this.colorLabels_.addExistingLegacyLabel(col.key);
        }
    }

    private void writeColors(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<colors>");
        ind.up();
        Iterator colors = this.colors_.keySet().iterator();
        while (colors.hasNext()) {
            String key = (String)colors.next();
            NamedColor nc = (NamedColor)this.colors_.get(key);
            Color c = nc.color;
            ind.indent();
            out.print("<color ");
            out.print("color=\"");
            out.print(key);
            out.print("\" name=\"");
            out.print(nc.name);
            out.print("\" r=\"");
            out.print(c.getRed());
            out.print("\" g=\"");
            out.print(c.getGreen());
            out.print("\" b=\"");
            out.print(c.getBlue());
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</colors>");
    }

    private List buildGeneColors() {
        ArrayList<NamedColor> colors = new ArrayList<NamedColor>();
        colors.add(new NamedColor("EX-red", Color.getHSBColor(0.0f, 1.0f, 1.0f), "Bright Red"));
        colors.add(new NamedColor("EX-pale-red-orange", Color.getHSBColor(0.033f, 0.4f, 0.9f), "Dark Salmon"));
        colors.add(new NamedColor("EX-orange", Color.getHSBColor(0.067f, 1.0f, 1.0f), "Pumpkin Orange"));
        colors.add(new NamedColor("EX-yellow-orange", Color.getHSBColor(0.1f, 1.0f, 1.0f), "Tangerine"));
        colors.add(new NamedColor("EX-pale-yellow orange", Color.getHSBColor(0.12f, 0.5f, 0.8f), "Dark Wheat"));
        colors.add(new NamedColor("EX-yellow", Color.getHSBColor(0.133f, 1.0f, 1.0f), "Gold"));
        colors.add(new NamedColor("EX-pale-yellow-green", Color.getHSBColor(0.183f, 0.4f, 0.9f), "Pale Goldenrod"));
        colors.add(new NamedColor("EX-yellow-green", Color.getHSBColor(0.233f, 1.0f, 1.0f), "Lime"));
        colors.add(new NamedColor("EX-pale-green", Color.getHSBColor(0.283f, 0.5f, 0.8f), "Pale Green"));
        colors.add(new NamedColor("EX-green", Color.getHSBColor(0.333f, 1.0f, 1.0f), "Bright Green"));
        colors.add(new NamedColor("EX-pale-cyan", Color.getHSBColor(0.413f, 0.4f, 0.9f), "Aquamarine"));
        colors.add(new NamedColor("EX-cyan", Color.getHSBColor(0.5f, 1.0f, 1.0f), "Cyan"));
        colors.add(new NamedColor("EX-pale-blue", Color.getHSBColor(0.534f, 0.5f, 0.8f), "Powder Blue"));
        colors.add(new NamedColor("EX-blue", Color.getHSBColor(0.567f, 1.0f, 1.0f), "Sky Blue"));
        colors.add(new NamedColor("EX-pale-purple", Color.getHSBColor(0.634f, 0.35f, 0.9f), "Cornflower Blue"));
        colors.add(new NamedColor("EX-pure-blue", Color.getHSBColor(0.667f, 1.0f, 1.0f), "Blue"));
        colors.add(new NamedColor("EX-purple", Color.getHSBColor(0.708f, 0.8f, 1.0f), "Indigo"));
        colors.add(new NamedColor("EX-pale-blue-magenta", Color.getHSBColor(0.738f, 0.5f, 0.8f), "Lilac"));
        colors.add(new NamedColor("EX-blue-magenta", Color.getHSBColor(0.767f, 1.0f, 1.0f), "Bright Purple"));
        colors.add(new NamedColor("EX-pale-magenta", Color.getHSBColor(0.8f, 0.4f, 0.9f), "Light Plum"));
        colors.add(new NamedColor("EX-magenta", Color.getHSBColor(0.833f, 1.0f, 1.0f), "Fuchsia"));
        colors.add(new NamedColor("EX-pale-red", Color.getHSBColor(0.917f, 0.5f, 0.8f), "Rose"));
        colors.add(new NamedColor("EX-dark-red", Color.getHSBColor(0.0f, 0.6f, 0.55f), "Deep Ochre"));
        colors.add(new NamedColor("EX-dark-tan", Color.getHSBColor(0.1f, 0.5f, 0.65f), "Dark Tan"));
        colors.add(new NamedColor("EX-dark-orange", Color.getHSBColor(0.12f, 1.0f, 0.5f), "Sienna"));
        colors.add(new NamedColor("EX-dark-yellow-green", Color.getHSBColor(0.183f, 1.0f, 0.5f), "Olive Green"));
        colors.add(new NamedColor("EX-dark-green", Color.getHSBColor(0.283f, 1.0f, 0.5f), "Dark Green"));
        colors.add(new NamedColor("EX-dark-cyan", Color.getHSBColor(0.534f, 1.0f, 0.5f), "Dark Steel Blue"));
        colors.add(new NamedColor("EX-dark-gray-purple", Color.getHSBColor(0.634f, 1.0f, 0.5f), "Dark Blue"));
        colors.add(new NamedColor("EX-dark-purple", Color.getHSBColor(0.708f, 0.6f, 0.55f), "Slate Blue"));
        colors.add(new NamedColor("EX-dark-magenta", Color.getHSBColor(0.8f, 1.0f, 0.5f), "Violet"));
        colors.add(new NamedColor("EX-medium-magenta", Color.getHSBColor(0.833f, 0.5f, 0.65f), "Mauve"));
        return colors;
    }

    private HashMap deepCopyColorMap(Map otherMap) {
        HashMap<String, NamedColor> retval = new HashMap<String, NamedColor>();
        Set keys = otherMap.keySet();
        Iterator kit = keys.iterator();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            NamedColor col = (NamedColor)otherMap.get(key);
            retval.put(new String(key), new NamedColor(col));
        }
        return retval;
    }

    private void colorChangeUndo(GlobalChange undo) {
        if (undo.origColors == null || undo.newColors == null) {
            throw new IllegalArgumentException();
        }
        this.colors_ = undo.origColors;
    }

    private void colorChangeRedo(GlobalChange undo) {
        if (undo.origColors == null || undo.newColors == null) {
            throw new IllegalArgumentException();
        }
        this.colors_ = undo.newColors;
    }
}

