/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.awt.Color;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.db.ColorGenerator;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.GenomeSource;
import org.systemsbiology.biotapestry.db.GlobalChange;
import org.systemsbiology.biotapestry.db.LayoutSource;
import org.systemsbiology.biotapestry.db.ModelData;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.db.Workspace;
import org.systemsbiology.biotapestry.db.WorkspaceSource;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.GeneralChangeListener;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeListener;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.UserTreePathManager;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoData;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.ui.FontManager;
import org.systemsbiology.biotapestry.ui.GroupProperties;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NamedColor;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MultiLineRenderSupport;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class Database
implements GenomeSource,
LayoutSource,
WorkspaceSource,
ModelChangeListener,
GeneralChangeListener {
    private static final String PREVIOUS_IO_VERSION_A_ = "2.0";
    private static final String PREVIOUS_IO_VERSION_B_ = "2.1";
    private static final String PREVIOUS_IO_VERSION_C_ = "3.1";
    private static final String CURRENT_IO_VERSION_ = "5.0";
    private static Database singleton_;
    private ColorGenerator colGen_;
    private Genome holdingGenome_;
    private Genome genome_;
    private HashMap instances_ = new HashMap();
    private HashMap dynProxies_;
    private HashMap layouts_ = new HashMap();
    private NavTree navTree_ = new NavTree();
    private ModelData modelData_;
    private PerturbationData pertData_;
    private TimeCourseData timeCourse_;
    private CopiesPerEmbryoData copiesPerEmb_;
    private TemporalInputRangeData rangeData_;
    private UniqueLabeller labels_;
    private UniqueLabeller instructionLabels_;
    private int uniqueNameSuffix_ = 1;
    private HashMap simDefaultsNode_;
    private HashMap simDefaultsGeneAnd_;
    private HashMap simDefaultsGeneOr_;
    private ArrayList buildInstructions_;
    private HashMap instanceInstructionSets_;
    private TimeAxisDefinition timeAxis_;
    private Workspace workspace_;
    private StartupView startupView_;
    private String iOVersion_ = "5.0";

    public void newModel() {
        this.drop();
        this.clearHoldingGenome();
        this.genome_ = new DBGenome(ResourceManager.getManager().getString("tree.FullGenome"), "bioTapA");
        this.labels_.addExistingLabel("bioTapA");
        String layoutID = this.labels_.getNextLabel();
        this.layouts_.put(layoutID, new Layout(layoutID, "bioTapA"));
        this.navTree_.addNode(null, null, "bioTapA");
        this.modelData_ = null;
        this.pertData_ = new PerturbationData();
        this.timeCourse_ = new TimeCourseData();
        this.copiesPerEmb_ = new CopiesPerEmbryoData();
        this.rangeData_ = new TemporalInputRangeData();
        this.timeAxis_ = new TimeAxisDefinition();
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions options = dopmgr.getDisplayOptions();
        options.dropDataBasedOptions();
        this.workspace_ = new Workspace();
        this.uniqueNameSuffix_ = 1;
        this.iOVersion_ = CURRENT_IO_VERSION_;
        this.startupView_ = new StartupView();
    }

    public void drop() {
        this.holdingGenome_ = null;
        this.genome_ = null;
        this.layouts_.clear();
        this.instances_.clear();
        this.dynProxies_.clear();
        this.navTree_.clearOut();
        this.modelData_ = null;
        this.pertData_ = new PerturbationData();
        this.timeCourse_ = null;
        this.copiesPerEmb_ = null;
        this.rangeData_ = null;
        this.timeAxis_ = new TimeAxisDefinition();
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions options = dopmgr.getDisplayOptions();
        options.dropDataBasedOptions();
        this.workspace_ = new Workspace();
        this.uniqueNameSuffix_ = 1;
        this.iOVersion_ = CURRENT_IO_VERSION_;
        this.startupView_ = new StartupView();
        this.labels_ = new UniqueLabeller();
        this.colGen_.dropColors();
        FontManager.getMgr().resetToDefaults();
        ImageManager.getMgr().dropAllImages();
        UserTreePathManager.getMgr().dropAllPaths();
        this.buildInstructions_.clear();
        this.instructionLabels_ = new UniqueLabeller();
        this.instanceInstructionSets_.clear();
    }

    public DatabaseChange dropRootNetworkOnly() {
        DatabaseChange retval = new DatabaseChange();
        retval.oldGenome = this.genome_;
        retval.oldLayouts = new HashMap();
        retval.newLayouts = new HashMap();
        Iterator lit = this.layouts_.values().iterator();
        while (lit.hasNext()) {
            Layout lo = (Layout)lit.next();
            String targ = lo.getTarget();
            String name = lo.getName();
            if (!targ.equals(this.genome_.getID())) continue;
            retval.oldLayouts.put(name, new Layout(lo));
            retval.newLayouts.put(name, new Layout(name, "bioTapA"));
        }
        Iterator nlit = retval.newLayouts.keySet().iterator();
        while (nlit.hasNext()) {
            String name = (String)nlit.next();
            Layout lo = (Layout)retval.newLayouts.get(name);
            this.layouts_.put(name, new Layout(lo));
        }
        retval.newGenome = this.genome_ = ((DBGenome)this.genome_).getStrippedGenomeCopy();
        return retval;
    }

    public DatabaseChange dropInstanceNetworkOnly(String gid) {
        GenomeInstance gi = (GenomeInstance)this.instances_.get(gid);
        DatabaseChange retval = new DatabaseChange();
        retval.oldInstance = gi;
        retval.oldLayouts = new HashMap();
        retval.newLayouts = new HashMap();
        Iterator lit = this.layouts_.values().iterator();
        while (lit.hasNext()) {
            Layout lo = (Layout)lit.next();
            String targ = lo.getTarget();
            String name = lo.getName();
            if (!targ.equals(gid)) continue;
            retval.oldLayouts.put(name, new Layout(lo));
            retval.newLayouts.put(name, new Layout(name, gid));
        }
        Iterator nlit = retval.newLayouts.keySet().iterator();
        while (nlit.hasNext()) {
            String name = (String)nlit.next();
            Layout lo = (Layout)retval.newLayouts.get(name);
            this.layouts_.put(name, new Layout(lo));
        }
        GenomeInstance newGI = (GenomeInstance)gi.getStrippedGenomeCopy();
        this.instances_.put(gid, newGI);
        retval.newInstance = newGI;
        return retval;
    }

    public Iterator getSimulationDefaults(int nodeType, int logicType) {
        if (nodeType != 4) {
            return this.simDefaultsNode_.keySet().iterator();
        }
        if (logicType == 0) {
            return this.simDefaultsGeneAnd_.keySet().iterator();
        }
        return this.simDefaultsGeneOr_.keySet().iterator();
    }

    public String getSimulationDefaultValue(String key, int nodeType, int logicType) {
        if (nodeType != 4) {
            return (String)this.simDefaultsNode_.get(key);
        }
        if (logicType == 0) {
            return (String)this.simDefaultsGeneAnd_.get(key);
        }
        return (String)this.simDefaultsGeneOr_.get(key);
    }

    public void legacyIOFixup(JFrame topWindow) {
        List lineBrks;
        List noteOrphs;
        int numOrphs;
        List srcErrors;
        PadCalculatorToo pcalc;
        List padErrors;
        String msgDiv;
        FontManager.getMgr().fixupLegacyIO();
        ResourceManager rMan = ResourceManager.getManager();
        String message = rMan.getString("legacyIOFixup.baseChange");
        if (topWindow != null) {
            message = "<html><center>" + message;
            msgDiv = "<br><br>";
        } else {
            msgDiv = " ";
        }
        boolean doit = false;
        if (this.iOVersion_.equals("1.0")) {
            List nodeCh;
            List change = this.legacyIOFixupForHourBounds();
            if (change != null && !change.isEmpty()) {
                String desc;
                String form;
                int size = change.size();
                if (size == 1) {
                    form = rMan.getString("legacyIOFixup.singleHourBoundsChange");
                    desc = MessageFormat.format(form, change.get(0));
                } else {
                    form = rMan.getString("legacyIOFixup.multiHourBoundsChange");
                    desc = MessageFormat.format(form, change.get(0), new Integer(size - 1));
                }
                message = message + msgDiv + desc;
                doit = true;
            }
            if ((nodeCh = this.legacyIOFixupForNodeActivities()) != null && !nodeCh.isEmpty()) {
                String desc;
                String form;
                int size = nodeCh.size();
                if (size == 1) {
                    form = rMan.getString("legacyIOFixup.singleNodeActivityChange");
                    desc = MessageFormat.format(form, nodeCh.get(0));
                } else {
                    form = rMan.getString("legacyIOFixup.multiNodeActivityChange");
                    desc = MessageFormat.format(form, nodeCh.get(0), new Integer(size - 1));
                }
                message = message + msgDiv + desc;
                doit = true;
            }
        }
        if (this.iOVersion_.equals("1.0") || this.iOVersion_.equals(PREVIOUS_IO_VERSION_A_)) {
            this.legacyIOFixupForGroupOrdering();
        }
        if (!(padErrors = (pcalc = new PadCalculatorToo()).checkForPadErrors()).isEmpty()) {
            pcalc.fixIOPadErrors(padErrors);
            message = message + msgDiv + rMan.getString("legacyIOFixup.padErrors");
            doit = true;
        }
        if (!(srcErrors = pcalc.checkForGeneSrcPadErrors()).isEmpty()) {
            message = message + msgDiv + rMan.getString("legacyIOFixup.srcPadErrors");
            doit = true;
        }
        if ((this.iOVersion_.equals("1.0") || this.iOVersion_.equals(PREVIOUS_IO_VERSION_A_) || this.iOVersion_.equals(PREVIOUS_IO_VERSION_B_)) && (numOrphs = (noteOrphs = this.legacyIOFixupForOrphanedNotes()).size()) > 0) {
            String form = rMan.getString("legacyIOFixup.orphanNoteFixup");
            message = message + msgDiv + form;
            doit = true;
        }
        if ((this.iOVersion_.equals("1.0") || this.iOVersion_.equals(PREVIOUS_IO_VERSION_A_) || this.iOVersion_.equals(PREVIOUS_IO_VERSION_B_)) && (lineBrks = this.legacyIOFixupForLineBreaks()) != null && !lineBrks.isEmpty()) {
            String desc;
            int size = lineBrks.size();
            if (size == 1) {
                String form = rMan.getString("legacyIOFixup.singleLineBreakChange");
                desc = MessageFormat.format(form, lineBrks.get(0));
            } else {
                String form = rMan.getString("legacyIOFixup.multiLineBreakChange");
                desc = MessageFormat.format(form, lineBrks.get(0), new Integer(size - 1));
            }
            message = message + msgDiv + desc;
            doit = true;
        }
        if (this.iOVersion_.equals("1.0") || this.iOVersion_.equals(PREVIOUS_IO_VERSION_A_) || this.iOVersion_.equals(PREVIOUS_IO_VERSION_B_) || this.iOVersion_.equals(PREVIOUS_IO_VERSION_C_)) {
            this.pertData_.transferFromLegacy();
        }
        if (doit) {
            message = message + msgDiv + rMan.getString("legacyIOFixup.changeSuffix");
            if (topWindow != null) {
                message = message + "</center></html>";
                JOptionPane.showMessageDialog(topWindow, message, rMan.getString("legacyIOFixup.dialogTitle"), 2);
            } else {
                System.err.println(message);
            }
        }
    }

    private List legacyIOFixupForHourBounds() {
        GenomeInstance gi;
        if (this.dynProxies_.isEmpty()) {
            return null;
        }
        int minTcd = Integer.MAX_VALUE;
        int maxTcd = Integer.MIN_VALUE;
        TimeCourseData tcd = this.getTimeCourseData();
        if (tcd != null && tcd.haveData()) {
            minTcd = tcd.getMinimumTime();
            maxTcd = tcd.getMaximumTime();
        }
        ArrayList retval = new ArrayList();
        Iterator iit = this.getInstanceIterator();
        while (iit.hasNext()) {
            gi = (GenomeInstance)iit.next();
            gi.fixupLegacyIOHourBoundsFromProxies(minTcd, maxTcd, retval);
        }
        iit = this.getInstanceIterator();
        while (iit.hasNext()) {
            gi = (GenomeInstance)iit.next();
            gi.fixupLegacyIOHourBoundsFromParents(retval);
        }
        return retval;
    }

    private void legacyIOFixupForGroupOrdering() {
        String rootKey = this.getGenome().getID();
        HashSet processed = new HashSet();
        Iterator lokit = this.layouts_.keySet().iterator();
        while (lokit.hasNext()) {
            GroupProperties gprop;
            String groupID;
            Group group;
            String lokey = (String)lokit.next();
            Layout layout = (Layout)this.layouts_.get(lokey);
            String targ = layout.getTarget();
            if (targ.equals(rootKey)) continue;
            int order = 1;
            GenomeInstance git = (GenomeInstance)this.instances_.get(targ);
            Iterator it = git.getGroupIterator();
            while (it.hasNext()) {
                group = (Group)it.next();
                groupID = group.getID();
                gprop = layout.getGroupProperties(groupID);
                if (gprop.getLayer() != 0) continue;
                gprop.setOrder(order++);
            }
            it = git.getGroupIterator();
            while (it.hasNext()) {
                group = (Group)it.next();
                groupID = group.getID();
                gprop = layout.getGroupProperties(groupID);
                if (gprop.getLayer() == 0) continue;
                String parentID = group.getParentID();
                GroupProperties gpropParent = layout.getGroupProperties(parentID);
                gprop.setOrder(gpropParent.getOrder());
            }
        }
    }

    private List legacyIOFixupForLineBreaks() {
        ArrayList<String> fixes = new ArrayList<String>();
        AffineTransform trans = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(trans, true, true);
        Iterator lokit = this.layouts_.keySet().iterator();
        while (lokit.hasNext()) {
            String lokey = (String)lokit.next();
            Layout layout = (Layout)this.layouts_.get(lokey);
            String targ = layout.getTarget();
            Genome genome = this.getGenome(targ);
            Iterator it = genome.getAllNodeIterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                String nodeID = node.getID();
                NodeProperties np = layout.getNodeProperties(nodeID);
                String breakDef = MultiLineRenderSupport.legacyLineBreaks(np.getHideName(), node.getNodeType(), frc, node.getName());
                if (breakDef == null) continue;
                System.err.println(node.getName() + " def = " + breakDef);
                np.setLineBreakDef(breakDef);
                fixes.add(node.getName());
            }
        }
        return fixes;
    }

    private List legacyIOFixupForOrphanedNotes() {
        ArrayList<String> fixes = new ArrayList<String>();
        AffineTransform trans = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(trans, true, true);
        HashSet<String> goodNoteKeys = new HashSet<String>();
        Iterator iit = this.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            Iterator noteIt = gi.getNoteIterator();
            while (noteIt.hasNext()) {
                Note note = (Note)noteIt.next();
                goodNoteKeys.add(note.getID());
            }
        }
        Iterator pit = this.getDynamicProxyIterator();
        while (pit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)pit.next();
            Iterator noteIt = dip.getNoteIterator();
            while (noteIt.hasNext()) {
                Note note = (Note)noteIt.next();
                goodNoteKeys.add(note.getID());
            }
        }
        Iterator lokit = this.layouts_.keySet().iterator();
        while (lokit.hasNext()) {
            String lokey = (String)lokit.next();
            Layout layout = (Layout)this.layouts_.get(lokey);
            HashSet noteKeys = new HashSet(layout.getNotePropertiesKeys());
            Iterator nkit = noteKeys.iterator();
            while (nkit.hasNext()) {
                String noteKey = (String)nkit.next();
                if (goodNoteKeys.contains(noteKey)) continue;
                layout.removeNoteProperties(noteKey);
                fixes.add(noteKey);
            }
        }
        return fixes;
    }

    private List legacyIOFixupForNodeActivities() {
        ArrayList retval = new ArrayList();
        HashSet<String> processed = new HashSet<String>();
        int pCount = this.instances_.size();
        while (processed.size() < pCount) {
            Iterator it = this.getInstanceIterator();
            while (it.hasNext()) {
                String parentID;
                GenomeInstance parent;
                GenomeInstance git = (GenomeInstance)it.next();
                String myID = git.getID();
                if (processed.contains(myID) || (parent = git.getVfgParent()) != null && !processed.contains(parentID = parent.getID())) continue;
                processed.add(myID);
                git.fixupLegacyIONodeActivities(retval);
            }
        }
        return retval;
    }

    public boolean matchesExistingGeneName(String name, Genome genome, String exceptionID) {
        name = name.replaceAll(" ", "");
        String baseExceptionID = exceptionID == null ? null : GenomeItemInstance.getBaseID(exceptionID);
        Iterator rit = this.genome_.getGeneIterator();
        while (rit.hasNext()) {
            String baseID;
            Gene gene = (Gene)rit.next();
            if (baseExceptionID != null && (baseID = GenomeItemInstance.getBaseID(gene.getID())).equals(baseExceptionID) || !DataUtil.keysEqual(gene.getName(), name)) continue;
            return true;
        }
        Iterator iit = this.instances_.values().iterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            Iterator git = gi.getGeneIterator();
            while (git.hasNext()) {
                String oname;
                String baseID;
                GeneInstance genei = (GeneInstance)git.next();
                if (baseExceptionID != null && genome.getID().equals(gi.getID()) && (baseID = GenomeItemInstance.getBaseID(genei.getID())).equals(baseExceptionID) || (oname = genei.getOverrideName()) == null || !DataUtil.keysEqual(oname, name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesExistingGeneName(String name) {
        return this.matchesExistingGeneName(name, null, null);
    }

    public boolean matchesExistingGeneOrNodeName(String name, Genome genome, String exceptionID) {
        if (this.matchesExistingGeneName(name, genome, exceptionID)) {
            return true;
        }
        return this.matchesExistingNodeName(name, genome, exceptionID);
    }

    public boolean matchesExistingNodeName(String name) {
        return this.matchesExistingNodeName(name, null, null);
    }

    public boolean matchesExistingNodeName(String name, Genome genome, String exceptionID) {
        name = name.replaceAll(" ", "");
        String baseExceptionID = exceptionID != null ? GenomeItemInstance.getBaseID(exceptionID) : null;
        Iterator rit = this.genome_.getNodeIterator();
        while (rit.hasNext()) {
            Node node = (Node)rit.next();
            if (exceptionID != null && node.getID().equals(baseExceptionID) || !DataUtil.keysEqual(node.getName(), name)) continue;
            return true;
        }
        Iterator iit = this.instances_.values().iterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            Iterator nit = gi.getNodeIterator();
            while (nit.hasNext()) {
                String oname;
                NodeInstance nodei = (NodeInstance)nit.next();
                if (exceptionID != null && genome.getID().equals(gi.getID()) && nodei.getID().equals(exceptionID) || (oname = nodei.getOverrideName()) == null || !DataUtil.keysEqual(oname, name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matchesExistingGeneOrNodeName(String name) {
        return this.matchesExistingGeneOrNodeName(name, null, null);
    }

    public boolean hasDataAttachedByDefault(String nodeID) {
        Database db = Database.getDB();
        nodeID = GenomeItemInstance.getBaseID(nodeID);
        PerturbationData pdat = db.getPertData();
        if (pdat.haveDataForNode(nodeID, null) && !pdat.haveCustomMapForNode(nodeID)) {
            return true;
        }
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd.haveDataForNode(nodeID) && !tcd.haveCustomMapForNode(nodeID)) {
            return true;
        }
        TemporalInputRangeData tird = db.getTemporalInputRangeData();
        return tird.haveDataForNode(nodeID) && !tird.haveCustomMapForNode(nodeID);
    }

    public boolean hasRegionAttachedByDefault(Group group) {
        Database db = Database.getDB();
        TimeCourseData tcd = db.getTimeCourseData();
        String groupName = group.getName();
        String groupID = group.getID();
        if (DataUtil.containsKey(tcd.getRegions(), groupName) && !tcd.haveCustomMapForRegion(groupID)) {
            return true;
        }
        TemporalInputRangeData tird = db.getTemporalInputRangeData();
        return DataUtil.containsKey(tird.getRegions(), groupName) && !tird.haveCustomMapForRegion(groupID);
    }

    public boolean hasOtherRegionsAttachedByDefault(GenomeInstance gi, Group group) {
        if (gi.getVfgParent() != null) {
            throw new IllegalArgumentException();
        }
        Iterator iit = this.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance tgi = (GenomeInstance)iit.next();
            if (tgi.getVfgParent() != null || tgi == gi) continue;
            Iterator git = tgi.getGroupIterator();
            while (git.hasNext()) {
                Group testGroup = (Group)git.next();
                String tgName = testGroup.getName();
                if (tgName == null || !DataUtil.keysEqual(tgName, group.getName()) || !this.hasRegionAttachedByDefault(testGroup)) continue;
                return true;
            }
        }
        return false;
    }

    public ModelData getModelData() {
        return this.modelData_;
    }

    public void setModelData(ModelData md) {
        this.modelData_ = md;
    }

    public void rollbackDataUndoTransaction(DatabaseChange change) {
        this.databaseChangeUndo(change);
    }

    public PerturbationData getPertData() {
        return this.pertData_;
    }

    public void setPertData(PerturbationData pd) {
        this.pertData_ = pd;
    }

    public DatabaseChange startTimeCourseUndoTransaction() {
        DatabaseChange dc = new DatabaseChange();
        dc.oldTcd = this.timeCourse_;
        return dc;
    }

    public DatabaseChange finishTimeCourseUndoTransaction(DatabaseChange change) {
        change.newTcd = this.timeCourse_;
        return change;
    }

    public DatabaseChange startCopiesPerEmbryoUndoTransaction() {
        DatabaseChange dc = new DatabaseChange();
        dc.oldCpe = this.copiesPerEmb_;
        return dc;
    }

    public DatabaseChange finishCopiesPerEmbryoUndoTransaction(DatabaseChange change) {
        change.newCpe = this.copiesPerEmb_;
        return change;
    }

    public DatabaseChange startTemporalInputUndoTransaction() {
        DatabaseChange dc = new DatabaseChange();
        dc.oldTir = this.rangeData_;
        return dc;
    }

    public DatabaseChange finishTemporalInputUndoTransaction(DatabaseChange change) {
        change.newTir = this.rangeData_;
        return change;
    }

    public TimeCourseData getTimeCourseData() {
        return this.timeCourse_;
    }

    public void setTimeCourseData(TimeCourseData timeCourse) {
        this.timeCourse_ = timeCourse;
    }

    public CopiesPerEmbryoData getCopiesPerEmbryoData() {
        return this.copiesPerEmb_;
    }

    public void setCopiesPerEmbryoData(CopiesPerEmbryoData copies) {
        this.copiesPerEmb_ = copies;
    }

    public TemporalInputRangeData getTemporalInputRangeData() {
        return this.rangeData_;
    }

    public void setTemporalInputRangeData(TemporalInputRangeData rangeData) {
        this.rangeData_ = rangeData;
    }

    public TimeAxisDefinition getTimeAxisDefinition() {
        return this.timeAxis_;
    }

    public DatabaseChange setTimeAxisDefinition(TimeAxisDefinition timeAxis) {
        DatabaseChange dc = new DatabaseChange();
        dc.oldTimeAxis = (TimeAxisDefinition)this.timeAxis_.clone();
        this.timeAxis_ = timeAxis;
        dc.newTimeAxis = (TimeAxisDefinition)this.timeAxis_.clone();
        return dc;
    }

    public void installLegacyTimeAxisDefinition() {
        this.timeAxis_ = new TimeAxisDefinition().setToLegacy();
    }

    public boolean modelsHaveTimeBounds() {
        if (!this.dynProxies_.isEmpty()) {
            return true;
        }
        Iterator iit = this.instances_.values().iterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (!gi.hasTimeBounds()) continue;
            return true;
        }
        return false;
    }

    public StartupView getStartupView() {
        TaggedSet revChoice;
        TaggedSet modChoice;
        NetOverlayOwner owner;
        String ovrID;
        if (this.startupView_ == null) {
            return null;
        }
        String modelID = this.startupView_.getModel();
        if (modelID != null && (ovrID = (owner = this.getOverlayOwnerFromGenomeKey(modelID)).getFirstViewPreference(modChoice = new TaggedSet(), revChoice = new TaggedSet())) != null) {
            StartupView modified = new StartupView(modelID, ovrID, modChoice, revChoice);
            return modified;
        }
        return this.startupView_;
    }

    public DatabaseChange setStartupView(StartupView startupView) {
        DatabaseChange dc = new DatabaseChange();
        dc.oldStartupView = (StartupView)this.startupView_.clone();
        this.startupView_ = startupView;
        dc.newStartupView = (StartupView)this.startupView_.clone();
        return dc;
    }

    public Workspace getWorkspace() {
        return this.workspace_;
    }

    public void simpleSetWorkspace(Workspace workspace) {
        throw new UnsupportedOperationException();
    }

    public DatabaseChange setWorkspace(Workspace workspace) {
        DatabaseChange dc = new DatabaseChange();
        dc.oldWorkspace = (Workspace)this.workspace_.clone();
        this.workspace_ = workspace;
        dc.newWorkspace = (Workspace)this.workspace_.clone();
        return dc;
    }

    public void setWorkspaceNeedsCenter() {
        this.workspace_.setNeedsCenter(true);
    }

    public Genome getHoldingGenome() {
        return this.holdingGenome_;
    }

    public void clearHoldingGenome() {
        this.holdingGenome_ = new DBGenome("fake", "_BT_FAKE_HOLDING_GENOME_");
    }

    public Genome getGenome() {
        return this.genome_;
    }

    public int getGenomeCount() {
        return this.instances_.size() + 1;
    }

    public Genome getGenome(String key) {
        if (key.equals("bioTapA")) {
            return this.genome_;
        }
        Genome retval = (Genome)this.instances_.get(key);
        if (retval != null) {
            return retval;
        }
        if (DynamicInstanceProxy.isDynamicInstance(key)) {
            String proxKey = DynamicInstanceProxy.extractProxyID(key);
            DynamicInstanceProxy dip = (DynamicInstanceProxy)this.dynProxies_.get(proxKey);
            if (dip == null) {
                return null;
            }
            DynamicGenomeInstance dgi = dip.getProxiedInstance(key);
            if (dgi != null) {
                return dgi;
            }
        }
        return null;
    }

    public Layout getLayout(String key) {
        return (Layout)this.layouts_.get(key);
    }

    public String mapGenomeKeyToLayoutKey(String genomeKey) {
        return new LayoutManager().getLayout(genomeKey);
    }

    public NetOverlayOwner getOverlayOwnerFromGenomeKey(String key) {
        if (DynamicInstanceProxy.isDynamicInstance(key)) {
            String proxKey = DynamicInstanceProxy.extractProxyID(key);
            DynamicInstanceProxy fromProx = this.getDynamicProxy(proxKey);
            if (fromProx == null) {
                throw new IllegalArgumentException();
            }
            return fromProx;
        }
        Genome genOwn = this.getGenome(key);
        if (genOwn == null) {
            throw new IllegalArgumentException();
        }
        return genOwn;
    }

    public NetOverlayOwner getOverlayOwnerWithOwnerKey(String key) {
        DynamicInstanceProxy fromProx = this.getDynamicProxy(key);
        if (fromProx != null) {
            return fromProx;
        }
        Genome genOwn = this.getGenome(key);
        if (genOwn == null) {
            throw new IllegalArgumentException();
        }
        return genOwn;
    }

    public void clearAllDynamicProxyCaches() {
        Iterator dpit = this.dynProxies_.values().iterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            dip.clearCache();
        }
    }

    public DynamicInstanceProxy getDynamicProxy(String key) {
        return (DynamicInstanceProxy)this.dynProxies_.get(key);
    }

    public DatabaseChange addDynamicProxy(String key, DynamicInstanceProxy dip) {
        DatabaseChange retval = new DatabaseChange();
        retval.newProxy = dip;
        if (key == null) {
            key = this.labels_.getNextLabel();
        } else if (!this.labels_.addExistingLabel(key)) {
            System.err.println("Don't like " + key);
            throw new IllegalArgumentException();
        }
        if (this.dynProxies_.get(key) != null) {
            System.err.println(this.labels_ + " key = " + key);
            throw new IllegalArgumentException();
        }
        this.dynProxies_.put(key, dip);
        return retval;
    }

    public DatabaseChange addDynamicProxyExistingLabel(String key, DynamicInstanceProxy dip) {
        DatabaseChange retval = new DatabaseChange();
        retval.newProxy = dip;
        if (key == null) {
            key = this.labels_.getNextLabel();
        } else if (this.dynProxies_.get(key) != null) {
            System.err.println(this.labels_ + " key = " + key);
            throw new IllegalArgumentException();
        }
        this.dynProxies_.put(key, dip);
        return retval;
    }

    public DatabaseChange[] removeDynamicProxy(String key) {
        boolean dropStartup = key.equals(this.startupView_.getModel());
        DatabaseChange[] retval = new DatabaseChange[dropStartup ? 2 : 1];
        retval[0] = new DatabaseChange();
        retval[0].oldProxy = (DynamicInstanceProxy)this.dynProxies_.remove(key);
        if (retval[0].oldProxy == null) {
            throw new IllegalArgumentException();
        }
        this.labels_.removeLabel(key);
        if (dropStartup) {
            retval[1] = new DatabaseChange();
            retval[1].oldStartupView = (StartupView)this.startupView_.clone();
            this.startupView_ = this.startupView_.dropModel();
            retval[1].newStartupView = (StartupView)this.startupView_.clone();
        }
        return retval;
    }

    public void setGenome(Genome genome) {
        if (this.genome_ != null) {
            throw new IllegalArgumentException();
        }
        this.labels_.addExistingLabel("bioTapA");
        this.genome_ = genome;
    }

    public DatabaseChange addGenomeInstanceExistingLabel(String key, Genome genome) {
        DatabaseChange retval = new DatabaseChange();
        retval.newInstance = (GenomeInstance)genome;
        if (key == null) {
            key = this.labels_.getNextLabel();
        }
        if (this.instances_.get(key) != null) {
            throw new IllegalArgumentException();
        }
        this.instances_.put(key, genome);
        return retval;
    }

    public DatabaseChange addGenomeInstance(String key, Genome genome) {
        DatabaseChange retval = new DatabaseChange();
        retval.newInstance = (GenomeInstance)genome;
        if (key == null) {
            key = this.labels_.getNextLabel();
        } else if (!this.labels_.addExistingLabel(key)) {
            System.err.println("Don't like " + key);
            throw new IllegalArgumentException();
        }
        if (this.instances_.get(key) != null) {
            throw new IllegalArgumentException();
        }
        this.instances_.put(key, genome);
        return retval;
    }

    public DatabaseChange addLayout(String key, Layout layout) {
        DatabaseChange retval = new DatabaseChange();
        retval.newLayout = layout;
        if (key == null) {
            key = this.labels_.getNextLabel();
        } else if (this.layouts_.get(key) != null) {
            throw new IllegalArgumentException();
        }
        this.layouts_.put(key, layout);
        return retval;
    }

    public void addBuildInstruction(BuildInstruction bi) {
        if (bi.getID() == null) {
            bi.setID(this.instructionLabels_.getNextLabel());
        } else if (!this.instructionLabels_.addExistingLabel(bi.getID())) {
            throw new IllegalArgumentException();
        }
        this.buildInstructions_.add(bi);
    }

    public String getNextInstructionLabel() {
        return this.instructionLabels_.getNextLabel();
    }

    public Iterator getBuildInstructions() {
        return this.buildInstructions_.iterator();
    }

    public boolean haveBuildInstructions() {
        return this.buildInstructions_.size() > 0;
    }

    public DatabaseChange setBuildInstructions(List inst) {
        DatabaseChange retval = new DatabaseChange();
        retval.oldBuildInst = this.buildInstructions_;
        this.buildInstructions_ = this.deepCopyBuildInstr(inst);
        retval.newBuildInst = this.deepCopyBuildInstr(inst);
        this.stockInstructionLabels();
        return retval;
    }

    public BuildInstruction getBuildInstruction(String idTag) {
        int numbi = this.buildInstructions_.size();
        for (int i = 0; i < numbi; ++i) {
            BuildInstruction bi = (BuildInstruction)this.buildInstructions_.get(i);
            if (!idTag.equals(bi.getID())) continue;
            return bi;
        }
        throw new IllegalArgumentException();
    }

    public DatabaseChange dropBuildInstructions() {
        DatabaseChange retval = new DatabaseChange();
        retval.oldBuildInst = this.buildInstructions_;
        this.buildInstructions_ = new ArrayList();
        retval.newBuildInst = new ArrayList();
        return retval;
    }

    private void stockInstructionLabels() {
        this.instructionLabels_ = new UniqueLabeller();
        Iterator biit = this.getBuildInstructions();
        while (biit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)biit.next();
            this.instructionLabels_.addExistingLabel(bi.getID());
        }
    }

    public void addInstanceInstructionSet(String id, InstanceInstructionSet iis) {
        this.instanceInstructionSets_.put(id, iis);
    }

    public InstanceInstructionSet getInstanceInstructionSet(String key) {
        InstanceInstructionSet retval = (InstanceInstructionSet)this.instanceInstructionSets_.get(key);
        return retval;
    }

    public DatabaseChange removeInstanceInstructionSet(String key) {
        DatabaseChange retval = new DatabaseChange();
        retval.instructSetKey = key;
        retval.oldInstructSet = (InstanceInstructionSet)this.instanceInstructionSets_.get(key);
        this.instanceInstructionSets_.remove(key);
        retval.newInstructSet = null;
        return retval;
    }

    public DatabaseChange setInstanceInstructionSet(String key, InstanceInstructionSet iis) {
        DatabaseChange retval = new DatabaseChange();
        retval.instructSetKey = key;
        retval.oldInstructSet = (InstanceInstructionSet)this.instanceInstructionSets_.get(key);
        this.instanceInstructionSets_.put(key, new InstanceInstructionSet(iis));
        retval.newInstructSet = new InstanceInstructionSet(iis);
        return retval;
    }

    public DatabaseChange startLayoutUndoTransaction(String key) {
        DatabaseChange retval = new DatabaseChange();
        Layout lo = (Layout)this.layouts_.get(key);
        retval.oldLayout = new Layout(lo);
        return retval;
    }

    public DatabaseChange finishLayoutUndoTransaction(DatabaseChange change) {
        String key = change.oldLayout.getName();
        Layout lo = (Layout)this.layouts_.get(key);
        change.newLayout = new Layout(lo);
        return change;
    }

    public void rollbackLayoutUndoTransaction(DatabaseChange change) {
        this.databaseChangeUndo(change);
    }

    public NavTree getNavTree() {
        return this.navTree_;
    }

    public Iterator getInstanceIterator() {
        return this.instances_.values().iterator();
    }

    public Iterator getDynamicProxyIterator() {
        return this.dynProxies_.values().iterator();
    }

    public Iterator getLayoutIterator() {
        return this.layouts_.values().iterator();
    }

    public String getNextKey() {
        return this.labels_.getNextLabel();
    }

    public Color getColor(String colorKey) {
        return this.colGen_.getColor(colorKey);
    }

    public NamedColor getNamedColor(String colorKey) {
        return this.colGen_.getNamedColor(colorKey);
    }

    public GlobalChange updateColors(Map namedColors) {
        return this.colGen_.updateColors(namedColors);
    }

    /*
     * Unable to fully structure code
     */
    public String getUniqueModelName() {
        rMan = ResourceManager.getManager();
        format = rMan.getString("model.defaultNameFormat");
        block0: do lbl-1000:
        // 3 sources

        {
            suffix = new Integer(this.uniqueNameSuffix_++);
            tryName = MessageFormat.format(format, new Object[]{suffix});
            if (format.equals(tryName)) {
                throw new IllegalStateException();
            }
            iit = this.getInstanceIterator();
            noMatch = true;
            while (iit.hasNext()) {
                gi = (GenomeInstance)iit.next();
                if (!gi.getName().equals(tryName)) continue;
                noMatch = false;
                break;
            }
            if (!noMatch) ** GOTO lbl-1000
            dpit = this.getDynamicProxyIterator();
            while (dpit.hasNext()) {
                dip = (DynamicInstanceProxy)dpit.next();
                if (!dip.getName().equals(tryName)) continue;
                noMatch = false;
                continue block0;
            }
        } while (!noMatch);
        return tryName;
    }

    public DatabaseChange[] removeInstance(String key) {
        boolean dropStartup = key.equals(this.startupView_.getModel());
        DatabaseChange[] retval = new DatabaseChange[dropStartup ? 2 : 1];
        retval[0] = new DatabaseChange();
        retval[0].oldInstance = (GenomeInstance)this.instances_.remove(key);
        if (retval[0].oldInstance == null) {
            throw new IllegalArgumentException();
        }
        this.labels_.removeLabel(key);
        if (dropStartup) {
            retval[1] = new DatabaseChange();
            retval[1].oldStartupView = (StartupView)this.startupView_.clone();
            this.startupView_ = this.startupView_.dropModel();
            retval[1].newStartupView = (StartupView)this.startupView_.clone();
        }
        return retval;
    }

    public DatabaseChange removeLayout(String key) {
        DatabaseChange retval = new DatabaseChange();
        retval.oldLayout = (Layout)this.layouts_.remove(key);
        this.labels_.removeLabel(key);
        return retval;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        Iterator isit;
        ind.indent();
        out.print("<BioTapestry version=\"");
        out.print(CURRENT_IO_VERSION_);
        out.println("\" >");
        if (this.modelData_ != null) {
            this.modelData_.writeXML(out, ind.up());
            ind.down();
        }
        if (this.timeAxis_ != null && this.timeAxis_.isInitialized()) {
            this.timeAxis_.writeXML(out, ind.up());
            ind.down();
        }
        if (this.workspace_ != null) {
            this.workspace_.writeXML(out, ind.up());
            ind.down();
        }
        if (this.startupView_ != null) {
            this.startupView_.writeXML(out, ind.up());
            ind.down();
        }
        FontManager.getMgr().writeXML(out, ind.up());
        ind.down();
        DisplayOptionsManager.getMgr().writeXML(out, ind.up());
        ind.down();
        this.colGen_.writeXML(out, ind.up());
        ind.down();
        ImageManager.getMgr().writeXML(out, ind.up());
        ind.down();
        UserTreePathManager.getMgr().writeXML(out, ind.up());
        ind.down();
        ((DBGenome)this.genome_).writeXML(out, ind.up());
        ind.indent();
        List ordered = this.navTree_.getPreorderListing(true);
        Iterator oit = ordered.iterator();
        out.println("<genomeInstances>");
        ind.up();
        while (oit.hasNext()) {
            String gkey = (String)oit.next();
            GenomeInstance gi = (GenomeInstance)this.getGenome(gkey);
            gi.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</genomeInstances>");
        ind.indent();
        out.println("<layouts>");
        Iterator lit = this.getLayoutIterator();
        ind.up();
        while (lit.hasNext()) {
            Layout lo = (Layout)lit.next();
            lo.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</layouts>");
        if (this.pertData_ != null && this.pertData_.haveData()) {
            this.pertData_.writeXML(out, ind);
        }
        if (this.timeCourse_ != null) {
            this.timeCourse_.writeXML(out, ind);
        }
        if (this.rangeData_ != null) {
            this.rangeData_.writeXML(out, ind);
        }
        if (this.copiesPerEmb_ != null && this.copiesPerEmb_.haveData()) {
            this.copiesPerEmb_.writeXML(out, ind);
        }
        ArrayList<String> dumpList = new ArrayList<String>();
        ordered = this.navTree_.getPreorderListing(true);
        oit = ordered.iterator();
        while (oit.hasNext()) {
            DynamicGenomeInstance dgi;
            DynamicInstanceProxy dip;
            String gkey = (String)oit.next();
            GenomeInstance gi = (GenomeInstance)this.getGenome(gkey);
            if (!(gi instanceof DynamicGenomeInstance) || dumpList.contains((dip = (DynamicInstanceProxy)this.dynProxies_.get((dgi = (DynamicGenomeInstance)gi).getProxyID())).getID())) continue;
            dip.writeXML(out, ind);
            dumpList.add(dip.getID());
        }
        dumpList = new ArrayList();
        ordered = this.navTree_.getProxyPreorderListing();
        oit = ordered.iterator();
        while (oit.hasNext()) {
            String pkey = (String)oit.next();
            DynamicInstanceProxy dip = (DynamicInstanceProxy)this.dynProxies_.get(pkey);
            if (dumpList.contains(dip.getID())) continue;
            dip.writeXML(out, ind);
            dumpList.add(dip.getID());
        }
        Iterator biit = this.getBuildInstructions();
        if (biit.hasNext()) {
            ind.indent();
            out.println("<buildInstructions>");
            ind.up();
            while (biit.hasNext()) {
                BuildInstruction bi = (BuildInstruction)biit.next();
                bi.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</buildInstructions>");
        }
        if ((isit = this.instanceInstructionSets_.values().iterator()).hasNext()) {
            ind.indent();
            out.println("<instructionSets>");
            ind.up();
            while (isit.hasNext()) {
                InstanceInstructionSet iis = (InstanceInstructionSet)isit.next();
                iis.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</instructionSets>");
        }
        ind.down().indent();
        out.println("</BioTapestry>");
    }

    public void modelHasChanged(ModelChangeEvent event, int remaining) {
        if (remaining == 0) {
            this.modelHasChanged(event);
        }
    }

    public void modelHasChanged(ModelChangeEvent mcev) {
        this.clearAllDynamicProxyCaches();
    }

    public void generalChangeOccurred(GeneralChangeEvent gcev) {
        this.clearAllDynamicProxyCaches();
    }

    public String getNextColorLabel() {
        return this.colGen_.getNextColorLabel();
    }

    public void setColor(String itemId, NamedColor color) {
        this.colGen_.setColor(itemId, color);
    }

    public Iterator getColorKeys() {
        return this.colGen_.getColorKeys();
    }

    public void changeUndo(GlobalChange undo) {
        this.colGen_.changeUndo(undo);
    }

    public void changeRedo(GlobalChange undo) {
        this.colGen_.changeRedo(undo);
    }

    public void databaseChangeUndo(DatabaseChange undo) {
        String key;
        if (undo.oldInstance != null) {
            key = undo.oldInstance.getID();
            this.instances_.put(key, undo.oldInstance);
            this.labels_.addExistingLabel(key);
        } else if (undo.newInstance != null) {
            key = undo.newInstance.getID();
            this.instances_.remove(key);
            this.labels_.removeLabel(key);
        } else if (undo.oldLayout != null) {
            key = undo.oldLayout.getName();
            this.layouts_.put(key, new Layout(undo.oldLayout));
            this.labels_.addExistingLabel(key);
        } else if (undo.newLayout != null) {
            key = undo.newLayout.getName();
            this.layouts_.remove(key);
            this.labels_.removeLabel(key);
        } else if (undo.oldProxy != null) {
            key = undo.oldProxy.getID();
            this.dynProxies_.put(key, undo.oldProxy);
            this.labels_.addExistingLabel(key);
        } else if (undo.newProxy != null) {
            key = undo.newProxy.getID();
            this.dynProxies_.remove(key);
            this.labels_.removeLabel(key);
        } else if (undo.oldTcd != null) {
            this.timeCourse_ = undo.oldTcd;
        } else if (undo.oldCpe != null) {
            this.copiesPerEmb_ = undo.oldCpe;
        } else if (undo.oldTir != null) {
            this.rangeData_ = undo.oldTir;
        } else if (undo.oldBuildInst != null) {
            this.buildInstructions_ = undo.oldBuildInst;
            this.stockInstructionLabels();
        } else if (undo.instructSetKey != null) {
            if (undo.oldInstructSet != null) {
                this.instanceInstructionSets_.put(undo.instructSetKey, undo.oldInstructSet);
            } else {
                this.instanceInstructionSets_.remove(undo.instructSetKey);
            }
        } else if (undo.oldGenome != null) {
            this.genome_ = undo.oldGenome;
        } else if (undo.oldTimeAxis != null) {
            this.timeAxis_ = undo.oldTimeAxis;
        } else if (undo.oldWorkspace != null) {
            this.workspace_ = undo.oldWorkspace;
        } else if (undo.oldStartupView != null) {
            this.startupView_ = undo.oldStartupView;
        }
        if (undo.oldLayouts != null) {
            Iterator olit = undo.oldLayouts.keySet().iterator();
            while (olit.hasNext()) {
                String name = (String)olit.next();
                Layout lo = (Layout)undo.oldLayouts.get(name);
                Layout nlo = new Layout(lo);
                this.layouts_.put(name, nlo);
            }
        }
    }

    public void databaseChangeRedo(DatabaseChange undo) {
        String key;
        if (undo.newInstance != null) {
            key = undo.newInstance.getID();
            this.instances_.put(key, undo.newInstance);
            this.labels_.addExistingLabel(key);
        } else if (undo.oldInstance != null) {
            key = undo.oldInstance.getID();
            this.instances_.remove(key);
            this.labels_.removeLabel(key);
        } else if (undo.newLayout != null) {
            key = undo.newLayout.getName();
            this.layouts_.put(key, new Layout(undo.newLayout));
            this.labels_.addExistingLabel(key);
        } else if (undo.oldLayout != null) {
            key = undo.oldLayout.getName();
            this.layouts_.remove(key);
            this.labels_.removeLabel(key);
        } else if (undo.newProxy != null) {
            key = undo.newProxy.getID();
            this.dynProxies_.put(key, undo.newProxy);
            this.labels_.addExistingLabel(key);
        } else if (undo.oldProxy != null) {
            key = undo.oldProxy.getID();
            this.dynProxies_.remove(key);
            this.labels_.removeLabel(key);
        } else if (undo.newTcd != null) {
            this.timeCourse_ = undo.newTcd;
        } else if (undo.newCpe != null) {
            this.copiesPerEmb_ = undo.newCpe;
        } else if (undo.newTir != null) {
            this.rangeData_ = undo.newTir;
        } else if (undo.newBuildInst != null) {
            this.buildInstructions_ = undo.newBuildInst;
            this.stockInstructionLabels();
        } else if (undo.instructSetKey != null) {
            if (undo.newInstructSet != null) {
                this.instanceInstructionSets_.put(undo.instructSetKey, undo.newInstructSet);
            } else {
                this.instanceInstructionSets_.remove(undo.instructSetKey);
            }
        } else if (undo.newGenome != null) {
            this.genome_ = undo.newGenome;
        } else if (undo.newTimeAxis != null) {
            this.timeAxis_ = undo.newTimeAxis;
        } else if (undo.newWorkspace != null) {
            this.workspace_ = undo.newWorkspace;
        } else if (undo.newStartupView != null) {
            this.startupView_ = undo.newStartupView;
        }
        if (undo.newLayouts != null) {
            Iterator nlit = undo.newLayouts.keySet().iterator();
            while (nlit.hasNext()) {
                String name = (String)nlit.next();
                Layout lo = (Layout)undo.newLayouts.get(name);
                Layout nlo = new Layout(lo);
                this.layouts_.put(name, nlo);
            }
        }
    }

    public Set cannotDeleteColors() {
        return this.colGen_.cannotDeleteColors();
    }

    public String activeColorCycle(int i) {
        return this.colGen_.activeColorCycle(i);
    }

    public String distinctActiveColor() {
        return this.colGen_.distinctActiveColor();
    }

    public String distinctInactiveColor() {
        return this.colGen_.distinctInactiveColor();
    }

    public String inactiveColorCycle(int i) {
        return this.colGen_.inactiveColorCycle(i);
    }

    public String getNextColor() {
        List geneColors = this.colGen_.getGeneColorsAsList();
        HashMap<String, Integer> colorCounts = new HashMap<String, Integer>();
        int gcSize = geneColors.size();
        for (int i = 0; i < gcSize; ++i) {
            String col = (String)geneColors.get(i);
            colorCounts.put(col, new Integer(0));
        }
        Genome root = this.getGenome();
        String loKey = new LayoutManager().getLayout(root.getID());
        Layout lo = this.getLayout(loKey);
        Iterator git = root.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            NodeProperties np = lo.getNodeProperties(gene.getID());
            String col = np.getColorName();
            if (!geneColors.contains(col)) continue;
            Integer count = (Integer)colorCounts.get(col);
            colorCounts.put(col, new Integer(count + 1));
        }
        Iterator nit = root.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            if (!NodeProperties.setWithLinkColor(node.getNodeType())) continue;
            NodeProperties srcProp = lo.getNodeProperties(node.getID());
            String col = "black";
            if (node.getNodeType() == 5) {
                col = srcProp.getSecondColorName();
                if (col == null) {
                    col = srcProp.getColorName();
                }
            } else {
                col = srcProp.getColorName();
            }
            if (!geneColors.contains(col)) continue;
            Integer count = (Integer)colorCounts.get(col);
            colorCounts.put(col, new Integer(count + 1));
        }
        int minVal = Integer.MAX_VALUE;
        HashSet<String> minSet = new HashSet<String>();
        Iterator cckit = colorCounts.keySet().iterator();
        while (cckit.hasNext()) {
            String col = (String)cckit.next();
            int count = (Integer)colorCounts.get(col);
            if (count < minVal) {
                minSet.clear();
                minVal = count;
                minSet.add(col);
                continue;
            }
            if (count != minVal) continue;
            minSet.add(col);
        }
        for (int i = 0; i < gcSize; ++i) {
            String retval = (String)geneColors.get(i);
            if (!minSet.contains(retval)) continue;
            return retval;
        }
        return "black";
    }

    public void getRarestColors(List geneColors, List rareColors) {
        HashMap<String, Integer> colorCounts = new HashMap<String, Integer>();
        int gcSize = geneColors.size();
        for (int i = 0; i < gcSize; ++i) {
            String col = (String)geneColors.get(i);
            colorCounts.put(col, new Integer(0));
        }
        Genome root = this.getGenome();
        String loKey = new LayoutManager().getLayout(root.getID());
        Layout lo = this.getLayout(loKey);
        Iterator git = root.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            NodeProperties np = lo.getNodeProperties(gene.getID());
            String col = np.getColorName();
            if (!geneColors.contains(col)) continue;
            Integer count = (Integer)colorCounts.get(col);
            colorCounts.put(col, new Integer(count + 1));
        }
        Iterator nit = root.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            if (!NodeProperties.setWithLinkColor(node.getNodeType())) continue;
            NodeProperties srcProp = lo.getNodeProperties(node.getID());
            String col = "black";
            if (node.getNodeType() == 5) {
                col = srcProp.getSecondColorName();
                if (col == null) {
                    col = srcProp.getColorName();
                }
            } else {
                col = srcProp.getColorName();
            }
            if (!geneColors.contains(col)) continue;
            Integer count = (Integer)colorCounts.get(col);
            colorCounts.put(col, new Integer(count + 1));
        }
        int minVal = Integer.MAX_VALUE;
        HashSet<String> minSet = new HashSet<String>();
        Iterator cckit = colorCounts.keySet().iterator();
        while (cckit.hasNext()) {
            String col = (String)cckit.next();
            int count = (Integer)colorCounts.get(col);
            if (count < minVal) {
                minSet.clear();
                minVal = count;
                minSet.add(col);
                continue;
            }
            if (count != minVal) continue;
            minSet.add(col);
        }
        rareColors.clear();
        for (int i = 0; i < gcSize; ++i) {
            String retval = (String)geneColors.get(i);
            if (!minSet.contains(retval)) continue;
            rareColors.add(retval);
        }
    }

    public String getGeneColor(int i) {
        return this.colGen_.getGeneColor(i);
    }

    public int getNumColors() {
        return this.colGen_.getNumColors();
    }

    public void setIOVersion(String version) {
        this.iOVersion_ = version;
    }

    public static synchronized Database getDB() {
        if (singleton_ == null) {
            singleton_ = new Database();
        }
        return singleton_;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("BioTapestry");
        return retval;
    }

    public static String versionFromXML(String elemName, Attributes attrs) throws IOException {
        String version = AttributeExtractor.extractAttribute(elemName, attrs, "BioTapestry", "version", false);
        return version == null ? "1.0" : version;
    }

    private Database() {
        this.dynProxies_ = new HashMap();
        this.labels_ = new UniqueLabeller();
        this.colGen_ = new ColorGenerator();
        this.instructionLabels_ = new UniqueLabeller();
        this.buildInstructions_ = new ArrayList();
        this.timeAxis_ = new TimeAxisDefinition();
        this.workspace_ = new Workspace();
        this.pertData_ = new PerturbationData();
        this.startupView_ = new StartupView();
        this.instanceInstructionSets_ = new HashMap();
        this.simDefaultsNode_ = new HashMap();
        this.simDefaultsNode_.put("initVal", "200.0");
        this.simDefaultsNode_.put("KD", "0.005");
        this.simDefaultsNode_.put("Kmult", "1.0");
        this.simDefaultsGeneAnd_ = new HashMap();
        this.simDefaultsGeneAnd_.put("DN", "160000000.0");
        this.simDefaultsGeneAnd_.put("IM", "5.45");
        this.simDefaultsGeneAnd_.put("initVal", "0.0");
        this.simDefaultsGeneAnd_.put("KR", "100000.0");
        this.simDefaultsGeneAnd_.put("KQ", "10.0");
        this.simDefaultsGeneAnd_.put("KD", "0.005");
        this.simDefaultsGeneOr_ = new HashMap();
        this.simDefaultsGeneOr_.put("DN", "160000000.0");
        this.simDefaultsGeneOr_.put("IM", "5.45");
        this.simDefaultsGeneOr_.put("initVal", "0.0");
        this.simDefaultsGeneOr_.put("KR", "100000.0");
        this.simDefaultsGeneOr_.put("KQ", "1.0");
        this.simDefaultsGeneOr_.put("KD", "0.005");
        EventManager.getManager().addModelChangeListener(this);
        EventManager.getManager().addGeneralChangeListener(this);
    }

    private ArrayList deepCopyBuildInstr(List inst) {
        ArrayList<Object> retval = new ArrayList<Object>();
        int size = inst.size();
        for (int i = 0; i < size; ++i) {
            retval.add(((BuildInstruction)inst.get(i)).clone());
        }
        return retval;
    }
}

