/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.BuildInstructionFactory;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSetFactory;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.ModelDataFactory;
import org.systemsbiology.biotapestry.genome.DBGenomeFactory;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxyFactory;
import org.systemsbiology.biotapestry.genome.GenomeInstanceFactory;
import org.systemsbiology.biotapestry.nav.ImageFactory;
import org.systemsbiology.biotapestry.nav.UserTreePathFactory;
import org.systemsbiology.biotapestry.parser.ParserClient;
import org.systemsbiology.biotapestry.perturb.PerturbationData;
import org.systemsbiology.biotapestry.qpcr.QpcrLegacyPublicExposed;
import org.systemsbiology.biotapestry.timeCourse.CopiesPerEmbryoFormatFactory;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeFormatFactory;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseFormatFactory;
import org.systemsbiology.biotapestry.ui.GlobalDataFactory;
import org.systemsbiology.biotapestry.ui.LayoutFactory;
import org.xml.sax.Attributes;

public class DatabaseFactory
implements ParserClient {
    private Set bioTapHeaderKeys_ = Database.keywordsOfInterest();
    private HashSet allKeys_ = new HashSet();
    private ParserClient currClient_;
    private HashMap clients_;

    public DatabaseFactory(boolean isViewer) {
        this.allKeys_.addAll(this.bioTapHeaderKeys_);
        ArrayList<ParserClient> alist = new ArrayList<ParserClient>();
        alist.add(new DBGenomeFactory());
        alist.add(new GenomeInstanceFactory());
        alist.add(new LayoutFactory());
        alist.add(new ModelDataFactory());
        alist.add(new BuildInstructionFactory());
        alist.add(new InstanceInstructionSetFactory());
        alist.add(new GlobalDataFactory());
        alist.add(new ImageFactory());
        alist.add(new UserTreePathFactory());
        alist.add(new QpcrLegacyPublicExposed().getParserClient(false, false));
        alist.add(new TimeCourseFormatFactory(false, false));
        alist.add(new CopiesPerEmbryoFormatFactory(false));
        alist.add(new TemporalInputRangeFormatFactory(false));
        alist.add(new DynamicInstanceProxyFactory());
        alist.add(new PerturbationData.PertDataWorker(false, false));
        Iterator cit = alist.iterator();
        this.clients_ = new HashMap();
        while (cit.hasNext()) {
            ParserClient pc = (ParserClient)cit.next();
            Set keys = pc.keywordsOfInterest();
            Iterator ki = keys.iterator();
            while (ki.hasNext()) {
                String key = (String)ki.next();
                ParserClient prev = this.clients_.put(key, pc);
                if (prev == null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.currClient_ = null;
    }

    public void setContainer(Object container) {
        if (this.currClient_ != null) {
            this.currClient_.setContainer(container);
        }
    }

    public boolean finishElement(String elemName) throws IOException {
        if (this.currClient_ == null) {
            return false;
        }
        if (this.currClient_.finishElement(elemName)) {
            this.currClient_ = null;
        }
        return this.allKeys_.contains(elemName);
    }

    public void processCharacters(char[] chars, int start, int length) {
        if (this.currClient_ != null) {
            this.currClient_.processCharacters(chars, start, length);
        }
    }

    public Set keywordsOfInterest() {
        return this.allKeys_;
    }

    public Object processElement(String elemName, Attributes attrs) throws IOException {
        if (this.bioTapHeaderKeys_.contains(elemName)) {
            String version = Database.versionFromXML(elemName, attrs);
            Database.getDB().setIOVersion(version);
            return null;
        }
        if (this.currClient_ != null) {
            return this.currClient_.processElement(elemName, attrs);
        }
        ParserClient pc = (ParserClient)this.clients_.get(elemName);
        if (pc != null) {
            this.currClient_ = pc;
            return this.currClient_.processElement(elemName, attrs);
        }
        return null;
    }
}

