/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class ModelData {
    private String date_;
    private String attribution_;
    private ArrayList key_;

    public void setDate(String date) {
        this.date_ = date;
    }

    public void appendDate(String date) {
        this.date_ = this.date_ == null ? date : this.date_.concat(date);
        this.date_ = CharacterEntityMapper.unmapEntities(this.date_, false);
    }

    public String getDate() {
        return this.date_;
    }

    public void setAttribution(String attribution) {
        this.attribution_ = attribution;
    }

    public void appendAttribution(String attribution) {
        this.attribution_ = this.attribution_ == null ? attribution : this.attribution_.concat(attribution);
        this.attribution_ = CharacterEntityMapper.unmapEntities(this.attribution_, false);
    }

    public String getAttribution() {
        return this.attribution_;
    }

    public void setKey(List entries) {
        if (entries == null) {
            this.key_ = null;
            return;
        }
        this.key_ = new ArrayList(entries);
    }

    public void startKey(String key) {
        if (this.key_ == null) {
            this.key_ = new ArrayList();
        }
        key = CharacterEntityMapper.unmapEntities(key, false);
        this.key_.add(key);
    }

    public void appendKey(String fragment) {
        int num = this.key_.size() - 1;
        String currLast = (String)this.key_.get(num);
        currLast = currLast.concat(fragment);
        currLast = CharacterEntityMapper.unmapEntities(currLast, false);
        this.key_.set(num, currLast);
    }

    public int getKeySize() {
        return this.key_ == null ? 0 : this.key_.size();
    }

    public String getKey(int i) {
        return (String)this.key_.get(i);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<modelData>");
        ind.up();
        if (this.date_ != null) {
            ind.indent();
            out.print("<modelDate>");
            out.print(CharacterEntityMapper.mapEntities(this.date_, false));
            out.println("</modelDate>");
        }
        if (this.attribution_ != null) {
            ind.indent();
            out.print("<modelAttribution>");
            out.print(CharacterEntityMapper.mapEntities(this.attribution_, false));
            out.println("</modelAttribution>");
        }
        if (this.key_ != null) {
            ind.indent();
            out.println("<modelKey>");
            ind.up();
            int numKey = this.key_.size();
            for (int i = 0; i < numKey; ++i) {
                ind.indent();
                out.print("<modelKeyEntry>");
                out.print(CharacterEntityMapper.mapEntities((String)this.key_.get(i), false));
                out.println("</modelKeyEntry>");
            }
            ind.down().indent();
            out.println("</modelKey>");
        }
        ind.down().indent();
        out.println("</modelData>");
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("modelData");
        return retval;
    }

    public static String attributionKeyword() {
        return "modelAttribution";
    }

    public static String dateKeyword() {
        return "modelDate";
    }

    public static String keyEntryKeyword() {
        return "modelKeyEntry";
    }

    public String toString() {
        return "ModelData: date = " + this.date_ + " attribution = " + this.attribution_;
    }

    public static ModelData buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("modelData")) {
            return null;
        }
        return new ModelData();
    }
}

