/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.io.IOException;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.ModelData;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.db.Workspace;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.nav.UserTreePathManager;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.xml.sax.Attributes;

public class ModelDataFactory
extends AbstractFactoryClient {
    private static final int NONE_ = 0;
    private static final int DATE_ = 1;
    private static final int ATTRIBUTION_ = 2;
    private static final int KEY_ = 3;
    private int charTarget_;
    private Set modelDataKeys_ = ModelData.keywordsOfInterest();
    private String attribKey_ = ModelData.attributionKeyword();
    private String dateKey_ = ModelData.dateKeyword();
    private String keyKey_ = ModelData.keyEntryKeyword();
    private Set timeAxisKeys_ = TimeAxisDefinition.keywordsOfInterest();
    private String timeAxisStageKey_ = TimeAxisDefinition.getStageKeyword();

    public ModelDataFactory() {
        super(new FactoryWhiteboard());
        FactoryWhiteboard whiteboard = (FactoryWhiteboard)this.sharedWhiteboard_;
        Workspace.WorkspaceWorker wfc = new Workspace.WorkspaceWorker(whiteboard);
        this.installWorker(wfc, new MyWorkspaceGlue());
        StartupView.StartupViewWorker svfc = new StartupView.StartupViewWorker(whiteboard);
        this.installWorker(svfc, new MyStartupViewGlue());
        this.myKeys_.addAll(wfc.keywordsOfInterest());
        this.myKeys_.addAll(svfc.keywordsOfInterest());
        this.myKeys_.addAll(this.modelDataKeys_);
        this.myKeys_.addAll(this.timeAxisKeys_);
    }

    public void localFinishElement(String elemName) {
        this.charTarget_ = 0;
    }

    public void localProcessCharacters(char[] chars, int start, int length) {
        String nextString = new String(chars, start, length);
        ModelData md = null;
        switch (this.charTarget_) {
            case 0: {
                break;
            }
            case 1: {
                md = (ModelData)this.container_;
                md.appendDate(nextString);
                break;
            }
            case 2: {
                md = (ModelData)this.container_;
                md.appendAttribution(nextString);
                break;
            }
            case 3: {
                md = (ModelData)this.container_;
                md.appendKey(nextString);
            }
        }
    }

    public Object localProcessElement(String elemName, Attributes attrs) throws IOException {
        TimeAxisDefinition.NamedStage ns;
        if (this.modelDataKeys_.contains(elemName)) {
            ModelData md = ModelData.buildFromXML(elemName, attrs);
            if (md != null) {
                Database db = Database.getDB();
                db.setModelData(md);
                return md;
            }
            return null;
        }
        if (this.dateKey_.equals(elemName)) {
            this.charTarget_ = 1;
        } else if (this.attribKey_.equals(elemName)) {
            this.charTarget_ = 2;
        } else if (this.keyKey_.equals(elemName)) {
            ModelData md = (ModelData)this.container_;
            md.startKey("");
            this.charTarget_ = 3;
        } else if (this.timeAxisKeys_.contains(elemName)) {
            TimeAxisDefinition tad = TimeAxisDefinition.buildFromXML(elemName, attrs);
            if (tad != null) {
                Database db = Database.getDB();
                db.setTimeAxisDefinition(tad);
            }
        } else if (this.timeAxisStageKey_.equals(elemName) && (ns = TimeAxisDefinition.NamedStage.buildFromXML(elemName, attrs)) != null) {
            Database db = Database.getDB();
            TimeAxisDefinition tad = db.getTimeAxisDefinition();
            tad.addAStage(ns);
        }
        return null;
    }

    public static class MyStartupViewGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            StartupView sView = board.startupView;
            Database db = Database.getDB();
            db.setStartupView(sView);
            return null;
        }
    }

    public static class MyWorkspaceGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            UserTreePathManager mgr = UserTreePathManager.getMgr();
            Workspace ws = board.workspace;
            Database db = Database.getDB();
            db.setWorkspace(ws);
            return null;
        }
    }
}

