/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.NetOverlayController;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.xml.sax.Attributes;

public class StartupView
implements Cloneable {
    private String modelKey_;
    private String ovrKey_;
    private TaggedSet modKeys_;
    private TaggedSet revKeys_;

    public StartupView() {
        this.modelKey_ = null;
        this.ovrKey_ = null;
        this.modKeys_ = new TaggedSet();
        this.revKeys_ = new TaggedSet();
    }

    public StartupView(String key, String ovrKey, TaggedSet modKeys, TaggedSet revKeys) {
        this.modelKey_ = key;
        this.ovrKey_ = ovrKey;
        this.modKeys_ = modKeys == null ? new TaggedSet() : modKeys;
        this.revKeys_ = revKeys == null ? new TaggedSet() : revKeys;
    }

    public Object clone() {
        try {
            StartupView retval = (StartupView)super.clone();
            retval.modKeys_ = (TaggedSet)this.modKeys_.clone();
            retval.revKeys_ = (TaggedSet)this.revKeys_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof StartupView)) {
            return false;
        }
        StartupView otherSV = (StartupView)other;
        if (this.modelKey_ == null ? otherSV.modelKey_ != null : !this.modelKey_.equals(otherSV.modelKey_)) {
            return false;
        }
        if (this.ovrKey_ == null ? otherSV.ovrKey_ != null : !this.ovrKey_.equals(otherSV.ovrKey_)) {
            return false;
        }
        if (this.modKeys_ == null ? otherSV.modKeys_ != null : !this.modKeys_.equals(otherSV.modKeys_)) {
            return false;
        }
        return !(this.revKeys_ == null ? otherSV.revKeys_ != null : !this.revKeys_.equals(otherSV.revKeys_));
    }

    public StartupView dropModel() {
        return new StartupView();
    }

    public String getModel() {
        return this.modelKey_;
    }

    public String getOverlay() {
        return this.ovrKey_;
    }

    public TaggedSet getModules() {
        return this.modKeys_;
    }

    public TaggedSet getRevealedModules() {
        return this.revKeys_;
    }

    public boolean referencesOverlay(String modelKey, String overlayKey) {
        if (this.modelKey_ == null || !this.modelKey_.equals(modelKey)) {
            return false;
        }
        if (this.ovrKey_ == null) {
            return false;
        }
        return this.ovrKey_.equals(overlayKey);
    }

    public boolean referencesModule(String modelKey, String overlayKey, String modKey) {
        if (!this.referencesOverlay(modelKey, overlayKey)) {
            return false;
        }
        return this.modKeys_.set.contains(modKey);
    }

    public void addModule(String modelKey, String overlayKey, String modKey) {
        if (!this.referencesOverlay(modelKey, overlayKey)) {
            throw new IllegalArgumentException();
        }
        this.modKeys_.set.add(modKey);
    }

    public boolean deleteModule(String modelKey, String overlayKey, String modKey) {
        if (!this.referencesOverlay(modelKey, overlayKey)) {
            throw new IllegalArgumentException();
        }
        this.modKeys_.set.remove(modKey);
        return this.modKeys_.set.isEmpty();
    }

    public void installInTree(CommonView suw, boolean selectRoot, NavTree navTree, JTree jtree) {
        StartupView suv;
        TreePath tp;
        int timeVal = -1;
        if (selectRoot) {
            DefaultTreeModel dtm = (DefaultTreeModel)jtree.getModel();
            DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)dtm.getRoot();
            DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(0);
            Object[] tn = rootChild.getPath();
            tp = new TreePath(tn);
        } else {
            tp = this.modelKey_ == null ? navTree.getDefaultSelection() : navTree.getStartupSelection(this.modelKey_);
        }
        DynamicInstanceProxy dip = null;
        if (this.modelKey_ != null && DynamicInstanceProxy.isDynamicInstance(this.modelKey_)) {
            String proxID = DynamicInstanceProxy.extractProxyID(this.modelKey_);
            Database db = Database.getDB();
            dip = db.getDynamicProxy(proxID);
            if (!dip.isSingle()) {
                DynamicGenomeInstance dgi = dip.getProxiedInstance(this.modelKey_);
                timeVal = dgi.getTime();
            }
        }
        NetOverlayController noc = MainCommands.getCmds().getOverlayController();
        String currModel = suw.getSUPanel().getGenome();
        boolean diffModel = currModel == null ? this.modelKey_ != null : !currModel.equals(this.modelKey_);
        boolean changeInTargOverlay = false;
        if (this.modelKey_ != null && !(suv = noc.getCachedStateForGenome(this.modelKey_)).equals(this)) {
            changeInTargOverlay = true;
        }
        String currOvr = suw.getSUPanel().getCurrentOverlay();
        if (this.ovrKey_ != null || currOvr != null || changeInTargOverlay) {
            if (diffModel) {
                noc.preloadForNextGenome(this.modelKey_, this.ovrKey_, this.modKeys_, this.revKeys_);
            } else {
                noc.setFullOverlayState(this.ovrKey_, this.modKeys_, this.revKeys_, null);
            }
        }
        jtree.setSelectionPath(tp);
        if (timeVal != -1) {
            suw.setSliderForTime(dip, timeVal);
        }
    }

    public void setModKeys(TaggedSet modKeys) {
        this.modKeys_ = modKeys == null ? new TaggedSet() : modKeys;
    }

    public void setRevKeys(TaggedSet revKeys) {
        this.revKeys_ = revKeys == null ? new TaggedSet() : revKeys;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<startupView");
        if (this.modelKey_ == null) {
            out.println("/>");
            return;
        }
        out.print(" model=\"");
        out.print(this.modelKey_);
        if (this.ovrKey_ != null) {
            out.print("\" ovrKey=\"");
            out.print(this.ovrKey_);
        }
        if (this.modKeys_ == null || this.modKeys_.set.isEmpty()) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up();
        if (this.modKeys_ != null) {
            ind.indent();
            if (this.modKeys_.set.isEmpty()) {
                out.println("<startMods/>");
            } else {
                out.println("<startMods>");
                ind.up();
                this.modKeys_.writeXML(out, ind);
                ind.down().indent();
                out.println("</startMods>");
            }
        }
        if (this.revKeys_ != null) {
            ind.indent();
            if (this.revKeys_.set.isEmpty()) {
                out.println("<startViz/>");
            } else {
                out.println("<startViz>");
                ind.up();
                this.revKeys_.writeXML(out, ind);
                ind.down().indent();
                out.println("</startViz>");
            }
        }
        ind.down().indent();
        out.println("</startupView>");
    }

    public static class MyTSVGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            StartupView startView = board.startupView;
            TaggedSet tSet = board.currentTaggedSet;
            startView.setRevKeys(tSet);
            return null;
        }
    }

    public static class MyTSMGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            StartupView startView = board.startupView;
            TaggedSet tSet = board.currentTaggedSet;
            startView.setModKeys(tSet);
            return null;
        }
    }

    public static class VizWorker
    extends AbstractFactoryClient {
        public VizWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("startViz");
            this.installWorker(new TaggedSet.TaggedSetWorker(whiteboard), new MyTSVGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }

    public static class ModWorker
    extends AbstractFactoryClient {
        public ModWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("startMods");
            this.installWorker(new TaggedSet.TaggedSetWorker(whiteboard), new MyTSMGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }

    public static class StartupViewWorker
    extends AbstractFactoryClient {
        public StartupViewWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("startupView");
            this.installWorker(new ModWorker(whiteboard), null);
            this.installWorker(new VizWorker(whiteboard), null);
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            StartupView retval = null;
            if (elemName.equals("startupView")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.startupView = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private StartupView buildFromXML(String elemName, Attributes attrs) throws IOException {
            String modelID = AttributeExtractor.extractAttribute(elemName, attrs, "startupView", "model", false);
            String ovrKey = AttributeExtractor.extractAttribute(elemName, attrs, "startupView", "ovrKey", false);
            return new StartupView(modelID, ovrKey, null, null);
        }
    }
}

