/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.MinMax;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class TimeAxisDefinition
implements Cloneable {
    private static final int SECONDS_ = 0;
    private static final int MINUTES_ = 1;
    private static final int HOURS_ = 2;
    private static final int DAYS_ = 3;
    private static final int WEEKS_ = 4;
    private static final int MONTHS_ = 5;
    private static final int YEARS_ = 6;
    private static final int NUMBERED_STAGES_ = 7;
    private static final int NAMED_STAGES_ = 8;
    private static final int NUM_UNIT_TYPES_ = 9;
    private static final String SECONDS_TAG_ = "seconds";
    private static final String MINUTES_TAG_ = "minutes";
    private static final String HOURS_TAG_ = "hours";
    private static final String DAYS_TAG_ = "days";
    private static final String WEEKS_TAG_ = "weeks";
    private static final String MONTHS_TAG_ = "months";
    private static final String YEARS_TAG_ = "years";
    private static final String NUMBERED_STAGES_TAG_ = "numbered";
    private static final String NAMED_STAGES_TAG_ = "named";
    private static final int DEFAULT_SPAN_MIN_ = 0;
    private static final int DEFAULT_SPAN_MAX_SECONDS_ = 60;
    private static final int DEFAULT_SPAN_MAX_MINUTES_ = 60;
    private static final int DEFAULT_SPAN_MAX_HOURS_ = 24;
    private static final int DEFAULT_SPAN_MAX_DAYS_ = 7;
    private static final int DEFAULT_SPAN_MAX_WEEKS_ = 4;
    private static final int DEFAULT_SPAN_MAX_MONTHS_ = 12;
    private static final int DEFAULT_SPAN_MAX_YEARS_ = 10;
    private static final int DEFAULT_SPAN_MAX_NUMBERED_ = 10;
    public static final int INVALID_STAGE_NAME = -1;
    public static final int FIRST_STAGE = 0;
    public static final int LEGACY_UNITS = 2;
    private boolean initialized_ = false;
    private int units_;
    private String userUnits_;
    private String userUnitAbbrev_;
    private boolean userUnitIsSuffix_;
    private ArrayList namedStages_;

    public Object clone() {
        try {
            TimeAxisDefinition retval = (TimeAxisDefinition)super.clone();
            if (this.namedStages_ == null) {
                return retval;
            }
            retval.namedStages_ = new ArrayList();
            int numStages = this.namedStages_.size();
            for (int i = 0; i < numStages; ++i) {
                retval.namedStages_.add(((NamedStage)this.namedStages_.get(i)).clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public TimeAxisDefinition setToDefault() {
        this.units_ = 2;
        this.userUnits_ = null;
        this.userUnitAbbrev_ = null;
        this.userUnitIsSuffix_ = true;
        this.namedStages_ = null;
        this.initialized_ = true;
        return this;
    }

    public TimeAxisDefinition setToLegacy() {
        return this.setToDefault();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDefinition(int units, String userUnits, String userUnitAbbrev, boolean isSuffix, List namedStages) {
        this.units_ = units;
        if (this.units_ == 8 || this.units_ == 7) {
            this.userUnits_ = userUnits == null ? "" : userUnits;
            this.userUnitAbbrev_ = userUnitAbbrev == null ? this.userUnits_ : userUnitAbbrev;
            this.userUnitIsSuffix_ = isSuffix;
        } else {
            this.userUnits_ = null;
            this.userUnitAbbrev_ = null;
            this.userUnitIsSuffix_ = true;
        }
        if (this.units_ == 8) {
            if (namedStages == null) throw new IllegalArgumentException();
            if (namedStages.isEmpty()) {
                throw new IllegalArgumentException();
            }
            this.namedStages_ = new ArrayList(namedStages);
        } else {
            this.namedStages_ = null;
        }
        this.initialized_ = true;
    }

    public void startDefinition(int units, String userUnits, String userUnitAbbrev, boolean isSuffix) throws IOException {
        this.units_ = units;
        if (this.units_ != 8 && this.units_ != 7) {
            this.initialized_ = true;
            this.userUnitIsSuffix_ = true;
            if (this.userUnits_ != null) {
                throw new IOException();
            }
            return;
        }
        this.userUnits_ = userUnits;
        this.userUnitAbbrev_ = userUnitAbbrev == null ? userUnits : userUnitAbbrev;
        this.userUnitIsSuffix_ = isSuffix;
        if (this.units_ == 7) {
            this.initialized_ = true;
        } else {
            this.namedStages_ = new ArrayList();
            this.initialized_ = false;
        }
    }

    public void addAStage(NamedStage stage) throws IOException {
        if (this.namedStages_.size() > 0) {
            NamedStage lastStage = (NamedStage)this.namedStages_.get(this.namedStages_.size() - 1);
            if (stage.order != lastStage.order + 1) {
                throw new IOException();
            }
        }
        this.namedStages_.add(stage);
        this.initialized_ = true;
    }

    public boolean isInitialized() {
        return this.initialized_;
    }

    public int getUnits() {
        if (!this.initialized_) {
            throw new IllegalStateException();
        }
        return this.units_;
    }

    public MinMax getDefaultTimeSpan() {
        if (!this.initialized_) {
            throw new IllegalStateException();
        }
        switch (this.units_) {
            case 0: {
                return new MinMax(0, 60);
            }
            case 1: {
                return new MinMax(0, 60);
            }
            case 2: {
                return new MinMax(0, 24);
            }
            case 3: {
                return new MinMax(0, 7);
            }
            case 4: {
                return new MinMax(0, 4);
            }
            case 5: {
                return new MinMax(0, 12);
            }
            case 6: {
                return new MinMax(0, 10);
            }
            case 7: {
                return new MinMax(0, 10);
            }
            case 8: {
                int max = this.namedStages_.size() - 1;
                return max == 0 ? new MinMax(0) : new MinMax(0, max);
            }
        }
        throw new IllegalArgumentException();
    }

    public String unitDisplayString() {
        if (this.haveCustomUnits()) {
            return this.userUnits_;
        }
        return TimeAxisDefinition.displayStringForUnit(this.units_);
    }

    public String unitDisplayAbbrev() {
        if (this.haveCustomUnits()) {
            return this.userUnitAbbrev_;
        }
        return TimeAxisDefinition.abbrevStringForUnit(this.units_);
    }

    public boolean unitsAreASuffix() {
        if (this.haveCustomUnits()) {
            return this.userUnitIsSuffix_;
        }
        return true;
    }

    public boolean haveNamedStages() {
        return this.initialized_ && this.namedStages_ != null;
    }

    public boolean haveCustomUnits() {
        return this.initialized_ && TimeAxisDefinition.wantsCustomUnits(this.units_);
    }

    public List getNamedStages() {
        if (!this.initialized_ || this.units_ != 8) {
            throw new IllegalStateException();
        }
        return this.namedStages_;
    }

    public boolean haveNamedStageForIndex(int index) {
        if (!this.initialized_ || this.units_ != 8) {
            throw new IllegalStateException();
        }
        if (index < 0 || index >= this.namedStages_.size()) {
            return false;
        }
        return this.namedStages_.get(index) != null;
    }

    public NamedStage getNamedStageForIndex(int index) {
        if (!this.initialized_ || this.units_ != 8) {
            throw new IllegalStateException();
        }
        return (NamedStage)this.namedStages_.get(index);
    }

    public int getIndexForNamedStage(String stageName) {
        if (!this.initialized_ || this.units_ != 8) {
            throw new IllegalStateException();
        }
        stageName = stageName.trim();
        int numStages = this.namedStages_.size();
        for (int i = 0; i < numStages; ++i) {
            NamedStage currStage = (NamedStage)this.namedStages_.get(i);
            if (!DataUtil.keysEqual(currStage.name, stageName) && !DataUtil.keysEqual(currStage.abbrev, stageName)) continue;
            return i;
        }
        return -1;
    }

    public String getUserUnitName() {
        if (!this.initialized_ || this.units_ != 8 && this.units_ != 7) {
            throw new IllegalStateException();
        }
        return this.userUnits_;
    }

    public String getUserUnitAbbrev() {
        if (!this.initialized_ || this.units_ != 8 && this.units_ != 7) {
            throw new IllegalStateException();
        }
        return this.userUnitAbbrev_;
    }

    public boolean spanIsOk(int min, int max) {
        if (!(!this.haveNamedStages() || this.haveNamedStageForIndex(min) && this.haveNamedStageForIndex(max))) {
            return false;
        }
        return min >= 0 && max >= 0 && max >= min;
    }

    public boolean timeIsOk(int min) {
        if (this.haveNamedStages() && !this.haveNamedStageForIndex(min)) {
            return false;
        }
        return min >= 0;
    }

    public Integer timeStringParse(String timeStr) {
        int timeVal = Integer.MIN_VALUE;
        if (timeStr == null) {
            return null;
        }
        timeStr = timeStr.trim();
        if (this.haveNamedStages()) {
            timeVal = this.getIndexForNamedStage(timeStr);
            if (timeVal == -1) {
                return null;
            }
        } else {
            String displayUnitAbbrev = DataUtil.normKey(this.unitDisplayAbbrev());
            try {
                int hIndex = DataUtil.normKey(timeStr).indexOf(displayUnitAbbrev);
                if (hIndex != -1) {
                    timeStr = timeStr.substring(0, hIndex);
                }
                timeVal = Integer.parseInt(timeStr);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return new Integer(timeVal);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<timeAxisDefinition units=\"");
        out.print(TimeAxisDefinition.mapUnitTypes(this.units_));
        if (this.userUnits_ != null) {
            out.print("\" customUnits=\"");
            out.print(CharacterEntityMapper.mapEntities(this.userUnits_, false));
            out.print("\" isSuffix=\"");
            out.print(Boolean.toString(this.userUnitIsSuffix_));
        }
        if (this.userUnitAbbrev_ != null) {
            out.print("\" customUnitAbbrev=\"");
            out.print(CharacterEntityMapper.mapEntities(this.userUnitAbbrev_, false));
        }
        if (this.namedStages_ == null || this.namedStages_.isEmpty()) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up();
        int numStages = this.namedStages_.size();
        for (int i = 0; i < numStages; ++i) {
            NamedStage stage = (NamedStage)this.namedStages_.get(i);
            stage.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</timeAxisDefinition>");
    }

    public static boolean wantsCustomUnits(int unitType) {
        return unitType == 7 || unitType == 8;
    }

    public static boolean wantsNamedStages(int unitType) {
        return unitType == 8;
    }

    public static String mapUnitTypes(int unitType) {
        switch (unitType) {
            case 0: {
                return SECONDS_TAG_;
            }
            case 1: {
                return MINUTES_TAG_;
            }
            case 2: {
                return HOURS_TAG_;
            }
            case 3: {
                return DAYS_TAG_;
            }
            case 4: {
                return WEEKS_TAG_;
            }
            case 5: {
                return MONTHS_TAG_;
            }
            case 6: {
                return YEARS_TAG_;
            }
            case 7: {
                return NUMBERED_STAGES_TAG_;
            }
            case 8: {
                return NAMED_STAGES_TAG_;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapUnitTypeTag(String unitTypeTag) {
        if (unitTypeTag.equalsIgnoreCase(SECONDS_TAG_)) {
            return 0;
        }
        if (unitTypeTag.equalsIgnoreCase(MINUTES_TAG_)) {
            return 1;
        }
        if (unitTypeTag.equalsIgnoreCase(HOURS_TAG_)) {
            return 2;
        }
        if (unitTypeTag.equalsIgnoreCase(DAYS_TAG_)) {
            return 3;
        }
        if (unitTypeTag.equalsIgnoreCase(WEEKS_TAG_)) {
            return 4;
        }
        if (unitTypeTag.equalsIgnoreCase(MONTHS_TAG_)) {
            return 5;
        }
        if (unitTypeTag.equalsIgnoreCase(YEARS_TAG_)) {
            return 6;
        }
        if (unitTypeTag.equalsIgnoreCase(NUMBERED_STAGES_TAG_)) {
            return 7;
        }
        if (unitTypeTag.equalsIgnoreCase(NAMED_STAGES_TAG_)) {
            return 8;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getUnitTypeChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 9; ++i) {
            retval.add(TimeAxisDefinition.unitTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent unitTypeForCombo(int unitType) {
        return new ChoiceContent(TimeAxisDefinition.displayStringForUnit(unitType), unitType);
    }

    public static String displayStringForUnit(int unitType) {
        return ResourceManager.getManager().getString("timeAxis." + TimeAxisDefinition.mapUnitTypes(unitType));
    }

    public static String abbrevStringForUnit(int unitType) {
        return ResourceManager.getManager().getString("timeAxis.abbrev_" + TimeAxisDefinition.mapUnitTypes(unitType));
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("timeAxisDefinition");
        return retval;
    }

    public static String getStageKeyword() {
        return "timeStage";
    }

    public static MinMax getLegacyDefaultTimeSpan() {
        return new MinMax(0, 24);
    }

    public static String getTimeDisplay(Integer timeObj, boolean showUnits, boolean abbreviate) {
        String timeStr;
        if (timeObj == null) {
            return null;
        }
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        if (tad.haveNamedStages()) {
            int timeNum = timeObj;
            NamedStage stage = tad.getNamedStageForIndex(timeNum);
            timeStr = abbreviate ? stage.abbrev : stage.name;
        } else {
            timeStr = timeObj.toString();
        }
        if (!showUnits) {
            return timeStr;
        }
        String displayUnitAbbrev = tad.unitDisplayAbbrev();
        StringBuffer buf = new StringBuffer();
        if (tad.unitsAreASuffix()) {
            buf.append(timeStr);
            buf.append(" ");
            buf.append(displayUnitAbbrev);
        } else {
            buf.append(displayUnitAbbrev);
            buf.append(" ");
            buf.append(timeStr);
        }
        return buf.toString();
    }

    public static TimeAxisDefinition buildFromXML(String elemName, Attributes attrs) throws IOException {
        int unit;
        String unitTag = null;
        String custom = null;
        String customAbbrev = null;
        String isSuffix = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("units")) {
                    unitTag = val;
                    continue;
                }
                if (key.equals("customUnits")) {
                    custom = val;
                    continue;
                }
                if (key.equals("isSuffix")) {
                    isSuffix = val;
                    continue;
                }
                if (!key.equals("customUnitAbbrev")) continue;
                customAbbrev = val;
            }
        }
        if (unitTag == null) {
            throw new IOException();
        }
        try {
            unit = TimeAxisDefinition.mapUnitTypeTag(unitTag);
        }
        catch (IllegalArgumentException ex) {
            throw new IOException();
        }
        boolean isSuffixVal = true;
        if (isSuffix != null) {
            isSuffixVal = Boolean.valueOf(isSuffix);
        }
        if (custom != null) {
            custom = CharacterEntityMapper.unmapEntities(custom, false);
        }
        if (customAbbrev != null) {
            customAbbrev = CharacterEntityMapper.unmapEntities(customAbbrev, false);
        }
        TimeAxisDefinition tfd = new TimeAxisDefinition();
        tfd.startDefinition(unit, custom, customAbbrev, isSuffixVal);
        return tfd;
    }

    public static class NamedStage
    implements Cloneable {
        public String name;
        public String abbrev;
        public int order;

        public NamedStage(String name, String abbrev, int order) {
            this.name = name;
            this.abbrev = abbrev;
            this.order = order;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("<timeStage order=\"");
            out.print(Integer.toString(this.order));
            out.print("\" name=\"");
            out.print(CharacterEntityMapper.mapEntities(this.name, false));
            out.print("\" abbrev=\"");
            out.print(CharacterEntityMapper.mapEntities(this.abbrev, false));
            out.println("\" />");
        }

        public static NamedStage buildFromXML(String elemName, Attributes attrs) throws IOException {
            String name = null;
            String abbrev = null;
            String orderStr = null;
            if (attrs != null) {
                int count = attrs.getLength();
                for (int i = 0; i < count; ++i) {
                    String key = attrs.getQName(i);
                    if (key == null) continue;
                    String val = attrs.getValue(i);
                    if (key.equals("name")) {
                        name = val;
                        continue;
                    }
                    if (key.equals("abbrev")) {
                        abbrev = val;
                        continue;
                    }
                    if (!key.equals("order")) continue;
                    orderStr = val;
                }
            }
            if (name == null || abbrev == null || orderStr == null) {
                throw new IOException();
            }
            int order = -1;
            try {
                order = Integer.parseInt(orderStr);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
            if (order < 0) {
                throw new IOException();
            }
            name = CharacterEntityMapper.unmapEntities(name, false);
            abbrev = CharacterEntityMapper.unmapEntities(abbrev, false);
            return new NamedStage(name, abbrev, order);
        }
    }
}

