/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.db;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.FactoryUtilWhiteboard;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.UiUtil;
import org.xml.sax.Attributes;

public class Workspace
implements Cloneable {
    private static final int DEFAULT_WIDTH_ = 12000;
    private static final int DEFAULT_HEIGHT_ = 9000;
    public static final double ASPECT_RATIO = 1.3333333333333333;
    public static final int MIN_DIMENSION = 1000;
    public static final int MAX_DIMENSION = 1000000;
    public static final int PADDING = 100;
    private Rectangle workspace_;
    private boolean needsCenter_;

    public Workspace() {
        this.workspace_ = new Rectangle(0, 0, 12000, 9000);
        this.needsCenter_ = false;
    }

    public Workspace(Rectangle rect) {
        this.workspace_ = (Rectangle)rect.clone();
        this.needsCenter_ = false;
    }

    public Workspace(Workspace oldSpace, Point2D newCenter) {
        this.workspace_ = (Rectangle)oldSpace.workspace_.clone();
        this.setCenter(newCenter);
        this.needsCenter_ = false;
    }

    public Workspace(String x, String y, String width, String height) throws IOException {
        int hNum;
        int wNum;
        int yNum;
        int xNum;
        try {
            xNum = Integer.parseInt(x);
            yNum = Integer.parseInt(y);
            wNum = Integer.parseInt(width);
            hNum = Integer.parseInt(height);
        }
        catch (NumberFormatException ex) {
            throw new IOException();
        }
        this.workspace_ = new Rectangle(xNum, yNum, wNum, hNum);
        this.needsCenter_ = false;
    }

    public Object clone() {
        try {
            Workspace retval = (Workspace)super.clone();
            retval.workspace_ = (Rectangle)this.workspace_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void setWorkspace(int x, int y, int width, int height) {
        this.workspace_ = new Rectangle(x, y, width, height);
        this.needsCenter_ = false;
    }

    public void setWorkspace(Rectangle rect) {
        this.workspace_ = (Rectangle)rect.clone();
        this.needsCenter_ = false;
    }

    public Rectangle getWorkspace() {
        return (Rectangle)this.workspace_.clone();
    }

    public int getHeight() {
        return this.workspace_.height;
    }

    public int getWidth() {
        return this.workspace_.width;
    }

    public Point2D getCenter() {
        double x = this.workspace_.getX() + this.workspace_.getWidth() / 2.0;
        double y = this.workspace_.getY() + this.workspace_.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    public Point2D getOrigin() {
        return new Point2D.Double(this.workspace_.getX(), this.workspace_.getY());
    }

    public boolean needsCenter() {
        return this.needsCenter_;
    }

    public void setNeedsCenter(boolean needsCenter) {
        this.needsCenter_ = needsCenter;
    }

    public void setOrigin(Point2D origin) {
        this.workspace_.x = (int)Math.round(origin.getX());
        this.workspace_.y = (int)Math.round(origin.getY());
        this.needsCenter_ = false;
    }

    public void setCenter(Point2D center) {
        this.workspace_.x = (int)Math.round(center.getX() - this.workspace_.getWidth() / 2.0);
        this.workspace_.y = (int)Math.round(center.getY() - this.workspace_.getHeight() / 2.0);
        this.needsCenter_ = false;
    }

    public boolean contains(Rectangle rect) {
        if (rect.x < this.workspace_.x || rect.y < this.workspace_.y) {
            return false;
        }
        if (rect.getMaxX() > this.workspace_.getMaxX()) {
            return false;
        }
        return !(rect.getMaxY() > this.workspace_.getMaxY());
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<workspace x=\"");
        out.print(this.workspace_.x);
        out.print("\" y=\"");
        out.print(this.workspace_.y);
        out.print("\" w=\"");
        out.print(this.workspace_.width);
        out.print("\" h=\"");
        out.print(this.workspace_.height);
        out.println("\" />");
    }

    public static Workspace setToModelBounds(Rectangle modelSize) {
        FixedAspectDim modelFad = Workspace.calcBoundedFit(modelSize, 100, 1.3333333333333333);
        Point2D centerPt = Workspace.getAllModelCenter(modelSize);
        int x = (int)Math.round(centerPt.getX() - (double)modelFad.getWidth() / 2.0);
        int y = (int)Math.round(centerPt.getY() - (double)modelFad.getHeight() / 2.0);
        return new Workspace(new Rectangle(x, y, modelFad.getWidth(), modelFad.getHeight()));
    }

    public static Point2D getAllModelCenter(Rectangle allModelSize) {
        double x = allModelSize.getX() + allModelSize.getWidth() / 2.0;
        double y = allModelSize.getY() + allModelSize.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    public static FixedAspectDim calcBoundedFit(Rectangle modelSize, int padding, double fixedAspect) {
        Dimension maxDim;
        Dimension minDim;
        if (fixedAspect >= 1.0) {
            int minHeight = 1000;
            int minWidth = (int)Math.round(1000.0 * fixedAspect);
            minDim = new Dimension(minWidth, minHeight);
            int maxWidth = 1000000;
            int maxHeight = (int)Math.round(1000000.0 / fixedAspect);
            if (maxHeight < 1000) {
                maxHeight = 1000;
                maxWidth = (int)Math.round(1000.0 * fixedAspect);
            }
            maxDim = new Dimension(maxWidth, maxHeight);
        } else {
            int minWidth = 1000;
            int minHeight = (int)Math.round(1000.0 / fixedAspect);
            minDim = new Dimension(minWidth, minHeight);
            int maxHeight = 1000000;
            int maxWidth = (int)Math.round(1000000.0 * fixedAspect);
            if (maxWidth < 1000) {
                maxWidth = 1000;
                maxHeight = (int)Math.round(1000.0 / fixedAspect);
            }
            maxDim = new Dimension(maxWidth, maxHeight);
        }
        int paddedWidth = (int)UiUtil.forceToGridValueMax(modelSize.width + padding, 10.0);
        int paddedHeight = (int)UiUtil.forceToGridValueMax(modelSize.height + padding, 10.0);
        double modelAspect = (double)paddedWidth / (double)paddedHeight;
        FixedAspectDim retval = new FixedAspectDim(new Dimension(paddedWidth, paddedHeight), fixedAspect);
        if (modelAspect < fixedAspect) {
            retval.changeHeight(paddedHeight, true);
        } else {
            retval.changeWidth(paddedWidth, true);
        }
        if (retval.getHeight() < minDim.height || retval.getWidth() < minDim.width) {
            return new FixedAspectDim(minDim, fixedAspect);
        }
        if (retval.getHeight() > maxDim.height || retval.getWidth() > maxDim.width) {
            return new FixedAspectDim(maxDim, fixedAspect);
        }
        return retval;
    }

    public static class FixedAspectDim {
        private Dimension dim_;
        private double aspect_;

        public FixedAspectDim(Dimension dim, double aspect) {
            this.dim_ = (Dimension)dim.clone();
            this.aspect_ = aspect;
        }

        public FixedAspectDim(FixedAspectDim other) {
            this.dim_ = (Dimension)other.dim_.clone();
            this.aspect_ = other.aspect_;
        }

        public void mergeAll(FixedAspectDim other) {
            this.dim_ = (Dimension)other.dim_.clone();
            this.aspect_ = other.aspect_;
        }

        public int getHeight() {
            return this.dim_.height;
        }

        public int getWidth() {
            return this.dim_.width;
        }

        public double getAspect() {
            return this.aspect_;
        }

        public boolean heightChanged(FixedAspectDim old) {
            return this.dim_.height != old.dim_.height;
        }

        public boolean widthChanged(FixedAspectDim old) {
            return this.dim_.width != old.dim_.width;
        }

        public void mergeHeight(FixedAspectDim src) {
            this.dim_.height = src.dim_.height;
        }

        public void mergeWidth(FixedAspectDim src) {
            this.dim_.width = src.dim_.width;
        }

        public void changeHeight(int newHeight, boolean force) {
            if (this.dim_.height != newHeight || force) {
                this.dim_.height = newHeight;
                this.dim_.width = (int)Math.round((double)this.dim_.height * this.aspect_);
            }
        }

        public void changeWidth(int newWidth, boolean force) {
            if (this.dim_.width != newWidth || force) {
                this.dim_.width = newWidth;
                this.dim_.height = (int)Math.round((double)this.dim_.width / this.aspect_);
            }
        }
    }

    public static class WorkspaceWorker
    extends AbstractFactoryClient {
        public WorkspaceWorker(FactoryUtilWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("workspace");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Workspace retval = null;
            if (elemName.equals("workspace")) {
                FactoryUtilWhiteboard board = (FactoryUtilWhiteboard)this.sharedWhiteboard_;
                retval = board.workspace = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private Workspace buildFromXML(String elemName, Attributes attrs) throws IOException {
            String x = AttributeExtractor.extractAttribute(elemName, attrs, "workspace", "x", true);
            String y = AttributeExtractor.extractAttribute(elemName, attrs, "workspace", "y", true);
            String width = AttributeExtractor.extractAttribute(elemName, attrs, "workspace", "w", true);
            String height = AttributeExtractor.extractAttribute(elemName, attrs, "workspace", "h", true);
            return new Workspace(x, y, width, height);
        }
    }
}

