/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.embedded;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryItem;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryLink;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryNode;
import org.systemsbiology.biotapestry.embedded.ExternalModelInfo;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;

public class EmbeddedViewerInventory {
    private HashMap modelInfo_;
    private ArrayList orderedModels_;
    private HashMap modelNodes_ = new HashMap();
    private HashMap modelLinks_ = new HashMap();

    EmbeddedViewerInventory() {
        this.modelInfo_ = new HashMap();
        this.orderedModels_ = new ArrayList();
        Database db = Database.getDB();
        NavTree navTree = db.getNavTree();
        TimeCourseData tcd = db.getTimeCourseData();
        List pol = navTree.getFullTreePreorderListing();
        Iterator it = pol.iterator();
        while (it.hasNext()) {
            String id = (String)it.next();
            Genome gen = db.getGenome(id);
            this.orderedModels_.add(id);
            List names = gen.getNamesToRoot();
            boolean canSelect = true;
            if (gen instanceof DynamicGenomeInstance) {
                DynamicGenomeInstance dgi = (DynamicGenomeInstance)gen;
                DynamicInstanceProxy dprox = db.getDynamicProxy(dgi.getProxyID());
                if (!dprox.isSingle()) {
                    names.set(names.size() - 1, dprox.getName());
                }
                canSelect = false;
            }
            String[] modelNameChain = names.toArray(new String[names.size()]);
            this.modelInfo_.put(id, new ExternalModelInfo(id, modelNameChain, canSelect));
            ArrayList nodes = new ArrayList();
            ArrayList links = new ArrayList();
            this.modelLinks_.put(id, links);
            this.modelNodes_.put(id, nodes);
            if (gen instanceof DynamicGenomeInstance) continue;
            this.inventoryForModel(gen, nodes, links, tcd);
        }
    }

    public Iterator getOrderedModelIDs() {
        return this.orderedModels_.iterator();
    }

    public ExternalModelInfo getModelInfo(String modelID) {
        return (ExternalModelInfo)this.modelInfo_.get(modelID);
    }

    public List getLinks(String modelID) {
        return new ArrayList((ArrayList)this.modelLinks_.get(modelID));
    }

    public List getNodes(String modelID) {
        return new ArrayList((ArrayList)this.modelNodes_.get(modelID));
    }

    private void inventoryForModel(Genome gen, List nodes, List links, TimeCourseData tcd) {
        String genomeKey = gen.getID();
        Iterator git = gen.getAllNodeIterator();
        while (git.hasNext()) {
            Node node = (Node)git.next();
            String nodeID = node.getID();
            String baseID = GenomeItemInstance.getBaseID(nodeID);
            List customs = tcd.getCustomTCMTimeCourseDataKeys(baseID);
            boolean internalOnly = tcd.isAllInternalForNode(baseID);
            ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(genomeKey, nodeID, false);
            ExternalInventoryItem.ArgsForExternalNode afen = new ExternalInventoryItem.ArgsForExternalNode(ba);
            ExternalInventoryNode ens = new ExternalInventoryNode(ba, afen, customs, internalOnly);
            nodes.add(ens);
        }
        Iterator lit = gen.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String linkID = link.getID();
            int sign = link.getSign();
            ExternalInventoryItem.BuilderArgs ba = new ExternalInventoryItem.BuilderArgs(genomeKey, linkID, true);
            ExternalInventoryItem.ArgsForExternalLink afel = new ExternalInventoryItem.ArgsForExternalLink(ba);
            ExternalInventoryLink els = new ExternalInventoryLink(ba, afel, sign);
            links.add(els);
        }
    }
}

