/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.embedded;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.embedded.EmbeddedBioTapestryViewer;
import org.systemsbiology.biotapestry.embedded.EmbeddedException;
import org.systemsbiology.biotapestry.embedded.EmbeddedViewerInventory;
import org.systemsbiology.biotapestry.embedded.ExternalSelectionChangeEvent;
import org.systemsbiology.biotapestry.embedded.ExternalSelectionChangeListener;
import org.systemsbiology.biotapestry.event.EventManager;
import org.systemsbiology.biotapestry.event.SelectionChangeEvent;
import org.systemsbiology.biotapestry.event.SelectionChangeListener;
import org.systemsbiology.biotapestry.gaggle.DeadGoose;
import org.systemsbiology.biotapestry.gaggle.GooseManager;
import org.systemsbiology.biotapestry.plugin.PlugInManager;
import org.systemsbiology.biotapestry.ui.SUPanel;
import org.systemsbiology.biotapestry.ui.dialogs.utils.UsageSelector;
import org.systemsbiology.biotapestry.util.ExceptionHandler;

public class EmbeddedViewerPanel
extends JPanel
implements EmbeddedBioTapestryViewer,
SelectionChangeListener {
    private CommonView cview_;
    private ArrayList selectionListeners_ = new ArrayList();
    private boolean amListening_ = false;
    private UsageSelector usageSel_;
    private static EmbeddedViewerPanel singleton_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBtp(InputStream is) throws EmbeddedException {
        EmbeddedViewerPanel embeddedViewerPanel = this;
        synchronized (embeddedViewerPanel) {
            try {
                Database db = Database.getDB();
                db.newModel();
                MainCommands mcmd = MainCommands.getCmds();
                MainCommands.OneShot loader = mcmd.getOneShot(5);
                Object[] osArgs = new Object[]{new Boolean(false), is};
                boolean ok = loader.performOperation(osArgs);
                if (!ok) {
                    throw new EmbeddedException("Embedded BioTapestry Input Exception");
                }
            }
            catch (ExceptionHandler.HeadlessException hex) {
                throw new EmbeddedException("Embedded BioTapestry Wrapped Exception", hex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangeListener(ExternalSelectionChangeListener escl) {
        EmbeddedViewerPanel embeddedViewerPanel = this;
        synchronized (embeddedViewerPanel) {
            this.selectionListeners_.add(escl);
            if (!this.amListening_) {
                EventManager em = EventManager.getManager();
                em.addSelectionChangeListener(this);
                this.amListening_ = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmbeddedViewerInventory getElementInventory() {
        EmbeddedViewerPanel embeddedViewerPanel = this;
        synchronized (embeddedViewerPanel) {
            return new EmbeddedViewerInventory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean goToModelAndSelect(String modelID, Set nodeIDs, Set linkIDs) {
        EmbeddedViewerPanel embeddedViewerPanel = this;
        synchronized (embeddedViewerPanel) {
            return this.usageSel_.goToModelAndSelect(modelID, nodeIDs, linkIDs);
        }
    }

    public void callForShutdown() {
    }

    public void selectionHasChanged(SelectionChangeEvent scev) {
        block3: {
            SUPanel sup;
            int change;
            block2: {
                change = scev.getChangeType();
                sup = this.cview_.getSUPanel();
                if (change != 2) break block2;
                ExternalSelectionChangeEvent ce = new ExternalSelectionChangeEvent(scev.getGenomeKey(), new HashSet(), new HashSet());
                int numSl = this.selectionListeners_.size();
                for (int i = 0; i < numSl; ++i) {
                    ExternalSelectionChangeListener escl = (ExternalSelectionChangeListener)this.selectionListeners_.get(i);
                    escl.selectedModelHasChanged(ce);
                }
                break block3;
            }
            if (change != 3) break block3;
            ExternalSelectionChangeEvent ce = !sup.hasASelection() ? new ExternalSelectionChangeEvent(scev.getGenomeKey(), new HashSet(), new HashSet()) : sup.getExternalSelectionEvent();
            int numSl = this.selectionListeners_.size();
            for (int i = 0; i < numSl; ++i) {
                ExternalSelectionChangeListener escl = (ExternalSelectionChangeListener)this.selectionListeners_.get(i);
                escl.selectionHasChanged(ce);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmbeddedViewerPanel initPanel(Map args, JFrame topWindow) {
        Class clazz = EmbeddedViewerPanel.class;
        synchronized (clazz) {
            if (singleton_ != null) {
                throw new IllegalStateException();
            }
            singleton_ = new EmbeddedViewerPanel(args, topWindow);
            return singleton_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmbeddedViewerPanel getPanel() {
        Class clazz = EmbeddedViewerPanel.class;
        synchronized (clazz) {
            if (singleton_ == null) {
                throw new IllegalStateException();
            }
            return singleton_;
        }
    }

    private EmbeddedViewerPanel(Map args, JFrame topWindow) {
        this.cview_ = new CommonView();
        URL aurl = this.getClass().getResource("/org/systemsbiology/biotapestry/data/about.html");
        this.cview_.buildViewOnlyView(topWindow, this, aurl, false);
        this.cview_.embeddedPanelInit();
        boolean ok = PlugInManager.getMgr().loadDataDisplayPlugIns(args);
        if (!ok) {
            System.err.println("Problems loading plugins");
        }
        ExceptionHandler.getHandler().initialize(topWindow);
        GooseManager.getManager().setGoose(new DeadGoose());
        SUPanel sup = this.cview_.getSUPanel();
        this.usageSel_ = new UsageSelector(topWindow, sup.getPresentation());
    }
}

