/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.embedded;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.systemsbiology.biotapestry.embedded.EmbeddedBioTapestryViewer;
import org.systemsbiology.biotapestry.embedded.EmbeddedException;
import org.systemsbiology.biotapestry.embedded.EmbeddedViewerInventory;
import org.systemsbiology.biotapestry.embedded.EmbeddedViewerPanel;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryLink;
import org.systemsbiology.biotapestry.embedded.ExternalInventoryNode;
import org.systemsbiology.biotapestry.embedded.ExternalModelInfo;
import org.systemsbiology.biotapestry.embedded.ExternalSelectionChangeEvent;
import org.systemsbiology.biotapestry.embedded.ExternalSelectionChangeListener;
import org.systemsbiology.biotapestry.util.ExceptionHandler;
import org.systemsbiology.biotapestry.util.FixedJButton;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;
import org.systemsbiology.biotapestry.util.UiUtil;

public class EmbeddedViewerPanelTestWrapper
extends JFrame
implements ExternalSelectionChangeListener {
    private EmbeddedBioTapestryViewer evp_;
    private EmbeddedViewerInventory evi_;
    private JComboBox modelSelector_;
    private JList nodeSelectionList_;
    private JList linkSelectionList_;
    private JLabel selectedLabel_;
    private String currModelID_;
    private Stack skipIt_;

    public static void main(String[] argv) {
        EmbeddedViewerPanelTestWrapper cc = new EmbeddedViewerPanelTestWrapper();
        cc.setVisible(true);
    }

    public EmbeddedViewerPanelTestWrapper() {
        super("Embedded BioTapestry Viewer Example");
        this.setSize(1000, 1000);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel pTop = new JPanel();
        pTop.setLayout(new GridBagLayout());
        this.skipIt_ = new Stack();
        this.skipIt_.push(new Boolean(false));
        FixedJButton button1 = new FixedJButton("Load BioTapestry File");
        button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    EmbeddedViewerPanelTestWrapper.this.loadAFile();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 0, 0, 2, 1, 0, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        pTop.add((Component)button1, gbc);
        this.modelSelector_ = new JComboBox();
        this.modelSelector_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (((Boolean)EmbeddedViewerPanelTestWrapper.this.skipIt_.peek()).booleanValue()) {
                        return;
                    }
                    EmbeddedViewerPanelTestWrapper.this.selectAModel();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 0, 1, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        pTop.add((Component)this.modelSelector_, gbc);
        this.selectedLabel_ = new JLabel("");
        UiUtil.gbcSet(gbc, 0, 2, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
        pTop.add((Component)this.selectedLabel_, gbc);
        this.nodeSelectionList_ = new JList(new DefaultListModel());
        this.nodeSelectionList_.setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane(this.nodeSelectionList_);
        this.nodeSelectionList_.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                try {
                    if (ev.getValueIsAdjusting()) {
                        return;
                    }
                    if (((Boolean)EmbeddedViewerPanelTestWrapper.this.skipIt_.peek()).booleanValue()) {
                        return;
                    }
                    EmbeddedViewerPanelTestWrapper.this.selectNodesAndLinks();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 0, 3, 1, 4, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        pTop.add((Component)scrollPane, gbc);
        this.linkSelectionList_ = new JList(new DefaultListModel());
        this.linkSelectionList_.setSelectionMode(2);
        scrollPane = new JScrollPane(this.linkSelectionList_);
        this.linkSelectionList_.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                try {
                    if (ev.getValueIsAdjusting()) {
                        return;
                    }
                    if (((Boolean)EmbeddedViewerPanelTestWrapper.this.skipIt_.peek()).booleanValue()) {
                        return;
                    }
                    EmbeddedViewerPanelTestWrapper.this.selectNodesAndLinks();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 1, 3, 1, 4, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        pTop.add((Component)scrollPane, gbc);
        UiUtil.gbcSet(gbc, 0, 0, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)pTop, gbc);
        EmbeddedViewerPanel evp = EmbeddedViewerPanel.initPanel(new HashMap(), this);
        evp.setBorder(BorderFactory.createTitledBorder("BioTapestry Network View"));
        UiUtil.gbcSet(gbc, 0, 1, 1, 1, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)evp, gbc);
        this.evp_ = evp;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WrapperListener());
        this.evp_.addSelectionChangeListener(this);
    }

    public void selectionHasChanged(ExternalSelectionChangeEvent escev) {
        this.changeNodeSelections(escev.getNodeSelections());
        this.changeLinkSelections(escev.getLinkSelections());
    }

    public void selectedModelHasChanged(ExternalSelectionChangeEvent escev) {
        String modelID = escev.getSelectedModel();
        ComboBoxModel cbm = this.modelSelector_.getModel();
        int num = cbm.getSize();
        for (int i = 0; i < num; ++i) {
            ObjChoiceContent selected = (ObjChoiceContent)cbm.getElementAt(i);
            if (!selected.val.equals(modelID)) continue;
            this.skipIt_.push(new Boolean(true));
            this.modelSelector_.setSelectedItem(selected);
            this.skipIt_.pop();
            this.currModelID_ = selected.val;
            this.loadSelectionsForModel();
            break;
        }
    }

    void selectAModel() {
        ObjChoiceContent selected = (ObjChoiceContent)this.modelSelector_.getSelectedItem();
        this.currModelID_ = selected.val;
        this.loadSelectionsForModel();
        HashSet nodeIDs = new HashSet();
        HashSet linkIDs = new HashSet();
        this.evp_.goToModelAndSelect(this.currModelID_, nodeIDs, linkIDs);
    }

    void loadAFile() throws IOException {
        File file = null;
        while (file == null) {
            JFileChooser chooser = new JFileChooser();
            int option = chooser.showOpenDialog(this);
            if (option != 0) {
                return;
            }
            file = chooser.getSelectedFile();
            if (file == null) continue;
            try {
                this.evp_.loadBtp(new FileInputStream(file));
            }
            catch (EmbeddedException ge) {
                throw new IOException();
            }
            catch (IOException ioex) {
                throw new IOException();
            }
            this.evi_ = this.evp_.getElementInventory();
            this.skipIt_.push(new Boolean(true));
            this.currModelID_ = null;
            Vector<ObjChoiceContent> modelGuys = new Vector<ObjChoiceContent>();
            Iterator omidit = this.evi_.getOrderedModelIDs();
            while (omidit.hasNext()) {
                String omid = (String)omidit.next();
                ExternalModelInfo exmi = this.evi_.getModelInfo(omid);
                String[] path = exmi.getModelNameChain();
                modelGuys.add(new ObjChoiceContent(this.pathToString(path), omid));
                if (this.currModelID_ != null) continue;
                this.currModelID_ = omid;
            }
            UiUtil.replaceComboItems(this.modelSelector_, modelGuys);
            this.skipIt_.pop();
            this.loadSelectionsForModel();
            this.clearEmbeddedSelections();
            return;
        }
    }

    void selectNodesAndLinks() {
        this.skipIt_.push(new Boolean(true));
        DefaultListModel dlm = (DefaultListModel)this.nodeSelectionList_.getModel();
        HashSet<String> nodeIDs = new HashSet<String>();
        int[] indices = this.nodeSelectionList_.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            ObjChoiceContent occ = (ObjChoiceContent)dlm.getElementAt(indices[i]);
            nodeIDs.add(occ.val);
        }
        dlm = (DefaultListModel)this.linkSelectionList_.getModel();
        HashSet<String> linkIDs = new HashSet<String>();
        indices = this.linkSelectionList_.getSelectedIndices();
        for (int i = 0; i < indices.length; ++i) {
            ObjChoiceContent occ = (ObjChoiceContent)dlm.getElementAt(indices[i]);
            linkIDs.add(occ.val);
        }
        boolean success = this.evp_.goToModelAndSelect(this.currModelID_, nodeIDs, linkIDs);
        if (!success) {
            this.evp_.goToModelAndSelect(this.currModelID_, new HashSet(), new HashSet());
        }
        this.skipIt_.pop();
    }

    private void loadSelectionsForModel() {
        this.skipIt_.push(new Boolean(true));
        DefaultListModel dlm = (DefaultListModel)this.nodeSelectionList_.getModel();
        List nodes = this.evi_.getNodes(this.currModelID_);
        int numNodes = nodes.size();
        TreeSet<ObjChoiceContent> sorted = new TreeSet<ObjChoiceContent>();
        for (int i = 0; i < numNodes; ++i) {
            ExternalInventoryNode ens = (ExternalInventoryNode)nodes.get(i);
            sorted.add(new ObjChoiceContent(ens.toString(), ens.getInternalID()));
        }
        dlm.clear();
        Iterator sit = sorted.iterator();
        while (sit.hasNext()) {
            dlm.addElement(sit.next());
        }
        dlm = (DefaultListModel)this.linkSelectionList_.getModel();
        List links = this.evi_.getLinks(this.currModelID_);
        int numLinks = links.size();
        sorted = new TreeSet();
        for (int i = 0; i < numLinks; ++i) {
            ExternalInventoryLink ens = (ExternalInventoryLink)links.get(i);
            sorted.add(new ObjChoiceContent(ens.toString(), ens.getInternalID()));
        }
        dlm.clear();
        sit = sorted.iterator();
        while (sit.hasNext()) {
            dlm.addElement(sit.next());
        }
        this.skipIt_.pop();
        ExternalModelInfo emi = this.evi_.getModelInfo(this.currModelID_);
        boolean selSup = emi.supportsSelections();
        this.linkSelectionList_.setEnabled(selSup);
        this.nodeSelectionList_.setEnabled(selSup);
        this.selectedLabel_.setText(selSup ? "" : "Selections not supported for dynamic submodels");
        this.selectedLabel_.invalidate();
        this.validate();
    }

    private void clearEmbeddedSelections() {
        this.skipIt_.push(new Boolean(true));
        if (this.currModelID_ != null) {
            HashSet nodeIDs = new HashSet();
            HashSet linkIDs = new HashSet();
            this.evp_.goToModelAndSelect(this.currModelID_, nodeIDs, linkIDs);
        }
        this.skipIt_.pop();
    }

    private String pathToString(String[] path) {
        StringBuffer buf = new StringBuffer();
        int skipit = path.length - 1;
        for (int i = 0; i < path.length; ++i) {
            String mName = path[i];
            buf.append(mName);
            if (i >= skipit) continue;
            buf.append("::");
        }
        return buf.toString();
    }

    private void changeNodeSelections(Set nodes) {
        this.skipIt_.push(new Boolean(true));
        DefaultListModel dlm = (DefaultListModel)this.nodeSelectionList_.getModel();
        int numSel = nodes.size();
        if (numSel == 0) {
            this.nodeSelectionList_.clearSelection();
        } else {
            HashSet ns = new HashSet(nodes);
            int[] indices = new int[numSel];
            int count = 0;
            int num = dlm.getSize();
            for (int i = 0; i < num; ++i) {
                ObjChoiceContent selected = (ObjChoiceContent)dlm.getElementAt(i);
                if (!ns.contains(selected.val)) continue;
                indices[count++] = i;
            }
            this.nodeSelectionList_.setSelectedIndices(indices);
            this.nodeSelectionList_.ensureIndexIsVisible(indices[0]);
        }
        this.skipIt_.pop();
    }

    private void changeLinkSelections(Set links) {
        this.skipIt_.push(new Boolean(true));
        DefaultListModel dlm = (DefaultListModel)this.linkSelectionList_.getModel();
        int numSel = links.size();
        if (numSel == 0) {
            this.linkSelectionList_.clearSelection();
        } else {
            HashSet ns = new HashSet(links);
            int[] indices = new int[numSel];
            int count = 0;
            int num = dlm.getSize();
            for (int i = 0; i < num; ++i) {
                ObjChoiceContent selected = (ObjChoiceContent)dlm.getElementAt(i);
                if (!ns.contains(selected.val)) continue;
                indices[count++] = i;
            }
            this.linkSelectionList_.setSelectedIndices(indices);
            this.linkSelectionList_.ensureIndexIsVisible(indices[0]);
        }
        this.skipIt_.pop();
    }

    private class WrapperListener
    extends WindowAdapter {
        private WrapperListener() {
        }

        public void windowClosing(WindowEvent e) {
            EmbeddedViewerPanelTestWrapper.this.evp_.callForShutdown();
            EmbeddedViewerPanelTestWrapper.this.dispose();
            System.exit(0);
        }
    }
}

