/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.embedded;

import java.util.List;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;

public abstract class ExternalInventoryItem {
    private BuilderArgs bArgs_;

    public ExternalInventoryItem(BuilderArgs bArgs) {
        this.bArgs_ = bArgs;
    }

    public String getInternalID() {
        return this.bArgs_.itemID;
    }

    public String getModelID() {
        return this.bArgs_.genomeKey;
    }

    public static class ArgsForExternalNode {
        public String[] modelNameChain;
        public String nodeDisplay;
        public String simpleNodeDisplay;
        public String regionName;
        public String nodeName;

        public ArgsForExternalNode(BuilderArgs args) {
            Genome genome = Database.getDB().getGenome(args.genomeKey);
            List names = genome.getNamesToRoot();
            this.modelNameChain = names.toArray(new String[names.size()]);
            this.regionName = null;
            if (genome instanceof GenomeInstance) {
                GenomeInstance gi = (GenomeInstance)genome;
                Group srcGroup = gi.getGroupForNode(args.itemID, 1);
                this.regionName = srcGroup.getInheritedDisplayName(gi);
            }
            Node node = genome.getNode(args.itemID);
            this.nodeDisplay = node.getDisplayString(genome, false);
            this.simpleNodeDisplay = node.getDisplayString(genome, true);
            this.nodeName = node.getName();
        }
    }

    public static class ArgsForExternalLink {
        public String[] modelNameChain;
        public String srcNodeName;
        public String trgNodeName;
        public String srcRegionName;
        public String trgRegionName;
        public String linkDisplay;
        public String simpleLinkDisplay;

        public ArgsForExternalLink(BuilderArgs args) {
            Genome genome = Database.getDB().getGenome(args.genomeKey);
            List names = genome.getNamesToRoot();
            this.modelNameChain = names.toArray(new String[names.size()]);
            Linkage link = genome.getLinkage(args.itemID);
            String srcID = link.getSource();
            String trgID = link.getTarget();
            Node srcNode = genome.getNode(srcID);
            Node trgNode = genome.getNode(trgID);
            this.srcNodeName = srcNode.getName();
            this.trgNodeName = trgNode.getName();
            this.srcRegionName = null;
            this.trgRegionName = null;
            if (genome instanceof GenomeInstance) {
                GenomeInstance gi = (GenomeInstance)genome;
                Group srcGroup = gi.getGroupForNode(srcID, 1);
                Group trgGroup = gi.getGroupForNode(trgID, 1);
                this.srcRegionName = srcGroup.getInheritedDisplayName(gi);
                this.trgRegionName = trgGroup.getInheritedDisplayName(gi);
            }
            this.linkDisplay = link.getDisplayString(genome, false);
            this.simpleLinkDisplay = link.getDisplayString(genome, true);
        }
    }

    public static class BuilderArgs {
        public String genomeKey;
        public String itemID;
        public boolean isALink;

        public BuilderArgs(String genomeKey, String itemID, boolean isALink) {
            this.genomeKey = genomeKey;
            this.itemID = itemID;
            this.isALink = isALink;
        }
    }
}

