/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.event;

import java.util.HashSet;
import java.util.Iterator;
import org.systemsbiology.biotapestry.event.GeneralChangeEvent;
import org.systemsbiology.biotapestry.event.GeneralChangeListener;
import org.systemsbiology.biotapestry.event.LayoutChangeEvent;
import org.systemsbiology.biotapestry.event.LayoutChangeListener;
import org.systemsbiology.biotapestry.event.ModelChangeEvent;
import org.systemsbiology.biotapestry.event.ModelChangeListener;
import org.systemsbiology.biotapestry.event.OverlayDisplayChangeEvent;
import org.systemsbiology.biotapestry.event.OverlayDisplayChangeListener;
import org.systemsbiology.biotapestry.event.SelectionChangeEvent;
import org.systemsbiology.biotapestry.event.SelectionChangeListener;

public class EventManager {
    private static EventManager singleton_;
    private HashSet layoutListeners_ = new HashSet();
    private HashSet modelListeners_ = new HashSet();
    private HashSet selectListeners_ = new HashSet();
    private HashSet generalListeners_ = new HashSet();
    private HashSet overlayListeners_ = new HashSet();

    public void addLayoutChangeListener(LayoutChangeListener lcl) {
        this.layoutListeners_.add(lcl);
    }

    public void removeLayoutChangeListener(LayoutChangeListener lcl) {
        this.layoutListeners_.remove(lcl);
    }

    public void sendLayoutChangeEvent(LayoutChangeEvent lcev) {
        Iterator lclit = this.layoutListeners_.iterator();
        while (lclit.hasNext()) {
            LayoutChangeListener lcl = (LayoutChangeListener)lclit.next();
            lcl.layoutHasChanged(lcev);
        }
    }

    public void addGeneralChangeListener(GeneralChangeListener gcl) {
        this.generalListeners_.add(gcl);
    }

    public void removeGeneralChangeListener(GeneralChangeListener gcl) {
        this.generalListeners_.remove(gcl);
    }

    public void sendGeneralChangeEvent(GeneralChangeEvent gcev) {
        Iterator gclit = this.generalListeners_.iterator();
        while (gclit.hasNext()) {
            GeneralChangeListener gcl = (GeneralChangeListener)gclit.next();
            gcl.generalChangeOccurred(gcev);
        }
    }

    public void addModelChangeListener(ModelChangeListener mcl) {
        this.modelListeners_.add(mcl);
    }

    public void removeModelChangeListener(ModelChangeListener mcl) {
        this.modelListeners_.remove(mcl);
    }

    public void sendModelChangeEvent(ModelChangeEvent mcev) {
        Iterator mclit = this.modelListeners_.iterator();
        while (mclit.hasNext()) {
            ModelChangeListener mcl = (ModelChangeListener)mclit.next();
            mcl.modelHasChanged(mcev);
        }
    }

    public void sendModelChangeEvent(ModelChangeEvent mcev, int remaining) {
        Iterator mclit = this.modelListeners_.iterator();
        while (mclit.hasNext()) {
            ModelChangeListener mcl = (ModelChangeListener)mclit.next();
            mcl.modelHasChanged(mcev, remaining);
        }
    }

    public void addSelectionChangeListener(SelectionChangeListener scl) {
        this.selectListeners_.add(scl);
    }

    public void removeSelectionChangeListener(SelectionChangeListener scl) {
        this.selectListeners_.remove(scl);
    }

    public void sendSelectionChangeEvent(SelectionChangeEvent scev) {
        Iterator sclit = this.selectListeners_.iterator();
        while (sclit.hasNext()) {
            SelectionChangeListener scl = (SelectionChangeListener)sclit.next();
            scl.selectionHasChanged(scev);
        }
    }

    public void addOverlayDisplayChangeListener(OverlayDisplayChangeListener odcl) {
        this.overlayListeners_.add(odcl);
    }

    public void removeOverlayDisplayChangeListener(OverlayDisplayChangeListener odcl) {
        this.overlayListeners_.remove(odcl);
    }

    public void sendOverlayDisplayChangeEvent(OverlayDisplayChangeEvent odcev) {
        Iterator odclit = this.overlayListeners_.iterator();
        while (odclit.hasNext()) {
            OverlayDisplayChangeListener odcl = (OverlayDisplayChangeListener)odclit.next();
            odcl.overlayDisplayChangeOccurred(odcev);
        }
    }

    public static synchronized EventManager getManager() {
        if (singleton_ == null) {
            singleton_ = new EventManager();
        }
        return singleton_;
    }

    private EventManager() {
    }
}

