/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.gaggle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.systemsbiology.biotapestry.analysis.SignedLink;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.gaggle.InboundGaggleOp;
import org.systemsbiology.biotapestry.gaggle.InboundNetworkOp;
import org.systemsbiology.biotapestry.gaggle.InboundSelectionOp;

public class SelectionSupport {
    private Set pendingSelections_;
    private List inboundNetwork_;
    private NetworkForSpecies outboundNetwork_;
    private String species_;
    private CommonView cview_;
    private ArrayList commands_;
    private ArrayList gooseList_;
    private boolean initGooseList_;

    public SelectionSupport(CommonView cview, String species) {
        this.cview_ = cview;
        this.species_ = species;
        this.commands_ = new ArrayList();
        this.gooseList_ = new ArrayList();
        this.pendingSelections_ = new HashSet();
        this.initGooseList_ = true;
    }

    public synchronized void setSpecies(String species) {
        this.species_ = species;
    }

    public synchronized String getSpecies() {
        return this.species_;
    }

    public synchronized List getPendingCommands() {
        ArrayList pending = this.commands_;
        this.commands_ = new ArrayList();
        return pending;
    }

    public synchronized void registerNewGooseList(List gooseList) {
        this.gooseList_.clear();
        this.gooseList_.addAll(gooseList);
        if (this.initGooseList_) {
            this.initGooseList_ = false;
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SelectionSupport.this.cview_.haveGaggleGooseChange();
                }
            });
        }
    }

    public synchronized List getGooseList() {
        return new ArrayList(this.gooseList_);
    }

    public synchronized void createNewNetwork(String species, List instruct) {
        InboundNetworkOp op = new InboundNetworkOp(species, instruct);
        this.commands_.add(op);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectionSupport.this.cview_.haveInboundGaggleCommands();
            }
        });
    }

    public synchronized void addUnsupportedCommand() {
        InboundGaggleOp op = new InboundGaggleOp(this.cview_);
        this.commands_.add(op);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectionSupport.this.cview_.haveInboundGaggleCommands();
            }
        });
    }

    public synchronized void addSelectionCommand(String species, String[] selections) {
        HashSet<String> newSelections = new HashSet<String>(Arrays.asList(selections));
        SelectionsForSpecies sfs = new SelectionsForSpecies(species, newSelections);
        InboundSelectionOp op = new InboundSelectionOp(this.cview_, sfs);
        this.commands_.add(op);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectionSupport.this.cview_.haveInboundGaggleCommands();
            }
        });
    }

    public synchronized void clearSelections() {
        SelectionsForSpecies sfs = new SelectionsForSpecies(this.species_, new HashSet());
        InboundSelectionOp op = new InboundSelectionOp(this.cview_, sfs);
        this.commands_.add(op);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SelectionSupport.this.cview_.haveInboundGaggleCommands();
            }
        });
    }

    public synchronized SelectionsForSpecies getSelections() {
        return new SelectionsForSpecies(this.species_, new HashSet(this.pendingSelections_));
    }

    public synchronized void setOutboundNetwork(NetworkForSpecies network) {
        NetworkForSpecies networkForSpecies = this.outboundNetwork_ = network == null ? null : (NetworkForSpecies)network.clone();
        if (this.outboundNetwork_ != null) {
            this.outboundNetwork_.setSpecies(this.species_);
        }
    }

    public synchronized NetworkForSpecies getOutboundNetwork() {
        return this.outboundNetwork_ == null ? null : (NetworkForSpecies)this.outboundNetwork_.clone();
    }

    public synchronized void setSelections(List selections) {
        this.pendingSelections_.clear();
        this.pendingSelections_.addAll(selections);
    }

    public synchronized int getSelectionCount() {
        return this.pendingSelections_.size();
    }

    public static class NetworkForSpecies
    implements Cloneable {
        private String species_;
        private Map nodeTypes_;
        private List links_;
        private List optLinks_;
        private boolean dupNames_;

        public NetworkForSpecies(boolean dupNames, String species, Map nodeTypes, List reqLinks, List optLinks) {
            this.species_ = species;
            this.nodeTypes_ = nodeTypes;
            this.links_ = reqLinks;
            this.optLinks_ = optLinks;
            this.dupNames_ = dupNames;
        }

        public NetworkForSpecies() {
            this(false, null, new HashMap(), new ArrayList(), new ArrayList());
        }

        public NetworkForSpecies(boolean dupNames, Map nodeTypes, List reqLinks, List optLinks) {
            this(dupNames, null, nodeTypes, reqLinks, optLinks);
        }

        public Object clone() {
            try {
                int i;
                NetworkForSpecies retval = (NetworkForSpecies)super.clone();
                retval.nodeTypes_ = new HashMap(this.nodeTypes_);
                retval.links_ = new ArrayList();
                int numLinks = this.links_.size();
                for (i = 0; i < numLinks; ++i) {
                    retval.links_.add(((SignedLink)this.links_.get(i)).clone());
                }
                numLinks = this.optLinks_.size();
                for (i = 0; i < numLinks; ++i) {
                    retval.optLinks_.add(((SignedLink)this.optLinks_.get(i)).clone());
                }
                return retval;
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }

        void setSpecies(String species) {
            this.species_ = species;
        }

        public String getSpecies() {
            return this.species_;
        }

        public boolean haveDupNames() {
            return this.dupNames_;
        }

        public boolean haveOptionalLinks() {
            return this.optLinks_ != null && !this.optLinks_.isEmpty();
        }

        public Map getNodes() {
            return this.nodeTypes_;
        }

        public List getLinks() {
            return this.links_;
        }

        public List getLinksWithOptionalLinks() {
            ArrayList retval = new ArrayList(this.links_);
            retval.addAll(this.optLinks_);
            return retval;
        }
    }

    public static class SelectionsForSpecies {
        public String species;
        public Set selections;

        SelectionsForSpecies(String species, Set selections) {
            this.species = species;
            this.selections = selections;
        }
    }
}

