/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.PrintWriter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;

public class AlgSbmlSupport {
    public void writeSBML(PrintWriter out, Indenter ind, Genome genome) {
        ind.indent();
        out.print("<model ");
        out.print("name=\"");
        out.print(CharacterEntityMapper.mapEntities(genome.getName(), false));
        out.println("\" >");
        ind.up().indent();
        out.println("<listOfCompartments>");
        ind.up().indent();
        out.println("<compartment name=\"A\" />");
        ind.down().indent();
        out.println("</listOfCompartments>");
        this.writeSpecies(out, ind, "A", genome);
        this.writeParameters(out, ind, genome);
        this.writeRules(out, ind, "A", genome);
        this.writeReactions(out, ind, "A", genome);
        ind.down().indent();
        out.println("</model>");
    }

    private void writeSpecies(PrintWriter out, Indenter ind, String cmpt, Genome genome) {
        Linkage lnk;
        ind.indent();
        out.println("<listOfSpecies>");
        HashSet<String> sourceOnly = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            lnk = (Linkage)lit.next();
            sourceOnly.add(lnk.getSource());
        }
        lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            lnk = (Linkage)lit.next();
            sourceOnly.remove(lnk.getTarget());
        }
        StringBuffer buf = new StringBuffer();
        TreeSet<String> sSet = new TreeSet<String>();
        TreeSet<String> bcSet = new TreeSet<String>();
        ind.up();
        lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk2 = (Linkage)lit.next();
            String source = lnk2.getSource();
            String id = lnk2.getSource();
            if (sourceOnly.contains(source)) {
                bcSet.add(this.buildPostSourceSpecie(id, cmpt, buf, false));
            } else {
                sSet.add(this.buildSourceSpecie(id, cmpt, buf, false));
                sSet.add(this.buildPostSourceSpecie(id, cmpt, buf, false));
            }
            sSet.add(this.buildTargetSpecie(lnk2, cmpt, buf, false));
        }
        Iterator bcit = bcSet.iterator();
        while (bcit.hasNext()) {
            String specie = (String)bcit.next();
            ind.indent();
            out.print("<specie name=\"");
            out.print(specie);
            out.print("\" compartment=\"");
            out.print(cmpt);
            out.print("\" initialAmount=\"0");
            out.println("\" boundaryCondition=\"true\" />");
        }
        Iterator ssit = sSet.iterator();
        while (ssit.hasNext()) {
            String specie = (String)ssit.next();
            ind.indent();
            out.print("<specie name=\"");
            out.print(specie);
            out.print("\" compartment=\"");
            out.print(cmpt);
            out.println("\" initialAmount=\"0\" />");
        }
        ind.down().indent();
        out.println("</listOfSpecies>");
    }

    private void writeParameters(PrintWriter out, Indenter ind, Genome genome) {
        ind.indent();
        out.println("<listOfParameters>");
        StringBuffer buf = new StringBuffer();
        TreeSet<String> pSet = new TreeSet<String>();
        ind.up();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            pSet.add(this.buildParam(lnk, "p", buf, false));
            pSet.add(this.buildParam(lnk, "f", buf, false));
        }
        Iterator psit = pSet.iterator();
        while (psit.hasNext()) {
            String param = (String)psit.next();
            ind.indent();
            out.print("<parameter name=\"");
            out.print(param);
            out.println("\" value=\"1\" />");
        }
        ind.down().indent();
        out.println("</listOfParameters>");
    }

    private void writeRules(PrintWriter out, Indenter ind, String cmpt, Genome genome) {
        ind.indent();
        out.println("<listOfRules>");
        StringBuffer buf = new StringBuffer();
        TreeSet<Formula> rSet = new TreeSet<Formula>(new FormulaComparator());
        ind.up();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            rSet.add(this.buildFormula(lnk, buf, cmpt, genome));
        }
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            Formula form = this.buildFormulaForNode(node, buf, cmpt, genome);
            if (form == null) continue;
            rSet.add(form);
        }
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            Formula form = this.buildFormulaForNode(gene, buf, cmpt, genome);
            if (form == null) continue;
            rSet.add(form);
        }
        Iterator rsit = rSet.iterator();
        while (rsit.hasNext()) {
            Formula formula = (Formula)rsit.next();
            ind.indent();
            out.print("<specieConcentrationRule specie=\"");
            out.print(formula.specie);
            out.println("\"");
            ind.up().indent();
            out.print("formula=\"");
            out.print(formula.formula);
            out.println("\" />");
            ind.down();
        }
        ind.down().indent();
        out.println("</listOfRules>");
    }

    private void writeReactions(PrintWriter out, Indenter ind, String cmpt, Genome genome) {
        Linkage lnk;
        ind.indent();
        out.println("<listOfReactions>");
        HashSet<String> sourceOnly = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            lnk = (Linkage)lit.next();
            sourceOnly.add(lnk.getSource());
        }
        lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            lnk = (Linkage)lit.next();
            sourceOnly.remove(lnk.getTarget());
        }
        StringBuffer buf = new StringBuffer();
        TreeSet<String> rSet = new TreeSet<String>();
        ind.up();
        Iterator nit = genome.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            String nodeID = node.getID();
            if (sourceOnly.contains(nodeID)) continue;
            rSet.add(nodeID);
        }
        Iterator git = genome.getGeneIterator();
        while (git.hasNext()) {
            Gene gene = (Gene)git.next();
            String geneID = gene.getID();
            if (sourceOnly.contains(geneID)) continue;
            rSet.add(geneID);
        }
        Iterator rsit = rSet.iterator();
        while (rsit.hasNext()) {
            String nodeID = (String)rsit.next();
            String postSrcSpecie = this.buildPostSourceSpecie(nodeID, cmpt, buf, false);
            String srcSpecie = this.buildSourceSpecie(nodeID, cmpt, buf, false);
            buf.setLength(0);
            String tauTerm = buf.append("Tau_bt").append(nodeID).toString();
            ind.indent();
            out.print("<reaction name=\"j_");
            out.print(postSrcSpecie);
            out.println("\" reversible=\"true\">");
            ind.up().indent();
            out.println("<listOfReactants>");
            ind.up().indent();
            out.print("<specieReference specie=\"");
            out.print(srcSpecie);
            out.println("\"/>");
            ind.down().indent();
            out.println("</listOfReactants>");
            ind.indent();
            out.println("<listOfProducts>");
            ind.up().indent();
            out.print("<specieReference specie=\"");
            out.print(postSrcSpecie);
            out.println("\"/>");
            ind.down().indent();
            out.println("</listOfProducts>");
            ind.indent();
            out.print("<kineticLaw formula=\"");
            out.print("(");
            out.print(srcSpecie);
            out.print(" - ");
            out.print(postSrcSpecie);
            out.print(")/");
            out.print(tauTerm);
            out.println("\">");
            ind.up().indent();
            out.println("<listOfParameters>");
            ind.up().indent();
            out.print("<parameter name=\"");
            out.print("tauTerm");
            out.println("\" value=\"1\" />");
            ind.down().indent();
            out.println("</listOfParameters>");
            ind.down().indent();
            out.println("</kineticLaw>");
            ind.down().indent();
            out.println("</reaction>");
        }
        ind.down().indent();
        out.println("</listOfReactions>");
    }

    private String buildTargetSpecie(Linkage lnk, String cmpt, StringBuffer buf, boolean append) {
        String src = lnk.getTarget();
        int landingPad = lnk.getLandingPad();
        if (!append) {
            buf.setLength(0);
        }
        buf.append("bt");
        buf.append(src);
        buf.append("_i");
        buf.append(landingPad);
        buf.append('_');
        buf.append(cmpt);
        return append ? null : buf.toString();
    }

    private String buildSourceSpecie(String id, String cmpt, StringBuffer buf, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        buf.append("bt");
        buf.append(id);
        buf.append("_input_");
        buf.append(cmpt);
        return append ? null : buf.toString();
    }

    private String buildPostSourceSpecie(String id, String cmpt, StringBuffer buf, boolean append) {
        if (!append) {
            buf.setLength(0);
        }
        buf.append("bt");
        buf.append(id);
        buf.append('_');
        buf.append(cmpt);
        return append ? null : buf.toString();
    }

    private String buildParam(Linkage lnk, String prefix, StringBuffer buf, boolean append) {
        String src = lnk.getSource();
        String trg = lnk.getTarget();
        int landingPad = lnk.getLandingPad();
        if (!append) {
            buf.setLength(0);
        }
        buf.append(prefix);
        buf.append('_');
        buf.append("bt");
        buf.append(src);
        buf.append('_');
        buf.append("bt");
        buf.append(trg);
        buf.append("_i");
        buf.append(landingPad);
        return append ? null : buf.toString();
    }

    private Formula buildFormula(Linkage lnk, StringBuffer buf, String cmpt, Genome genome) {
        String specie = this.buildTargetSpecie(lnk, cmpt, buf, false);
        buf.setLength(0);
        String trg = lnk.getTarget();
        Node node = genome.getNode(trg);
        boolean normalize = node.getNodeType() == 4;
        int sign = lnk.getSign();
        if (!normalize) {
            this.buildFormulaTerm(lnk, buf, cmpt, true);
        } else if (sign == -1) {
            buf.append("1 / (1 + ");
            this.buildFormulaTerm(lnk, buf, cmpt, true);
            buf.append(")");
        } else {
            this.buildFormulaTerm(lnk, buf, cmpt, true);
            buf.append(" / (1 + ");
            this.buildFormulaTerm(lnk, buf, cmpt, true);
            buf.append(")");
        }
        String formula = buf.toString();
        Formula form = new Formula(specie, formula);
        return form;
    }

    private Formula buildFormulaForNode(Node node, StringBuffer buf, String cmpt, Genome genome) {
        boolean doAnd;
        String id = node.getID();
        String specie = this.buildSourceSpecie(id, cmpt, buf, false);
        String formula = null;
        boolean bl = doAnd = node.getNodeType() == 4;
        if (doAnd) {
            buf.setLength(0);
            HashSet<Integer> seenPads = new HashSet<Integer>();
            boolean first = true;
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Integer padObj;
                Linkage lnk = (Linkage)lit.next();
                String targ = lnk.getTarget();
                if (!targ.equals(id) || seenPads.contains(padObj = new Integer(lnk.getLandingPad()))) continue;
                seenPads.add(padObj);
                if (!first) {
                    buf.append(" * ");
                } else {
                    first = false;
                }
                this.buildTargetSpecie(lnk, cmpt, buf, true);
            }
            formula = buf.toString();
        } else {
            Iterator lit = genome.getLinkageIterator();
            while (lit.hasNext()) {
                Linkage lnk = (Linkage)lit.next();
                String targ = lnk.getTarget();
                if (!targ.equals(id)) continue;
                formula = this.buildTargetSpecie(lnk, cmpt, buf, false);
                break;
            }
        }
        return formula == null ? null : new Formula(specie, formula);
    }

    private String buildFormulaTerm(Linkage lnk, StringBuffer buf, String cmpt, boolean append) {
        String src = lnk.getSource();
        String trg = lnk.getTarget();
        int landingPad = lnk.getLandingPad();
        if (!append) {
            buf.setLength(0);
        }
        this.buildParam(lnk, "f", buf, true);
        buf.append(" * ");
        this.buildPostSourceSpecie(src, cmpt, buf, true);
        buf.append('^');
        this.buildParam(lnk, "p", buf, true);
        return append ? null : buf.toString();
    }

    class FormulaComparator
    implements Comparator {
        FormulaComparator() {
        }

        public int compare(Object o1, Object o2) {
            Formula form1 = (Formula)o1;
            Formula form2 = (Formula)o2;
            int spcCompare = form1.specie.compareTo(form2.specie);
            if (spcCompare == 0) {
                return form1.formula.compareTo(form2.formula);
            }
            return spcCompare;
        }
    }

    class Formula {
        String specie;
        String formula;

        Formula(String specie, String formula) {
            this.specie = specie;
            this.formula = formula;
        }

        public int hashCode() {
            return this.specie.hashCode();
        }

        public boolean equals(Object other) {
            boolean matchS;
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Formula)) {
                return false;
            }
            Formula otherF = (Formula)other;
            boolean bl = this.specie == null ? otherF.specie == null : (matchS = this.specie.equals(otherF.specie));
            if (!matchS) {
                return false;
            }
            boolean matchF = this.formula == null ? otherF.formula == null : this.formula.equals(otherF.formula);
            return matchF;
        }
    }
}

