/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.ui.INodeRenderer;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.NameValuePairList;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UniqueLabeller;

public class CommonGenomeCode {
    private NetOverlayOwner noo_;
    private Map netOverlays_;
    private int ownerMode_;
    private HashMap notes_;
    private UniqueLabeller labels_;
    private Genome genome_;
    private HashMap nodes_;
    private HashMap genes_;
    private HashMap links_;

    public GenomeChange changeNodeURLs(String nodeID, List urls) {
        GenomeChange retval = new GenomeChange();
        Node theNode = this.genome_.getNode(nodeID);
        if (theNode.getNodeType() == 4) {
            retval.gOrig = (Gene)theNode.clone();
            retval.gNew = (Gene)retval.gOrig.clone();
            retval.gNew.setAllUrls(urls);
            this.genes_.put(nodeID, retval.gNew.clone());
        } else {
            retval.nOrig = (Node)theNode.clone();
            retval.nNew = (Node)retval.nOrig.clone();
            retval.nNew.setAllUrls(urls);
            this.nodes_.put(nodeID, retval.nNew.clone());
        }
        retval.genomeKey = this.genome_.getID();
        return retval;
    }

    public GenomeChange changeLinkageURLs(String linkID, List urls) {
        GenomeChange retval = new GenomeChange();
        Linkage theLink = this.genome_.getLinkage(linkID);
        retval.lOrig = (Linkage)theLink.clone();
        retval.lNew = (Linkage)retval.lOrig.clone();
        retval.lNew.setAllUrls(urls);
        this.links_.put(linkID, retval.lNew.clone());
        retval.genomeKey = this.genome_.getID();
        return retval;
    }

    public GenomeChange changeNodeDescription(String nodeID, String desc) {
        GenomeChange retval = new GenomeChange();
        Node theNode = this.genome_.getNode(nodeID);
        if (theNode.getNodeType() == 4) {
            retval.gOrig = (Gene)theNode.clone();
            retval.gNew = (Gene)retval.gOrig.clone();
            retval.gNew.setDescription(desc);
            this.genes_.put(nodeID, retval.gNew.clone());
        } else {
            retval.nOrig = (Node)theNode.clone();
            retval.nNew = (Node)retval.nOrig.clone();
            ((DBNode)retval.nNew).setDescription(desc);
            this.nodes_.put(nodeID, retval.nNew.clone());
        }
        retval.genomeKey = this.genome_.getID();
        return retval;
    }

    public GenomeChange changeLinkageDescription(String linkID, String desc) {
        GenomeChange retval = new GenomeChange();
        Linkage theLink = this.genome_.getLinkage(linkID);
        retval.lOrig = (Linkage)theLink.clone();
        retval.lNew = (Linkage)retval.lOrig.clone();
        retval.lNew.setDescription(desc);
        this.links_.put(linkID, retval.lNew.clone());
        retval.genomeKey = this.genome_.getID();
        return retval;
    }

    public PadCalculatorToo.PadResult getNodePadRequirements(Genome genome, Node whichNode) {
        int trueLaunchMax;
        String nodeID = whichNode.getID();
        int minLandPad = Integer.MAX_VALUE;
        int maxLandPad = Integer.MIN_VALUE;
        int minLaunchPad = Integer.MAX_VALUE;
        int maxLaunchPad = Integer.MIN_VALUE;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            String src;
            Linkage link = (Linkage)lit.next();
            String targ = link.getTarget();
            if (targ.equals(nodeID)) {
                int linkPad = link.getLandingPad();
                if (linkPad > maxLandPad) {
                    maxLandPad = linkPad;
                }
                if (linkPad < minLandPad) {
                    minLandPad = linkPad;
                }
            }
            if (!(src = link.getSource()).equals(nodeID)) continue;
            int linkPad = link.getLaunchPad();
            if (linkPad > maxLaunchPad) {
                maxLaunchPad = linkPad;
            }
            if (linkPad >= minLaunchPad) continue;
            minLaunchPad = linkPad;
        }
        Layout lo = Database.getDB().getLayout(new LayoutManager().getLayout(genome.getID()));
        INodeRenderer nodeRenderer = NodeProperties.chooseRenderer(whichNode.getNodeType(), lo.getLayoutType());
        int trueLandMax = minLandPad < 0 ? nodeRenderer.getFixedLandingPadMax() - minLandPad : maxLandPad;
        int n = trueLaunchMax = minLaunchPad < 0 ? nodeRenderer.getFixedLaunchPadMax() - minLaunchPad : maxLaunchPad;
        if (nodeRenderer.sharedPadNamespaces()) {
            int fullMax;
            trueLandMax = fullMax = trueLandMax > trueLaunchMax ? trueLandMax : trueLaunchMax;
            trueLaunchMax = fullMax;
        }
        PadCalculatorToo.PadResult retval = new PadCalculatorToo.PadResult(trueLaunchMax, trueLandMax);
        return retval;
    }

    public int getInboundLinkCount(Genome genome, String nodeID) {
        int count = 0;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String trgID = link.getTarget();
            if (!nodeID.equals(trgID)) continue;
            ++count;
        }
        return count;
    }

    public int getOutboundLinkCount(Genome genome, String nodeID) {
        int count = 0;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcID = link.getSource();
            if (!nodeID.equals(srcID)) continue;
            ++count;
        }
        return count;
    }

    public Set getOutboundLinks(Genome genome, String nodeID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            String srcID = link.getSource();
            if (!nodeID.equals(srcID)) continue;
            retval.add(link.getID());
        }
        return retval;
    }

    public Integer getSourcePad(Genome genome, String nodeID) {
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(nodeID)) continue;
            return new Integer(link.getLaunchPad());
        }
        return null;
    }

    public int getLinkCount(Genome genome, String srcNodeID, String trgNodeID) {
        int count = 0;
        Iterator lit = genome.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getSource().equals(srcNodeID) || !link.getTarget().equals(trgNodeID)) continue;
            ++count;
        }
        return count;
    }

    public GenomeChange[] resolvePadChanges(Genome genome, String nodeID, NodeProperties.PadLimits padLimits) {
        HashMap launchPads = new HashMap();
        HashMap landPads = new HashMap();
        new PadCalculatorToo().decidePadChanges(genome, nodeID, padLimits, launchPads, landPads);
        return this.installPadChanges(genome, launchPads, landPads);
    }

    public GenomeChange[] installPadChanges(Genome genome, Map launchPads, Map landPads) {
        ArrayList<GenomeChange> retList = new ArrayList<GenomeChange>();
        Iterator doit = launchPads.keySet().iterator();
        while (doit.hasNext()) {
            String key = (String)doit.next();
            Linkage link = genome.getLinkage(key);
            GenomeChange retval = new GenomeChange();
            retval.genomeKey = genome.getID();
            retval.lOrig = (Linkage)link.clone();
            link.setLaunchPad((Integer)launchPads.get(key));
            retval.lNew = (Linkage)link.clone();
            retList.add(retval);
        }
        Iterator diit = landPads.keySet().iterator();
        while (diit.hasNext()) {
            String key = (String)diit.next();
            Linkage link = genome.getLinkage(key);
            GenomeChange retval = new GenomeChange();
            retval.genomeKey = genome.getID();
            retval.lOrig = (Linkage)link.clone();
            link.setLandingPad((Integer)landPads.get(key));
            retval.lNew = (Linkage)link.clone();
            retList.add(retval);
        }
        return retList.toArray(new GenomeChange[retList.size()]);
    }

    public NetworkOverlayOwnerChange addNetworkOverlay(NetworkOverlay nmView) {
        String id = nmView.getID();
        if (this.netOverlays_.get(id) != null) {
            throw new IllegalArgumentException();
        }
        NetworkOverlayOwnerChange retval = new NetworkOverlayOwnerChange();
        this.netOverlays_.put(id, nmView);
        retval.nmvOrig = null;
        retval.nmvNew = (NetworkOverlay)nmView.clone();
        retval.ownerKey = this.noo_.getID();
        retval.ownerMode = this.ownerMode_;
        return retval;
    }

    public void addNetworkOverlayAndKey(NetworkOverlay nmView) throws IOException {
        String id = nmView.getID();
        if (this.netOverlays_.get(id) != null) {
            throw new IOException();
        }
        try {
            ((DBGenome)Database.getDB().getGenome()).addKey(id);
        }
        catch (IllegalStateException iaex) {
            throw new IOException();
        }
        this.netOverlays_.put(id, nmView);
    }

    public NetworkOverlayOwnerChange removeNetworkOverlay(String key) {
        NetworkOverlayOwnerChange retval = new NetworkOverlayOwnerChange();
        retval.nmvOrig = (NetworkOverlay)((NetworkOverlay)this.netOverlays_.get(key)).clone();
        this.netOverlays_.remove(key);
        retval.nmvNew = null;
        ((DBGenome)Database.getDB().getGenome()).removeKey(key);
        retval.ownerKey = this.noo_.getID();
        retval.ownerMode = this.ownerMode_;
        return retval;
    }

    public void overlayChangeUndo(NetworkOverlayOwnerChange undo) {
        if (undo.nmvOrig != null && undo.nmvNew != null) {
            throw new IllegalArgumentException();
        }
        if (undo.nmvOrig == null && undo.nmvNew != null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(undo.nmvNew.getID());
            this.netOverlays_.remove(undo.nmvNew.getID());
        } else if (undo.nmvOrig != null && undo.nmvNew == null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(undo.nmvOrig.getID());
            this.netOverlays_.put(undo.nmvOrig.getID(), undo.nmvOrig.clone());
        }
    }

    public void overlayChangeRedo(NetworkOverlayOwnerChange redo) {
        if (redo.nmvOrig != null && redo.nmvNew != null) {
            throw new IllegalArgumentException();
        }
        if (redo.nmvOrig == null && redo.nmvNew != null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(redo.nmvNew.getID());
            this.netOverlays_.put(redo.nmvNew.getID(), redo.nmvNew.clone());
        } else if (redo.nmvOrig != null && redo.nmvNew == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(redo.nmvOrig.getID());
            this.netOverlays_.remove(redo.nmvOrig.getID());
        }
    }

    public NetworkOverlay getNetworkOverlay(String key) {
        return (NetworkOverlay)this.netOverlays_.get(key);
    }

    public Iterator getNetworkOverlayIterator() {
        return this.netOverlays_.values().iterator();
    }

    public int getNetworkOverlayCount() {
        return this.netOverlays_.size();
    }

    public int getNetworkModuleCount() {
        int count = 0;
        Iterator nokit = this.netOverlays_.keySet().iterator();
        while (nokit.hasNext()) {
            String noKey = (String)nokit.next();
            NetworkOverlay novr = (NetworkOverlay)this.netOverlays_.get(noKey);
            Iterator nmit = novr.getModuleIterator();
            while (nmit.hasNext()) {
                NetModule nmod = (NetModule)nmit.next();
                ++count;
            }
        }
        return count;
    }

    public NetworkOverlayChange addNetworkModule(String overlayKey, NetModule module) {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IllegalArgumentException();
        }
        NetworkOverlayChange noc = netOv.addNetModule(module, this.noo_.getID(), this.ownerMode_);
        return noc;
    }

    public void addNetworkModuleAndKey(String overlayKey, NetModule module) throws IOException {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IOException();
        }
        try {
            ((DBGenome)Database.getDB().getGenome()).addKey(module.getID());
        }
        catch (IllegalStateException isex) {
            throw new IOException();
        }
        netOv.addNetModule(module, this.noo_.getID(), this.ownerMode_);
    }

    public NetworkOverlayChange[] removeNetworkModule(String overlayKey, String moduleKey) {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IllegalArgumentException();
        }
        ((DBGenome)Database.getDB().getGenome()).removeKey(moduleKey);
        NetworkOverlayChange[] noc = netOv.removeNetModule(moduleKey, this.noo_.getID(), this.ownerMode_);
        return noc;
    }

    public NetModuleChange addMemberToNetworkModule(String overlayKey, NetModule module, String nodeID) {
        NetModuleMember nmm = new NetModuleMember(nodeID);
        NetModuleChange nmc = module.addMember(nmm, this.noo_.getID(), this.ownerMode_, overlayKey);
        return nmc;
    }

    public NetModuleChange deleteMemberFromNetworkModule(String overlayKey, NetModule module, String nodeID) {
        NetModuleChange nmc = module.removeMember(nodeID, this.noo_.getID(), this.ownerMode_, overlayKey);
        return nmc;
    }

    public Map findMatchingNetworkModules(int searchMode, String key, NameValuePair nvPair) {
        HashMap retval = new HashMap();
        Iterator nokit = this.netOverlays_.keySet().iterator();
        while (nokit.hasNext()) {
            String noKey = (String)nokit.next();
            NetworkOverlay novr = (NetworkOverlay)this.netOverlays_.get(noKey);
            HashSet<String> retSet = null;
            Iterator nmit = novr.getModuleIterator();
            while (nmit.hasNext()) {
                NetModule nmod = (NetModule)nmit.next();
                if (searchMode == 1) {
                    NameValuePairList nvpl = nmod.getNVPairs();
                    Iterator nvit = nvpl.getIterator();
                    while (nvit.hasNext()) {
                        NameValuePair nvp = (NameValuePair)nvit.next();
                        String name = nvp.getName();
                        String value = nvp.getValue();
                        if (!DataUtil.keysEqual(name, nvPair.getName()) || !DataUtil.keysEqual(value, nvPair.getValue())) continue;
                        if (retSet == null) {
                            retSet = new HashSet();
                            retval.put(noKey, retSet);
                        }
                        retSet.add(nmod.getID());
                    }
                    continue;
                }
                Iterator ti = nmod.getTagIterator();
                while (ti.hasNext()) {
                    String tag = (String)ti.next();
                    if (!DataUtil.keysEqual(tag, key)) continue;
                    if (retSet == null) {
                        retSet = new HashSet<String>();
                        retval.put(noKey, retSet);
                    }
                    retSet.add(nmod.getID());
                }
            }
        }
        return retval;
    }

    public void addNetworkModuleLinkageAndKey(String overlayKey, NetModuleLinkage linkage) throws IOException {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IOException();
        }
        try {
            ((DBGenome)Database.getDB().getGenome()).addKey(linkage.getID());
        }
        catch (IllegalStateException isex) {
            throw new IOException();
        }
        netOv.addNetModuleLinkage(linkage, this.noo_.getID(), this.ownerMode_);
    }

    public NetworkOverlayChange addNetworkModuleLinkage(String overlayKey, NetModuleLinkage linkage) {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IllegalArgumentException();
        }
        NetworkOverlayChange noc = netOv.addNetModuleLinkage(linkage, this.noo_.getID(), this.ownerMode_);
        return noc;
    }

    public NetworkOverlayChange removeNetworkModuleLinkage(String overlayKey, String linkKey) {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IllegalArgumentException();
        }
        ((DBGenome)Database.getDB().getGenome()).removeKey(linkKey);
        NetworkOverlayChange noc = netOv.removeNetModuleLinkage(linkKey, this.noo_.getID(), this.ownerMode_);
        return noc;
    }

    public NetworkOverlayChange modifyNetModuleLinkage(String overlayKey, String linkKey, int newSign) {
        NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(overlayKey);
        if (netOv == null) {
            throw new IllegalArgumentException();
        }
        NetworkOverlayChange noc = netOv.modifyNetModuleLinkage(linkKey, this.noo_.getID(), this.ownerMode_, newSign);
        return noc;
    }

    public String getFirstViewPreference(TaggedSet modChoice, TaggedSet revChoice) {
        Iterator nokit = this.netOverlays_.keySet().iterator();
        while (nokit.hasNext()) {
            TaggedSet fvr;
            TaggedSet fvs;
            String noKey = (String)nokit.next();
            NetworkOverlay no = (NetworkOverlay)this.netOverlays_.get(noKey);
            boolean isFirst = no.getFirstViewState(fvs = new TaggedSet(), fvr = new TaggedSet());
            if (!isFirst) continue;
            modChoice.tag = fvs.tag;
            modChoice.set.clear();
            modChoice.set.addAll(fvs.set);
            revChoice.tag = fvr.tag;
            revChoice.set.clear();
            revChoice.set.addAll(fvr.set);
            return no.getID();
        }
        return null;
    }

    public void writeOverlaysToXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<netOverlays>");
        TreeSet sorted = new TreeSet(this.netOverlays_.keySet());
        Iterator kit = sorted.iterator();
        ind.up();
        while (kit.hasNext()) {
            String key = (String)kit.next();
            NetworkOverlay netOv = (NetworkOverlay)this.netOverlays_.get(key);
            netOv.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</netOverlays>");
    }

    public ImageChange[] setGenomeImageSupport(Genome genome, String newImgKey, String currImgKey) {
        int changeCount;
        ImageManager mgr = ImageManager.getMgr();
        ArrayList<ImageChange> allChanges = new ArrayList<ImageChange>();
        if (currImgKey != null) {
            ImageChange dropChange = mgr.dropImageUsage(currImgKey);
            dropChange.genomeKey = genome.getID();
            allChanges.add(dropChange);
        }
        if (newImgKey != null) {
            ImageChange regChange = mgr.registerImageUsage(newImgKey);
            regChange.genomeKey = genome.getID();
            allChanges.add(regChange);
        }
        if ((changeCount = allChanges.size()) == 0) {
            return null;
        }
        ImageChange[] retval = new ImageChange[changeCount];
        allChanges.toArray(retval);
        return retval;
    }

    public ImageChange dropGenomeImageSupport(Genome genome, String currImgKey) {
        ImageManager mgr = ImageManager.getMgr();
        if (currImgKey != null) {
            ImageChange dropChange = mgr.dropImageUsage(currImgKey);
            dropChange.genomeKey = genome.getID();
            return dropChange;
        }
        return null;
    }

    public String imageChangeUndoSupport(Genome genome, ImageChange undo) {
        ImageManager mgr = ImageManager.getMgr();
        mgr.changeUndo(undo);
        if (undo.countOnlyKey != null) {
            return undo.newCount > undo.oldCount ? null : undo.countOnlyKey;
        }
        if (undo.newKey != null) {
            return null;
        }
        if (undo.oldKey != null) {
            return undo.oldKey;
        }
        throw new IllegalStateException();
    }

    public String imageChangeRedoSupport(Genome genome, ImageChange redo) {
        ImageManager mgr = ImageManager.getMgr();
        mgr.changeRedo(redo);
        if (redo.countOnlyKey != null) {
            return redo.oldCount > redo.newCount ? null : redo.countOnlyKey;
        }
        if (redo.newKey != null) {
            return redo.newKey;
        }
        if (redo.oldKey != null) {
            return null;
        }
        throw new IllegalStateException();
    }

    public String getNextNoteKey() {
        return this.labels_.getNextLabel();
    }

    public void addNote(Note note) {
        String id = note.getID();
        this.notes_.put(id, note);
        if (!this.labels_.addExistingLabel(id)) {
            System.err.println("Don't like " + id);
            throw new IllegalArgumentException();
        }
    }

    public GenomeChange addNoteWithExistingLabel(Note note) {
        String id = note.getID();
        if (this.notes_.get(id) != null) {
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.notes_.put(id, note);
        retval.ntOrig = null;
        retval.ntNew = note;
        retval.genomeKey = this.genome_.getID();
        return retval;
    }

    public GenomeChange changeNote(Note note, String newLabel, String newText, boolean isInteractive) {
        Note newNote = new Note(note);
        newNote.setName(newLabel);
        newNote.setText(newText);
        newNote.setInteractive(isInteractive);
        this.notes_.put(newNote.getID(), newNote);
        GenomeChange retval = new GenomeChange();
        retval.ntOrig = note;
        retval.ntNew = newNote;
        retval.genomeKey = this.genome_.getID();
        return retval;
    }

    public GenomeChange removeNote(String key) {
        GenomeChange retval = new GenomeChange();
        retval.ntOrig = (Note)this.notes_.remove(key);
        retval.ntNew = null;
        retval.genomeKey = this.genome_.getID();
        this.labels_.removeLabel(key);
        return retval;
    }

    public Iterator getNoteIterator() {
        return this.notes_.values().iterator();
    }

    public Note getNote(String key) {
        return (Note)this.notes_.get(key);
    }

    protected void noteChangeUndo(GenomeChange undo) {
        if (undo.ntOrig != null && undo.ntNew != null) {
            String id = undo.ntOrig.getID();
            this.notes_.put(id, undo.ntOrig);
        } else if (undo.ntOrig == null) {
            this.notes_.remove(undo.ntNew.getID());
            this.labels_.removeLabel(undo.ntNew.getID());
        } else {
            String id = undo.ntOrig.getID();
            this.notes_.put(id, undo.ntOrig);
            if (!this.labels_.addExistingLabel(id)) {
                System.err.println("Don't like " + id);
                throw new IllegalArgumentException();
            }
        }
    }

    protected void noteChangeRedo(GenomeChange undo) {
        if (undo.ntOrig != null && undo.ntNew != null) {
            String id = undo.ntNew.getID();
            this.notes_.put(id, undo.ntNew);
        } else if (undo.ntOrig == null) {
            String id = undo.ntNew.getID();
            this.notes_.put(id, undo.ntNew);
            if (!this.labels_.addExistingLabel(id)) {
                System.err.println("Don't like " + id);
                throw new IllegalArgumentException();
            }
        } else {
            this.notes_.remove(undo.ntOrig.getID());
            this.labels_.removeLabel(undo.ntOrig.getID());
        }
    }

    CommonGenomeCode() {
    }

    CommonGenomeCode(Genome genome, HashMap nodes, HashMap genes, HashMap links) {
        this.genome_ = genome;
        this.nodes_ = nodes;
        this.genes_ = genes;
        this.links_ = links;
    }

    CommonGenomeCode(NetOverlayOwner noo, int ownerMode, Map netOverlays) {
        this.noo_ = noo;
        this.ownerMode_ = ownerMode;
        this.netOverlays_ = netOverlays;
    }

    CommonGenomeCode(Genome genome, HashMap notes, UniqueLabeller labels) {
        this.genome_ = genome;
        this.notes_ = notes;
        this.labels_ = labels;
    }
}

