/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.PrintWriter;
import java.util.List;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;

public class CommonGenomeItemCode {
    public static final String FT_TAG_ROOT = "FreeText";
    public static final String URLS_TAG_ROOT = "URLs";
    public static final String URL_TAG_ROOT = "URL";

    public void writeDescUrlToXML(PrintWriter out, Indenter ind, List urls, String desc, String tagPrefix) {
        String ftTag = tagPrefix + FT_TAG_ROOT;
        String urlsTag = tagPrefix + URLS_TAG_ROOT;
        String urlTag = tagPrefix + URL_TAG_ROOT;
        int numURL = urls.size();
        if (desc != null) {
            ind.up().indent();
            out.print("<");
            out.print(ftTag);
            out.print(">");
            out.print(CharacterEntityMapper.mapEntities(desc, false));
            out.print("</");
            out.print(ftTag);
            out.println(">");
            ind.down();
        }
        if (numURL > 0) {
            ind.up().indent();
            out.print("<");
            out.print(urlsTag);
            out.println(">");
            ind.up();
            for (int i = 0; i < numURL; ++i) {
                String url = (String)urls.get(i);
                ind.indent();
                out.print("<");
                out.print(urlTag);
                out.print(">");
                out.print(CharacterEntityMapper.mapEntities(url, false));
                out.print("</");
                out.print(urlTag);
                out.println(">");
            }
            ind.down().indent();
            out.print("</");
            out.print(urlsTag);
            out.println(">");
            ind.down();
        }
    }

    CommonGenomeItemCode() {
    }
}

