/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.DBGeneRegion;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class DBGene
extends DBNode
implements Gene {
    public static final int DEFAULT_PAD_COUNT = 7;
    public static final int MAX_PAD_COUNT = 30;
    private ArrayList regions_;
    private int evidenceLevel_;

    public DBGene(String name, String id) {
        super(4, name, id);
        this.regions_ = new ArrayList();
        this.evidenceLevel_ = 0;
    }

    public DBGene(String name, String id, String evidence, String size) throws IOException {
        super("gene", name, id, size);
        this.regions_ = new ArrayList();
        this.evidenceLevel_ = 0;
        if (evidence != null) {
            try {
                this.evidenceLevel_ = Integer.parseInt(evidence);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
    }

    public DBGene(DBNode node) {
        super(node);
        this.nodeType_ = 4;
        this.regions_ = new ArrayList();
        this.evidenceLevel_ = 0;
        if (this.padCount_ < 7) {
            this.padCount_ = 7;
        }
    }

    public DBGene(DBGene other) {
        super(other);
        this.regions_ = new ArrayList();
        Iterator rit = other.regions_.iterator();
        while (rit.hasNext()) {
            DBGeneRegion reg = (DBGeneRegion)rit.next();
            this.regions_.add(new DBGeneRegion(reg));
        }
        this.evidenceLevel_ = other.evidenceLevel_;
    }

    public Object clone() {
        DBGene retval = (DBGene)super.clone();
        retval.regions_ = new ArrayList();
        Iterator rit = this.regions_.iterator();
        while (rit.hasNext()) {
            DBGeneRegion reg = (DBGeneRegion)rit.next();
            retval.regions_.add(reg.clone());
        }
        return retval;
    }

    public String toString() {
        return "DBGene: name = " + this.name_ + " id = " + this.id_ + " regions = " + this.regions_ + " evidence = " + this.evidenceLevel_;
    }

    public String getDisplayString(Genome genome, boolean typePreface) {
        String retval;
        if (typePreface) {
            String format = ResourceManager.getManager().getString("ncreate.importFormat");
            String typeDisplay = DBGene.mapTypeToDisplay(this.nodeType_);
            retval = MessageFormat.format(format, typeDisplay, this.getName());
        } else {
            String format = ResourceManager.getManager().getString("ncreate.importFormatNoType");
            retval = MessageFormat.format(format, this.getName());
        }
        return retval;
    }

    public void addRegion(DBGeneRegion region) {
        this.regions_.add(region);
    }

    public void setRegions(List newRegions) {
        Iterator nrit = newRegions.iterator();
        this.regions_.clear();
        while (nrit.hasNext()) {
            DBGeneRegion region = (DBGeneRegion)nrit.next();
            this.regions_.add(new DBGeneRegion(region));
        }
    }

    public Iterator regionIterator() {
        return this.regions_.iterator();
    }

    public int getNumRegions() {
        return this.regions_.size();
    }

    public int getEvidenceLevel() {
        return this.evidenceLevel_;
    }

    public void setEvidenceLevel(int evidenceLevel) {
        this.evidenceLevel_ = evidenceLevel;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print("gene");
        out.print(" name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" id=\"");
        out.print(this.id_);
        if (this.evidenceLevel_ != 0) {
            out.print("\" evidence=\"");
            out.print(this.evidenceLevel_);
        }
        if (this.padCount_ != 7) {
            out.print("\" size=\"");
            out.print(this.padCount_);
        }
        int numURL = this.urls_.size();
        if (this.regions_.size() == 0 && this.logic_ == null && this.description_ == null && numURL == 0) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        if (this.regions_.size() != 0) {
            ind.up();
            Iterator regs = this.regions_.iterator();
            while (regs.hasNext()) {
                DBGeneRegion reg = (DBGeneRegion)regs.next();
                reg.writeXML(out, ind);
            }
            ind.down();
        }
        this.writeLogicDescUrlToXML(out, ind);
        ind.indent();
        out.print("</");
        out.print("gene");
        out.println(">");
    }

    public static DBGene buildFromXML(Genome genome, Attributes attrs) throws IOException {
        String name = null;
        String id = null;
        String evidence = null;
        String size = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("evidence")) {
                    evidence = val;
                    continue;
                }
                if (!key.equals("size")) continue;
                size = val;
            }
        }
        return new DBGene(name, id, evidence, size);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("gene");
        return retval;
    }

    public static Set evidenceLevels() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("none");
        retval.add("isolated");
        return retval;
    }

    public static Vector getEvidenceChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 2; ++i) {
            retval.add(DBGene.evidenceTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent evidenceTypeForCombo(int eviLev) {
        return new ChoiceContent(ResourceManager.getManager().getString("nprop." + DBGene.mapToEvidenceTag(eviLev)), eviLev);
    }

    public static String mapToEvidenceTag(int val) {
        switch (val) {
            case 0: {
                return "none";
            }
            case 1: {
                return "isolated";
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromEvidenceTag(String tag) {
        if (tag.equals("none")) {
            return 0;
        }
        if (tag.equals("isolated")) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    protected DBGene() {
    }
}

