/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class DBGeneRegion
implements Cloneable {
    private String name_;
    private int startPad_;
    private int endPad_;
    private int evidenceLevel_;

    public DBGeneRegion(String name, int startPad, int endPad, int evidenceLevel) {
        this.name_ = name;
        this.startPad_ = startPad;
        this.endPad_ = endPad;
        this.evidenceLevel_ = evidenceLevel;
    }

    public DBGeneRegion(String name, String startPad, String endPad, String evidence) throws IOException {
        this.name_ = name;
        this.startPad_ = 0;
        if (startPad != null) {
            try {
                this.startPad_ = Integer.parseInt(startPad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.endPad_ = 0;
        if (endPad != null) {
            try {
                this.endPad_ = Integer.parseInt(endPad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.evidenceLevel_ = 0;
        if (evidence != null) {
            try {
                this.evidenceLevel_ = Integer.parseInt(evidence);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
    }

    public DBGeneRegion(DBGeneRegion other) {
        this.name_ = other.name_;
        this.startPad_ = other.startPad_;
        this.endPad_ = other.endPad_;
        this.evidenceLevel_ = other.evidenceLevel_;
    }

    public Object clone() {
        try {
            DBGeneRegion retval = (DBGeneRegion)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DBGeneRegion)) {
            return false;
        }
        DBGeneRegion otherDbgr = (DBGeneRegion)other;
        if (otherDbgr.startPad_ != this.startPad_) {
            return false;
        }
        if (otherDbgr.endPad_ != this.endPad_) {
            return false;
        }
        if (otherDbgr.evidenceLevel_ != this.evidenceLevel_) {
            return false;
        }
        if (otherDbgr.name_ == null) {
            return this.name_ == null;
        }
        return otherDbgr.name_.equals(this.name_);
    }

    public String getName() {
        return this.name_;
    }

    public int getStartPad() {
        return this.startPad_;
    }

    public int getEndPad() {
        return this.endPad_;
    }

    public int getEvidenceLevel() {
        return this.evidenceLevel_;
    }

    public String toString() {
        return "DBGeneRegion: name = " + this.name_ + " startPad = " + this.startPad_ + " endPad = " + this.endPad_ + " evidence = " + this.evidenceLevel_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<region");
        out.print(" name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" startPad=\"");
        out.print(this.startPad_);
        out.print("\" endPad=\"");
        out.print(this.endPad_);
        if (this.evidenceLevel_ != 0) {
            out.print("\" evidence=\"");
            out.print(this.evidenceLevel_);
        }
        out.println("\" />");
    }

    public static DBGeneRegion buildFromXML(Genome genome, Attributes attrs) throws IOException {
        String name = null;
        String startPad = null;
        String endPad = null;
        String evidence = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("startPad")) {
                    startPad = val;
                    continue;
                }
                if (key.equals("endPad")) {
                    endPad = val;
                    continue;
                }
                if (!key.equals("evidence")) continue;
                evidence = val;
            }
        }
        return new DBGeneRegion(name, startPad, endPad, evidence);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("region");
        return retval;
    }

    protected DBGeneRegion() {
    }
}

