/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.genome.CommonGenomeCode;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.genome.SbmlSupport;
import org.systemsbiology.biotapestry.genome.SifSupport;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class DBGenome
implements Genome,
Cloneable {
    private String name_;
    private String id_;
    private String longName_;
    private String description_;
    private HashMap genes_;
    private HashMap nodes_;
    private HashMap links_;
    private Map netOverlays_;
    private HashMap notes_;
    private UniqueLabeller labels_;
    private int uniqueNameSuffix_;
    private String imgKey_;

    public DBGenome(String name, String id) {
        this.name_ = name;
        this.id_ = id;
        this.genes_ = new HashMap();
        this.nodes_ = new HashMap();
        this.links_ = new HashMap();
        this.netOverlays_ = new HashMap();
        this.labels_ = new UniqueLabeller();
        this.imgKey_ = null;
        this.notes_ = new HashMap();
        this.uniqueNameSuffix_ = 1;
    }

    public Object clone() {
        try {
            DBGenome retval = (DBGenome)super.clone();
            retval.genes_ = new HashMap();
            Iterator git = this.genes_.keySet().iterator();
            while (git.hasNext()) {
                String gID = (String)git.next();
                retval.genes_.put(gID, ((DBGene)this.genes_.get(gID)).clone());
            }
            retval.nodes_ = new HashMap();
            Iterator nit = this.nodes_.keySet().iterator();
            while (nit.hasNext()) {
                String nID = (String)nit.next();
                retval.nodes_.put(nID, ((DBNode)this.nodes_.get(nID)).clone());
            }
            retval.links_ = new HashMap();
            Iterator lit = this.links_.keySet().iterator();
            while (lit.hasNext()) {
                String lID = (String)lit.next();
                retval.links_.put(lID, ((DBLinkage)this.links_.get(lID)).clone());
            }
            retval.netOverlays_ = new HashMap();
            Iterator nmit = this.netOverlays_.keySet().iterator();
            while (nmit.hasNext()) {
                String nmID = (String)nmit.next();
                retval.netOverlays_.put(nmID, ((NetworkOverlay)this.netOverlays_.get(nmID)).clone());
            }
            retval.notes_ = new HashMap();
            Iterator noit = this.notes_.keySet().iterator();
            while (noit.hasNext()) {
                String noID = (String)noit.next();
                retval.notes_.put(noID, ((Note)this.notes_.get(noID)).clone());
            }
            retval.labels_ = (UniqueLabeller)this.labels_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public int getLinkCount(String srcNodeID, String trgNodeID) {
        return new CommonGenomeCode().getLinkCount(this, srcNodeID, trgNodeID);
    }

    public Genome getStrippedGenomeCopy() {
        DBGenome retval = new DBGenome(this.name_, this.id_);
        retval.notes_ = this.notes_;
        retval.longName_ = this.longName_;
        retval.description_ = this.description_;
        retval.labels_ = new UniqueLabeller(this.labels_);
        retval.uniqueNameSuffix_ = this.uniqueNameSuffix_;
        retval.imgKey_ = this.imgKey_;
        retval.netOverlays_ = new HashMap();
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            NetworkOverlay stripped = nextOver.getMemberStrippedOverlay();
            retval.netOverlays_.put(noID, stripped);
        }
        return retval;
    }

    public void recoverMappedModuleMembers(Genome oldGenome, Map oldNodeToNew) {
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            NetworkOverlay oldOver = oldGenome.getNetworkOverlay(noID);
            nextOver.recoverMappedMembersAndGroups(oldOver, oldNodeToNew, null);
        }
    }

    public boolean isEmpty() {
        return this.genes_.size() == 0 && this.nodes_.size() == 0 && this.links_.size() == 0 && this.notes_.size() == 0;
    }

    public String getName() {
        return this.name_;
    }

    public String getID() {
        return this.id_;
    }

    public void setID(String id) {
        this.id_ = id;
    }

    public String getLongName() {
        return this.longName_;
    }

    public String getDescription() {
        return this.description_;
    }

    public int getTargetCount(String nodeID) {
        Set targs = this.getNodeTargets(nodeID);
        return targs.size();
    }

    public int getSourceCount(String nodeID) {
        Set srcs = this.getNodeSources(nodeID);
        return srcs.size();
    }

    public Set getSources(String nodeID) {
        HashSet<String> srcs = new HashSet<String>();
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            Linkage link = (Linkage)lit.next();
            if (!link.getTarget().equals(nodeID)) continue;
            srcs.add(link.getSource());
        }
        return srcs;
    }

    public GenomeChange setProperties(String name, String longName, String desc) {
        GenomeChange retval = new GenomeChange();
        retval.genomeKey = this.getID();
        retval.descOld = this.description_;
        retval.longNameOld = this.longName_;
        retval.nameOld = this.name_;
        this.longName_ = longName;
        this.name_ = name;
        retval.descNew = this.description_ = desc;
        retval.longNameNew = this.longName_;
        retval.nameNew = this.name_;
        return retval;
    }

    public void appendLongName(String longName) {
        this.longName_ = this.longName_ == null ? longName : this.longName_.concat(longName);
        this.longName_ = CharacterEntityMapper.unmapEntities(this.longName_, false);
    }

    public void appendDescription(String description) {
        this.description_ = this.description_ == null ? description : this.description_.concat(description);
        this.description_ = CharacterEntityMapper.unmapEntities(this.description_, false);
    }

    public GenomeChange addGene(Gene gene) {
        String id = gene.getID();
        if (this.genes_.get(id) != null) {
            throw new IllegalArgumentException();
        }
        if (!this.labels_.addExistingLabel(id)) {
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.genes_.put(id, gene);
        retval.gOrig = null;
        retval.gNew = gene;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange replaceNode(Node node) {
        GenomeChange retval = new GenomeChange();
        retval.nOrig = (Node)((Node)this.nodes_.get(node.getID())).clone();
        retval.nNew = (Node)node.clone();
        this.nodes_.put(node.getID(), node);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange replaceGene(Gene gene) {
        GenomeChange retval = new GenomeChange();
        retval.gOrig = (Gene)((Gene)this.genes_.get(gene.getID())).clone();
        retval.gNew = (Gene)gene.clone();
        this.genes_.put(gene.getID(), gene);
        retval.genomeKey = this.getID();
        return retval;
    }

    public Integer getSourcePad(String nodeID) {
        return new CommonGenomeCode().getSourcePad(this, nodeID);
    }

    public GenomeChange changeNodeType(String nodeID, int type) {
        GenomeChange retval = new GenomeChange();
        retval.genomeKey = this.getID();
        Node existing = this.getNode(nodeID);
        int oldType = existing.getNodeType();
        int newPads = DBNode.mapPadCount(oldType, type, existing.getPadCount());
        if (type == 4) {
            if (oldType == 4) {
                retval.gOrig = new DBGene((DBGene)existing);
                retval.gNew = new DBGene((DBGene)existing);
                ((DBNode)((Object)retval.gNew)).setPadCount(newPads);
                this.genes_.put(nodeID, new DBGene((DBGene)retval.gNew));
            } else {
                retval.nOrig = new DBNode((DBNode)existing);
                retval.gNew = new DBGene((DBNode)existing);
                ((DBNode)((Object)retval.gNew)).setPadCount(newPads);
                this.nodes_.remove(nodeID);
                this.genes_.put(nodeID, new DBGene((DBGene)retval.gNew));
            }
        } else if (oldType == 4) {
            retval.gOrig = new DBGene((DBGene)existing);
            retval.nNew = new DBNode((DBNode)existing);
            retval.nNew.setNodeType(type);
            ((DBNode)retval.nNew).setPadCount(newPads);
            this.genes_.remove(nodeID);
            this.nodes_.put(nodeID, new DBNode((DBNode)retval.nNew));
        } else {
            retval.nOrig = new DBNode((DBNode)existing);
            retval.nNew = new DBNode((DBNode)existing);
            retval.nNew.setNodeType(type);
            ((DBNode)retval.nNew).setPadCount(newPads);
            this.nodes_.put(nodeID, new DBNode((DBNode)retval.nNew));
        }
        return retval;
    }

    public GenomeChange[] resolvePadChanges(String nodeID, NodeProperties.PadLimits padLimits) {
        return new CommonGenomeCode().resolvePadChanges(this, nodeID, padLimits);
    }

    public GenomeChange[] installPadChanges(Map launchPads, Map landingPads) {
        return new CommonGenomeCode().installPadChanges(this, launchPads, landingPads);
    }

    public GenomeChange changeNodeName(String nodeID, String name) {
        GenomeChange retval = new GenomeChange();
        retval.nOrig = (Node)((Node)this.nodes_.get(nodeID)).clone();
        retval.nNew = (Node)retval.nOrig.clone();
        retval.nNew.setName(name);
        this.nodes_.put(nodeID, retval.nNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeGeneName(String geneID, String name) {
        GenomeChange retval = new GenomeChange();
        retval.gOrig = (Gene)((Gene)this.genes_.get(geneID)).clone();
        retval.gNew = (Gene)retval.gOrig.clone();
        retval.gNew.setName(name);
        this.genes_.put(geneID, retval.gNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeGeneEvidence(String geneID, int evidence) {
        GenomeChange retval = new GenomeChange();
        retval.gOrig = (Gene)((Gene)this.genes_.get(geneID)).clone();
        retval.gNew = (Gene)retval.gOrig.clone();
        ((DBGene)retval.gNew).setEvidenceLevel(evidence);
        this.genes_.put(geneID, retval.gNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeGeneSize(String geneID, int pads) {
        GenomeChange retval = new GenomeChange();
        retval.gOrig = (Gene)((Gene)this.genes_.get(geneID)).clone();
        retval.gNew = (Gene)retval.gOrig.clone();
        ((DBGene)retval.gNew).setPadCount(pads);
        this.genes_.put(geneID, retval.gNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeNodeSize(String nodeID, int pads) {
        GenomeChange retval = new GenomeChange();
        retval.nOrig = (Node)((Node)this.nodes_.get(nodeID)).clone();
        retval.nNew = (Node)retval.nOrig.clone();
        int padInc = DBNode.getPadIncrement(retval.nOrig.getNodeType());
        if (padInc != 0) {
            int currVal;
            for (currVal = DBNode.getDefaultPadCount(retval.nOrig.getNodeType()); currVal < pads; currVal += padInc) {
            }
            pads = currVal;
        }
        ((DBNode)retval.nNew).setPadCount(pads);
        this.nodes_.put(nodeID, retval.nNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeNodeURLs(String nodeID, List urls) {
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeNodeURLs(nodeID, urls);
    }

    public GenomeChange changeLinkageURLs(String linkID, List urls) {
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeLinkageURLs(linkID, urls);
    }

    public GenomeChange changeNodeDescription(String nodeID, String desc) {
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeNodeDescription(nodeID, desc);
    }

    public GenomeChange changeLinkageDescription(String linkID, String desc) {
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeLinkageDescription(linkID, desc);
    }

    public GenomeChange changeGeneRegions(String geneID, List newRegions) {
        GenomeChange retval = new GenomeChange();
        retval.gOrig = (Gene)((Gene)this.genes_.get(geneID)).clone();
        retval.gNew = (Gene)retval.gOrig.clone();
        ((DBGene)retval.gNew).setRegions(newRegions);
        this.genes_.put(geneID, retval.gNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public Iterator getGeneIterator() {
        return this.genes_.values().iterator();
    }

    public Iterator getSortedGeneIterator() {
        TreeSet sorted = new TreeSet(new NodeComparator());
        sorted.addAll(this.genes_.values());
        return sorted.iterator();
    }

    public int getGeneCount() {
        return this.genes_.size();
    }

    public int getFullNodeCount() {
        return this.genes_.size() + this.nodes_.size();
    }

    public int getLinkageCount() {
        return this.links_.size();
    }

    public Gene getGene(String key) {
        return (Gene)this.genes_.get(key);
    }

    public boolean rootDisplayNameIsUnique(String nodeID) {
        String display;
        Node node = this.getGene(nodeID = GenomeItemInstance.getBaseID(nodeID));
        if (node == null) {
            node = this.getNode(nodeID);
        }
        if ((display = node.getName()) == null || display.trim().equals("")) {
            return false;
        }
        if (!this.uniqueCheck(this.getGeneIterator(), node, display)) {
            return false;
        }
        return this.uniqueCheck(this.getNodeIterator(), node, display);
    }

    public DBGene getGeneWithName(String geneName) {
        if (geneName == null || geneName.trim().equals("")) {
            return null;
        }
        Iterator git = this.getGeneIterator();
        while (git.hasNext()) {
            DBGene gene = (DBGene)git.next();
            String testName = gene.getName();
            if (testName == null || testName.trim().equals("")) {
                throw new IllegalStateException();
            }
            if (!DataUtil.keysEqual(testName, geneName)) continue;
            return gene;
        }
        return null;
    }

    public Set getNodesWithName(String nodeName) {
        HashSet<DBNode> retval = new HashSet<DBNode>();
        Iterator nit = this.getNodeIterator();
        while (nit.hasNext()) {
            DBNode node = (DBNode)nit.next();
            String testName = node.getName();
            if (testName == null) {
                if (nodeName != null) continue;
                retval.add(node);
                continue;
            }
            if (nodeName == null || !DataUtil.keysEqual(testName, nodeName)) continue;
            retval.add(node);
        }
        return retval;
    }

    public boolean nodeHasInputs(String nodeID) {
        Iterator lit = this.links_.values().iterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getTarget().equals(nodeID)) continue;
            return true;
        }
        return false;
    }

    public Set getNodeTargets(String nodeID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.links_.values().iterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getSource().equals(nodeID)) continue;
            retval.add(lnk.getTarget());
        }
        return retval;
    }

    public Set getNodeSources(String nodeID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.links_.values().iterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getTarget().equals(nodeID)) continue;
            retval.add(lnk.getSource());
        }
        return retval;
    }

    public String getNextNoteKey() {
        return new CommonGenomeCode(this, this.notes_, this.labels_).getNextNoteKey();
    }

    public void addNote(Note note) {
        new CommonGenomeCode(this, this.notes_, this.labels_).addNote(note);
    }

    public GenomeChange addNoteWithExistingLabel(Note note) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).addNoteWithExistingLabel(note);
    }

    public GenomeChange changeNote(Note note, String newLabel, String newText, boolean isInteractive) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).changeNote(note, newLabel, newText, isInteractive);
    }

    public GenomeChange removeNote(String key) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).removeNote(key);
    }

    public Iterator getNoteIterator() {
        return new CommonGenomeCode(this, this.notes_, this.labels_).getNoteIterator();
    }

    public Note getNote(String key) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).getNote(key);
    }

    protected void noteChangeUndo(GenomeChange undo) {
        new CommonGenomeCode(this, this.notes_, this.labels_).noteChangeUndo(undo);
    }

    protected void noteChangeRedo(GenomeChange undo) {
        new CommonGenomeCode(this, this.notes_, this.labels_).noteChangeRedo(undo);
    }

    public int getOutboundLinkCount(String nodeID) {
        return new CommonGenomeCode().getOutboundLinkCount(this, nodeID);
    }

    public Set getOutboundLinks(String nodeID) {
        return new CommonGenomeCode().getOutboundLinks(this, nodeID);
    }

    public int getInboundLinkCount(String nodeID) {
        return new CommonGenomeCode().getInboundLinkCount(this, nodeID);
    }

    public List getNodeTargetNames(String nodeID, boolean toUpper) {
        ArrayList<String> retval = new ArrayList<String>();
        Iterator lit = this.links_.values().iterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getSource().equals(nodeID)) continue;
            String targ = lnk.getTarget();
            Node node = this.getNode(targ);
            String name = node.getName();
            retval.add(toUpper ? name.toUpperCase() : name);
        }
        return retval;
    }

    private boolean uniqueCheck(Iterator nodes, Node node, String display) {
        display = display.toUpperCase().replaceAll(" ", "");
        while (nodes.hasNext()) {
            String testName;
            Node testNode = (Node)nodes.next();
            if (testNode == node || (testName = testNode.getName()) == null || testName.trim().equals("") || !testName.toUpperCase().replaceAll(" ", "").equals(display)) continue;
            return false;
        }
        return true;
    }

    public GenomeChange addNode(Node node) {
        String id = node.getID();
        if (this.nodes_.get(id) != null) {
            System.err.println("got an existing node");
            throw new IllegalArgumentException();
        }
        if (!this.labels_.addExistingLabel(id)) {
            System.err.println("got an existing label " + id);
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.nodes_.put(id, node);
        retval.nOrig = null;
        retval.nNew = node;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange addNodeWithExistingLabel(Node node) {
        String id = node.getID();
        if (this.nodes_.get(id) != null) {
            System.err.println("got an existing node");
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.nodes_.put(id, node);
        retval.nOrig = null;
        retval.nNew = node;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange addGeneWithExistingLabel(Gene gene) {
        String id = gene.getID();
        if (this.genes_.get(id) != null) {
            System.err.println("got an existing gene");
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.genes_.put(id, gene);
        retval.gOrig = null;
        retval.gNew = gene;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange addLinkWithExistingLabel(Linkage link) {
        String id = link.getID();
        if (this.links_.get(id) != null) {
            System.err.println("got an existing link");
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.links_.put(id, link);
        retval.lOrig = null;
        retval.lNew = new DBLinkage((DBLinkage)link);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageTarget(Linkage link, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setLandingPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageSource(Linkage link, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setLaunchPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageSourceNode(Linkage link, String srcID, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setSource(srcID);
        retval.lNew.setLaunchPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageTargetNode(Linkage link, String trgID, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setTarget(trgID);
        retval.lNew.setLandingPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange replaceLinkageProperties(String linkID, String name, int sign, int targetLevel) {
        GenomeChange retval = new GenomeChange();
        Linkage link = (Linkage)this.links_.get(linkID);
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setName(name == null || name.trim().equals("") ? null : name.trim());
        retval.lNew.setSign(sign);
        retval.lNew.setTargetLevel(targetLevel);
        this.links_.put(linkID, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public ImageChange[] setGenomeImage(String imgKey) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        ImageChange[] retval = cgc.setGenomeImageSupport(this, imgKey, this.imgKey_);
        this.imgKey_ = imgKey;
        return retval;
    }

    public ImageChange dropGenomeImage() {
        CommonGenomeCode cgc = new CommonGenomeCode();
        ImageChange retval = cgc.dropGenomeImageSupport(this, this.imgKey_);
        this.imgKey_ = null;
        return retval;
    }

    public String getGenomeImage() {
        return this.imgKey_;
    }

    public void imageChangeUndo(ImageChange undo) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        this.imgKey_ = cgc.imageChangeUndoSupport(this, undo);
    }

    public void imageChangeRedo(ImageChange redo) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        this.imgKey_ = cgc.imageChangeRedoSupport(this, redo);
    }

    public Iterator getNodeIterator() {
        return this.nodes_.values().iterator();
    }

    public Iterator getAllNodeIterator() {
        HashSet allSet = new HashSet(this.nodes_.values());
        allSet.addAll(this.genes_.values());
        return allSet.iterator();
    }

    public Node getNode(String key) {
        Node retval = (Node)this.nodes_.get(key);
        if (retval != null) {
            return retval;
        }
        return (Node)this.genes_.get(key);
    }

    public GenomeChange removeNode(String key) {
        GenomeChange retval = new GenomeChange();
        Node rem = (Node)this.nodes_.get(key);
        if (rem != null) {
            this.nodes_.remove(key);
            retval.nOrig = (Node)rem.clone();
            retval.nNew = null;
        } else {
            retval.gOrig = (Gene)((Gene)this.genes_.get(key)).clone();
            this.genes_.remove(key);
            retval.gNew = null;
        }
        retval.genomeKey = this.getID();
        this.labels_.removeLabel(key);
        return retval;
    }

    public GenomeChange addLinkage(Linkage link) {
        String id = link.getID();
        if (this.links_.get(id) != null) {
            throw new IllegalArgumentException();
        }
        if (!this.labels_.addExistingLabel(id)) {
            System.err.println("Don't like " + id);
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.links_.put(id, link);
        retval.lOrig = null;
        retval.lNew = link;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange removeLinkage(String key) {
        GenomeChange retval = new GenomeChange();
        retval.lOrig = (Linkage)this.links_.get(key);
        this.links_.remove(key);
        retval.lNew = null;
        this.labels_.removeLabel(key);
        retval.genomeKey = this.getID();
        return retval;
    }

    public NetworkOverlayOwnerChange addNetworkOverlay(NetworkOverlay nmView) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.addNetworkOverlay(nmView);
    }

    public void addNetworkOverlayAndKey(NetworkOverlay nmView) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        cgc.addNetworkOverlayAndKey(nmView);
    }

    public NetworkOverlayOwnerChange removeNetworkOverlay(String key) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.removeNetworkOverlay(key);
    }

    public NetworkOverlay getNetworkOverlay(String key) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.getNetworkOverlay(key);
    }

    public Iterator getNetworkOverlayIterator() {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.getNetworkOverlayIterator();
    }

    public int getNetworkOverlayCount() {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.getNetworkOverlayCount();
    }

    public int getNetworkModuleCount() {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.getNetworkModuleCount();
    }

    public NetworkOverlayChange addNetworkModule(String overlayKey, NetModule module) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.addNetworkModule(overlayKey, module);
    }

    public void addNetworkModuleAndKey(String overlayKey, NetModule module) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        cgc.addNetworkModuleAndKey(overlayKey, module);
    }

    public NetworkOverlayChange[] removeNetworkModule(String overlayKey, String moduleKey) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.removeNetworkModule(overlayKey, moduleKey);
    }

    public NetworkOverlayChange addNetworkModuleLinkage(String overlayKey, NetModuleLinkage linkage) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.addNetworkModuleLinkage(overlayKey, linkage);
    }

    public NetworkOverlayChange removeNetworkModuleLinkage(String overlayKey, String linkageKey) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.removeNetworkModuleLinkage(overlayKey, linkageKey);
    }

    public NetworkOverlayChange modifyNetModuleLinkage(String overlayKey, String linkKey, int newSign) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.modifyNetModuleLinkage(overlayKey, linkKey, newSign);
    }

    public void addNetworkModuleLinkageAndKey(String overlayKey, NetModuleLinkage linkage) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        cgc.addNetworkModuleLinkageAndKey(overlayKey, linkage);
    }

    public NetModuleChange addMemberToNetworkModule(String overlayKey, NetModule module, String nodeID) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.addMemberToNetworkModule(overlayKey, module, nodeID);
    }

    public NetModuleChange deleteMemberFromNetworkModule(String overlayKey, NetModule module, String nodeID) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.deleteMemberFromNetworkModule(overlayKey, module, nodeID);
    }

    public Map findMatchingNetworkModules(int searchMode, String key, NameValuePair nvPair) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.findMatchingNetworkModules(searchMode, key, nvPair);
    }

    public String getFirstViewPreference(TaggedSet modChoice, TaggedSet revChoice) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        return cgc.getFirstViewPreference(modChoice, revChoice);
    }

    public int overlayModeForOwner() {
        return 0;
    }

    public void overlayChangeUndo(NetworkOverlayOwnerChange undo) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        cgc.overlayChangeUndo(undo);
    }

    public void overlayChangeRedo(NetworkOverlayOwnerChange redo) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        cgc.overlayChangeRedo(redo);
    }

    public Iterator getLinkageIterator() {
        return this.links_.values().iterator();
    }

    public Linkage getLinkage(String key) {
        return (Linkage)this.links_.get(key);
    }

    public String getNextKey() {
        return this.labels_.getNextLabel();
    }

    public void removeKey(String key) {
        this.labels_.removeLabel(key);
    }

    public void addKey(String key) {
        if (!this.labels_.addExistingLabel(key)) {
            System.err.println("key is " + key);
            System.err.println("labels are " + this.labels_);
            throw new IllegalStateException();
        }
    }

    public boolean nameInUse(String name) {
        if (name == null) {
            return true;
        }
        if (name.trim().equals("")) {
            return true;
        }
        Iterator genes = this.getGeneIterator();
        while (genes.hasNext()) {
            DBGene g = (DBGene)genes.next();
            if (!g.getName().equals(name)) continue;
            return true;
        }
        Iterator nodes = this.getNodeIterator();
        while (nodes.hasNext()) {
            DBNode n = (DBNode)nodes.next();
            if (!n.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getUniqueGeneName() {
        String tryName;
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("gene.defaultNameFormat");
        do {
            Integer suffix = new Integer(this.uniqueNameSuffix_++);
            tryName = MessageFormat.format(format, suffix);
            if (!format.equals(tryName)) continue;
            throw new IllegalStateException();
        } while (this.nameInUse(tryName));
        return tryName;
    }

    public String getUniqueNodeName() {
        String tryName;
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("node.defaultNameFormat");
        do {
            Integer suffix = new Integer(this.uniqueNameSuffix_++);
            tryName = MessageFormat.format(format, suffix);
            if (!format.equals(tryName)) continue;
            throw new IllegalStateException();
        } while (this.nameInUse(tryName));
        return tryName;
    }

    public Set getGroupsForOverlayRendering() {
        return null;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<genome ");
        out.print("name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" id=\"");
        out.print(this.id_);
        if (this.imgKey_ != null) {
            out.print("\" image=\"");
            out.print(this.imgKey_);
        }
        out.println("\" >");
        ind.up().indent();
        if (this.longName_ != null) {
            out.print("<rootLongName>");
            out.print(CharacterEntityMapper.mapEntities(this.longName_, false));
            out.println("</rootLongName>");
        } else {
            out.println("<rootLongName />");
        }
        ind.indent();
        if (this.description_ != null) {
            out.print("<rootDescription>");
            out.print(CharacterEntityMapper.mapEntities(this.description_, false));
            out.println("</rootDescription>");
        } else {
            out.println("<rootDescription />");
        }
        ind.indent();
        out.println("<nodes>");
        this.writeNodes(out, ind);
        this.writeGenes(out, ind);
        ind.down().indent();
        out.println("</nodes>");
        this.writeLinks(out, ind);
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 0, this.netOverlays_);
        cgc.writeOverlaysToXML(out, ind);
        this.writeNotes(out, ind);
        ind.down().indent();
        out.println("</genome>");
    }

    public Set hasLinkTargetPadCollisions() {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit1 = this.getLinkageIterator();
        while (lit1.hasNext()) {
            Linkage link1 = (Linkage)lit1.next();
            String link1Targ = link1.getTarget();
            int link1Pad = link1.getLandingPad();
            Iterator lit2 = this.getLinkageIterator();
            while (lit2.hasNext()) {
                int link2Pad;
                String link2Targ;
                Linkage link2 = (Linkage)lit2.next();
                if (link1 == link2 || !link1Targ.equals(link2Targ = link2.getTarget()) || link1Pad != (link2Pad = link2.getLandingPad())) continue;
                retval.add(link1.getID());
                retval.add(link2.getID());
            }
        }
        return retval;
    }

    public PadCalculatorToo.PadResult getNodePadRequirements(Node whichNode) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        return cgc.getNodePadRequirements(this, whichNode);
    }

    public Set requiredGeneParameters(Gene gene) {
        SbmlSupport sbmls = new SbmlSupport();
        return sbmls.requiredGeneParameters(gene, this);
    }

    public Set requiredNonGeneParameters(Node node) {
        SbmlSupport sbmls = new SbmlSupport();
        return sbmls.requiredNonGeneParameters(node, this);
    }

    public boolean canWriteSBML() {
        Iterator nit = this.getNodeIterator();
        while (nit.hasNext()) {
            Node node = (Node)nit.next();
            int type = node.getNodeType();
            Iterator lit = this.getLinkageIterator();
            int inputCount = 0;
            while (lit.hasNext()) {
                Linkage link = (Linkage)lit.next();
                String linkTarget = link.getTarget();
                Node node2 = this.getNode(linkTarget);
                if (!node2.getID().equals(node.getID())) continue;
                ++inputCount;
            }
            if (inputCount <= 0 || ((DBNode)node).getInternalLogic().getFunctionType() != 2) continue;
            return false;
        }
        HashSet<LinkEnds> allLinkEnds = new HashSet<LinkEnds>();
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            int linkageType;
            Linkage link = (Linkage)lit.next();
            String trg = link.getTarget();
            Node node = this.getNode(trg);
            int targetNodeType = node.getNodeType();
            if (targetNodeType != 4 && (linkageType = link.getSign()) == 0) {
                return false;
            }
            LinkEnds le = new LinkEnds(link.getSource(), trg);
            if (allLinkEnds.contains(le)) {
                return false;
            }
            allLinkEnds.add(le);
        }
        return true;
    }

    public void writeSIF(PrintWriter out) {
        SifSupport ssup = new SifSupport(this);
        ssup.writeSIF(out);
    }

    public void writeSBML(PrintWriter out, Indenter ind) {
        SbmlSupport sbmls = new SbmlSupport();
        StringBuffer buf = new StringBuffer();
        Indenter bufIndent = new Indenter(buf, ind.getIndent());
        bufIndent.setCurrLevel(ind.getCurrLevel());
        sbmls.writeSBML(buf, bufIndent, this);
        ind.setCurrLevel(bufIndent.getCurrLevel());
        out.print(buf.toString());
    }

    public void writeSBML(StringBuffer buf, Indenter ind) {
        SbmlSupport sbmls = new SbmlSupport();
        sbmls.writeSBML(buf, ind, this);
    }

    public void changeUndo(GenomeChange undo) {
        if (undo.gOrig != null && undo.nNew != null || undo.nOrig != null && undo.gNew != null) {
            this.typeChangeUndo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeUndo(undo);
        } else if (undo.nOrig != null || undo.nNew != null) {
            this.nodeChangeUndo(undo);
        } else if (undo.lOrig != null || undo.lNew != null) {
            this.linkChangeUndo(undo);
        } else if (undo.ntOrig != null || undo.ntNew != null) {
            this.noteChangeUndo(undo);
        } else if (undo.descOld != null || undo.descNew != null || undo.nameOld != null || undo.nameNew != null || undo.longNameOld != null || undo.longNameNew != null) {
            this.propChangeUndo(undo);
        }
    }

    public void changeRedo(GenomeChange undo) {
        if (undo.gOrig != null && undo.nNew != null || undo.nOrig != null && undo.gNew != null) {
            this.typeChangeRedo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeRedo(undo);
        } else if (undo.nOrig != null || undo.nNew != null) {
            this.nodeChangeRedo(undo);
        } else if (undo.lOrig != null || undo.lNew != null) {
            this.linkChangeRedo(undo);
        } else if (undo.ntOrig != null || undo.ntNew != null) {
            this.noteChangeRedo(undo);
        } else if (undo.descOld != null || undo.descNew != null || undo.nameOld != null || undo.nameNew != null || undo.longNameOld != null || undo.longNameNew != null) {
            this.propChangeRedo(undo);
        }
    }

    public GenomeChange startNodeUndoTransaction(String nodeName) {
        GenomeChange retval = new GenomeChange();
        Node node = this.getNode(nodeName);
        if (node.getNodeType() == 4) {
            retval.gOrig = (Gene)((Gene)node).clone();
        } else {
            retval.nOrig = (Node)node.clone();
        }
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange finishNodeUndoTransaction(String nodeName, GenomeChange change) {
        Node node = this.getNode(nodeName);
        if (node.getNodeType() == 4) {
            change.gNew = (Gene)((Gene)node).clone();
        } else {
            change.nNew = (Node)node.clone();
        }
        return change;
    }

    private Set nameDups() {
        HashSet<String> seen = new HashSet<String>();
        HashSet<String> dups = new HashSet<String>();
        Iterator git = this.getAllNodeIterator();
        while (git.hasNext()) {
            Node node = (Node)git.next();
            String normName = DataUtil.normKey(node.getName());
            if (seen.contains(normName)) {
                dups.add(normName);
            }
            seen.add(normName);
        }
        return dups;
    }

    private String uniqueSuffix() {
        String retval;
        boolean noMatch;
        StringBuffer buf = new StringBuffer();
        buf.append("-{BIO_TAP_ID=");
        block0: do {
            retval = buf.toString();
            Iterator git = this.getAllNodeIterator();
            noMatch = true;
            while (git.hasNext()) {
                Node node = (Node)git.next();
                String normName = DataUtil.normKey(node.getName());
                if (normName.indexOf(retval) == -1) continue;
                buf.append("=");
                noMatch = false;
                continue block0;
            }
        } while (!noMatch);
        return retval;
    }

    public Map genUnique() {
        Set dups = this.nameDups();
        if (dups.isEmpty()) {
            return null;
        }
        String suffix = this.uniqueSuffix();
        HashMap<String, String> unique = new HashMap<String, String>();
        StringBuffer buf = new StringBuffer();
        Iterator git = this.getAllNodeIterator();
        while (git.hasNext()) {
            String genName;
            Node node = (Node)git.next();
            String normName = DataUtil.normKey(node.getName());
            if (!dups.contains(normName)) {
                genName = node.getName();
            } else {
                buf.setLength(0);
                buf.append(node.getName());
                buf.append(suffix);
                buf.append(node.getID());
                buf.append("}");
                genName = buf.toString();
            }
            unique.put(node.getID(), genName);
        }
        return unique;
    }

    public List getNamesToRoot() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add(this.name_);
        return retval;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("genome");
        return retval;
    }

    public static String descriptionKeyword() {
        return "rootDescription";
    }

    public static String longNameKeyword() {
        return "rootLongName";
    }

    public static DBGenome buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("genome")) {
            return null;
        }
        String name = null;
        String id = null;
        String imgKey = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (!key.equals("image")) continue;
                imgKey = val;
            }
        }
        if (name == null || id == null) {
            throw new IOException();
        }
        DBGenome retval = new DBGenome(name, id);
        if (imgKey != null) {
            retval.imgKey_ = imgKey;
        }
        return retval;
    }

    private void writeNotes(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<notes>");
        Iterator notes = this.getNoteIterator();
        ind.up();
        while (notes.hasNext()) {
            Note n = (Note)notes.next();
            n.writeXML(out, ind, false);
        }
        ind.down().indent();
        out.println("</notes>");
    }

    private void writeNodes(PrintWriter out, Indenter ind) {
        TreeSet sorted = new TreeSet(new NodeComparator());
        sorted.addAll(this.nodes_.values());
        Iterator nodes = sorted.iterator();
        ind.up();
        int currNodeType = -1;
        while (nodes.hasNext()) {
            DBNode n = (DBNode)nodes.next();
            int nodeType = n.getNodeType();
            if (nodeType != currNodeType) {
                if (currNodeType != -1) {
                    ind.down().indent();
                    out.println("</" + this.mapNodeType(currNodeType) + ">");
                }
                ind.indent();
                out.println("<" + this.mapNodeType(nodeType) + ">");
                currNodeType = nodeType;
                ind.up();
            }
            n.writeXML(out, ind);
        }
        if (currNodeType != -1) {
            ind.down().indent();
            out.println("</" + this.mapNodeType(currNodeType) + ">");
        }
    }

    private void writeGenes(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<genes>");
        TreeSet sorted = new TreeSet(new NodeComparator());
        sorted.addAll(this.genes_.values());
        Iterator genes = sorted.iterator();
        ind.up();
        while (genes.hasNext()) {
            DBGene g = (DBGene)genes.next();
            g.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</genes>");
    }

    private void writeLinks(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<links>");
        TreeSet sorted = new TreeSet(new LinkComparator());
        sorted.addAll(this.links_.values());
        Iterator links = sorted.iterator();
        ind.up();
        while (links.hasNext()) {
            DBLinkage lnk = (DBLinkage)links.next();
            lnk.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</links>");
    }

    private String mapNodeType(int nodeType) {
        switch (nodeType) {
            case 1: {
                return "bares";
            }
            case 2: {
                return "boxes";
            }
            case 3: {
                return "bubbles";
            }
            case 4: {
                return "genes";
            }
            case 5: {
                return "intercels";
            }
            case 6: {
                return "slashes";
            }
        }
        return null;
    }

    private void typeChangeUndo(GenomeChange undo) {
        if (undo.nOrig != null && undo.gNew != null) {
            this.nodes_.put(undo.nOrig.getID(), undo.nOrig);
            this.genes_.remove(undo.gNew.getID());
        } else if (undo.gOrig != null && undo.nNew != null) {
            this.genes_.put(undo.gOrig.getID(), undo.gOrig);
            this.nodes_.remove(undo.nNew.getID());
        }
    }

    private void typeChangeRedo(GenomeChange undo) {
        if (undo.nOrig != null && undo.gNew != null) {
            this.genes_.put(undo.gNew.getID(), undo.gNew);
            this.nodes_.remove(undo.nOrig.getID());
        } else if (undo.gOrig != null && undo.nNew != null) {
            this.nodes_.put(undo.nNew.getID(), undo.nNew);
            this.genes_.remove(undo.gOrig.getID());
        }
    }

    private void propChangeUndo(GenomeChange undo) {
        this.longName_ = undo.longNameOld;
        this.name_ = undo.nameOld;
        this.description_ = undo.descOld;
    }

    private void propChangeRedo(GenomeChange undo) {
        this.longName_ = undo.longNameNew;
        this.name_ = undo.nameNew;
        this.description_ = undo.descNew;
    }

    private void nodeChangeUndo(GenomeChange undo) {
        if (undo.nOrig != null && undo.nNew != null) {
            this.nodes_.put(undo.nOrig.getID(), undo.nOrig);
        } else if (undo.nOrig == null) {
            this.nodes_.remove(undo.nNew.getID());
            this.labels_.removeLabel(undo.nNew.getID());
        } else {
            this.nodes_.put(undo.nOrig.getID(), undo.nOrig);
            this.labels_.addExistingLabel(undo.nOrig.getID());
        }
    }

    private void nodeChangeRedo(GenomeChange undo) {
        if (undo.nOrig != null && undo.nNew != null) {
            this.nodes_.put(undo.nNew.getID(), undo.nNew);
        } else if (undo.nOrig == null) {
            this.nodes_.put(undo.nNew.getID(), undo.nNew);
            this.labels_.addExistingLabel(undo.nNew.getID());
        } else {
            this.nodes_.remove(undo.nOrig.getID());
            this.labels_.removeLabel(undo.nOrig.getID());
        }
    }

    private void geneChangeUndo(GenomeChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.put(undo.gOrig.getID(), undo.gOrig);
        } else if (undo.gOrig == null) {
            this.genes_.remove(undo.gNew.getID());
            this.labels_.removeLabel(undo.gNew.getID());
        } else {
            this.genes_.put(undo.gOrig.getID(), undo.gOrig);
            this.labels_.addExistingLabel(undo.gOrig.getID());
        }
    }

    private void geneChangeRedo(GenomeChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.put(undo.gNew.getID(), undo.gNew);
        } else if (undo.gOrig == null) {
            this.genes_.put(undo.gNew.getID(), undo.gNew);
            this.labels_.addExistingLabel(undo.gNew.getID());
        } else {
            this.genes_.remove(undo.gOrig.getID());
            this.labels_.removeLabel(undo.gOrig.getID());
        }
    }

    private void linkChangeUndo(GenomeChange undo) {
        if (undo.lOrig != null && undo.lNew != null) {
            this.links_.put(undo.lOrig.getID(), undo.lOrig);
        } else if (undo.lOrig == null) {
            this.links_.remove(undo.lNew.getID());
            this.labels_.removeLabel(undo.lNew.getID());
        } else {
            this.links_.put(undo.lOrig.getID(), undo.lOrig);
            this.labels_.addExistingLabel(undo.lOrig.getID());
        }
    }

    private void linkChangeRedo(GenomeChange undo) {
        if (undo.lOrig != null && undo.lNew != null) {
            this.links_.put(undo.lNew.getID(), undo.lNew);
        } else if (undo.lOrig == null) {
            this.links_.put(undo.lNew.getID(), undo.lNew);
            this.labels_.addExistingLabel(undo.lNew.getID());
        } else {
            this.links_.remove(undo.lOrig.getID());
            this.labels_.removeLabel(undo.lOrig.getID());
        }
    }

    class LinkEnds {
        public String src;
        public String trg;

        public LinkEnds(String src, String trg) {
            this.src = src;
            this.trg = trg;
        }

        public int hashCode() {
            return this.src.hashCode() + this.trg.hashCode();
        }

        public String toString() {
            return "LinkEnds: " + this.src + " -> " + this.trg;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof LinkEnds)) {
                return false;
            }
            LinkEnds otherLE = (LinkEnds)other;
            if (!this.src.equals(otherLE.src)) {
                return false;
            }
            return this.trg.equals(otherLE.trg);
        }
    }

    class LinkComparator
    implements Comparator {
        LinkComparator() {
        }

        public int compare(Object o1, Object o2) {
            DBLinkage link1 = (DBLinkage)o1;
            DBLinkage link2 = (DBLinkage)o2;
            int srcCompare = link1.getSource().compareTo(link2.getSource());
            int trgCompare = link1.getTarget().compareTo(link2.getTarget());
            if (srcCompare == 0) {
                if (trgCompare == 0) {
                    return link1.getID().compareTo(link2.getID());
                }
                return trgCompare;
            }
            return srcCompare;
        }
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            int type2;
            DBNode node1 = (DBNode)o1;
            DBNode node2 = (DBNode)o2;
            int type1 = node1.getNodeType();
            if (type1 == (type2 = node2.getNodeType())) {
                return node1.getID().compareTo(node2.getID());
            }
            return type1 > type2 ? 1 : -1;
        }
    }
}

