/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBGeneRegion;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBInternalLogic;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.InternalFunction;
import org.systemsbiology.biotapestry.genome.InternalLink;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.xml.sax.Attributes;

public class DBGenomeFactory
extends AbstractFactoryClient {
    private static final int NONE_ = 0;
    private static final int LONG_NAME_ = 1;
    private static final int DESCRIPTION_ = 2;
    private static final int NODE_DESCRIPTION_ = 3;
    private static final int NODE_URL_ = 4;
    private static final int NOTE_ = 5;
    private static final int LINK_DESCRIPTION_ = 6;
    private static final int LINK_URL_ = 7;
    private DBGenome currGenome_;
    private DBGene currGene_;
    private DBNode currNode_;
    private DBLinkage currLink_;
    private DBInternalLogic currILog_;
    private Note currNote_;
    private int charTarget_;
    private Set genomeKeys_ = DBGenome.keywordsOfInterest();
    private Set geneKeys_ = DBGene.keywordsOfInterest();
    private Set nodeKeys_ = DBNode.keywordsOfInterest();
    private Set linkKeys_ = DBLinkage.keywordsOfInterest();
    private Set regionKeys_ = DBGeneRegion.keywordsOfInterest();
    private Set logicKeys_ = DBInternalLogic.keywordsOfInterest();
    private Set internalNodeKeys_ = InternalFunction.keywordsOfInterest();
    private Set internalLinkKeys_ = InternalLink.keywordsOfInterest();
    private Set noteKeys_ = Note.keywordsOfInterest(false);
    private String simParamKey_ = DBInternalLogic.getSimParamKeyword();
    private String descripKey_ = DBGenome.descriptionKeyword();
    private String nodeDescripKey_ = DBNode.descriptionKeyword();
    private String urlKeyword_ = DBNode.urlKeyword();
    private String longNameKey_ = DBGenome.longNameKeyword();
    private String linkDescripKey_ = DBLinkage.descriptionKeyword();
    private String linkUrlKeyword_ = DBLinkage.urlKeyword();
    private StringBuffer descBuf_;
    private StringBuffer urlBuf_;

    public DBGenomeFactory() {
        super(new FactoryWhiteboard());
        FactoryWhiteboard whiteboard = (FactoryWhiteboard)this.sharedWhiteboard_;
        whiteboard.genomeType = 0;
        this.installWorker(new NetworkOverlay.NetOverlayWorker(whiteboard), new MyGlue());
        this.myKeys_.addAll(this.genomeKeys_);
        this.descBuf_ = new StringBuffer();
        this.urlBuf_ = new StringBuffer();
    }

    protected void localFinishElement(String elemName) {
        if (this.charTarget_ == 3) {
            if (!elemName.equals(this.nodeDescripKey_)) {
                throw new IllegalStateException();
            }
            this.currNode_.appendDescription(this.descBuf_.toString());
        } else if (this.charTarget_ == 4) {
            if (!elemName.equals(this.urlKeyword_)) {
                throw new IllegalStateException();
            }
            this.currNode_.addUrl(this.urlBuf_.toString());
        } else if (this.charTarget_ == 6) {
            if (!elemName.equals(this.linkDescripKey_)) {
                throw new IllegalStateException();
            }
            this.currLink_.appendDescription(this.descBuf_.toString());
        } else if (this.charTarget_ == 7) {
            if (!elemName.equals(this.linkUrlKeyword_)) {
                throw new IllegalStateException();
            }
            this.currLink_.addUrl(this.urlBuf_.toString());
        }
        this.charTarget_ = 0;
    }

    protected void localProcessCharacters(char[] chars, int start, int length) {
        String nextString = new String(chars, start, length);
        switch (this.charTarget_) {
            case 0: {
                break;
            }
            case 1: {
                this.currGenome_.appendLongName(nextString);
                break;
            }
            case 2: {
                this.currGenome_.appendDescription(nextString);
                break;
            }
            case 3: 
            case 6: {
                this.descBuf_.append(nextString);
                break;
            }
            case 4: 
            case 7: {
                this.urlBuf_.append(nextString);
                break;
            }
            case 5: {
                if (this.currNote_ == null) break;
                this.currNote_.appendToNote(nextString);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
        if (this.genomeKeys_.contains(elemName)) {
            DBGenome dbg = DBGenome.buildFromXML(elemName, attrs);
            if (dbg != null) {
                Database db = Database.getDB();
                db.setGenome(dbg);
                this.currGenome_ = dbg;
                ((FactoryWhiteboard)this.sharedWhiteboard_).genome = dbg;
                NavTree tree = db.getNavTree();
                tree.addNode(null, null, dbg.getID());
                return dbg;
            }
            return null;
        }
        if (this.geneKeys_.contains(elemName)) {
            this.currGene_ = DBGene.buildFromXML(this.currGenome_, attrs);
            this.currNode_ = this.currGene_;
            this.currGenome_.addGene(this.currGene_);
        } else if (this.nodeKeys_.contains(elemName)) {
            this.currNode_ = DBNode.buildFromXML(this.currGenome_, elemName, attrs);
            this.currGenome_.addNode(this.currNode_);
        } else if (this.linkKeys_.contains(elemName)) {
            this.currLink_ = DBLinkage.buildFromXML(this.currGenome_, attrs);
            this.currGenome_.addLinkage(this.currLink_);
        } else if (this.regionKeys_.contains(elemName)) {
            this.currGene_.addRegion(DBGeneRegion.buildFromXML(this.currGenome_, attrs));
        } else if (this.logicKeys_.contains(elemName)) {
            DBInternalLogic ilog = DBInternalLogic.buildFromXML(this.currGenome_, elemName, attrs);
            if (ilog != null) {
                this.currILog_ = ilog;
                this.currNode_.setInternalLogic(this.currILog_);
            }
        } else if (this.internalNodeKeys_.contains(elemName)) {
            InternalFunction ifunc = InternalFunction.buildFromXML(this.currGenome_, attrs);
            this.currILog_.addFunctionNodeWithExistingLabel(ifunc);
        } else if (this.internalLinkKeys_.contains(elemName)) {
            InternalLink.buildFromXML(this.currGenome_, attrs);
            InternalLink iLink = InternalLink.buildFromXML(this.currGenome_, attrs);
            this.currILog_.addFunctionLinkWithExistingLabel(iLink);
        } else if (this.noteKeys_.contains(elemName)) {
            Note newNote = Note.buildFromXML(elemName, attrs);
            if (newNote != null) {
                this.charTarget_ = 5;
                this.currNote_ = newNote;
                this.currGenome_.addNote(this.currNote_);
            }
        } else if (this.simParamKey_.equals(elemName)) {
            this.currILog_.addSimParam(elemName, attrs);
        } else if (this.descripKey_.equals(elemName)) {
            this.charTarget_ = 2;
        } else if (this.nodeDescripKey_.equals(elemName)) {
            this.charTarget_ = 3;
            this.descBuf_.setLength(0);
        } else if (this.urlKeyword_.equals(elemName)) {
            this.charTarget_ = 4;
            this.urlBuf_.setLength(0);
        } else if (this.linkDescripKey_.equals(elemName)) {
            this.charTarget_ = 6;
            this.descBuf_.setLength(0);
        } else if (this.linkUrlKeyword_.equals(elemName)) {
            this.charTarget_ = 7;
            this.urlBuf_.setLength(0);
        } else if (this.longNameKey_.equals(elemName)) {
            this.charTarget_ = 1;
        }
        return null;
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Genome genome = board.genome;
            NetworkOverlay netOvr = board.netOvr;
            if (netOvr != null) {
                genome.addNetworkOverlayAndKey(netOvr);
            }
            return null;
        }
    }
}

