/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.cmd.AddCommands;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.BuildInstructionProcessor;
import org.systemsbiology.biotapestry.cmd.GeneralBuildInstruction;
import org.systemsbiology.biotapestry.cmd.GenomeChangeCmd;
import org.systemsbiology.biotapestry.cmd.LoneNodeBuildInstruction;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class DBGenomeSIFFormatFactory {
    private DBGenome genome_;
    private AddCommands ac_;
    private HashMap newNodeTypes_;
    private HashSet newLinks_;
    private HashMap seenNames_;
    private UndoSupport support_;
    private CommonView suw_;

    public DBGenomeSIFFormatFactory(CommonView suw) {
        this.suw_ = suw;
    }

    public LinkRouter.RoutingResult buildFromSIF(File infile, JFrame topWindow, UndoManager undo, Point2D center, Dimension size, FontRenderContext frc, boolean doReplacement, UndoSupport support, boolean doOpts, int overlayOption, BTProgressMonitor monitor, double startFrac, double endFrac) throws IOException, AsynchExitRequestException {
        ArrayList<BuildInstruction> commands = new ArrayList<BuildInstruction>();
        BufferedReader in = new BufferedReader(new FileReader(infile));
        String line = null;
        while ((line = in.readLine()) != null) {
            String[] tokens = line.split("\\t");
            if (tokens.length == 0) continue;
            if (tokens.length == 1 || tokens.length == 2) {
                if (tokens[0].trim().equals("")) {
                    throw new IOException();
                }
                commands.add(this.processRelationToInstruction(tokens[0].trim(), null, null));
                continue;
            }
            for (int i = 2; i < tokens.length; ++i) {
                if (tokens[0].trim().equals("") || tokens[i].trim().equals("")) {
                    throw new IOException();
                }
                commands.add(this.processRelationToInstruction(tokens[0].trim(), tokens[1], tokens[i].trim()));
            }
        }
        in.close();
        ToolCommands tc = new ToolCommands(topWindow, this.suw_, undo);
        LayoutOptions options = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
        options.optimizationPasses = doOpts ? 1 : 0;
        options.overlayOption = overlayOption;
        BuildInstructionProcessor bip = new BuildInstructionProcessor();
        LinkRouter.RoutingResult result = bip.processInstructionsForSIF(commands, tc, center, size, frc, !doReplacement, false, options, support, monitor, startFrac, endFrac, 5);
        return result;
    }

    public LinkRouter.RoutingResult buildForGaggle(List commands, JFrame topWindow, UndoManager undo, Point2D center, Dimension size, FontRenderContext frc, boolean doReplacement, UndoSupport support, boolean doOpts, BTProgressMonitor monitor, double startFrac, double endFrac) throws IOException, AsynchExitRequestException {
        ToolCommands tc = new ToolCommands(topWindow, this.suw_, undo);
        LayoutOptions options = LayoutOptionsManager.getMgr().getLayoutOptions();
        options.optimizationPasses = doOpts ? 1 : 0;
        Database db = Database.getDB();
        Iterator cit = commands.iterator();
        while (cit.hasNext()) {
            BuildInstruction bi = (BuildInstruction)cit.next();
            String id = db.getNextInstructionLabel();
            bi.setID(id);
        }
        BuildInstructionProcessor bip = new BuildInstructionProcessor();
        LinkRouter.RoutingResult result = bip.processInstructionsForSIF(commands, tc, center, size, frc, !doReplacement, false, options, support, monitor, startFrac, endFrac, 5);
        return result;
    }

    private void processRelation(String node1ID, String link, String node2ID) {
        String node1Key;
        String existing = (String)this.seenNames_.get(node1ID);
        if (existing != null) {
            Node node1 = this.genome_.getNode(existing);
            node1Key = node1.getID();
        } else {
            node1Key = this.genome_.getNextKey();
            DBGene node1 = new DBGene(node1ID, node1Key);
            GenomeChange gc = this.genome_.addNodeWithExistingLabel(node1);
            if (gc != null) {
                GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                this.support_.addEdit(gcc);
            }
            this.seenNames_.put(node1ID, node1Key);
            this.newNodeTypes_.put(node1Key, new Integer(4));
        }
        if (link != null && node2ID != null) {
            String node2Key;
            Node node2;
            existing = (String)this.seenNames_.get(node2ID);
            if (existing != null) {
                node2 = this.genome_.getNode(existing);
                node2Key = node2.getID();
            } else {
                node2Key = this.genome_.getNextKey();
                node2 = new DBGene(node2ID, node2Key);
                GenomeChange gc = this.genome_.addNodeWithExistingLabel(node2);
                if (gc != null) {
                    GenomeChangeCmd gcc = new GenomeChangeCmd(gc);
                    this.support_.addEdit(gcc);
                }
                this.seenNames_.put(node2ID, node2Key);
                this.newNodeTypes_.put(node2Key, new Integer(4));
            }
            Linkage newLink = this.ac_.autoAddLinkToRoot(node1Key, node2Key, 0, this.support_, true, null, null, 0);
            if (newLink != null) {
                this.newLinks_.add(newLink.getID());
            }
        }
    }

    private BuildInstruction processRelationToInstruction(String node1ID, String link, String node2ID) {
        Database db = Database.getDB();
        String id = db.getNextInstructionLabel();
        if (link != null && node2ID != null) {
            return new GeneralBuildInstruction(id, 4, node1ID, GeneralBuildInstruction.mapFromLinkageSign(1), 4, node2ID);
        }
        return new LoneNodeBuildInstruction(id, 4, node1ID);
    }
}

