/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.InternalFunction;
import org.systemsbiology.biotapestry.genome.InternalLink;
import org.systemsbiology.biotapestry.genome.SbmlSupport;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class DBInternalLogic
implements Cloneable {
    private HashMap nodes_;
    private HashMap links_;
    private int funcType_;
    private UniqueLabeller labels_;
    private HashMap params_;
    private static final String AND_TAG_ = "AND";
    private static final String OR_TAG_ = "OR";
    private static final String XOR_TAG_ = "XOR";
    private static final String CUSTOM_TAG_ = "CUSTOM";
    public static final int AND_FUNCTION = 0;
    public static final int OR_FUNCTION = 1;
    public static final int XOR_FUNCTION = 2;
    public static final int CUSTOM_FUNCTION = 3;

    public DBInternalLogic(DBInternalLogic other) {
        this.copyGuts(other);
    }

    public DBInternalLogic() {
        this.funcType_ = 0;
        this.nodes_ = new HashMap();
        this.links_ = new HashMap();
        this.params_ = new HashMap();
        this.labels_ = new UniqueLabeller();
    }

    public DBInternalLogic(String function) throws IOException {
        if (function == null) {
            throw new IOException();
        }
        if (function.equals(AND_TAG_)) {
            this.funcType_ = 0;
        } else if (function.equals(OR_TAG_)) {
            this.funcType_ = 1;
        } else if (function.equals(XOR_TAG_)) {
            this.funcType_ = 2;
        } else if (function.equals(CUSTOM_TAG_)) {
            this.funcType_ = 3;
        } else {
            throw new IOException();
        }
        this.nodes_ = new HashMap();
        this.links_ = new HashMap();
        this.params_ = new HashMap();
        this.labels_ = new UniqueLabeller();
    }

    public Object clone() {
        try {
            DBInternalLogic retval = (DBInternalLogic)super.clone();
            retval.copyGuts(this);
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public int getFunctionType() {
        return this.funcType_;
    }

    public void setFunctionType(int type) {
        this.funcType_ = type;
    }

    public Iterator getFunctionNodes() {
        return this.nodes_.values().iterator();
    }

    public Iterator getFunctionLinks() {
        return this.links_.values().iterator();
    }

    public Iterator getParameterKeys() {
        return this.params_.keySet().iterator();
    }

    public int getParameterCount() {
        return this.params_.size();
    }

    public void addFunctionNodeWithExistingLabel(InternalFunction ifunc) {
        String id = ifunc.getID();
        if (this.nodes_.get(id) != null) {
            System.err.println("got an existing function node");
            throw new IllegalArgumentException();
        }
        this.nodes_.put(id, ifunc);
    }

    public void addFunctionLinkWithExistingLabel(InternalLink iLink) {
        String id = iLink.getID();
        if (this.links_.get(id) != null) {
            System.err.println("got an existing link");
            throw new IllegalArgumentException();
        }
        this.links_.put(id, iLink);
    }

    public void addSimParam(String elemName, Attributes attrs) throws IOException {
        String name = AttributeExtractor.extractAttribute(elemName, attrs, "simParameter", "name", true);
        String value = AttributeExtractor.extractAttribute(elemName, attrs, "simParameter", "value", true);
        this.params_.put(name, value);
    }

    public String getSimulationParam(String name, int nodeType) {
        String retval = (String)this.params_.get(name);
        if (retval == null) {
            String root = SbmlSupport.extractRootIdFromParam(name);
            Database db = Database.getDB();
            retval = db.getSimulationDefaultValue(root, nodeType, this.funcType_);
        }
        return retval;
    }

    public void setSimulationParam(String key, String value) {
        this.params_.put(key, value);
    }

    public String getNextKey() {
        return this.labels_.getNextLabel();
    }

    public String toString() {
        return "DBInternalLogic: funcType = " + this.funcType_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<simulationLogic");
        out.print(" type=\"");
        out.print(this.getTag());
        int pSize = this.params_.size();
        if (this.funcType_ != 3 && pSize == 0) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        if (pSize != 0) {
            ind.up().indent();
            out.println("<simParameters>");
            ind.up();
            Iterator psit = this.params_.keySet().iterator();
            while (psit.hasNext()) {
                String name = (String)psit.next();
                String value = (String)this.params_.get(name);
                ind.indent();
                out.print("<simParameter name=\"");
                out.print(name);
                out.print("\" value=\"");
                out.print(value);
                out.println("\" />");
            }
            ind.down().indent();
            out.println("</simParameters>");
            ind.down();
        }
        if (this.funcType_ == 3) {
            ind.up().indent();
            out.println("<customNetwork>");
            ind.up();
            Iterator nodes = this.getFunctionNodes();
            while (nodes.hasNext()) {
                InternalFunction ifunc = (InternalFunction)nodes.next();
                ifunc.writeXML(out, ind);
            }
            Iterator links = this.getFunctionLinks();
            while (links.hasNext()) {
                InternalLink iLink = (InternalLink)links.next();
                iLink.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</customNetwork>");
            ind.down();
        }
        ind.indent();
        out.println("</simulationLogic>");
    }

    public static DBInternalLogic buildFromXML(Genome genome, String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("simulationLogic")) {
            return null;
        }
        String type = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("type")) continue;
                type = val;
            }
        }
        return new DBInternalLogic(type);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("simulationLogic");
        retval.add("simParameters");
        retval.add("customNetwork");
        return retval;
    }

    public static String getSimParamKeyword() {
        return "simParameter";
    }

    public static Map getLogicValues() {
        HashMap<Integer, String> retval = new HashMap<Integer, String>();
        retval.put(new Integer(0), AND_TAG_);
        retval.put(new Integer(1), OR_TAG_);
        retval.put(new Integer(2), XOR_TAG_);
        return retval;
    }

    private void copyGuts(DBInternalLogic other) {
        this.funcType_ = other.funcType_;
        this.nodes_ = new HashMap();
        Iterator nit = other.nodes_.values().iterator();
        while (nit.hasNext()) {
            InternalFunction ifunc = (InternalFunction)nit.next();
            InternalFunction newFunc = (InternalFunction)ifunc.clone();
            this.nodes_.put(newFunc.getID(), newFunc);
        }
        this.links_ = new HashMap();
        Iterator lit = other.links_.values().iterator();
        while (lit.hasNext()) {
            InternalLink ilink = (InternalLink)lit.next();
            InternalLink newLink = (InternalLink)ilink.clone();
            this.links_.put(newLink.getID(), newLink);
        }
        this.params_ = new HashMap();
        Iterator pit = other.params_.keySet().iterator();
        while (pit.hasNext()) {
            String pkey = (String)pit.next();
            String value = (String)other.params_.get(pkey);
            this.params_.put(new String(pkey), new String(value));
        }
        this.labels_ = (UniqueLabeller)other.labels_.clone();
    }

    private String getTag() {
        switch (this.funcType_) {
            case 0: {
                return AND_TAG_;
            }
            case 1: {
                return OR_TAG_;
            }
            case 2: {
                return XOR_TAG_;
            }
            case 3: {
                return CUSTOM_TAG_;
            }
        }
        throw new IllegalStateException();
    }
}

