/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.CommonGenomeItemCode;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class DBLinkage
extends DBGenomeItem
implements Linkage {
    private String src_;
    private String targ_;
    private int sign_;
    private int pad_;
    private String signTag_;
    private int lpad_;
    private int tnote_;
    private String starg_;
    private String description_;
    private ArrayList urls_;

    public DBLinkage(DBLinkage other) {
        super(other);
        this.signTag_ = other.signTag_;
        this.sign_ = other.sign_;
        this.tnote_ = other.tnote_;
        this.starg_ = other.starg_;
        this.src_ = other.src_;
        this.targ_ = other.targ_;
        this.pad_ = other.pad_;
        this.lpad_ = other.lpad_;
        this.description_ = other.description_;
        this.urls_ = (ArrayList)other.urls_.clone();
    }

    public DBLinkage(String name, String id, String src, String targ, int sign, int pad, int lpad) {
        super(name, id);
        if (src == null || targ == null) {
            throw new IllegalArgumentException();
        }
        this.src_ = src;
        this.targ_ = targ;
        this.sign_ = sign;
        this.signTag_ = this.sign_ == -1 ? "-" : (this.sign_ == 1 ? "+" : null);
        this.pad_ = pad;
        this.lpad_ = lpad;
        this.tnote_ = 0;
        this.starg_ = null;
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DBLinkage(String name, String id, String src, String targ, String sign, String pad, String lpad, String tnote, String starg) throws IOException {
        super(name, id);
        if (src == null || targ == null) {
            throw new IOException();
        }
        this.src_ = src.trim();
        this.targ_ = targ.trim();
        if (sign != null) {
            if ((sign = sign.trim()).equals("+")) {
                this.sign_ = 1;
            } else if (sign.equals("-")) {
                this.sign_ = -1;
            } else {
                if (!sign.equals("")) throw new IOException();
                this.sign_ = 0;
            }
        } else {
            this.sign_ = 0;
        }
        this.signTag_ = sign;
        this.pad_ = 0;
        if (pad != null) {
            try {
                this.pad_ = Integer.parseInt(pad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.lpad_ = 0;
        if (lpad != null) {
            try {
                this.lpad_ = Integer.parseInt(lpad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.tnote_ = 0;
        if (tnote != null) {
            try {
                this.tnote_ = Integer.parseInt(tnote);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
            if (this.tnote_ > 10) {
                throw new IOException();
            }
        }
        this.starg_ = starg;
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    public Object clone() {
        DBLinkage retval = (DBLinkage)super.clone();
        retval.urls_ = (ArrayList)this.urls_.clone();
        return retval;
    }

    public String getSource() {
        return this.src_;
    }

    public void setSource(String src) {
        this.src_ = src;
    }

    public void setTarget(String targ) {
        this.targ_ = targ;
    }

    public String getTarget() {
        return this.targ_;
    }

    public int getSign() {
        return this.sign_;
    }

    public int getLandingPad() {
        return this.pad_;
    }

    public int getLaunchPad() {
        return this.lpad_;
    }

    public void setLandingPad(int landingPad) {
        this.pad_ = landingPad;
    }

    public void setLaunchPad(int launchPad) {
        this.lpad_ = launchPad;
    }

    public int getTargetLevel() {
        return this.tnote_;
    }

    public void setSign(int newSign) {
        this.sign_ = newSign;
        this.signTag_ = this.sign_ == -1 ? "-" : (this.sign_ == 1 ? "+" : null);
    }

    public void setTargetLevel(int newTarget) {
        this.tnote_ = newTarget;
    }

    public Iterator getURLs() {
        return this.urls_.iterator();
    }

    public int getURLCount() {
        return this.urls_.size();
    }

    public void addUrl(String url) {
        this.urls_.add(url);
    }

    public void setAllUrls(List urls) {
        this.urls_.clear();
        this.urls_.addAll(urls);
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public void appendDescription(String description) {
        this.description_ = this.description_ == null ? description : this.description_.concat(description);
        this.description_ = CharacterEntityMapper.unmapEntities(this.description_, false);
    }

    public String getDisplayString(Genome genome, boolean typePreface) {
        Node srcNode = genome.getNode(this.src_);
        Node trgNode = genome.getNode(this.targ_);
        String format = DBLinkage.mapSignToDisplay(this.sign_);
        String linkMsg = MessageFormat.format(format, srcNode.getDisplayString(genome, typePreface), trgNode.getDisplayString(genome, typePreface));
        return linkMsg;
    }

    public String toString() {
        return "DBLinkage: name = " + this.name_ + " id = " + this.id_ + " source = " + this.src_ + " target = " + this.targ_ + " sign = " + this.sign_ + " pad = " + this.pad_ + " lpad = " + this.lpad_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<link");
        out.print(" label=\"");
        out.print(this.name_ == null ? "" : CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" src=\"");
        out.print(this.src_);
        out.print("\" targ=\"");
        out.print(this.targ_);
        if (this.signTag_ != null) {
            out.print("\" sign=\"");
            out.print(this.signTag_);
        }
        out.print("\" id=\"");
        out.print(this.id_);
        out.print("\" targPad=\"");
        out.print(this.pad_);
        if (this.lpad_ != 0) {
            out.print("\" launchPad=\"");
            out.print(this.lpad_);
        }
        if (this.tnote_ != 0) {
            out.print("\" targNote=\"");
            out.print(this.tnote_);
        }
        if (this.starg_ != null) {
            out.print("\" subTarg=\"");
            out.print(this.starg_);
        }
        if (!this.urls_.isEmpty() || this.description_ != null) {
            out.println("\" >");
            new CommonGenomeItemCode().writeDescUrlToXML(out, ind, this.urls_, this.description_, "link");
            ind.indent();
            out.println("</link>");
        } else {
            out.println("\" />");
        }
    }

    public static DBLinkage buildFromXML(Genome genome, Attributes attrs) throws IOException {
        String name = null;
        String id = null;
        String src = null;
        String targ = null;
        String sign = null;
        String pad = null;
        String lpad = null;
        String tnote = null;
        String starg = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("label")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("src")) {
                    src = val;
                    continue;
                }
                if (key.equals("targ")) {
                    targ = val;
                    continue;
                }
                if (key.equals("sign")) {
                    sign = val;
                    continue;
                }
                if (key.equals("targPad")) {
                    pad = val;
                    continue;
                }
                if (key.equals("launchPad")) {
                    lpad = val;
                    continue;
                }
                if (key.equals("targNote")) {
                    tnote = val;
                    continue;
                }
                if (!key.equals("subTarg")) continue;
                starg = val;
            }
        }
        return new DBLinkage(name, id, src, targ, sign, pad, lpad, tnote, starg);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("link");
        return retval;
    }

    public static String descriptionKeyword() {
        return "linkFreeText";
    }

    public static String urlKeyword() {
        return "linkURL";
    }

    public static Vector getSignChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        retval.add(DBLinkage.signForCombo(1));
        retval.add(DBLinkage.signForCombo(-1));
        retval.add(DBLinkage.signForCombo(0));
        return retval;
    }

    public static ChoiceContent signForCombo(int sign) {
        ResourceManager rMan = ResourceManager.getManager();
        return new ChoiceContent(rMan.getString("lcreate." + DBLinkage.mapToSignTag(sign)), sign);
    }

    public static Set linkSigns() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("negative");
        retval.add("neutral");
        retval.add("positive");
        return retval;
    }

    public static String mapSignToDisplay(int val) {
        String signTag = DBLinkage.mapToSignTag(val);
        return ResourceManager.getManager().getString("linkage." + signTag + "Format");
    }

    public static String mapToSignTag(int val) {
        switch (val) {
            case -1: {
                return "negative";
            }
            case 0: {
                return "neutral";
            }
            case 1: {
                return "positive";
            }
        }
        throw new IllegalStateException();
    }

    public static int invertSign(int val) {
        switch (val) {
            case -1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return -1;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromSignTag(String tag) {
        if (tag.equals("negative")) {
            return -1;
        }
        if (tag.equals("neutral")) {
            return 0;
        }
        if (tag.equals("positive")) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    public static Vector getEvidenceChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i <= 10; ++i) {
            retval.add(DBLinkage.evidenceTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent evidenceTypeForCombo(int eviLev) {
        return new ChoiceContent(ResourceManager.getManager().getString("lprop." + DBLinkage.mapToEvidenceTag(eviLev)), eviLev);
    }

    public static List linkEvidence() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add("none");
        retval.add("level1");
        retval.add("level2");
        retval.add("level3");
        retval.add("level4");
        retval.add("level5");
        retval.add("level6");
        retval.add("level7");
        retval.add("level8");
        retval.add("level9");
        retval.add("level10");
        return retval;
    }

    public static String mapToEvidenceTag(int val) {
        switch (val) {
            case 0: {
                return "none";
            }
            case 1: {
                return "level1";
            }
            case 2: {
                return "level2";
            }
            case 3: {
                return "level3";
            }
            case 4: {
                return "level4";
            }
            case 5: {
                return "level5";
            }
            case 6: {
                return "level6";
            }
            case 7: {
                return "level7";
            }
            case 8: {
                return "level8";
            }
            case 9: {
                return "level9";
            }
            case 10: {
                return "level10";
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromEvidenceTag(String tag) {
        if (tag.equals("none")) {
            return 0;
        }
        if (tag.equals("level1")) {
            return 1;
        }
        if (tag.equals("level2")) {
            return 2;
        }
        if (tag.equals("level3")) {
            return 3;
        }
        if (tag.equals("level4")) {
            return 4;
        }
        if (tag.equals("level5")) {
            return 5;
        }
        if (tag.equals("level6")) {
            return 6;
        }
        if (tag.equals("level7")) {
            return 7;
        }
        if (tag.equals("level8")) {
            return 8;
        }
        if (tag.equals("level9")) {
            return 9;
        }
        if (tag.equals("level10")) {
            return 10;
        }
        throw new IllegalArgumentException();
    }

    protected DBLinkage() {
    }
}

