/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.CommonGenomeItemCode;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.DBInternalLogic;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class DBNode
extends DBGenomeItem
implements Node {
    private static final String BARE_TAG_ = "bare";
    private static final String BOX_TAG_ = "box";
    private static final String BUBBLE_TAG_ = "bubble";
    private static final String INTERCELL_TAG_ = "intercel";
    private static final String SLASH_TAG_ = "slash";
    private static final String DIAMOND_TAG_ = "diamond";
    public static final String GENE_TAG = "gene";
    private static final int MAX_TEXT_PAD_COUNT_ = 100;
    private static final int TEXT_PAD_INCREMENT_ = 4;
    protected int nodeType_;
    protected DBInternalLogic logic_;
    protected String description_;
    protected int padCount_;
    protected ArrayList urls_;

    public DBNode(DBNode other) {
        super(other);
        this.nodeType_ = other.nodeType_;
        this.description_ = other.description_;
        this.logic_ = new DBInternalLogic(other.logic_);
        this.padCount_ = other.padCount_;
        this.urls_ = (ArrayList)other.urls_.clone();
    }

    public DBNode(int nodeType, String name, String id) {
        super(name, id);
        this.nodeType_ = nodeType;
        this.logic_ = new DBInternalLogic();
        this.padCount_ = DBNode.getDefaultPadCount(nodeType);
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    public DBNode(String elemName, String name, String id, String size) throws IOException {
        super(name, id);
        if (elemName == null) {
            throw new IOException();
        }
        this.nodeType_ = DBNode.mapFromTag(elemName);
        this.logic_ = new DBInternalLogic();
        this.padCount_ = DBNode.getDefaultPadCount(this.nodeType_);
        if (size != null) {
            try {
                this.padCount_ = Integer.parseInt(size);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.urls_ = new ArrayList();
    }

    public Object clone() {
        DBNode retval = (DBNode)super.clone();
        retval.logic_ = (DBInternalLogic)this.logic_.clone();
        retval.urls_ = (ArrayList)this.urls_.clone();
        return retval;
    }

    public int getNodeType() {
        return this.nodeType_;
    }

    public void setNodeType(int type) {
        this.nodeType_ = type;
    }

    public String getRootName() {
        return this.name_;
    }

    public void setInternalLogic(DBInternalLogic logic) {
        this.logic_ = logic;
    }

    public DBInternalLogic getInternalLogic() {
        return this.logic_;
    }

    public int getPadCount() {
        return this.padCount_;
    }

    public void setPadCount(int padCount) {
        this.padCount_ = padCount;
    }

    public String toString() {
        return "DBNode: name = " + this.name_ + " id = " + this.id_ + " type = " + this.getTag();
    }

    public Iterator getURLs() {
        return this.urls_.iterator();
    }

    public int getURLCount() {
        return this.urls_.size();
    }

    public void addUrl(String url) {
        this.urls_.add(url);
    }

    public void setAllUrls(List urls) {
        this.urls_.clear();
        this.urls_.addAll(urls);
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public void appendDescription(String description) {
        this.description_ = this.description_ == null ? description : this.description_.concat(description);
        this.description_ = CharacterEntityMapper.unmapEntities(this.description_, false);
    }

    public String getDisplayString(Genome genome, boolean typePreface) {
        String format = ResourceManager.getManager().getString("ncreate.importFormat");
        String typeDisplay = DBNode.mapTypeToDisplay(this.nodeType_);
        String nodeMsg = MessageFormat.format(format, typeDisplay, this.name_);
        return nodeMsg;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(this.getTag());
        out.print(" name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" id=\"");
        out.print(this.id_);
        if (this.padCount_ != DBNode.getDefaultPadCount(this.nodeType_)) {
            out.print("\" size=\"");
            out.print(this.padCount_);
        }
        int numURL = this.urls_.size();
        if (this.logic_ == null && this.description_ == null && numURL == 0) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        this.writeLogicDescUrlToXML(out, ind);
        ind.indent();
        out.print("</");
        out.print(this.getTag());
        out.println(">");
    }

    protected void writeLogicDescUrlToXML(PrintWriter out, Indenter ind) {
        new CommonGenomeItemCode().writeDescUrlToXML(out, ind, this.urls_, this.description_, "node");
        if (this.logic_ != null) {
            ind.up();
            this.logic_.writeXML(out, ind);
            ind.down();
        }
    }

    public static DBNode buildFromXML(Genome genome, String elemName, Attributes attrs) throws IOException {
        String name = null;
        String id = null;
        String size = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (!key.equals("size")) continue;
                size = val;
            }
        }
        return new DBNode(elemName, name, id, size);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(BARE_TAG_);
        retval.add(BOX_TAG_);
        retval.add(BUBBLE_TAG_);
        retval.add(INTERCELL_TAG_);
        retval.add(SLASH_TAG_);
        retval.add(DIAMOND_TAG_);
        return retval;
    }

    public static String descriptionKeyword() {
        return "nodeFreeText";
    }

    public static String urlKeyword() {
        return "nodeURL";
    }

    public static Vector getTypeChoices(boolean haveGene) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        retval.add(DBNode.typeForCombo(1));
        retval.add(DBNode.typeForCombo(2));
        retval.add(DBNode.typeForCombo(3));
        if (haveGene) {
            retval.add(DBNode.typeForCombo(4));
        }
        retval.add(DBNode.typeForCombo(5));
        retval.add(DBNode.typeForCombo(6));
        retval.add(DBNode.typeForCombo(7));
        return retval;
    }

    public static Vector getTypeChoices(int skipType) {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        if (skipType != 1) {
            retval.add(DBNode.typeForCombo(1));
        }
        if (skipType != 2) {
            retval.add(DBNode.typeForCombo(2));
        }
        if (skipType != 3) {
            retval.add(DBNode.typeForCombo(3));
        }
        if (skipType != 4) {
            retval.add(DBNode.typeForCombo(4));
        }
        if (skipType != 5) {
            retval.add(DBNode.typeForCombo(5));
        }
        if (skipType != 6) {
            retval.add(DBNode.typeForCombo(6));
        }
        if (skipType != 7) {
            retval.add(DBNode.typeForCombo(7));
        }
        return retval;
    }

    public static ChoiceContent typeForCombo(int type) {
        return new ChoiceContent(DBNode.mapTypeToDisplay(type), type);
    }

    public static String mapTypeToDisplay(int type) {
        String typeTag = DBNode.mapToTag(type);
        return ResourceManager.getManager().getString("nprop." + typeTag);
    }

    public static int mapFromTag(String tag) {
        if (tag.equals(BARE_TAG_)) {
            return 1;
        }
        if (tag.equals(BOX_TAG_)) {
            return 2;
        }
        if (tag.equals(BUBBLE_TAG_)) {
            return 3;
        }
        if (tag.equals(INTERCELL_TAG_)) {
            return 5;
        }
        if (tag.equals(SLASH_TAG_)) {
            return 6;
        }
        if (tag.equals(DIAMOND_TAG_)) {
            return 7;
        }
        if (tag.equals(GENE_TAG)) {
            return 4;
        }
        throw new IllegalArgumentException();
    }

    public static String mapToTag(int val) {
        switch (val) {
            case 1: {
                return BARE_TAG_;
            }
            case 2: {
                return BOX_TAG_;
            }
            case 3: {
                return BUBBLE_TAG_;
            }
            case 5: {
                return INTERCELL_TAG_;
            }
            case 6: {
                return SLASH_TAG_;
            }
            case 7: {
                return DIAMOND_TAG_;
            }
            case 4: {
                return GENE_TAG;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getDefaultPadCount(int nodeType) {
        switch (nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return 4;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 4: {
                return 7;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getMaxPadCount(int nodeType) {
        switch (nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return 100;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 2;
            }
            case 4: {
                return 30;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getPadIncrement(int nodeType) {
        switch (nodeType) {
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int mapPadCount(int oldNodeType, int newNodeType, int oldPadCount) {
        int currVal;
        int newPadInc = DBNode.getPadIncrement(newNodeType);
        int newPadDefault = DBNode.getDefaultPadCount(newNodeType);
        if (newPadInc == 0) {
            return newPadDefault;
        }
        if (oldPadCount <= newPadDefault) {
            return newPadDefault;
        }
        for (currVal = newPadDefault; currVal < oldPadCount; currVal += newPadInc) {
        }
        return currVal;
    }

    protected DBNode() {
    }

    private String getTag() {
        switch (this.nodeType_) {
            case 1: {
                return BARE_TAG_;
            }
            case 2: {
                return BOX_TAG_;
            }
            case 3: {
                return BUBBLE_TAG_;
            }
            case 5: {
                return INTERCELL_TAG_;
            }
            case 6: {
                return SLASH_TAG_;
            }
            case 7: {
                return DIAMOND_TAG_;
            }
            case 4: {
                return GENE_TAG;
            }
        }
        throw new IllegalStateException();
    }
}

