/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.timeCourse.GroupUsage;
import org.systemsbiology.biotapestry.timeCourse.InputTimeRange;
import org.systemsbiology.biotapestry.timeCourse.RegionAndRange;
import org.systemsbiology.biotapestry.timeCourse.TemporalInputRangeData;
import org.systemsbiology.biotapestry.timeCourse.TemporalRange;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseData;
import org.systemsbiology.biotapestry.timeCourse.TimeCourseGene;
import org.systemsbiology.biotapestry.ui.DisplayOptions;
import org.systemsbiology.biotapestry.ui.DisplayOptionsManager;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePair;

public class DynamicGenomeInstance
extends GenomeInstance {
    private boolean initialized_;
    private HashSet times_;
    private String proxyID_;

    public DynamicGenomeInstance(String name, String id, GenomeInstance vfgParent, String proxyID, String imgKey) {
        super(name, id, vfgParent == null ? null : vfgParent.getID());
        this.initialized_ = false;
        this.times_ = new HashSet();
        this.longName_ = this.name_;
        this.proxyID_ = proxyID;
        this.imgKey_ = imgKey;
    }

    public String getProxyID() {
        return this.proxyID_;
    }

    public String getNextNoteKey() {
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        String next = dip.getNextKey();
        return next;
    }

    protected void noteChangeUndo(GenomeChange undo) {
        super.noteChangeUndo(undo);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.undoNoteChange(undo);
    }

    protected void noteChangeRedo(GenomeChange undo) {
        super.noteChangeRedo(undo);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.redoNoteChange(undo);
    }

    protected void groupChangeUndo(GenomeChange undo) {
        super.groupChangeUndo(undo);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.undoGroupChange(undo);
    }

    protected void groupChangeRedo(GenomeChange undo) {
        super.groupChangeRedo(undo);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.redoGroupChange(undo);
    }

    public void setTime(Set times) {
        this.times_.clear();
        this.times_.addAll(times);
    }

    public Integer getTime() {
        if (this.times_.size() != 1) {
            throw new IllegalStateException();
        }
        return (Integer)this.times_.iterator().next();
    }

    public ImageChange[] setGenomeImage(String imgKey) {
        this.initialize();
        ImageChange[] retval = super.setGenomeImage(imgKey);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        Integer timeKey = dip.setGenomeImage(imgKey, this.getID());
        return retval;
    }

    public ImageChange dropGenomeImage() {
        this.initialize();
        ImageChange retval = super.dropGenomeImage();
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        retval.timeKey = dip.dropGenomeImage(this.getID());
        return retval;
    }

    public void imageChangeUndo(ImageChange undo) {
        this.initialize();
        super.imageChangeUndo(undo);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.imageChangeUndo(undo);
    }

    public void imageChangeRedo(ImageChange redo) {
        this.initialize();
        super.imageChangeRedo(redo);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.imageChangeRedo(redo);
    }

    public GenomeChange addGene(Gene gene) {
        throw new UnsupportedOperationException();
    }

    public boolean isEmpty() {
        this.initialize();
        return super.isEmpty();
    }

    public Iterator getGeneIterator() {
        this.initialize();
        return super.getGeneIterator();
    }

    public Iterator getSortedGeneIterator() {
        this.initialize();
        return super.getSortedGeneIterator();
    }

    public int getGeneCount() {
        this.initialize();
        return super.getGeneCount();
    }

    public Gene getGene(String key) {
        this.initialize();
        return super.getGene(key);
    }

    public int getNextNodeInstanceNumber(String nodeKey) {
        throw new UnsupportedOperationException();
    }

    public int getNextLinkInstanceNumber(String linkKey) {
        throw new UnsupportedOperationException();
    }

    public GenomeChange addNode(Node node) {
        throw new UnsupportedOperationException();
    }

    public Iterator getNodeIterator() {
        this.initialize();
        return super.getNodeIterator();
    }

    public Iterator getAllNodeIterator() {
        this.initialize();
        return super.getAllNodeIterator();
    }

    public Node getNode(String key) {
        this.initialize();
        return super.getNode(key);
    }

    public GenomeChange removeNode(String key) {
        throw new UnsupportedOperationException();
    }

    public GenomeChange addLinkage(Linkage link) {
        throw new UnsupportedOperationException();
    }

    public Iterator getLinkageIterator() {
        this.initialize();
        return super.getLinkageIterator();
    }

    public Linkage getLinkage(String key) {
        this.initialize();
        return super.getLinkage(key);
    }

    public GenomeChange removeLinkage(String key) {
        throw new UnsupportedOperationException();
    }

    public boolean haveBridgingInstance(String backingID, String testSrcID, String testTrgID) {
        this.initialize();
        return super.haveBridgingInstance(backingID, testSrcID, testTrgID);
    }

    public Group getGroupForNode(String nodeID, int fallbackMode) {
        this.initialize();
        return super.getGroupForNode(nodeID, fallbackMode);
    }

    public int getInstanceForNodeInGroup(String backingNodeID, String groupID) {
        this.initialize();
        return super.getInstanceForNodeInGroup(backingNodeID, groupID);
    }

    public Set getNewConnectionTuples(String backingKey) {
        this.initialize();
        return super.getNewConnectionTuples(backingKey);
    }

    public GenomeChange addGroup(Group group) {
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.addGroup(group);
        return super.addGroup(group);
    }

    public GenomeChange addGroupWithExistingLabel(Group group) {
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.addGroup(group);
        return super.addGroupWithExistingLabel(group);
    }

    public GenomeChange[] removeEmptyGroup(String key) {
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        GenomeChange[] retval = super.removeEmptyGroup(key);
        dip.removeGroup(key);
        return retval;
    }

    public GenomeChange[] removeSubGroup(String key) {
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        GenomeChange[] retval = super.removeSubGroup(key);
        dip.removeSubGroup(key);
        return retval;
    }

    public GenomeChange[] activateSubGroup(String parentKey, String subKey) {
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        GenomeChange[] retval = super.activateSubGroup(parentKey, subKey);
        int parentIndex = retval[1].grOrig == null ? 0 : 1;
        Group sub = retval[parentIndex == 0 ? 1 : 0].grNew;
        Group parent = retval[parentIndex].grNew;
        dip.activateSubGroup(parent, sub);
        return retval;
    }

    public String getNextKey() {
        this.initialize();
        return super.getNextKey();
    }

    public Iterator getGroupIterator() {
        this.initialize();
        return super.getGroupIterator();
    }

    public Set getGroupsForOverlayRendering() {
        this.initialize();
        return super.getGroupsForOverlayRendering();
    }

    public Group getGroup(String key) {
        this.initialize();
        return super.getGroup(key);
    }

    public void addNote(Note note) {
        throw new UnsupportedOperationException();
    }

    public GenomeChange addNoteWithExistingLabel(Note note) {
        this.initialize();
        GenomeChange retval = super.addNoteWithExistingLabel(note);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.addNoteWithExistingLabel(note);
        return retval;
    }

    public GenomeChange changeNote(Note note, String newLabel, String newText, boolean isInteractive) {
        this.initialize();
        GenomeChange retval = super.changeNote(note, newLabel, newText, isInteractive);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.changeNote(retval.ntOrig, retval.ntNew);
        return retval;
    }

    public GenomeChange removeNote(String key) {
        this.initialize();
        GenomeChange retval = super.removeNote(key);
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        dip.removeNote(key);
        return retval;
    }

    public Iterator getNoteIterator() {
        this.initialize();
        return super.getNoteIterator();
    }

    public Note getNote(String key) {
        this.initialize();
        return super.getNote(key);
    }

    public boolean groupNameInUse(String name) {
        this.initialize();
        return super.groupNameInUse(name);
    }

    public String getUniqueGroupName() {
        this.initialize();
        return super.getUniqueGroupName();
    }

    public int getGeneration() {
        return super.getGeneration();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
    }

    public NetworkOverlayOwnerChange addNetworkOverlay(NetworkOverlay nmView) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.addNetworkOverlay(nmView);
    }

    public void addNetworkOverlayAndKey(NetworkOverlay nmView) throws IOException {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        dip.addNetworkOverlayAndKey(nmView);
    }

    public void addNetworkModuleAndKey(String overlayKey, NetModule module) throws IOException {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        dip.addNetworkModuleAndKey(overlayKey, module);
    }

    public void addNetworkModuleLinkageAndKey(String overlayKey, NetModuleLinkage linkage) throws IOException {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        dip.addNetworkModuleLinkageAndKey(overlayKey, linkage);
    }

    public NetworkOverlayOwnerChange removeNetworkOverlay(String key) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.removeNetworkOverlay(key);
    }

    public NetworkOverlay getNetworkOverlay(String key) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.getNetworkOverlay(key);
    }

    public Iterator getNetworkOverlayIterator() {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.getNetworkOverlayIterator();
    }

    public int getNetworkOverlayCount() {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.getNetworkOverlayCount();
    }

    public int getNetworkModuleCount() {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.getNetworkModuleCount();
    }

    public NetworkOverlayChange addNetworkModule(String overlayKey, NetModule module) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.addNetworkModule(overlayKey, module);
    }

    public NetworkOverlayChange[] removeNetworkModule(String overlayKey, String moduleKey) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.removeNetworkModule(overlayKey, moduleKey);
    }

    public NetModuleChange addMemberToNetworkModule(String overlayKey, NetModule module, String nodeID) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.addMemberToNetworkModule(overlayKey, module, nodeID);
    }

    public NetModuleChange deleteMemberFromNetworkModule(String overlayKey, NetModule module, String nodeID) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.deleteMemberFromNetworkModule(overlayKey, module, nodeID);
    }

    public Map findMatchingNetworkModules(int searchMode, String key, NameValuePair nvPair) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return dip.findMatchingNetworkModules(searchMode, key, nvPair);
    }

    public Map findModulesOwnedByGroup(String groupID) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        return this.findModulesOwnedByGroupGuts(groupID, dip.getNetworkOverlayMap());
    }

    public int overlayModeForOwner() {
        return 2;
    }

    public void overlayChangeUndo(NetworkOverlayOwnerChange undo) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        dip.overlayChangeUndo(undo);
    }

    public void overlayChangeRedo(NetworkOverlayOwnerChange redo) {
        DynamicInstanceProxy dip = Database.getDB().getDynamicProxy(this.proxyID_);
        dip.overlayChangeRedo(redo);
    }

    private DynamicGenomeInstance() {
    }

    private void initialize() {
        if (this.initialized_) {
            return;
        }
        this.initialized_ = true;
        Database db = Database.getDB();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        Iterator grit = dip.getGroupIterator();
        while (grit.hasNext()) {
            Group grp = (Group)grit.next();
            Group myGroup = grp.copyForProxy();
            this.groups_.put(myGroup.getID(), myGroup);
        }
        Iterator nit = dip.getNoteIterator();
        while (nit.hasNext()) {
            Note note = (Note)nit.next();
            Note myNote = new Note(note);
            this.notes_.put(myNote.getID(), myNote);
        }
        TimeCourseData tcd = db.getTimeCourseData();
        if (tcd == null) {
            return;
        }
        GenomeInstance parent = this.getVfgParent();
        HashSet caught = new HashSet();
        Iterator genes = parent.getGeneIterator();
        this.initCore(tcd, genes, this.genes_, true, caught);
        Iterator nodes = parent.getNodeIterator();
        this.initCore(tcd, nodes, this.nodes_, false, caught);
        TemporalInputRangeData trd = db.getTemporalInputRangeData();
        if (trd == null) {
            return;
        }
        this.lazyLinkInit(parent, trd);
    }

    private void initCore(TimeCourseData tcd, Iterator it, Map dest, boolean isGene, Set caught) {
        Database db = Database.getDB();
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        TimeCourseGene.VariableLevel varLev = new TimeCourseGene.VariableLevel();
        double weakLevel = dopt.getWeakExpressionLevel();
        while (it.hasNext()) {
            List groupKeys;
            NodeInstance node = (NodeInstance)it.next();
            Group group = this.getGroupForNode(node.getID(), 0);
            String trueName = null;
            String gid = null;
            if (group == null) {
                Iterator anit = dip.getAddedNodeIterator();
                while (anit.hasNext()) {
                    DynamicInstanceProxy.AddedNode added = (DynamicInstanceProxy.AddedNode)anit.next();
                    if (!added.nodeName.equals(node.getID())) continue;
                    gid = added.groupToUse;
                    trueName = this.getVfgParentRoot().getGroup(Group.getBaseID(gid)).getName();
                    break;
                }
                if (gid == null) {
                    continue;
                }
            } else {
                gid = group.getID();
                trueName = group.getInheritedTrueName(this);
            }
            if ((groupKeys = tcd.getTimeCourseGroupKeysWithDefault(Group.getBaseID(gid), trueName)) == null) continue;
            Iterator gkit = groupKeys.iterator();
            boolean keepLooking = true;
            while (gkit.hasNext()) {
                GroupUsage groupUse = (GroupUsage)gkit.next();
                if (groupUse == null || groupUse.usage != null && !groupUse.usage.equals(this.proxyID_)) continue;
                String baseID = GenomeItemInstance.getBaseID(node.getID());
                List dataKeys = tcd.getTimeCourseTCMDataKeysWithDefault(baseID);
                Iterator dkit = dataKeys.iterator();
                while (dkit.hasNext() && keepLooking) {
                    TimeCourseData.TCMapping tcm = (TimeCourseData.TCMapping)dkit.next();
                    TimeCourseGene tcg = tcd.getTimeCourseDataCaseInsensitive(tcm.name);
                    if (tcg == null) continue;
                    Iterator hit = this.times_.iterator();
                    boolean addIt = false;
                    boolean partialLevel = true;
                    double partialMax = 0.0;
                    while (hit.hasNext()) {
                        int time = (Integer)hit.next();
                        int expression = tcg.getExpressionLevelForSource(groupUse.mappedGroup, time, tcm.channel, varLev);
                        if (expression == 3) {
                            addIt = true;
                            partialLevel = false;
                            break;
                        }
                        if (expression == 2) {
                            addIt = true;
                            partialMax = Math.max(partialMax, weakLevel);
                            continue;
                        }
                        if (expression != 4) continue;
                        double level = varLev.level;
                        addIt = true;
                        partialMax = Math.max(partialMax, level);
                    }
                    if (!addIt) continue;
                    NodeInstance newNode = isGene ? new GeneInstance((GeneInstance)node) : new NodeInstance(node);
                    if (partialLevel) {
                        int parentActivity = node.getActivity();
                        if (parentActivity == 0) {
                            newNode.setActivity(2);
                            newNode.setActivityLevel(partialMax);
                        } else if (parentActivity == 2) {
                            newNode.setActivityLevel(Math.min(partialMax, node.getActivityLevel()));
                        }
                    }
                    dest.put(node.getID(), newNode);
                    caught.add(tcg.getName());
                    keepLooking = false;
                }
            }
        }
    }

    private void lazyLinkInit(GenomeInstance parent, TemporalInputRangeData trd) {
        Database db = Database.getDB();
        DisplayOptionsManager dopmgr = DisplayOptionsManager.getMgr();
        DisplayOptions dopt = dopmgr.getDisplayOptions();
        DynamicInstanceProxy dip = db.getDynamicProxy(this.proxyID_);
        Iterator lit = parent.getLinkageIterator();
        while (lit.hasNext()) {
            String source;
            String srcBaseID;
            List srcKeys;
            LinkageInstance link = (LinkageInstance)lit.next();
            String target = link.getTarget();
            String baseID = GenomeItemInstance.getBaseID(target);
            List rangeKeys = trd.getTemporalInputRangeEntryKeysWithDefault(baseID);
            if (rangeKeys == null || (srcKeys = trd.getTemporalInputRangeSourceKeysWithDefault(srcBaseID = GenomeItemInstance.getBaseID(source = link.getSource()))) == null) continue;
            Group group = this.getGroupForNode(target, 0);
            boolean force = false;
            String gid = null;
            String trueName = null;
            if (group == null) {
                Iterator anit = dip.getAddedNodeIterator();
                while (anit.hasNext()) {
                    DynamicInstanceProxy.AddedNode added = (DynamicInstanceProxy.AddedNode)anit.next();
                    if (!added.nodeName.equals(target)) continue;
                    gid = added.groupToUse;
                    trueName = this.getVfgParentRoot().getGroup(Group.getBaseID(gid)).getName();
                    force = true;
                    break;
                }
                if (gid == null) {
                    continue;
                }
            } else {
                gid = group.getID();
                trueName = group.getInheritedTrueName(this);
            }
            Group srcGroup = this.getGroupForNode(source, 0);
            boolean forceSrc = false;
            String srcGid = null;
            String srcTrueName = null;
            if (srcGroup == null) {
                Iterator anit = dip.getAddedNodeIterator();
                while (anit.hasNext()) {
                    DynamicInstanceProxy.AddedNode added = (DynamicInstanceProxy.AddedNode)anit.next();
                    if (!added.nodeName.equals(source)) continue;
                    srcGid = added.groupToUse;
                    srcTrueName = this.getVfgParentRoot().getGroup(Group.getBaseID(srcGid)).getName();
                    forceSrc = true;
                    break;
                }
                if (srcGid == null) {
                    continue;
                }
            } else {
                srcGid = srcGroup.getID();
                srcTrueName = srcGroup.getInheritedTrueName(this);
            }
            int linkSign = link.getSign();
            Set groupTargs = this.resolveGroupTargets(trd, gid, trueName);
            Set srcGroupTargs = this.resolveGroupTargets(trd, srcGid, srcTrueName);
            Iterator rkit = rangeKeys.iterator();
            while (rkit.hasNext()) {
                String rKey = (String)rkit.next();
                TemporalRange tr = trd.getRange(rKey);
                if (tr == null) continue;
                Iterator perts = tr.getTimeRanges();
                block4: while (perts.hasNext()) {
                    InputTimeRange pert = (InputTimeRange)perts.next();
                    Iterator skit = srcKeys.iterator();
                    while (skit.hasNext()) {
                        String srcKey = (String)skit.next();
                        if (!DataUtil.keysEqual(srcKey, pert.getName())) continue;
                        Iterator rit = pert.getRanges();
                        while (rit.hasNext()) {
                            String restrict;
                            RegionAndRange range = (RegionAndRange)rit.next();
                            String reg = range.getRegion();
                            if (reg != null && !DataUtil.containsKey(groupTargs, reg) || (restrict = range.getRestrictedSource()) != null && !DataUtil.containsKey(srcGroupTargs, restrict) || !range.signMatch(linkSign)) continue;
                            Iterator hit = this.times_.iterator();
                            boolean addIt = false;
                            while (hit.hasNext()) {
                                int time = (Integer)hit.next();
                                if (!range.isActive(time)) continue;
                                addIt = true;
                                break;
                            }
                            if (!addIt) continue;
                            if (!this.installNeededNode(parent, source, forceSrc) || !this.installNeededNode(parent, target, force)) continue block4;
                            LinkageInstance newLink = new LinkageInstance(link);
                            NodeInstance sourceNode = (NodeInstance)this.getNode(source);
                            int sourceActivity = sourceNode.getActivity();
                            int linkActivity = newLink.getActivitySetting();
                            double currActivity = 1.0;
                            double dynLevel = 1.0;
                            if (linkActivity == 2 || linkActivity == 3) {
                                currActivity = newLink.getActivityLevel(this);
                            }
                            if (linkActivity == 0 && sourceActivity == 2) {
                                newLink.setActivity(2);
                                dynLevel = sourceNode.getActivityLevel();
                            }
                            if ((linkActivity = newLink.getActivitySetting()) == 2) {
                                newLink.setActivityLevel(Math.min(dynLevel, currActivity));
                            }
                            this.links_.put(newLink.getID(), newLink);
                            continue block4;
                        }
                        continue block4;
                    }
                }
            }
        }
    }

    private Set resolveGroupTargets(TemporalInputRangeData trd, String gid, String trueName) {
        HashSet<String> groupTargs = new HashSet<String>();
        List grpKeys = trd.getTemporalRangeGroupKeysWithDefault(Group.getBaseID(gid), trueName);
        if (grpKeys != null) {
            Iterator gkit = grpKeys.iterator();
            while (gkit.hasNext()) {
                GroupUsage groupUse = (GroupUsage)gkit.next();
                if (groupUse == null || groupUse.usage != null && !groupUse.usage.equals(this.proxyID_)) continue;
                groupTargs.add(DataUtil.normKey(groupUse.mappedGroup));
            }
        }
        return groupTargs;
    }

    private boolean installNeededNode(GenomeInstance parent, String nodeID, boolean force) {
        Node srcNode = this.getNode(nodeID);
        if (srcNode == null) {
            Node parentNode = parent.getNode(nodeID);
            if (parentNode == null) {
                return false;
            }
            int nodeType = parentNode.getNodeType();
            Group group = this.getGroupForNode(nodeID, 0);
            if (group == null && !force) {
                return false;
            }
            if (nodeType == 4) {
                GeneInstance newNode = new GeneInstance((GeneInstance)parentNode);
                newNode.setActivity(1);
                this.genes_.put(parentNode.getID(), newNode);
            } else {
                NodeInstance newNode = new NodeInstance((NodeInstance)parentNode);
                newNode.setActivity(1);
                this.nodes_.put(parentNode.getID(), newNode);
            }
        }
        return true;
    }
}

