/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biotapestry.cmd.MainCommands;
import org.systemsbiology.biotapestry.cmd.UserTreePathController;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.db.StartupView;
import org.systemsbiology.biotapestry.db.TimeAxisDefinition;
import org.systemsbiology.biotapestry.genome.CommonGenomeCode;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.genome.ProxyChange;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.nav.UserTreePathChange;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class DynamicInstanceProxy
implements Cloneable,
NetOverlayOwner {
    private String vfgParent_;
    private String name_;
    private String id_;
    private HashMap cache_;
    private HashMap imageKeys_;
    private Map netOverlays_;
    private int min_;
    private int max_;
    private boolean isSingle_;
    private TreeSet sortedTimes_;
    private ArrayList groups_;
    private ArrayList addedNodes_;
    private ArrayList notes_;
    private UniqueLabeller labels_;
    private static final String KEY_PREF_ = ":";

    public DynamicInstanceProxy(String name, String id, GenomeInstance vfgParent, boolean isSingle, int minTime, int maxTime) {
        this.name_ = name;
        this.id_ = id;
        this.vfgParent_ = vfgParent.getID();
        this.cache_ = new HashMap();
        this.groups_ = new ArrayList();
        this.addedNodes_ = new ArrayList();
        this.notes_ = new ArrayList();
        this.labels_ = new UniqueLabeller();
        this.labels_.setFixedPrefix(this.id_ + KEY_PREF_);
        this.imageKeys_ = new HashMap();
        this.netOverlays_ = new HashMap();
        this.isSingle_ = isSingle;
        this.min_ = minTime;
        this.max_ = maxTime;
    }

    public DynamicInstanceProxy(String name, String id, GenomeInstance vfgParent, String isSingle, String minTime, String maxTime) throws IOException {
        this.name_ = name;
        this.id_ = id;
        this.vfgParent_ = vfgParent.getID();
        this.cache_ = new HashMap();
        this.groups_ = new ArrayList();
        this.addedNodes_ = new ArrayList();
        this.notes_ = new ArrayList();
        this.labels_ = new UniqueLabeller();
        this.labels_.setFixedPrefix(this.id_ + KEY_PREF_);
        this.imageKeys_ = new HashMap();
        this.netOverlays_ = new HashMap();
        this.isSingle_ = isSingle == null ? false : Boolean.valueOf(isSingle);
        try {
            this.min_ = minTime != null ? Integer.parseInt(minTime) : -1;
            this.max_ = maxTime != null ? Integer.parseInt(maxTime) : -1;
        }
        catch (NumberFormatException nfex) {
            throw new IOException();
        }
    }

    private DynamicInstanceProxy(DynamicInstanceProxy other) {
        this.name_ = other.name_;
        this.id_ = other.id_;
        this.vfgParent_ = other.vfgParent_;
        this.cache_ = new HashMap();
        this.groups_ = new ArrayList();
        int numGrp = other.groups_.size();
        for (int i = 0; i < numGrp; ++i) {
            this.groups_.add(((Group)other.groups_.get(i)).clone());
        }
        this.addedNodes_ = new ArrayList();
        int numAN = other.addedNodes_.size();
        for (int i = 0; i < numAN; ++i) {
            this.addedNodes_.add(((AddedNode)other.addedNodes_.get(i)).clone());
        }
        this.notes_ = new ArrayList();
        int numNo = other.notes_.size();
        for (int i = 0; i < numNo; ++i) {
            this.notes_.add(((Note)other.notes_.get(i)).clone());
        }
        this.labels_ = (UniqueLabeller)other.labels_.clone();
        this.isSingle_ = other.isSingle_;
        this.min_ = other.min_;
        this.max_ = other.max_;
        this.sortedTimes_ = null;
        if (other.sortedTimes_ != null) {
            this.sortedTimes_ = new TreeSet(other.sortedTimes_);
        }
        this.imageKeys_ = new HashMap();
        Iterator ikit = other.imageKeys_.keySet().iterator();
        while (ikit.hasNext()) {
            Integer timeKey = (Integer)ikit.next();
            String imgKey = (String)other.imageKeys_.get(timeKey);
            this.imageKeys_.put(timeKey, imgKey);
        }
        this.netOverlays_ = new HashMap();
        Iterator nmit = other.netOverlays_.keySet().iterator();
        while (nmit.hasNext()) {
            String nmID = (String)nmit.next();
            this.netOverlays_.put(nmID, ((NetworkOverlay)other.netOverlays_.get(nmID)).clone());
        }
        for (int i = 0; i < numAN; ++i) {
            this.addedNodes_.add(((AddedNode)other.addedNodes_.get(i)).clone());
        }
    }

    public DynamicInstanceProxy(DynamicInstanceProxy other, String newName, String newVfgParentID, String newID, Map groupIDMap, Map noteIDMap, Map ovrIDMap, Map modIDMap, Map modLinkIDMap, List imageChanges) {
        this(other);
        Group groupCopy;
        Group otherGroup;
        int i;
        this.name_ = newName;
        this.id_ = newID;
        this.vfgParent_ = newVfgParentID;
        this.labels_ = other.labels_.mappedPrefixCopy(other.id_ + KEY_PREF_, this.id_ + KEY_PREF_);
        this.notes_ = new ArrayList();
        int numNo = other.notes_.size();
        for (int i2 = 0; i2 < numNo; ++i2) {
            Note oldNote = (Note)other.notes_.get(i2);
            String myNtID = UniqueLabeller.mapKeyPrefix(oldNote.getID(), other.id_ + KEY_PREF_, this.id_ + KEY_PREF_, null);
            noteIDMap.put(oldNote.getID(), myNtID);
            this.notes_.add(new Note(oldNote, myNtID));
        }
        DBGenome rootGenome = (DBGenome)Database.getDB().getGenome();
        this.groups_ = new ArrayList();
        int numGrp = other.groups_.size();
        for (i = 0; i < numGrp; ++i) {
            otherGroup = (Group)other.groups_.get(i);
            if (otherGroup.isASubset(other)) continue;
            groupCopy = otherGroup.getMappedCopy(rootGenome, other, groupIDMap);
            this.groups_.add(groupCopy);
        }
        for (i = 0; i < numGrp; ++i) {
            otherGroup = (Group)other.groups_.get(i);
            if (!otherGroup.isASubset(other)) continue;
            groupCopy = otherGroup.getMappedCopy(rootGenome, other, groupIDMap);
            this.groups_.add(groupCopy);
        }
        this.addedNodes_ = new ArrayList();
        int numAN = other.addedNodes_.size();
        for (int i3 = 0; i3 < numAN; ++i3) {
            AddedNode an = (AddedNode)other.addedNodes_.get(i3);
            AddedNode myAn = (AddedNode)an.clone();
            String mappedGroup = (String)groupIDMap.get(an.groupToUse);
            myAn.groupToUse = mappedGroup == null ? an.groupToUse : mappedGroup;
            this.addedNodes_.add(myAn);
        }
        this.netOverlays_ = new HashMap();
        Iterator noit = other.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            String newOvID = rootGenome.getNextKey();
            NetworkOverlay nextOver = (NetworkOverlay)other.netOverlays_.get(noID);
            ovrIDMap.put(noID, newOvID);
            NetworkOverlay newCopy = new NetworkOverlay(nextOver, newOvID, groupIDMap, null, modIDMap, modLinkIDMap);
            this.netOverlays_.put(noID, newCopy);
        }
        ImageManager imgr = ImageManager.getMgr();
        this.imageKeys_ = new HashMap();
        Iterator ikit = other.imageKeys_.keySet().iterator();
        while (ikit.hasNext()) {
            Integer timeKey = (Integer)ikit.next();
            String imgKey = (String)other.imageKeys_.get(timeKey);
            this.imageKeys_.put(timeKey, imgKey);
            ImageChange ic = imgr.registerImageUsage(imgKey);
            ic.timeKey = timeKey;
            ic.proxyKey = this.getID();
            imageChanges.add(ic);
        }
    }

    public Object clone() {
        try {
            DynamicInstanceProxy retval = (DynamicInstanceProxy)super.clone();
            retval.cache_ = new HashMap();
            retval.groups_ = new ArrayList();
            int numGrp = this.groups_.size();
            for (int i = 0; i < numGrp; ++i) {
                retval.groups_.add(((Group)this.groups_.get(i)).clone());
            }
            retval.addedNodes_ = new ArrayList();
            int numAN = this.addedNodes_.size();
            for (int i = 0; i < numAN; ++i) {
                retval.addedNodes_.add(((AddedNode)this.addedNodes_.get(i)).clone());
            }
            retval.notes_ = new ArrayList();
            int numNo = this.notes_.size();
            for (int i = 0; i < numNo; ++i) {
                retval.notes_.add(((Note)this.notes_.get(i)).clone());
            }
            retval.netOverlays_ = new HashMap();
            Iterator nmit = this.netOverlays_.keySet().iterator();
            while (nmit.hasNext()) {
                String nmID = (String)nmit.next();
                retval.netOverlays_.put(nmID, ((NetworkOverlay)this.netOverlays_.get(nmID)).clone());
            }
            retval.labels_ = (UniqueLabeller)this.labels_.clone();
            retval.sortedTimes_ = null;
            if (this.sortedTimes_ != null) {
                retval.sortedTimes_ = new TreeSet(this.sortedTimes_);
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getID() {
        return this.id_;
    }

    public String getNextKey() {
        return this.labels_.getNextLabel();
    }

    public GenomeInstance getVfgParent() {
        Database db = Database.getDB();
        return (GenomeInstance)db.getGenome(this.vfgParent_);
    }

    public GenomeInstance getStaticVfgParent() {
        Database db = Database.getDB();
        String currParent = this.vfgParent_;
        GenomeInstance gi;
        while (DynamicInstanceProxy.isDynamicInstance((gi = (GenomeInstance)db.getGenome(currParent)).getID())) {
            currParent = gi.getVfgParent().getID();
        }
        return gi;
    }

    public boolean instanceIsAncestor(GenomeInstance gi) {
        if (gi instanceof DynamicGenomeInstance) {
            throw new IllegalArgumentException();
        }
        String parent = this.vfgParent_;
        Database db = Database.getDB();
        String staticParent = null;
        while (DynamicInstanceProxy.isDynamicInstance(parent)) {
            DynamicInstanceProxy pdip = db.getDynamicProxy(DynamicInstanceProxy.extractProxyID(parent));
            parent = pdip.vfgParent_;
        }
        staticParent = this.vfgParent_;
        GenomeInstance gifirst = (GenomeInstance)db.getGenome(staticParent);
        return gi.isAncestor(gifirst);
    }

    public boolean proxyIsAncestor(String target) {
        if (this.id_.equals(target)) {
            return true;
        }
        String parent = this.vfgParent_;
        Database db = Database.getDB();
        while (DynamicInstanceProxy.isDynamicInstance(parent)) {
            String pid = DynamicInstanceProxy.extractProxyID(parent);
            if (pid.equals(target)) {
                return true;
            }
            DynamicInstanceProxy pdip = db.getDynamicProxy(pid);
            parent = pdip.vfgParent_;
        }
        return false;
    }

    public DynamicInstanceProxy getProxyParent() {
        Database db = Database.getDB();
        if (DynamicInstanceProxy.isDynamicInstance(this.vfgParent_)) {
            String pid = DynamicInstanceProxy.extractProxyID(this.vfgParent_);
            return db.getDynamicProxy(pid);
        }
        return null;
    }

    public boolean isSingle() {
        return this.isSingle_;
    }

    public String getFirstProxiedKey() {
        return (String)this.getProxiedKeys().get(0);
    }

    public List getProxiedKeys() {
        ArrayList<String> retval = new ArrayList<String>();
        this.getProxiedTimes();
        GenomeInstance parent = this.getVfgParent();
        GenomeInstance root = parent.getVfgParentRoot();
        if (root == null) {
            root = parent;
        }
        String rootID = root.getID();
        Iterator timit = this.getSortedTimes().iterator();
        StringBuffer buf = new StringBuffer();
        if (this.isSingle_) {
            buf.append("{DiP}@");
            buf.append(rootID);
            buf.append("-");
            buf.append(this.id_);
            buf.append(KEY_PREF_);
            buf.append("ALL");
            retval.add(buf.toString());
        } else {
            while (timit.hasNext()) {
                buf.setLength(0);
                Integer time = (Integer)timit.next();
                buf.append("{DiP}@");
                buf.append(rootID);
                buf.append("-");
                buf.append(this.id_);
                buf.append(KEY_PREF_);
                buf.append(time);
                retval.add(buf.toString());
            }
        }
        return retval;
    }

    public String getSingleKey(boolean forceConsistency) {
        GenomeInstance parent = this.getVfgParent();
        GenomeInstance root = parent.getVfgParentRoot();
        if (root == null) {
            root = parent;
        }
        String rootID = root.getID();
        StringBuffer buf = new StringBuffer();
        if (forceConsistency && !this.isSingle_) {
            throw new IllegalArgumentException();
        }
        buf.append("{DiP}@");
        buf.append(rootID);
        buf.append("-");
        buf.append(this.id_);
        buf.append(KEY_PREF_);
        buf.append("ALL");
        return buf.toString();
    }

    public String getKeyForTime(int time, boolean forceConsistency) {
        this.getProxiedTimes();
        GenomeInstance parent = this.getVfgParent();
        GenomeInstance root = parent.getVfgParentRoot();
        if (root == null) {
            root = parent;
        }
        String rootID = root.getID();
        StringBuffer buf = new StringBuffer();
        if (forceConsistency && this.isSingle_) {
            throw new IllegalArgumentException();
        }
        buf.setLength(0);
        buf.append("{DiP}@");
        buf.append(rootID);
        buf.append("-");
        buf.append(this.id_);
        buf.append(KEY_PREF_);
        buf.append(time);
        return buf.toString();
    }

    public int getMinimumTime() {
        return this.min_;
    }

    public int getMaximumTime() {
        return this.max_;
    }

    public List getProxiedTimes() {
        Iterator timit = this.getSortedTimes().iterator();
        ArrayList retval = new ArrayList();
        while (timit.hasNext()) {
            retval.add(timit.next());
        }
        return retval;
    }

    public void addGroup(Group group) {
        String id = group.getID();
        Iterator grit = this.groups_.iterator();
        while (grit.hasNext()) {
            Group g = (Group)grit.next();
            if (!id.equals(g.getID())) continue;
            System.err.println("Proxy has group: " + g.getID());
            throw new IllegalArgumentException();
        }
        this.groups_.add(group.copyForProxy());
    }

    public void activateSubGroup(Group parent, Group sub) {
        String id = parent.getID();
        Iterator grit = this.groups_.iterator();
        while (grit.hasNext()) {
            Group g = (Group)grit.next();
            if (!id.equals(g.getID())) continue;
            g.setActiveSubset(sub.getID());
        }
    }

    public Set getAllSubsets() {
        HashSet<String> retval = new HashSet<String>();
        Iterator git = this.getGroupIterator();
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (!group.isASubset(this)) continue;
            retval.add(group.getID());
        }
        return retval;
    }

    public ChangeBundle changeProperties(String name, boolean perTime, int min, int max) {
        ChangeBundle retval = new ChangeBundle();
        retval.proxyChange = new ProxyChange();
        retval.proxyChange.proxyID = this.id_;
        retval.proxyChange.nameOld = this.name_;
        retval.proxyChange.hourlyOld = !this.isSingle_;
        retval.proxyChange.minOld = this.min_;
        retval.proxyChange.maxOld = this.max_;
        retval.proxyChange.oldImageKeys = (HashMap)this.imageKeys_.clone();
        retval.imageChanges = this.doImageChangesForPropertyChange(perTime, min, max);
        retval.pathChanges = this.doPathChangesForPropertyChange(perTime, min, max);
        retval.dc = this.doStartupViewChangesForPropertyChange(perTime, min, max);
        this.name_ = name;
        this.isSingle_ = !perTime;
        this.min_ = min;
        this.max_ = max;
        retval.proxyChange.nameNew = this.name_;
        retval.proxyChange.hourlyNew = !this.isSingle_;
        retval.proxyChange.minNew = this.min_;
        retval.proxyChange.maxNew = this.max_;
        retval.proxyChange.newImageKeys = (HashMap)this.imageKeys_.clone();
        this.sortedTimes_ = null;
        return retval;
    }

    public ImageChange[] doImageChangesForPropertyChange(boolean newPerTime, int newMin, int newMax) {
        boolean newIsSingle = !newPerTime;
        ImageManager mgr = ImageManager.getMgr();
        if (this.isSingle_) {
            Iterator ikit;
            if (newMin != this.min_ && (ikit = this.imageKeys_.keySet().iterator()).hasNext()) {
                Integer onlyKey = (Integer)ikit.next();
                if (ikit.hasNext()) {
                    throw new IllegalStateException();
                }
                String onlyImage = (String)this.imageKeys_.get(onlyKey);
                this.imageKeys_.clear();
                this.imageKeys_.put(new Integer(newMin), onlyImage);
            }
            return new ImageChange[0];
        }
        if (!this.isSingle_ && newIsSingle) {
            ImageChange[] ics = this.dropGenomeImages();
            return ics == null ? new ImageChange[]{} : ics;
        }
        if (!this.isSingle_ && !newIsSingle) {
            HashSet<Integer> oldTimes = new HashSet<Integer>();
            for (int i = this.min_; i <= this.max_; ++i) {
                oldTimes.add(new Integer(i));
            }
            HashSet<Integer> newTimes = new HashSet<Integer>();
            for (int i = newMin; i <= newMax; ++i) {
                newTimes.add(new Integer(i));
            }
            HashSet lostKeys = new HashSet(oldTimes);
            lostKeys.removeAll(newTimes);
            Iterator lkit = lostKeys.iterator();
            ArrayList<ImageChange> changes = new ArrayList<ImageChange>();
            while (lkit.hasNext()) {
                Integer lostKey = (Integer)lkit.next();
                String lostImage = (String)this.imageKeys_.get(lostKey);
                if (lostImage == null) continue;
                ImageChange lostChange = mgr.dropImageUsage(lostImage);
                lostChange.timeKey = lostKey;
                lostChange.proxyKey = this.getID();
                changes.add(lostChange);
                this.imageKeys_.remove(lostKey);
            }
            return changes.toArray(new ImageChange[changes.size()]);
        }
        throw new IllegalStateException();
    }

    public UserTreePathChange[] doPathChangesForPropertyChange(boolean newPerTime, int newMin, int newMax) {
        ArrayList<UserTreePathChange> retval;
        block7: {
            boolean newIsSingle;
            UserTreePathController utpc;
            block6: {
                utpc = MainCommands.getCmds().getPathController();
                newIsSingle = !newPerTime;
                retval = new ArrayList<UserTreePathChange>();
                if (!this.isSingle_) break block6;
                if (newIsSingle) break block7;
                String oldModelKey = this.getFirstProxiedKey();
                String newMinKey = this.getKeyForTime(newMin, false);
                UserTreePathChange[] chgs = utpc.replaceStopsOnModel(oldModelKey, newMinKey);
                retval.addAll(Arrays.asList(chgs));
                break block7;
            }
            if (newIsSingle) {
                List allKeys = this.getProxiedKeys();
                Iterator lkit = allKeys.iterator();
                while (lkit.hasNext()) {
                    String keyToDrop = (String)lkit.next();
                    UserTreePathChange[] chgs = utpc.dropStopsOnModel(keyToDrop);
                    retval.addAll(Arrays.asList(chgs));
                }
            } else {
                HashSet<Integer> oldTimes = new HashSet<Integer>();
                for (int i = this.min_; i <= this.max_; ++i) {
                    oldTimes.add(new Integer(i));
                }
                HashSet<Integer> newTimes = new HashSet<Integer>();
                for (int i = newMin; i <= newMax; ++i) {
                    newTimes.add(new Integer(i));
                }
                HashSet lostKeys = new HashSet(oldTimes);
                lostKeys.removeAll(newTimes);
                Iterator lkit = lostKeys.iterator();
                while (lkit.hasNext()) {
                    Integer lostKey = (Integer)lkit.next();
                    String keyToDrop = this.getKeyForTime(lostKey, true);
                    UserTreePathChange[] chgs = utpc.dropStopsOnModel(keyToDrop);
                    retval.addAll(Arrays.asList(chgs));
                }
            }
        }
        return retval.toArray(new UserTreePathChange[retval.size()]);
    }

    public DatabaseChange doStartupViewChangesForPropertyChange(boolean newPerTime, int newMin, int newMax) {
        boolean newIsSingle;
        Database db = Database.getDB();
        StartupView sView = db.getStartupView();
        if (sView == null) {
            return null;
        }
        String modelId = sView.getModel();
        if (modelId == null) {
            return null;
        }
        boolean bl = newIsSingle = !newPerTime;
        if (this.isSingle_) {
            if (newIsSingle) {
                return null;
            }
            String oldModelKey = this.getFirstProxiedKey();
            if (oldModelKey.equals(modelId)) {
                String newMinKey = this.getKeyForTime(newMin, false);
                return db.setStartupView(new StartupView(newMinKey, null, null, null));
            }
        } else if (newIsSingle) {
            List allKeys = this.getProxiedKeys();
            Iterator lkit = allKeys.iterator();
            while (lkit.hasNext()) {
                String oldModelKey = (String)lkit.next();
                if (!oldModelKey.equals(modelId)) continue;
                String newKey = this.getSingleKey(false);
                return db.setStartupView(new StartupView(newKey, null, null, null));
            }
        } else {
            HashSet<Integer> oldTimes = new HashSet<Integer>();
            for (int i = this.min_; i <= this.max_; ++i) {
                oldTimes.add(new Integer(i));
            }
            HashSet<Integer> newTimes = new HashSet<Integer>();
            for (int i = newMin; i <= newMax; ++i) {
                newTimes.add(new Integer(i));
            }
            HashSet lostKeys = new HashSet(oldTimes);
            lostKeys.removeAll(newTimes);
            Iterator lkit = lostKeys.iterator();
            while (lkit.hasNext()) {
                Integer lostKey = (Integer)lkit.next();
                String oldModelKey = this.getKeyForTime(lostKey, true);
                if (!oldModelKey.equals(modelId)) continue;
                String newKey = this.getKeyForTime(newMin, true);
                return db.setStartupView(new StartupView(newKey, null, null, null));
            }
        }
        return null;
    }

    public Integer setGenomeImage(String newKey, String instanceID) {
        Integer retval;
        if (this.isSingle_) {
            retval = new Integer(this.min_);
            if (newKey != null) {
                this.imageKeys_.put(retval, newKey);
            } else {
                this.imageKeys_.remove(retval);
            }
        } else {
            DynamicGenomeInstance pi = this.getProxiedInstance(instanceID);
            retval = pi.getTime();
            if (newKey != null) {
                this.imageKeys_.put(retval, newKey);
            } else {
                this.imageKeys_.remove(retval);
            }
        }
        return retval;
    }

    public Integer dropGenomeImage(String instanceID) {
        Integer retval;
        if (this.isSingle_) {
            retval = new Integer(this.min_);
            this.imageKeys_.clear();
        } else {
            DynamicGenomeInstance pi = this.getProxiedInstance(instanceID);
            retval = pi.getTime();
            this.imageKeys_.remove(retval);
        }
        return retval;
    }

    private void setGenomeImageForTime(String newKey, Integer time) {
        if (newKey != null) {
            this.imageKeys_.put(time, newKey);
        } else {
            this.imageKeys_.remove(time);
        }
    }

    public void imageChangeUndo(ImageChange undo) {
        if (undo.timeKey == null) {
            return;
        }
        if (undo.countOnlyKey != null) {
            String cok = undo.newCount > undo.oldCount ? null : undo.countOnlyKey;
            this.setGenomeImageForTime(cok, undo.timeKey);
        } else if (undo.newKey != null) {
            this.setGenomeImageForTime(null, undo.timeKey);
        } else if (undo.oldKey != null) {
            this.setGenomeImageForTime(undo.oldKey, undo.timeKey);
        }
        if (undo.proxyKey != null) {
            ImageManager mgr = ImageManager.getMgr();
            mgr.changeUndo(undo);
        }
    }

    public void imageChangeRedo(ImageChange redo) {
        if (redo.timeKey == null) {
            return;
        }
        if (redo.countOnlyKey != null) {
            String cok = redo.oldCount > redo.newCount ? null : redo.countOnlyKey;
            this.setGenomeImageForTime(cok, redo.timeKey);
        } else if (redo.newKey != null) {
            this.setGenomeImageForTime(redo.newKey, redo.timeKey);
        } else if (redo.oldKey != null) {
            this.setGenomeImageForTime(null, redo.timeKey);
        }
        if (redo.proxyKey != null) {
            ImageManager mgr = ImageManager.getMgr();
            mgr.changeRedo(redo);
        }
    }

    public ImageChange[] dropGenomeImages() {
        ArrayList<ImageChange> allChanges = new ArrayList<ImageChange>();
        ImageManager imgr = ImageManager.getMgr();
        Iterator ikit = new HashSet(this.imageKeys_.keySet()).iterator();
        while (ikit.hasNext()) {
            Integer timeKey = (Integer)ikit.next();
            String imgKey = (String)this.imageKeys_.get(timeKey);
            this.imageKeys_.remove(timeKey);
            ImageChange ic = imgr.dropImageUsage(imgKey);
            ic.timeKey = timeKey;
            ic.proxyKey = this.getID();
            allChanges.add(ic);
        }
        int changeCount = allChanges.size();
        if (changeCount == 0) {
            return null;
        }
        ImageChange[] retval = new ImageChange[changeCount];
        allChanges.toArray(retval);
        return retval;
    }

    public void changeUndo(ProxyChange undo) {
        block4: {
            AddedNode an;
            int i;
            block8: {
                block7: {
                    block6: {
                        block5: {
                            if (undo.moduleChanges != null) {
                                for (i = 0; i < undo.moduleChanges.length; ++i) {
                                    NetworkOverlay no = this.getNetworkOverlay(undo.moduleChanges[i].overlayKey);
                                    NetModule nm = no.getModule(undo.moduleChanges[i].moduleKey);
                                    nm.changeUndo(undo.moduleChanges[i]);
                                }
                            }
                            if (undo.removedGroup == null) break block5;
                            this.groups_.add(undo.removedGroup);
                            break block4;
                        }
                        if (undo.addedNew != null || undo.addedOld != null) break block6;
                        this.name_ = undo.nameOld;
                        this.isSingle_ = !undo.hourlyOld;
                        this.min_ = undo.minOld;
                        this.max_ = undo.maxOld;
                        this.imageKeys_ = (HashMap)undo.oldImageKeys.clone();
                        this.sortedTimes_ = null;
                        break block4;
                    }
                    if (undo.addedOld == null || undo.addedNew != null) break block7;
                    this.addedNodes_.add(undo.addedOld);
                    break block4;
                }
                if (undo.addedOld == null) break block8;
                for (i = 0; i < this.addedNodes_.size(); ++i) {
                    an = (AddedNode)this.addedNodes_.get(i);
                    if (!an.nodeName.equals(undo.addedOld.nodeName)) continue;
                    this.addedNodes_.set(i, undo.addedOld);
                    break block4;
                }
                break block4;
            }
            if (undo.addedOld != null || undo.addedNew == null) break block4;
            for (i = 0; i < this.addedNodes_.size(); ++i) {
                an = (AddedNode)this.addedNodes_.get(i);
                if (!an.nodeName.equals(undo.addedNew.nodeName)) continue;
                this.addedNodes_.remove(i);
                break;
            }
        }
    }

    public void changeRedo(ProxyChange undo) {
        AddedNode an;
        if (undo.removedGroup != null) {
            Iterator git = this.groups_.iterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (!undo.removedGroup.getID().equals(group.getID())) continue;
                this.groups_.remove(group);
                break;
            }
        } else if (undo.addedNew == null && undo.addedOld == null) {
            this.name_ = undo.nameNew;
            this.isSingle_ = !undo.hourlyNew;
            this.min_ = undo.minNew;
            this.max_ = undo.maxNew;
            this.imageKeys_ = (HashMap)undo.newImageKeys.clone();
            this.sortedTimes_ = null;
        } else if (undo.addedNew != null && undo.addedOld == null) {
            this.addedNodes_.add(undo.addedNew);
        } else if (undo.addedNew != null && undo.addedOld != null) {
            for (int i = 0; i < this.addedNodes_.size(); ++i) {
                an = (AddedNode)this.addedNodes_.get(i);
                if (!an.nodeName.equals(undo.addedNew.nodeName)) continue;
                this.addedNodes_.set(i, undo.addedNew);
                break;
            }
        } else if (undo.addedNew == null && undo.addedOld != null) {
            for (int i = 0; i < this.addedNodes_.size(); ++i) {
                an = (AddedNode)this.addedNodes_.get(i);
                if (!an.nodeName.equals(undo.addedOld.nodeName)) continue;
                this.addedNodes_.remove(i);
                break;
            }
        }
        if (undo.moduleChanges != null) {
            for (int i = 0; i < undo.moduleChanges.length; ++i) {
                NetworkOverlay no = this.getNetworkOverlay(undo.moduleChanges[i].overlayKey);
                NetModule nm = no.getModule(undo.moduleChanges[i].moduleKey);
                nm.changeRedo(undo.moduleChanges[i]);
            }
        }
    }

    public void addNote(Note note) {
        String id = note.getID();
        Iterator nit = this.notes_.iterator();
        while (nit.hasNext()) {
            Note n = (Note)nit.next();
            if (!id.equals(n.getID())) continue;
            throw new IllegalArgumentException();
        }
        if (!this.labels_.addExistingLabel(id)) {
            System.err.println("Don't like " + id);
            throw new IllegalArgumentException();
        }
        this.notes_.add(note);
    }

    public void addNoteWithExistingLabel(Note note) {
        String id = note.getID();
        Iterator nit = this.notes_.iterator();
        while (nit.hasNext()) {
            Note n = (Note)nit.next();
            if (!id.equals(n.getID())) continue;
            throw new IllegalArgumentException();
        }
        this.notes_.add(new Note(note));
    }

    public void changeNote(Note oldNote, Note newNote) {
        Iterator nit = this.notes_.iterator();
        while (nit.hasNext()) {
            Note note = (Note)nit.next();
            if (!note.getID().equals(oldNote.getID())) continue;
            this.notes_.remove(note);
            break;
        }
        this.notes_.add(new Note(newNote));
    }

    public void removeNote(String key) {
        Iterator nit = this.notes_.iterator();
        while (nit.hasNext()) {
            Note note = (Note)nit.next();
            if (!note.getID().equals(key)) continue;
            this.notes_.remove(note);
            break;
        }
    }

    public void undoNoteChange(GenomeChange undo) {
        if (undo.ntOrig != null && undo.ntNew != null) {
            Iterator nit = this.notes_.iterator();
            while (nit.hasNext()) {
                Note note = (Note)nit.next();
                if (!note.getID().equals(undo.ntNew.getID())) continue;
                this.notes_.remove(note);
                break;
            }
            this.notes_.add(new Note(undo.ntOrig));
        } else if (undo.ntOrig == null) {
            Iterator nit = this.notes_.iterator();
            while (nit.hasNext()) {
                Note note = (Note)nit.next();
                if (!note.getID().equals(undo.ntNew.getID())) continue;
                this.notes_.remove(note);
                break;
            }
        } else {
            this.notes_.add(new Note(undo.ntOrig));
        }
    }

    public void redoNoteChange(GenomeChange undo) {
        if (undo.ntOrig != null && undo.ntNew != null) {
            Iterator nit = this.notes_.iterator();
            while (nit.hasNext()) {
                Note note = (Note)nit.next();
                if (!note.getID().equals(undo.ntOrig.getID())) continue;
                this.notes_.remove(note);
                break;
            }
            this.notes_.add(new Note(undo.ntNew));
        } else if (undo.ntOrig == null) {
            this.notes_.add(new Note(undo.ntNew));
        } else {
            Iterator nit = this.notes_.iterator();
            while (nit.hasNext()) {
                Note note = (Note)nit.next();
                if (!note.getID().equals(undo.ntOrig.getID())) continue;
                this.notes_.remove(note);
                break;
            }
        }
    }

    public void removeGroup(String key) {
        Iterator git = this.groups_.iterator();
        Group match = null;
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (!group.getID().equals(key)) continue;
            this.groups_.remove(group);
            match = group;
            break;
        }
        if (match == null) {
            throw new IllegalArgumentException();
        }
        Set subs = match.getSubsets(this);
        Iterator subit = subs.iterator();
        block1: while (subit.hasNext()) {
            String subID = (String)subit.next();
            Iterator grit = this.groups_.iterator();
            while (grit.hasNext()) {
                Group group = (Group)grit.next();
                if (!group.getID().equals(subID)) continue;
                this.groups_.remove(group);
                continue block1;
            }
        }
    }

    public ProxyChange removeGroupNoChecks(String key) {
        Iterator git = this.groups_.iterator();
        Group match = null;
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (!group.getID().equals(key)) continue;
            this.groups_.remove(group);
            match = group;
            break;
        }
        ProxyChange retval = new ProxyChange();
        retval.proxyID = this.id_;
        retval.removedGroup = match;
        return retval;
    }

    public void removeSubGroup(String key) {
        Iterator git = this.groups_.iterator();
        while (git.hasNext()) {
            Group grpChk = (Group)git.next();
            String active = grpChk.getActiveSubset();
            if (active == null || !active.equals(key)) continue;
            grpChk.setActiveSubset(null);
            break;
        }
        git = this.groups_.iterator();
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (!group.getID().equals(key)) continue;
            if (!group.isASubset(this.getVfgParent())) {
                throw new IllegalArgumentException();
            }
            this.groups_.remove(group);
            return;
        }
        throw new IllegalArgumentException();
    }

    public void undoGroupChange(GenomeChange undo) {
        if (undo.grOrig != null && undo.grNew != null) {
            Iterator git = this.groups_.iterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (!group.getID().equals(undo.grNew.getID())) continue;
                this.groups_.remove(group);
                break;
            }
            this.groups_.add(undo.grOrig.copyForProxy());
        } else if (undo.grOrig == null) {
            Iterator git = this.groups_.iterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (!group.getID().equals(undo.grNew.getID())) continue;
                this.groups_.remove(group);
                break;
            }
        } else {
            this.groups_.add(undo.grOrig.copyForProxy());
        }
    }

    public void redoGroupChange(GenomeChange undo) {
        if (undo.grOrig != null && undo.grNew != null) {
            Iterator git = this.groups_.iterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (!group.getID().equals(undo.grOrig.getID())) continue;
                this.groups_.remove(group);
                break;
            }
            this.groups_.add(undo.grNew.copyForProxy());
        } else if (undo.grOrig == null) {
            this.groups_.add(undo.grNew.copyForProxy());
        } else {
            Iterator git = this.groups_.iterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (!group.getID().equals(undo.grOrig.getID())) continue;
                this.groups_.remove(group);
                break;
            }
        }
    }

    public ProxyChange addExtraNode(AddedNode added) {
        Iterator anit = this.addedNodes_.iterator();
        while (anit.hasNext()) {
            AddedNode an = (AddedNode)anit.next();
            if (!added.nodeName.equals(an.nodeName)) continue;
            throw new IllegalArgumentException();
        }
        this.addedNodes_.add(new AddedNode(added));
        ProxyChange retval = new ProxyChange();
        retval.proxyID = this.id_;
        retval.addedNew = new AddedNode(added);
        retval.addedOld = null;
        return retval;
    }

    public ProxyChange deleteExtraNode(String nodeID) {
        ProxyChange retval = new ProxyChange();
        retval.proxyID = this.id_;
        retval.addedNew = null;
        for (int i = 0; i < this.addedNodes_.size(); ++i) {
            AddedNode an = (AddedNode)this.addedNodes_.get(i);
            if (!an.nodeName.equals(nodeID)) continue;
            retval.addedOld = new AddedNode(an);
            this.addedNodes_.remove(i);
            break;
        }
        retval.moduleChanges = this.dropModuleMembersForExtraNode(nodeID);
        return retval;
    }

    public ProxyChange[] deleteIllegalExtraNodes() {
        GenomeInstance parent = this.getVfgParent();
        int generation = parent.getGeneration();
        ArrayList<String> deadList = new ArrayList<String>();
        for (int i = 0; i < this.addedNodes_.size(); ++i) {
            AddedNode an = (AddedNode)this.addedNodes_.get(i);
            Group nodeGroup = parent.getGroupForNode(an.nodeName, 0);
            if (nodeGroup == null) continue;
            for (int j = 0; j < this.groups_.size(); ++j) {
                String myID;
                Group g = (Group)this.groups_.get(j);
                String activeID = g.getActiveSubset();
                if (activeID != null || !(myID = Group.buildInheritedID(g.getID(), generation)).equals(nodeGroup.getID())) continue;
                deadList.add(an.nodeName);
            }
        }
        ArrayList<ProxyChange> retvalList = new ArrayList<ProxyChange>();
        for (int i = 0; i < deadList.size(); ++i) {
            String nodeID = (String)deadList.get(i);
            retvalList.add(this.deleteExtraNode(nodeID));
        }
        return retvalList.toArray(new ProxyChange[retvalList.size()]);
    }

    public ProxyChange[] deleteOrphanedExtraNodes() {
        DynamicInstanceProxy dip = this.getProxyParent();
        if (dip == null) {
            return new ProxyChange[0];
        }
        ArrayList<String> deadList = new ArrayList<String>();
        for (int i = 0; i < this.addedNodes_.size(); ++i) {
            AddedNode an = (AddedNode)this.addedNodes_.get(i);
            if (dip.hasAddedNode(an.nodeName)) continue;
            deadList.add(an.nodeName);
        }
        ArrayList<ProxyChange> retvalList = new ArrayList<ProxyChange>();
        for (int i = 0; i < deadList.size(); ++i) {
            String nodeID = (String)deadList.get(i);
            retvalList.add(this.deleteExtraNode(nodeID));
        }
        return retvalList.toArray(new ProxyChange[retvalList.size()]);
    }

    public ProxyChange[] deleteExtraNodesForGroup(String groupID) {
        ArrayList<String> deadList = new ArrayList<String>();
        for (int i = 0; i < this.addedNodes_.size(); ++i) {
            AddedNode an = (AddedNode)this.addedNodes_.get(i);
            if (!an.groupToUse.equals(groupID)) continue;
            deadList.add(an.nodeName);
        }
        ArrayList<ProxyChange> retvalList = new ArrayList<ProxyChange>();
        for (int i = 0; i < deadList.size(); ++i) {
            String nodeID = (String)deadList.get(i);
            retvalList.add(this.deleteExtraNode(nodeID));
        }
        return retvalList.toArray(new ProxyChange[retvalList.size()]);
    }

    public ProxyChange changeExtraNodeGroupBinding(String nodeID, String groupID) {
        ProxyChange retval = new ProxyChange();
        retval.proxyID = this.id_;
        for (int i = 0; i < this.addedNodes_.size(); ++i) {
            AddedNode an = (AddedNode)this.addedNodes_.get(i);
            if (!an.nodeName.equals(nodeID)) continue;
            retval.addedOld = new AddedNode(an);
            an.groupToUse = groupID;
            retval.addedNew = new AddedNode(an);
            break;
        }
        return retval;
    }

    public NetModuleChange[] adjustDynamicGroupModuleMembers(DynamicGenomeInstance dgi) {
        ArrayList<NetModuleChange> preRetval = new ArrayList<NetModuleChange>();
        int numgrp = this.groups_.size();
        HashSet<String> deadMembers = new HashSet<String>();
        Iterator oit = this.getNetworkOverlayIterator();
        while (oit.hasNext()) {
            NetworkOverlay no = (NetworkOverlay)oit.next();
            String noID = no.getID();
            Iterator nmit = no.getModuleIterator();
            while (nmit.hasNext()) {
                NetModule nmod = (NetModule)nmit.next();
                deadMembers.clear();
                Iterator mit = nmod.getMemberIterator();
                while (mit.hasNext()) {
                    int i;
                    NetModuleMember nmm = (NetModuleMember)mit.next();
                    String nmID = nmm.getID();
                    boolean inAGroup = false;
                    boolean isExtra = false;
                    for (i = 0; i < numgrp; ++i) {
                        Group grp = (Group)this.groups_.get(i);
                        if (grp.getActiveSubset() != null || !grp.isInGroup(nmID, dgi)) continue;
                        inAGroup = true;
                        break;
                    }
                    if (!inAGroup) {
                        for (i = 0; i < this.addedNodes_.size(); ++i) {
                            AddedNode an = (AddedNode)this.addedNodes_.get(i);
                            if (!an.nodeName.equals(nmID)) continue;
                            isExtra = true;
                        }
                    }
                    if (inAGroup || isExtra) continue;
                    deadMembers.add(nmID);
                }
                Iterator dit = deadMembers.iterator();
                while (dit.hasNext()) {
                    String memID = (String)dit.next();
                    NetModuleChange nmc = this.deleteMemberFromNetworkModule(noID, nmod, memID);
                    if (nmc == null) continue;
                    preRetval.add(nmc);
                }
            }
        }
        return preRetval.toArray(new NetModuleChange[preRetval.size()]);
    }

    public Iterator getGroupIterator() {
        return this.groups_.iterator();
    }

    public Set getGroupsForOverlayRendering() {
        HashSet<String> retval = new HashSet<String>();
        int numgrp = this.groups_.size();
        for (int i = 0; i < numgrp; ++i) {
            Group grp = (Group)this.groups_.get(i);
            retval.add(grp.getID());
        }
        return retval;
    }

    public Iterator getNoteIterator() {
        return this.notes_.iterator();
    }

    public Iterator getAddedNodeIterator() {
        return this.addedNodes_.iterator();
    }

    public boolean hasAddedNodes() {
        return this.addedNodes_.size() > 0;
    }

    public AddedNode getAddedNode(String nodeID) {
        Iterator anit = this.getAddedNodeIterator();
        while (anit.hasNext()) {
            AddedNode an = (AddedNode)anit.next();
            if (!an.nodeName.equals(nodeID)) continue;
            return an;
        }
        return null;
    }

    public boolean hasAddedNode(String nodeID) {
        Iterator anit = this.getAddedNodeIterator();
        while (anit.hasNext()) {
            AddedNode an = (AddedNode)anit.next();
            if (!an.nodeName.equals(nodeID)) continue;
            return true;
        }
        return false;
    }

    public String getGroupForExtraNode(String nodeID) {
        Iterator anit = this.getAddedNodeIterator();
        while (anit.hasNext()) {
            AddedNode an = (AddedNode)anit.next();
            if (!an.nodeName.equals(nodeID)) continue;
            return an.groupToUse;
        }
        return null;
    }

    public void clearCache() {
        this.cache_.clear();
    }

    public DynamicGenomeInstance getAnInstance() {
        String dgiKey = this.isSingle() ? (String)this.getProxiedKeys().iterator().next() : this.getKeyForTime(this.getMinimumTime(), true);
        return this.getProxiedInstance(dgiKey);
    }

    public DynamicGenomeInstance getProxiedInstance(String key) {
        DynamicGenomeInstance retval = (DynamicGenomeInstance)this.cache_.get(key);
        if (retval != null) {
            return retval;
        }
        GenomeInstance parent = this.getVfgParent();
        String ti = key.substring(key.lastIndexOf(KEY_PREF_) + 1);
        if (ti.equals("ALL")) {
            Iterator imgKit = this.imageKeys_.keySet().iterator();
            String imgKey = imgKit.hasNext() ? (String)this.imageKeys_.get(imgKit.next()) : null;
            retval = new DynamicGenomeInstance(this.name_, key, parent, this.id_, imgKey);
            retval.setTime(this.getSortedTimes());
        } else {
            int time;
            try {
                time = Integer.parseInt(ti);
            }
            catch (NumberFormatException nfex) {
                System.err.println(key + " " + ti);
                throw new IllegalArgumentException();
            }
            TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
            boolean namedStages = tad.haveNamedStages();
            String displayUnits = tad.unitDisplayString();
            String stageName = namedStages ? tad.getNamedStageForIndex((int)time).name : Integer.toString(time);
            ResourceManager rMan = ResourceManager.getManager();
            String format = tad.unitsAreASuffix() ? "dgi.titleFormat" : "dgi.titleFormatPrefix";
            String dgiTitle = MessageFormat.format(rMan.getString(format), this.name_, stageName, displayUnits);
            String imgKey = (String)this.imageKeys_.get(new Integer(time));
            retval = new DynamicGenomeInstance(dgiTitle, key, parent, this.id_, imgKey);
            HashSet<Integer> singleton = new HashSet<Integer>();
            singleton.add(new Integer(time));
            retval.setTime(singleton);
        }
        this.cache_.put(key, retval);
        return retval;
    }

    public String getProxiedInstanceName(String key) {
        int time;
        String hr = key.substring(key.lastIndexOf(KEY_PREF_) + 1);
        if (hr.equals("ALL")) {
            return this.name_;
        }
        try {
            time = Integer.parseInt(hr);
        }
        catch (NumberFormatException nfex) {
            System.err.println(key + " " + hr);
            throw new IllegalArgumentException();
        }
        TimeAxisDefinition tad = Database.getDB().getTimeAxisDefinition();
        boolean namedStages = tad.haveNamedStages();
        String displayUnits = tad.unitDisplayString();
        String stageName = namedStages ? tad.getNamedStageForIndex((int)time).name : Integer.toString(time);
        ResourceManager rMan = ResourceManager.getManager();
        String format = tad.unitsAreASuffix() ? "dgi.nameFormat" : "dgi.nameFormatPrefix";
        String dgiName = MessageFormat.format(rMan.getString(format), this.name_, stageName, displayUnits);
        return dgiName;
    }

    public String getName() {
        return this.name_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<dynamicProxy ");
        out.print("name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        if (this.min_ != -1) {
            out.print("\" minHour=\"");
            out.print(this.min_);
        }
        if (this.max_ != -1) {
            out.print("\" maxHour=\"");
            out.print(this.max_);
        }
        if (this.isSingle_) {
            out.print("\" isSingle=\"true");
        }
        out.print("\" id=\"");
        out.print(this.id_);
        out.print("\" vfgParent=\"");
        out.print(this.vfgParent_);
        out.println("\" >");
        ind.up();
        this.writeGroups(out, ind);
        this.writeNotes(out, ind);
        this.writeImages(out, ind);
        this.writeAddedNodes(out, ind);
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        cgc.writeOverlaysToXML(out, ind);
        ind.down().indent();
        out.println("</dynamicProxy>");
    }

    public void addImage(String elemName, Attributes attrs) throws IOException {
        Integer time;
        String imgKey = AttributeExtractor.extractAttribute(elemName, attrs, "dpImage", "img", true);
        if (!this.isSingle_) {
            String timeStr = AttributeExtractor.extractAttribute(elemName, attrs, "dpImage", "time", true);
            try {
                time = Integer.valueOf(timeStr);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
        } else {
            time = new Integer(this.min_);
        }
        this.imageKeys_.put(time, imgKey);
    }

    public void getModulesAttachedToGroup(String grpID, Set attached) {
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            nextOver.getModulesAttachedToGroup(grpID, 2, this.id_, attached);
        }
    }

    Map getNetworkOverlayMap() {
        return this.netOverlays_;
    }

    public NetworkOverlayOwnerChange addNetworkOverlay(NetworkOverlay nmView) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.addNetworkOverlay(nmView);
    }

    public void addNetworkOverlayAndKey(NetworkOverlay nmView) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        cgc.addNetworkOverlayAndKey(nmView);
    }

    public void addNetworkModuleAndKey(String overlayKey, NetModule module) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        cgc.addNetworkModuleAndKey(overlayKey, module);
    }

    public void addNetworkModuleLinkageAndKey(String overlayKey, NetModuleLinkage linkage) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        cgc.addNetworkModuleLinkageAndKey(overlayKey, linkage);
    }

    public NetworkOverlayChange addNetworkModuleLinkage(String overlayKey, NetModuleLinkage linkage) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.addNetworkModuleLinkage(overlayKey, linkage);
    }

    public NetworkOverlayChange removeNetworkModuleLinkage(String overlayKey, String linkageKey) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.removeNetworkModuleLinkage(overlayKey, linkageKey);
    }

    public NetworkOverlayChange modifyNetModuleLinkage(String overlayKey, String linkKey, int newSign) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.modifyNetModuleLinkage(overlayKey, linkKey, newSign);
    }

    public NetworkOverlayOwnerChange removeNetworkOverlay(String key) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.removeNetworkOverlay(key);
    }

    public NetworkOverlay getNetworkOverlay(String key) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.getNetworkOverlay(key);
    }

    public Iterator getNetworkOverlayIterator() {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.getNetworkOverlayIterator();
    }

    public int getNetworkOverlayCount() {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.getNetworkOverlayCount();
    }

    public int getNetworkModuleCount() {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.getNetworkModuleCount();
    }

    public NetworkOverlayChange addNetworkModule(String overlayKey, NetModule module) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.addNetworkModule(overlayKey, module);
    }

    public NetworkOverlayChange[] removeNetworkModule(String overlayKey, String moduleKey) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.removeNetworkModule(overlayKey, moduleKey);
    }

    public NetModuleChange addMemberToNetworkModule(String overlayKey, NetModule module, String nodeID) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.addMemberToNetworkModule(overlayKey, module, nodeID);
    }

    public NetModuleChange deleteMemberFromNetworkModule(String overlayKey, NetModule module, String nodeID) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.deleteMemberFromNetworkModule(overlayKey, module, nodeID);
    }

    public Map findMatchingNetworkModules(int searchMode, String key, NameValuePair nvPair) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.findMatchingNetworkModules(searchMode, key, nvPair);
    }

    public String getFirstViewPreference(TaggedSet modChoice, TaggedSet revChoice) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        return cgc.getFirstViewPreference(modChoice, revChoice);
    }

    public int overlayModeForOwner() {
        return 2;
    }

    public void overlayChangeUndo(NetworkOverlayOwnerChange undo) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        cgc.overlayChangeUndo(undo);
    }

    public void overlayChangeRedo(NetworkOverlayOwnerChange redo) {
        CommonGenomeCode cgc = new CommonGenomeCode(this, 2, this.netOverlays_);
        cgc.overlayChangeRedo(redo);
    }

    public void fillMapsForGroupExtraction(String grpID, Map keyMap) {
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            nextOver.fillMapForGroupExtraction(grpID, keyMap, this.overlayModeForOwner(), this.id_);
        }
    }

    public static boolean isDynamicInstance(String key) {
        return key.startsWith("{DiP}@");
    }

    public static String extractProxyID(String key) {
        Pattern p = Pattern.compile(".+-(.+):[^:]+");
        Matcher pm = p.matcher(key);
        if (pm.matches()) {
            return pm.group(1);
        }
        System.err.println("I don't match " + key);
        throw new IllegalArgumentException();
    }

    public static String extractTime(String key) {
        Pattern p = Pattern.compile(".+-(.+):([^:]+)");
        Matcher pm = p.matcher(key);
        if (pm.matches()) {
            return pm.group(2);
        }
        System.err.println("I don't match " + key);
        throw new IllegalArgumentException();
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("dynamicProxy");
        return retval;
    }

    public static String addedNodeKeyword() {
        return "addedNode";
    }

    public static String imageKeyword() {
        return "dpImage";
    }

    public static AddedNode extractAddedNode(String elemName, Attributes attrs) throws IOException {
        String extraName = AttributeExtractor.extractAttribute(elemName, attrs, "addedNode", "ref", true);
        String fromGroup = AttributeExtractor.extractAttribute(elemName, attrs, "addedNode", "fromGroup", true);
        return new AddedNode(extraName, fromGroup);
    }

    public static DynamicInstanceProxy buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("dynamicProxy")) {
            return null;
        }
        String name = null;
        String id = null;
        String parentVfg = null;
        String minHour = null;
        String maxHour = null;
        String isSingle = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("vfgParent")) {
                    parentVfg = val;
                    continue;
                }
                if (key.equals("minHour")) {
                    minHour = val;
                    continue;
                }
                if (key.equals("maxHour")) {
                    maxHour = val;
                    continue;
                }
                if (!key.equals("isSingle")) continue;
                isSingle = val;
            }
        }
        if (name == null || id == null || parentVfg == null) {
            throw new IOException();
        }
        Database db = Database.getDB();
        GenomeInstance vfg = (GenomeInstance)db.getGenome(parentVfg);
        return new DynamicInstanceProxy(name, id, vfg, isSingle, minHour, maxHour);
    }

    protected DynamicInstanceProxy() {
    }

    private void writeGroups(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<dpGroups>");
        Iterator grit = this.groups_.iterator();
        ind.up();
        while (grit.hasNext()) {
            Group g = (Group)grit.next();
            g.writeXML(out, ind, true);
        }
        ind.down().indent();
        out.println("</dpGroups>");
    }

    private void writeNotes(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<dpNotes>");
        Iterator nit = this.notes_.iterator();
        ind.up();
        while (nit.hasNext()) {
            Note n = (Note)nit.next();
            n.writeXML(out, ind, true);
        }
        ind.down().indent();
        out.println("</dpNotes>");
    }

    private void writeAddedNodes(PrintWriter out, Indenter ind) {
        Iterator anit = this.addedNodes_.iterator();
        while (anit.hasNext()) {
            AddedNode an = (AddedNode)anit.next();
            ind.indent();
            out.print("<addedNode ");
            out.print("ref=\"");
            out.print(an.nodeName);
            out.print("\" fromGroup=\"");
            out.print(an.groupToUse);
            out.println("\" />");
        }
    }

    private void writeImages(PrintWriter out, Indenter ind) {
        if (this.imageKeys_.isEmpty()) {
            return;
        }
        ind.indent();
        out.println("<dpImages>");
        TreeSet sortkeys = new TreeSet(this.imageKeys_.keySet());
        Iterator skit = sortkeys.iterator();
        ind.up();
        while (skit.hasNext()) {
            Integer key = (Integer)skit.next();
            String img = (String)this.imageKeys_.get(key);
            ind.indent();
            out.print("<dpImage ");
            out.print("img=\"");
            out.print(img);
            if (!this.isSingle_) {
                out.print("\" time=\"");
                out.print(key);
            }
            out.println("\" />");
        }
        ind.down().indent();
        out.println("</dpImages>");
    }

    private TreeSet getSortedTimes() {
        if (this.sortedTimes_ == null) {
            this.sortedTimes_ = new TreeSet();
            for (int i = this.min_; i <= this.max_; ++i) {
                this.sortedTimes_.add(new Integer(i));
            }
        }
        return this.sortedTimes_;
    }

    public NetModuleChange[] dropModuleMembersForExtraNode(String extraID) {
        ArrayList<NetModuleChange> preRetval = new ArrayList<NetModuleChange>();
        Iterator oit = this.getNetworkOverlayIterator();
        while (oit.hasNext()) {
            NetworkOverlay no = (NetworkOverlay)oit.next();
            String noID = no.getID();
            Iterator nmit = no.getModuleIterator();
            while (nmit.hasNext()) {
                NetModuleChange nmc;
                NetModule nmod = (NetModule)nmit.next();
                if (!nmod.isAMember(extraID) || (nmc = this.deleteMemberFromNetworkModule(noID, nmod, extraID)) == null) continue;
                preRetval.add(nmc);
            }
        }
        return preRetval.toArray(new NetModuleChange[preRetval.size()]);
    }

    public static class ChangeBundle {
        public ProxyChange proxyChange;
        public ImageChange[] imageChanges;
        public UserTreePathChange[] pathChanges;
        public DatabaseChange dc;
    }

    public static class AddedNode
    implements Cloneable {
        public String nodeName;
        public String groupToUse;

        public AddedNode(String nodeName, String groupToUse) {
            this.nodeName = nodeName;
            this.groupToUse = groupToUse;
        }

        public AddedNode(AddedNode other) {
            this.nodeName = other.nodeName;
            this.groupToUse = other.groupToUse;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }
    }
}

