/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.xml.sax.Attributes;

public class DynamicInstanceProxyFactory
extends AbstractFactoryClient {
    private static final int NONE_ = 0;
    private static final int NOTE_ = 1;
    private Set proxyKeys_ = DynamicInstanceProxy.keywordsOfInterest();
    private Set groupKeys_ = Group.keywordsOfInterest(true);
    private Set noteKeys_ = Note.keywordsOfInterest(true);
    private String addedNodeKey_ = DynamicInstanceProxy.addedNodeKeyword();
    private String imageKey_ = DynamicInstanceProxy.imageKeyword();
    private DynamicInstanceProxy currDip_;
    private Note currNote_;
    private int charTarget_;

    public DynamicInstanceProxyFactory() {
        super(new FactoryWhiteboard());
        FactoryWhiteboard whiteboard = (FactoryWhiteboard)this.sharedWhiteboard_;
        whiteboard.genomeType = 0;
        this.installWorker(new NetworkOverlay.NetOverlayWorker(whiteboard), new MyGlue());
        this.myKeys_.addAll(this.proxyKeys_);
    }

    protected void localFinishElement(String elemName) {
        if (this.currNote_ != null) {
            this.currNote_ = null;
        }
        this.charTarget_ = 0;
    }

    protected void localProcessCharacters(char[] chars, int start, int length) {
        String nextString = new String(chars, start, length);
        switch (this.charTarget_) {
            case 0: {
                break;
            }
            case 1: {
                if (this.currNote_ == null) break;
                this.currNote_.appendToNote(nextString);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
        if (this.proxyKeys_.contains(elemName)) {
            DynamicInstanceProxy dip = DynamicInstanceProxy.buildFromXML(elemName, attrs);
            if (dip != null) {
                Database db = Database.getDB();
                db.addDynamicProxy(dip.getID(), dip);
                NavTree tree = db.getNavTree();
                GenomeInstance parent = dip.getVfgParent();
                String parentID = parent.getID();
                if (dip.isSingle()) {
                    List newNodes = dip.getProxiedKeys();
                    Iterator nnit = newNodes.iterator();
                    while (nnit.hasNext()) {
                        String key = (String)nnit.next();
                        tree.addNode(dip.getProxiedInstanceName(key), parentID, key);
                    }
                } else {
                    tree.addProxyNode(dip.getName(), parentID, dip.getID());
                }
                this.currDip_ = dip;
                ((FactoryWhiteboard)this.sharedWhiteboard_).prox = dip;
                return dip;
            }
        } else if (this.groupKeys_.contains(elemName)) {
            Group newGroup = Group.buildFromXML(elemName, attrs);
            if (newGroup != null) {
                this.currDip_.addGroup(newGroup);
            }
        } else if (this.noteKeys_.contains(elemName)) {
            Note newNote = Note.buildFromXML(elemName, attrs);
            if (newNote != null) {
                this.charTarget_ = 1;
                this.currNote_ = newNote;
                this.currDip_.addNote(this.currNote_);
            }
        } else if (this.addedNodeKey_.equals(elemName)) {
            this.currDip_.addExtraNode(DynamicInstanceProxy.extractAddedNode(elemName, attrs));
        } else if (this.imageKey_.equals(elemName)) {
            this.currDip_.addImage(elemName, attrs);
        }
        return null;
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            DynamicInstanceProxy prox = board.prox;
            NetworkOverlay netOvr = board.netOvr;
            if (netOvr != null) {
                prox.addNetworkOverlayAndKey(netOvr);
            }
            return null;
        }
    }
}

