/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.TopOfTheHeap;
import org.systemsbiology.biotapestry.plugin.InternalLinkDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;

public class FreeLinkTextDisplayPlugIn
implements InternalLinkDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        if (!haveInstance) {
            return false;
        }
        Linkage link = genome.getLinkage(itemID);
        String desc = link.getDescription();
        return desc != null;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String linkId) {
        return null;
    }

    public String getDataAsHTML(String genomeID, String linkId) {
        StringBuffer buf = new StringBuffer();
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        Database db = Database.getDB();
        Linkage link = genome.getLinkage(linkId);
        String desc = link.getDescription();
        if (desc == null && haveInstance) {
            Genome useGenome = db.getGenome();
            String useID = GenomeItemInstance.getBaseID(linkId);
            link = useGenome.getLinkage(useID);
            desc = link.getDescription();
        }
        if (desc != null) {
            buf.append("<p>");
            buf.append(desc);
            buf.append("</p>");
        }
        return buf.toString();
    }
}

