/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.TopOfTheHeap;
import org.systemsbiology.biotapestry.plugin.InternalNodeDataDisplayPlugIn;
import org.systemsbiology.biotapestry.plugin.PluginCallbackWorker;

public class FreeTextDisplayPlugIn
implements InternalNodeDataDisplayPlugIn {
    public boolean isInternal() {
        return true;
    }

    public boolean requiresPerInstanceDisplay(String genomeID, String itemID) {
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        if (!haveInstance) {
            return false;
        }
        Node node = genome.getNode(itemID);
        String desc = node.getDescription();
        return desc != null;
    }

    public boolean haveCallbackWorker() {
        return false;
    }

    public PluginCallbackWorker getCallbackWorker(String genomeID, String nodeID) {
        return null;
    }

    public String getDataAsHTML(String genomeID, String nodeID) {
        StringBuffer buf = new StringBuffer();
        TopOfTheHeap tooth = new TopOfTheHeap(genomeID);
        Genome genome = tooth.getGenome();
        boolean haveInstance = tooth.isInstance();
        Database db = Database.getDB();
        Node node = genome.getNode(nodeID);
        String desc = node.getDescription();
        if (desc == null && haveInstance) {
            Genome useGenome = db.getGenome();
            String useID = GenomeItemInstance.getBaseID(nodeID);
            node = useGenome.getNode(useID);
            desc = node.getDescription();
        }
        if (desc != null) {
            buf.append("<p>");
            buf.append(desc);
            buf.append("</p>");
        }
        return buf.toString();
    }
}

