/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.nav.LayoutManager;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.NameValuePairList;
import org.systemsbiology.biotapestry.util.ObjChoiceContent;

public class FullGenomeHierarchyOracle {
    public List orderedModels() {
        ArrayList<Link> linkList = new ArrayList<Link>();
        ArrayList<String> nodeList = new ArrayList<String>();
        Database db = Database.getDB();
        String rootModel = db.getGenome().getID();
        nodeList.add(rootModel);
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            String myID = gi.getID();
            nodeList.add(gi.getID());
            GenomeInstance pgi = gi.getVfgParent();
            String parID = pgi == null ? rootModel : pgi.getID();
            Link link = new Link(parID, myID);
            linkList.add(link);
        }
        GraphSearcher search = new GraphSearcher(nodeList, linkList);
        List depthFirst = search.depthSearch();
        ArrayList<String> retval = new ArrayList<String>();
        int num = depthFirst.size();
        for (int i = 0; i < num; ++i) {
            retval.add(((GraphSearcher.QueueEntry)depthFirst.get((int)i)).name);
        }
        return retval;
    }

    public Vector topLevelInstanceModels() {
        Database db = Database.getDB();
        Iterator iit = db.getInstanceIterator();
        Vector<ObjChoiceContent> retval = new Vector<ObjChoiceContent>();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            if (gi.getVfgParent() != null) continue;
            ObjChoiceContent occ = new ObjChoiceContent(gi.getName(), gi.getID());
            retval.add(occ);
        }
        Collections.sort(retval);
        return retval;
    }

    public boolean hourlyDynamicModelExists() {
        Database db = Database.getDB();
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            if (dip.isSingle()) continue;
            return true;
        }
        return false;
    }

    public void fillMapsForGroupExtraction(GenomeInstance rootInstance, String grpID, Map keyMap) {
        if (!rootInstance.isRootInstance()) {
            throw new IllegalArgumentException();
        }
        rootInstance.fillMapsForGroupExtraction(grpID, keyMap);
        String baseID = Group.getBaseID(grpID);
        Database db = Database.getDB();
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            if (rootInstance == gi || !rootInstance.isAncestor(gi)) continue;
            int genCount = gi.getGeneration();
            String inherit = Group.buildInheritedID(baseID, genCount);
            gi.fillMapsForGroupExtraction(inherit, keyMap);
        }
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            if (!dip.instanceIsAncestor(rootInstance)) continue;
            DynamicGenomeInstance kid = dip.getAnInstance();
            String inherit = Group.buildInheritedID(baseID, kid.getGeneration());
            dip.fillMapsForGroupExtraction(inherit, keyMap);
        }
    }

    public void getModulesAttachedToGroup(GenomeInstance rootInstance, String grpID, Set attached) {
        if (!rootInstance.isRootInstance()) {
            throw new IllegalArgumentException();
        }
        rootInstance.getModulesAttachedToGroup(grpID, attached);
        String baseID = Group.getBaseID(grpID);
        Database db = Database.getDB();
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            if (rootInstance == gi || !rootInstance.isAncestor(gi)) continue;
            int genCount = gi.getGeneration();
            String inherit = Group.buildInheritedID(baseID, genCount);
            gi.getModulesAttachedToGroup(inherit, attached);
        }
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            if (!dip.instanceIsAncestor(rootInstance)) continue;
            DynamicGenomeInstance kid = dip.getAnInstance();
            String inherit = Group.buildInheritedID(baseID, kid.getGeneration());
            dip.getModulesAttachedToGroup(inherit, attached);
        }
    }

    public Layout.OverlayKeySet allFullModuleKeys(boolean addEmptyOverlayKeys) {
        Layout.OverlayKeySet retval = new Layout.OverlayKeySet();
        List allOwners = this.getAllOverlayOwners();
        int numOwn = allOwners.size();
        for (int i = 0; i < numOwn; ++i) {
            NetOverlayOwner owner = (NetOverlayOwner)allOwners.get(i);
            int ownerMode = owner.overlayModeForOwner();
            String ownerID = owner.getID();
            Iterator noit = owner.getNetworkOverlayIterator();
            while (noit.hasNext()) {
                NetworkOverlay novr = (NetworkOverlay)noit.next();
                String ovrID = novr.getID();
                if (addEmptyOverlayKeys && novr.getModuleCount() == 0) {
                    NetModule.FullModuleKey fullKey = new NetModule.FullModuleKey(ownerMode, ownerID, ovrID, null);
                    retval.addKey(fullKey);
                }
                Iterator nmit = novr.getModuleIterator();
                while (nmit.hasNext()) {
                    NetModule nmod = (NetModule)nmit.next();
                    String modID = nmod.getID();
                    NetModule.FullModuleKey fullKey = new NetModule.FullModuleKey(ownerMode, ownerID, ovrID, modID);
                    retval.addKey(fullKey);
                }
            }
        }
        return retval;
    }

    public Map fullModuleKeysPerLayout() {
        return this.fullModuleKeysPerLayout(false);
    }

    public Map fullModuleKeysPerLayout(boolean addEmptyOverlayKeys) {
        HashMap<String, Layout.OverlayKeySet> retval = new HashMap<String, Layout.OverlayKeySet>();
        Database db = Database.getDB();
        LayoutManager loman = new LayoutManager();
        Layout.OverlayKeySet allFullKeys = this.allFullModuleKeys(addEmptyOverlayKeys);
        Iterator afkit = allFullKeys.iterator();
        while (afkit.hasNext()) {
            String genKey;
            NetModule.FullModuleKey fullKey = (NetModule.FullModuleKey)afkit.next();
            if (fullKey.ownerType == 2) {
                DynamicInstanceProxy dip = db.getDynamicProxy(fullKey.ownerKey);
                genKey = dip.getFirstProxiedKey();
            } else {
                genKey = fullKey.ownerKey;
            }
            String loKey = loman.getLayout(genKey);
            Layout.OverlayKeySet keysForLayout = (Layout.OverlayKeySet)retval.get(loKey);
            if (keysForLayout == null) {
                keysForLayout = new Layout.OverlayKeySet();
                retval.put(loKey, keysForLayout);
            }
            keysForLayout.addKey(fullKey);
        }
        return retval;
    }

    public boolean overlayExists() {
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        if (genome.getNetworkOverlayCount() > 0) {
            return true;
        }
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            if (gi.getNetworkOverlayCount() <= 0) continue;
            return true;
        }
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            if (dip.getNetworkOverlayCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public List getAllOverlayOwners() {
        Database db = Database.getDB();
        ArrayList<NetOverlayOwner> allOwners = new ArrayList<NetOverlayOwner>();
        Genome genome = db.getGenome();
        allOwners.add(genome);
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            allOwners.add(gi);
        }
        Iterator dpit = db.getDynamicProxyIterator();
        while (dpit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)dpit.next();
            allOwners.add(dip);
        }
        return allOwners;
    }

    public void getGlobalTagsAndNVPairsForModules(Map nvPairs, Set allNames, Set allVals, Set tags, NetModule skipMe) {
        List allOwners = this.getAllOverlayOwners();
        int numOwn = allOwners.size();
        for (int i = 0; i < numOwn; ++i) {
            NetOverlayOwner owner = (NetOverlayOwner)allOwners.get(i);
            Iterator noit = owner.getNetworkOverlayIterator();
            while (noit.hasNext()) {
                NetworkOverlay novr = (NetworkOverlay)noit.next();
                Iterator nmit = novr.getModuleIterator();
                while (nmit.hasNext()) {
                    NetModule nmod = (NetModule)nmit.next();
                    if (skipMe != null && skipMe == nmod) continue;
                    NameValuePairList nvpl = nmod.getNVPairs();
                    Iterator nvit = nvpl.getIterator();
                    while (nvit.hasNext()) {
                        NameValuePair nvp = (NameValuePair)nvit.next();
                        String name = nvp.getName();
                        String normName = DataUtil.normKey(name);
                        HashSet<String> valsForName = (HashSet<String>)nvPairs.get(normName);
                        if (valsForName == null) {
                            valsForName = new HashSet<String>();
                            nvPairs.put(normName, valsForName);
                        }
                        allNames.add(name);
                        String val = nvp.getValue();
                        allVals.add(val);
                        valsForName.add(val);
                    }
                    Iterator ti = nmod.getTagIterator();
                    while (ti.hasNext()) {
                        String tag = (String)ti.next();
                        tags.add(tag);
                    }
                }
            }
        }
    }

    public PadCalculatorToo.PadResult getNodePadRequirements(String backingID) {
        Database db = Database.getDB();
        Genome genome = db.getGenome();
        Node baseNode = genome.getNode(backingID);
        PadCalculatorToo.PadResult res = genome.getNodePadRequirements(baseNode);
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            GenomeInstance gi = (GenomeInstance)git.next();
            Set instances = gi.getNodeInstances(backingID);
            Iterator iit = instances.iterator();
            while (iit.hasNext()) {
                String nodeID = (String)iit.next();
                Node node = gi.getNode(nodeID);
                PadCalculatorToo.PadResult giRes = gi.getNodePadRequirements(node);
                if (giRes.launch > res.launch) {
                    res.launch = giRes.launch;
                }
                if (giRes.landing <= res.landing) continue;
                res.landing = giRes.landing;
            }
        }
        return res;
    }
}

