/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.systemsbiology.biotapestry.analysis.GraphSearcher;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.InstructionRegions;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.util.DataUtil;

public class FullHierarchyBuilder {
    public List unifyInstructions(Map buildCmds) {
        Database db = Database.getDB();
        ArrayList<BuildInstruction> retval = new ArrayList<BuildInstruction>();
        Iterator bit = buildCmds.keySet().iterator();
        while (bit.hasNext()) {
            String modelName = (String)bit.next();
            List iList = (List)buildCmds.get(modelName);
            int num = iList.size();
            for (int i = 0; i < num; ++i) {
                BuildInstruction bi = (BuildInstruction)iList.get(i);
                int need = this.numberPresentWithSameRegions(bi, iList);
                int have = this.numberPresent(bi, retval);
                int diff = need - have;
                for (int j = 0; j < diff; ++j) {
                    BuildInstruction newBI = (BuildInstruction)bi.clone();
                    newBI.setID(db.getNextInstructionLabel());
                    newBI.setRegions(null);
                    retval.add(newBI);
                }
            }
        }
        return retval;
    }

    public Map buildUnifiedCommands(Map cmdByID, List topDownID) {
        List unified = this.unifyInstructions(cmdByID);
        int uniNum = unified.size();
        HashMap uniCmds = new HashMap();
        Iterator ciit = cmdByID.keySet().iterator();
        while (ciit.hasNext()) {
            String modelID = (String)ciit.next();
            ArrayList<Object> cmdList = new ArrayList<Object>();
            uniCmds.put(modelID, cmdList);
            for (int i = 0; i < uniNum; ++i) {
                BuildInstruction cmd = (BuildInstruction)unified.get(i);
                cmdList.add(cmd.clone());
            }
        }
        Iterator cit = cmdByID.keySet().iterator();
        while (cit.hasNext()) {
            String modelID = (String)cit.next();
            List origList = (List)cmdByID.get(modelID);
            List uniList = (List)uniCmds.get(modelID);
            int olNum = origList.size();
            int ulNum = uniList.size();
            for (int j = 0; j < ulNum; ++j) {
                BuildInstruction ubi = (BuildInstruction)uniList.get(j);
                if (ubi.hasRegions() || modelID.equals(topDownID.get(0))) continue;
                ubi.setRegions(new InstructionRegions());
            }
            for (int i = 0; i < olNum; ++i) {
                BuildInstruction bi = (BuildInstruction)origList.get(i);
                InstructionRegions ir = bi.getRegions();
                if (!bi.hasRegions()) continue;
                Iterator rtit = ir.getRegionTuples();
                while (rtit.hasNext()) {
                    InstructionRegions.RegionTuple tup = (InstructionRegions.RegionTuple)rtit.next();
                    for (int j = 0; j < ulNum; ++j) {
                        InstructionRegions uir;
                        BuildInstruction ubi = (BuildInstruction)uniList.get(j);
                        if (!ubi.sameDefinition(bi) || (uir = ubi.getRegions()).hasTuple(tup)) continue;
                        uir.addRegionTuple(tup);
                    }
                }
            }
        }
        return uniCmds;
    }

    public int numberPresent(BuildInstruction bi, List cmds) {
        int retval = 0;
        int num = cmds.size();
        for (int i = 0; i < num; ++i) {
            BuildInstruction chkbi = (BuildInstruction)cmds.get(i);
            if (!chkbi.sameDefinition(bi)) continue;
            ++retval;
        }
        return retval;
    }

    public int numberPresentWithSameRegions(BuildInstruction bi, List cmds) {
        int retval = 0;
        int num = cmds.size();
        for (int i = 0; i < num; ++i) {
            BuildInstruction chkbi = (BuildInstruction)cmds.get(i);
            if (!bi.getID().equals(chkbi.getID())) {
                throw new IllegalArgumentException();
            }
            if (!chkbi.equals(bi)) continue;
            ++retval;
        }
        return retval;
    }

    public void populateParentInstances(List bottomUp, Map buildCmds, Map regions) {
        Database db = Database.getDB();
        int num = bottomUp.size();
        for (int i = 0; i < num; ++i) {
            GenomeInstance gi;
            GenomeInstance parent;
            String id = (String)bottomUp.get(i);
            Genome genome = db.getGenome(id);
            if (!(genome instanceof GenomeInstance) || (parent = (gi = (GenomeInstance)genome).getVfgParent()) == null) continue;
            List cmds = (List)buildCmds.get(id);
            List pCmds = (List)buildCmds.get(parent.getID());
            int nCmds = cmds.size();
            for (int j = 0; j < nCmds; ++j) {
                BuildInstruction bi = (BuildInstruction)cmds.get(j);
                int need = this.numberPresentWithSameRegions(bi, cmds);
                int have = this.numberPresentWithSameRegions(bi, pCmds);
                int diff = need - have;
                for (int k = 0; k < diff; ++k) {
                    BuildInstruction newBI = (BuildInstruction)bi.clone();
                    pCmds.add(newBI);
                }
            }
            List regs = (List)regions.get(id);
            List pregs = (List)regions.get(parent.getID());
            int nRegs = regs.size();
            for (int j = 0; j < nRegs; ++j) {
                InstanceInstructionSet.RegionInfo ri = (InstanceInstructionSet.RegionInfo)regs.get(j);
                if (pregs.contains(ri)) continue;
                pregs.add(new InstanceInstructionSet.RegionInfo(ri));
            }
        }
    }

    public String orderModelDefinitions(Map modelDefs, List modelInputOrder, List bottomUp, List topDown) {
        int i;
        String rootName = null;
        ArrayList<Link> linkList = new ArrayList<Link>();
        HashSet<String> nodeSet = new HashSet<String>();
        ArrayList<String> nodeList = new ArrayList<String>();
        int numIO = modelInputOrder.size();
        for (int i2 = 0; i2 < numIO; ++i2) {
            String modName = (String)modelInputOrder.get(i2);
            modName = DataUtil.normKey(modName);
            ModelDef md = (ModelDef)modelDefs.get(modName);
            if (!nodeSet.contains(modName)) {
                nodeList.add(modName);
                nodeSet.add(modName);
            }
            if (md.modelParent == null) {
                rootName = md.modelName;
                continue;
            }
            Link link = new Link(md.modelParent, modName);
            if (linkList.contains(link)) continue;
            linkList.add(link);
        }
        GraphSearcher search = new GraphSearcher(nodeList, linkList);
        List depthFirst = search.depthSearch();
        int num = depthFirst.size();
        for (i = 0; i < num; ++i) {
            topDown.add(((GraphSearcher.QueueEntry)depthFirst.get((int)i)).name);
        }
        for (i = num - 1; i >= 0; --i) {
            bottomUp.add(((GraphSearcher.QueueEntry)depthFirst.get((int)i)).name);
        }
        return DataUtil.normKey(rootName);
    }

    public static class ModelDef {
        String modelName;
        String modelParent;

        ModelDef(String name, String parent) {
            this.modelName = name;
            this.modelParent = parent;
        }

        public String toString() {
            return "ModelDef: name = " + this.modelName + " parent = " + this.modelParent;
        }
    }

    public static class BIPData {
        public List processOrder;
        public Map buildCmds;
        public Map regions;
        public ToolCommands tc;
    }
}

