/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import org.systemsbiology.biotapestry.analysis.Link;
import org.systemsbiology.biotapestry.analysis.TreeEditor;
import org.systemsbiology.biotapestry.app.CommonView;
import org.systemsbiology.biotapestry.app.ExpansionChange;
import org.systemsbiology.biotapestry.app.PopupTree;
import org.systemsbiology.biotapestry.cmd.BuildInstruction;
import org.systemsbiology.biotapestry.cmd.BuildInstructionProcessor;
import org.systemsbiology.biotapestry.cmd.DatabaseChangeCmd;
import org.systemsbiology.biotapestry.cmd.DeleteCommands;
import org.systemsbiology.biotapestry.cmd.InstanceInstructionSet;
import org.systemsbiology.biotapestry.cmd.InstructionRegions;
import org.systemsbiology.biotapestry.cmd.NavTreeChangeCmd;
import org.systemsbiology.biotapestry.cmd.ToolCommands;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.db.DatabaseChange;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.FullHierarchyBuilder;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.nav.NavTreeChange;
import org.systemsbiology.biotapestry.ui.Layout;
import org.systemsbiology.biotapestry.ui.LayoutOptions;
import org.systemsbiology.biotapestry.ui.LayoutOptionsManager;
import org.systemsbiology.biotapestry.ui.LinkRouter;
import org.systemsbiology.biotapestry.util.AsynchExitRequestException;
import org.systemsbiology.biotapestry.util.BTProgressMonitor;
import org.systemsbiology.biotapestry.util.CSVParser;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.InvalidInputException;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.UndoSupport;

public class FullHierarchyCSVFormatFactory {
    private static final int BAD_VALUES_ = -1;
    private static final int MODEL_DEFINITION_ = 0;
    private static final int REGION_DEFINITION_ = 1;
    private static final int BUILD_INSTRUCTION_ = 2;
    private static final String MODEL_DEFINITION_STR_ = "model";
    private static final String REGION_DEFINITION_STR_ = "region";
    public static final String TOO_FEW_TOKENS = "HCSV_TOO_FEW_TOKENS";
    public static final String INCORRECT_INSTRUCTION_DEFINITION = "HCSV_INCORRECT_INSTRUCTION_DEFINITION";
    public static final String DUPLICATE_MODEL_NAME = "HCSV_DUPLICATE_MODEL_NAME";
    public static final String TYPE_MISMATCH = "HCSV_TYPE_MISMATCH";
    public static final String INCONSISTENT_REGIONS = "HCSV_INCONSISTENT_REGIONS";
    public static final String MODELS_NOT_A_TREE = "HCSV_MODELS_NOT_A_TREE";
    public static final String BLANK_TOKEN = "HCSV_BLANK_TOKEN";
    public static final String UNDEFINED_MODEL_NAME = "HCSV_UNDEFINED_MODEL_NAME";
    public static final String BAD_REGION_DEF = "HCSV_BAD_REGION_DEF";
    public static final String BAD_REGION_HIERARCHY = "HCSV_BAD_REGION_HIERARCHY";
    public static final String ROOT_MODEL_HAS_REGIONS = "HCSV_ROOT_MODEL_HAS_REGIONS";
    public static final String INCONSISTENT_LINK_EVIDENCE = "HCSV_INCONSISTENT_LINK_EVIDENCE";
    private CommonView suw_;
    private FullHierarchyBuilder fhb_;

    public FullHierarchyCSVFormatFactory(CommonView suw) {
        this.suw_ = suw;
        this.fhb_ = new FullHierarchyBuilder();
    }

    public FullHierarchyBuilder.BIPData buildFromCSVForeground(File infile, JFrame topWindow, UndoManager undo, boolean doReplacement, UndoSupport support) throws IOException, InvalidInputException {
        HashMap commands = new HashMap();
        HashMap modelDefs = new HashMap();
        HashMap regionDefs = new HashMap();
        ArrayList modelInputOrder = new ArrayList();
        this.readCSV(infile, commands, modelDefs, regionDefs, modelInputOrder);
        return this.buildFromCSVForegroundGuts(commands, modelDefs, regionDefs, modelInputOrder, topWindow, undo, doReplacement, null, support);
    }

    public FullHierarchyBuilder.BIPData buildFromCSVForegroundStream(InputStream stream, JFrame topWindow, UndoManager undo, boolean doReplacement, Map modelIDMap, UndoSupport support) throws IOException, InvalidInputException {
        HashMap commands = new HashMap();
        HashMap modelDefs = new HashMap();
        HashMap regionDefs = new HashMap();
        ArrayList modelInputOrder = new ArrayList();
        this.readCSV(stream, commands, modelDefs, regionDefs, modelInputOrder);
        return this.buildFromCSVForegroundGuts(commands, modelDefs, regionDefs, modelInputOrder, topWindow, undo, doReplacement, modelIDMap, support);
    }

    public LinkRouter.RoutingResult buildFromCSVBackground(FullHierarchyBuilder.BIPData bipd, Point2D center, Dimension size, FontRenderContext frc, boolean doReplacement, UndoSupport support, boolean doOpts, boolean doSquash, int overlayOption, Map nodeIDMap, String dbGenomeCSVName, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LayoutOptions options = new LayoutOptions(LayoutOptionsManager.getMgr().getLayoutOptions());
        options.optimizationPasses = doOpts ? 1 : 0;
        options.inheritanceSquash = doSquash;
        options.overlayOption = overlayOption;
        BuildInstructionProcessor bip = new BuildInstructionProcessor();
        LinkRouter.RoutingResult retval = bip.processInstructionsForFullHierarchy(bipd.processOrder, bipd.buildCmds, bipd.regions, bipd.tc, center, size, frc, !doReplacement, options, nodeIDMap, dbGenomeCSVName, null, false, support, monitor, startFrac, endFrac, 5);
        return retval;
    }

    private FullHierarchyBuilder.BIPData buildFromCSVForegroundGuts(HashMap commands, HashMap modelDefs, HashMap regionDefs, ArrayList modelInputOrder, JFrame topWindow, UndoManager undo, boolean doReplacement, Map modelIDMap, UndoSupport support) throws IOException, InvalidInputException {
        Database db = Database.getDB();
        NavTree nt = db.getNavTree();
        JTree tree = this.suw_.getTree();
        DefaultTreeModel dtm = (DefaultTreeModel)tree.getModel();
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)dtm.getRoot();
        HashMap<String, String> nameToId = new HashMap<String, String>();
        ArrayList bottomUp = new ArrayList();
        ArrayList topDown = new ArrayList();
        String rootName = this.fhb_.orderModelDefinitions(modelDefs, modelInputOrder, bottomUp, topDown);
        ArrayList addedNodes = new ArrayList();
        ArrayList<NavTreeChange> ntcs = new ArrayList<NavTreeChange>();
        ExpansionChange ec = null;
        if (!doReplacement) {
            ArrayList removedNodes = new ArrayList();
            if (!this.compareTreesForReplacement(rootName, modelDefs, nameToId, addedNodes, removedNodes)) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(topWindow, rMan.getString("cSVHierarchy.duplicateModelNameAbort"), rMan.getString("cSVHierarchy.cannotContinue"), 2);
                return null;
            }
            Iterator iit = db.getInstanceIterator();
            while (iit.hasNext()) {
                GenomeInstance gi = (GenomeInstance)iit.next();
                if (!(gi instanceof DynamicGenomeInstance)) continue;
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(topWindow, rMan.getString("cSVHierarchy.dynamicInstanceAbort"), rMan.getString("cSVHierarchy.cannotContinue"), 2);
                return null;
            }
            ec = ((PopupTree)tree).doUndoExpansionChange(support, true);
            int numRem = removedNodes.size();
            DeleteCommands dc = new DeleteCommands(topWindow, undo);
            HashSet deadCollection = new HashSet();
            for (int i = 0; i < numRem; ++i) {
                String deadOneName = (String)removedNodes.get(i);
                String deadOneID = (String)nameToId.get(deadOneName);
                if (deadCollection.contains(deadOneID)) continue;
                Set deadOnes = dc.deleteGenomeInstance(deadOneID, false, support);
                deadCollection.addAll(deadOnes);
                nt.setSkipFlag(2);
                NavTreeChange ntc = nt.deleteNode(deadOneID, deadOnes);
                nt.setSkipFlag(0);
                support.addEdit(new NavTreeChangeCmd(ntc));
                ntcs.add(ntc);
            }
            if (numRem > 0) {
                nt.setSkipFlag(2);
                dtm.nodeStructureChanged(rootNode);
                nt.setSkipFlag(0);
            }
            ArrayList<String> temp = new ArrayList<String>();
            int numTop = topDown.size();
            for (int i = 0; i < numTop; ++i) {
                String nextTop = (String)topDown.get(i);
                if (!addedNodes.contains(nextTop)) continue;
                temp.add(nextTop);
            }
            addedNodes = temp;
        } else {
            int numModels = topDown.size();
            for (int i = 1; i < numModels; ++i) {
                addedNodes.add(topDown.get(i));
            }
        }
        nameToId.put(rootName, Database.getDB().getGenome().getID());
        int numAdded = addedNodes.size();
        for (int i = 0; i < numAdded; ++i) {
            FullHierarchyBuilder.ModelDef md = (FullHierarchyBuilder.ModelDef)modelDefs.get(addedNodes.get(i));
            String vfgID = md.modelParent.equals(rootName) ? null : (String)nameToId.get(md.modelParent);
            String nextKey = db.getNextKey();
            GenomeInstance gi = new GenomeInstance(md.modelName, nextKey, vfgID);
            nameToId.put((String)addedNodes.get(i), nextKey);
            DatabaseChange dc = db.addGenomeInstanceExistingLabel(nextKey, gi);
            support.addEdit(new DatabaseChangeCmd(dc));
            if (vfgID == null) {
                String nextloKey = db.getNextKey();
                Layout lo = new Layout(nextloKey, nextKey);
                dc = db.addLayout(nextloKey, lo);
                support.addEdit(new DatabaseChangeCmd(dc));
            }
            nt.setSkipFlag(2);
            NavTreeChange ntc = nt.addNode(md.modelName, vfgID, nextKey);
            nt.setSkipFlag(0);
            support.addEdit(new NavTreeChangeCmd(ntc));
            ntcs.add(ntc);
        }
        if (numAdded > 0) {
            nt.setSkipFlag(2);
            dtm.nodeStructureChanged(rootNode);
            nt.setSkipFlag(0);
        }
        if (modelIDMap != null) {
            modelIDMap.clear();
            modelIDMap.putAll(nameToId);
        }
        if (!doReplacement) {
            nt.setSkipFlag(2);
            List nonleafPaths = nt.getAllPathsToNonLeaves();
            Iterator nlpit = nonleafPaths.iterator();
            while (nlpit.hasNext()) {
                TreePath tp = (TreePath)nlpit.next();
                tree.expandPath(tp);
            }
            DefaultMutableTreeNode rootChild = (DefaultMutableTreeNode)rootNode.getChildAt(0);
            Object[] tn = rootChild.getPath();
            TreePath tp = new TreePath(tn);
            tree.setSelectionPath(tp);
            nt.setSkipFlag(0);
            int ntcSize = ntcs.size();
            if (ntcSize > 0) {
                NavTreeChange ntc = (NavTreeChange)ntcs.get(0);
                ec.expanded = nt.mapAllPaths(ec.expanded, ntc, true);
                ec.selected = nt.mapAPath(ec.selected, ntc, true);
                ntc = (NavTreeChange)ntcs.get(ntcSize - 1);
                ((PopupTree)tree).doRedoExpansionChange(support, ntc, true);
            }
        }
        HashMap<String, List> cmdByID = new HashMap<String, List>();
        Iterator mdit = modelDefs.keySet().iterator();
        while (mdit.hasNext()) {
            String modelName = (String)mdit.next();
            String modelID = (String)nameToId.get(modelName);
            List clist = (List)commands.get(modelName);
            cmdByID.put(modelID, clist == null ? new ArrayList() : clist);
        }
        HashMap<String, List> regByID = new HashMap<String, List>();
        Iterator mrit = modelDefs.keySet().iterator();
        while (mrit.hasNext()) {
            String modelName = (String)mrit.next();
            if (modelName.equals(rootName)) continue;
            String modelID = (String)nameToId.get(modelName);
            List rlist = (List)regionDefs.get(modelName);
            regByID.put(modelID, rlist == null ? new ArrayList() : rlist);
        }
        ArrayList bottomUpID = new ArrayList();
        int buNum = bottomUp.size();
        for (int i = 0; i < buNum; ++i) {
            bottomUpID.add(nameToId.get(bottomUp.get(i)));
        }
        ArrayList topDownID = new ArrayList();
        int tdNum = topDown.size();
        for (int i = 0; i < tdNum; ++i) {
            topDownID.add(nameToId.get(topDown.get(i)));
        }
        this.fhb_.populateParentInstances(bottomUpID, cmdByID, regByID);
        Map uniCmds = this.fhb_.buildUnifiedCommands(cmdByID, topDownID);
        ToolCommands tc = new ToolCommands(null, null, null);
        FullHierarchyBuilder.BIPData retval = new FullHierarchyBuilder.BIPData();
        retval.processOrder = topDownID;
        retval.buildCmds = uniCmds;
        retval.regions = regByID;
        retval.tc = tc;
        return retval;
    }

    private void readCSV(InputStream stream, Map commands, Map modelDefs, Map regionDefs, List modelInputOrder) throws IOException, InvalidInputException {
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        this.readCSV(in, commands, modelDefs, regionDefs, modelInputOrder);
    }

    private void readCSV(File infile, Map commands, Map modelDefs, Map regionDefs, List modelInputOrder) throws IOException, InvalidInputException {
        BufferedReader in = new BufferedReader(new FileReader(infile));
        this.readCSV(in, commands, modelDefs, regionDefs, modelInputOrder);
    }

    private void readCSV(BufferedReader in, Map commands, Map modelDefs, Map regionDefs, List modelInputOrder) throws IOException, InvalidInputException {
        CSVParser csvp = new CSVParser(true);
        String line = null;
        int lineNumber = -1;
        while ((line = in.readLine()) != null) {
            List tokens;
            ++lineNumber;
            if (line.trim().equals("") || (tokens = csvp.processCSVLine(line)).isEmpty() || ((String)tokens.get(0)).trim().startsWith("#")) continue;
            int tokenCategory = this.getCategory((String)tokens.get(0));
            try {
                switch (tokenCategory) {
                    case 0: {
                        FullHierarchyBuilder.ModelDef md = this.processValuesToModelDefinition(tokens, lineNumber);
                        if (modelDefs.get(md.modelName) != null) {
                            throw new InvalidInputException(DUPLICATE_MODEL_NAME, lineNumber);
                        }
                        modelDefs.put(DataUtil.normKey(md.modelName), md);
                        modelInputOrder.add(md.modelName);
                        break;
                    }
                    case 1: {
                        RegionDef rd = this.processValuesToRegionDefinition(tokens, lineNumber);
                        if (modelDefs.get(rd.modelName) == null) {
                            throw new InvalidInputException(UNDEFINED_MODEL_NAME, lineNumber);
                        }
                        ArrayList<InstanceInstructionSet.RegionInfo> rList = (ArrayList<InstanceInstructionSet.RegionInfo>)regionDefs.get(rd.modelName);
                        if (!this.goodRegionDef(rd, rList)) {
                            throw new InvalidInputException(BAD_REGION_DEF, lineNumber);
                        }
                        if (rList == null) {
                            rList = new ArrayList<InstanceInstructionSet.RegionInfo>();
                            regionDefs.put(rd.modelName, rList);
                        }
                        rList.add(rd.ri);
                        break;
                    }
                    case 2: {
                        AugmentedInstruction ai = this.processValuesToInstruction(tokens, lineNumber);
                        if (modelDefs.get(ai.modelName) == null) {
                            throw new InvalidInputException(UNDEFINED_MODEL_NAME, lineNumber);
                        }
                        ArrayList<BuildInstruction> iList = (ArrayList<BuildInstruction>)commands.get(ai.modelName);
                        if (iList == null) {
                            iList = new ArrayList<BuildInstruction>();
                            commands.put(ai.modelName, iList);
                        }
                        iList.add(ai.bi);
                        break;
                    }
                    default: {
                        in.close();
                        throw new IOException();
                    }
                }
            }
            catch (InvalidInputException iaex) {
                in.close();
                throw iaex;
            }
        }
        in.close();
        this.validateCSV(commands, modelDefs, regionDefs);
    }

    private boolean compareTreesForReplacement(String newRootName, Map modelDefs, Map oldNameToId, List addedNodes, List removedNodes) {
        TreeEditor te = this.createHierarchyChecker(newRootName, oldNameToId);
        if (te == null) {
            return false;
        }
        Iterator mdit = modelDefs.keySet().iterator();
        HashSet<Link> linkSet = new HashSet<Link>();
        HashSet<String> nodeSet = new HashSet<String>();
        while (mdit.hasNext()) {
            String key = (String)mdit.next();
            FullHierarchyBuilder.ModelDef md = (FullHierarchyBuilder.ModelDef)modelDefs.get(key);
            nodeSet.add(DataUtil.normKey(md.modelName));
            if (md.modelParent == null) continue;
            linkSet.add(new Link(DataUtil.normKey(md.modelParent), DataUtil.normKey(md.modelName)));
        }
        te.getDifferences(nodeSet, linkSet, addedNodes, removedNodes);
        return true;
    }

    private TreeEditor createHierarchyChecker(String newRootName, Map oldNameToId) {
        HashSet<String> modelNodes = new HashSet<String>();
        HashSet<Link> modelLinks = new HashSet<Link>();
        newRootName = DataUtil.normKey(newRootName);
        modelNodes.add(newRootName);
        Database db = Database.getDB();
        Iterator iit = db.getInstanceIterator();
        while (iit.hasNext()) {
            GenomeInstance gi = (GenomeInstance)iit.next();
            String modName = DataUtil.normKey(gi.getName());
            if (modName.equals("") || modelNodes.contains(modName)) {
                return null;
            }
            modelNodes.add(modName);
            GenomeInstance parent = gi.getVfgParent();
            String parentName = parent == null ? newRootName : DataUtil.normKey(parent.getName());
            modelLinks.add(new Link(parentName, modName));
            oldNameToId.put(modName, gi.getID());
        }
        return new TreeEditor(modelNodes, modelLinks);
    }

    private int getCategory(String tok) {
        if (tok == null) {
            return -1;
        }
        if (tok.equals(MODEL_DEFINITION_STR_)) {
            return 0;
        }
        if (tok.equals("general") || tok.equals("nodeOnly") || tok.equals("signal")) {
            return 2;
        }
        if (tok.equals(REGION_DEFINITION_STR_)) {
            return 1;
        }
        return -1;
    }

    private FullHierarchyBuilder.ModelDef processValuesToModelDefinition(List tokens, int lineNo) throws InvalidInputException {
        String parentName;
        if (tokens.size() < 2) {
            throw new InvalidInputException(TOO_FEW_TOKENS, lineNo);
        }
        String modelName = (String)tokens.get(1);
        if (modelName.trim().equals("")) {
            throw new InvalidInputException(BLANK_TOKEN, lineNo);
        }
        String string = parentName = tokens.size() == 3 ? (String)tokens.get(2) : null;
        if (parentName != null && parentName.trim().equals("")) {
            throw new InvalidInputException(BLANK_TOKEN, lineNo);
        }
        return new FullHierarchyBuilder.ModelDef(modelName, parentName == null ? null : DataUtil.normKey(parentName));
    }

    private RegionDef processValuesToRegionDefinition(List tokens, int lineNo) throws InvalidInputException {
        if (tokens.size() < 4) {
            throw new InvalidInputException(TOO_FEW_TOKENS, lineNo);
        }
        String modelName = (String)tokens.get(1);
        String regionName = (String)tokens.get(2);
        String abbrev = (String)tokens.get(3);
        if (modelName.trim().equals("") || regionName.trim().equals("") || abbrev.trim().equals("")) {
            throw new InvalidInputException(BLANK_TOKEN, lineNo);
        }
        InstanceInstructionSet.RegionInfo ri = new InstanceInstructionSet.RegionInfo(regionName, abbrev);
        return new RegionDef(DataUtil.normKey(modelName), ri);
    }

    private AugmentedInstruction processValuesToInstruction(List tokens, int lineNo) throws InvalidInputException {
        if (tokens.size() < 2) {
            throw new InvalidInputException(TOO_FEW_TOKENS, lineNo);
        }
        String typeStr = (String)tokens.get(0);
        String modelName = (String)tokens.get(1);
        if (modelName.trim().equals("")) {
            throw new InvalidInputException(BLANK_TOKEN, lineNo);
        }
        try {
            BuildInstruction bi = BuildInstruction.buildFromTokens(tokens, typeStr, 2, "");
            return new AugmentedInstruction(DataUtil.normKey(modelName), bi);
        }
        catch (IOException ioex) {
            throw new InvalidInputException(INCORRECT_INSTRUCTION_DEFINITION, lineNo);
        }
    }

    private void validateCSV(Map commands, Map modelDefs, Map regionDefs) throws InvalidInputException {
        if (!this.modelsFormTree(modelDefs)) {
            throw new InvalidInputException(MODELS_NOT_A_TREE);
        }
        if (!this.noRegionsForRoot(modelDefs, regionDefs)) {
            throw new InvalidInputException(ROOT_MODEL_HAS_REGIONS);
        }
        if (!this.goodRegionHierarchy(regionDefs, modelDefs)) {
            throw new InvalidInputException(BAD_REGION_HIERARCHY);
        }
        HashMap typeMap = new HashMap();
        Iterator ckit = commands.keySet().iterator();
        while (ckit.hasNext()) {
            String modelName = (String)ckit.next();
            List iList = (List)commands.get(modelName);
            int num = iList.size();
            for (int i = 0; i < num; ++i) {
                BuildInstruction bi = (BuildInstruction)iList.get(i);
                if (!bi.typesAreConsistent(typeMap)) {
                    throw new InvalidInputException(TYPE_MISMATCH);
                }
                if (!this.regionsAreConsistent(bi, modelName, regionDefs, modelDefs)) {
                    throw new InvalidInputException(INCONSISTENT_REGIONS);
                }
                if (this.rootOnlyLinkEvidenceAssignment(bi, modelName, regionDefs, modelDefs)) continue;
                throw new InvalidInputException(INCONSISTENT_LINK_EVIDENCE);
            }
        }
    }

    private boolean rootOnlyLinkEvidenceAssignment(BuildInstruction bi, String modelName, Map regionDefs, Map modelDefs) {
        boolean modelIsRoot;
        FullHierarchyBuilder.ModelDef md = (FullHierarchyBuilder.ModelDef)modelDefs.get(modelName);
        boolean bl = modelIsRoot = md.modelParent == null;
        if (modelIsRoot) {
            return true;
        }
        return !bi.hasEvidenceLevel();
    }

    private boolean regionsAreConsistent(BuildInstruction bi, String modelName, Map regionDefs, Map modelDefs) {
        boolean modelNeedsRegions;
        List rList = (List)regionDefs.get(modelName);
        boolean modelHasRegions = rList != null && !rList.isEmpty();
        InstructionRegions ir = null;
        boolean instructHasRegions = false;
        boolean instructHasTarget = bi.hasTarget();
        if (bi.hasRegions()) {
            instructHasRegions = true;
            ir = bi.getRegions();
        }
        FullHierarchyBuilder.ModelDef md = (FullHierarchyBuilder.ModelDef)modelDefs.get(modelName);
        boolean bl = modelNeedsRegions = md.modelParent != null;
        if (modelHasRegions && !instructHasRegions) {
            return false;
        }
        if (!modelHasRegions && instructHasRegions) {
            return false;
        }
        if (!modelHasRegions && modelNeedsRegions) {
            return false;
        }
        if (!instructHasRegions) {
            return true;
        }
        if (ir.getNumTuples() != 1) {
            return false;
        }
        Iterator tuit = ir.getRegionTuples();
        InstructionRegions.RegionTuple tup = (InstructionRegions.RegionTuple)tuit.next();
        boolean haveTarg = false;
        boolean haveSrc = false;
        int numDef = rList.size();
        for (int i = 0; i < numDef; ++i) {
            InstanceInstructionSet.RegionInfo ri = (InstanceInstructionSet.RegionInfo)rList.get(i);
            if (!haveSrc && DataUtil.keysEqual(ri.abbrev, tup.sourceRegion)) {
                haveSrc = true;
            }
            if (instructHasTarget && !haveTarg && DataUtil.keysEqual(ri.abbrev, tup.targetRegion)) {
                haveTarg = true;
            }
            if (haveSrc && (!instructHasTarget || haveTarg)) break;
        }
        return haveSrc && (!instructHasTarget || haveTarg);
    }

    private boolean modelsFormTree(Map modelDefs) {
        Iterator mdit = modelDefs.keySet().iterator();
        HashSet<Link> linkSet = new HashSet<Link>();
        HashSet<String> nodeSet = new HashSet<String>();
        while (mdit.hasNext()) {
            String key = (String)mdit.next();
            FullHierarchyBuilder.ModelDef md = (FullHierarchyBuilder.ModelDef)modelDefs.get(key);
            nodeSet.add(DataUtil.normKey(md.modelName));
            if (md.modelParent == null) continue;
            linkSet.add(new Link(DataUtil.normKey(md.modelParent), DataUtil.normKey(md.modelName)));
        }
        try {
            TreeEditor newTree = new TreeEditor(nodeSet, linkSet);
        }
        catch (IllegalArgumentException iaex) {
            return false;
        }
        return true;
    }

    private boolean goodRegionDef(RegionDef rd, List otherDefs) {
        InstanceInstructionSet.RegionInfo ri = rd.ri;
        if (ri.abbrev.length() > 3) {
            return false;
        }
        if (otherDefs == null) {
            return true;
        }
        int num = otherDefs.size();
        for (int i = 0; i < num; ++i) {
            InstanceInstructionSet.RegionInfo chkri = (InstanceInstructionSet.RegionInfo)otherDefs.get(i);
            if (DataUtil.keysEqual(ri.abbrev, chkri.abbrev)) {
                return false;
            }
            if (!DataUtil.keysEqual(ri.name, chkri.name)) continue;
            return false;
        }
        return true;
    }

    private boolean goodRegionHierarchy(Map regionDefs, Map modelDefs) {
        Set mdkeys = modelDefs.keySet();
        Iterator mdit1 = mdkeys.iterator();
        Iterator mdit2 = mdkeys.iterator();
        while (mdit1.hasNext()) {
            String key1 = (String)mdit1.next();
            while (mdit2.hasNext()) {
                String key2 = (String)mdit2.next();
                if (!this.isModelAncestor(modelDefs, key1, key2) || this.consistentRegionDefs(regionDefs, key1, key2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isModelAncestor(Map modelDefs, String parent, String child) {
        FullHierarchyBuilder.ModelDef cmd = (FullHierarchyBuilder.ModelDef)modelDefs.get(child);
        String parKey = cmd.modelParent;
        while (parKey != null) {
            if (DataUtil.keysEqual(parKey, parent)) {
                return true;
            }
            FullHierarchyBuilder.ModelDef pmd = (FullHierarchyBuilder.ModelDef)modelDefs.get(parKey);
            parKey = pmd.modelParent;
        }
        return false;
    }

    private boolean consistentRegionDefs(Map regionDefs, String model1Name, String model2Name) {
        List list1 = (List)regionDefs.get(model1Name);
        if (list1 == null || list1.isEmpty()) {
            return true;
        }
        List list2 = (List)regionDefs.get(model2Name);
        if (list2 == null || list2.isEmpty()) {
            return true;
        }
        int num1 = list1.size();
        int num2 = list2.size();
        for (int i = 0; i < num1; ++i) {
            InstanceInstructionSet.RegionInfo ri1 = (InstanceInstructionSet.RegionInfo)list1.get(i);
            for (int j = 0; j < num2; ++j) {
                InstanceInstructionSet.RegionInfo ri2 = (InstanceInstructionSet.RegionInfo)list2.get(j);
                if (ri1.consistent(ri2)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean noRegionsForRoot(Map modelDefs, Map regionDefs) {
        Iterator mdit = modelDefs.keySet().iterator();
        while (mdit.hasNext()) {
            String key = (String)mdit.next();
            FullHierarchyBuilder.ModelDef md = (FullHierarchyBuilder.ModelDef)modelDefs.get(key);
            if (md.modelParent != null) continue;
            List list = (List)regionDefs.get(md.modelName);
            return list == null || list.isEmpty();
        }
        throw new IllegalStateException();
    }

    public static class AugmentedInstruction {
        String modelName;
        BuildInstruction bi;

        AugmentedInstruction(String name, BuildInstruction bi) {
            this.modelName = name;
            this.bi = bi;
        }

        public String toString() {
            return "AugmentedInstruction: modelName = " + this.modelName + " instr = " + this.bi;
        }
    }

    public static class RegionDef {
        String modelName;
        InstanceInstructionSet.RegionInfo ri;

        RegionDef(String model, InstanceInstructionSet.RegionInfo info) {
            this.modelName = model;
            this.ri = info;
        }

        public String toString() {
            return "RegionDef: model = " + this.modelName + " ri = " + this.ri;
        }
    }
}

