/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.CommonGenomeItemCode;
import org.systemsbiology.biotapestry.genome.DBGene;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class GeneInstance
extends NodeInstance
implements Gene {
    private static final String GENE_TAG_ = "geneInstance";

    public GeneInstance(GeneInstance other) {
        super(other);
    }

    public GeneInstance(GeneInstance other, int instance) {
        super(other, instance);
    }

    public GeneInstance(NodeInstance node) {
        super(node);
        this.nodeType_ = 4;
    }

    public GeneInstance(DBGenomeItem backing, int instance, Double activityLevel, int activity) {
        super(backing, 4, instance, activityLevel, activity);
    }

    public GeneInstance(DBGenomeItem backing, String instance, String activityLevel, String activityType, String override) throws IOException {
        super(backing, null, instance, activityLevel, activityType, override);
        this.nodeType_ = 4;
    }

    public Object clone() {
        return super.clone();
    }

    public DBGenomeItem getBacking() {
        Database db = Database.getDB();
        DBGenomeItem retval = (DBGenomeItem)((Object)db.getGenome().getGene(this.myItemID_));
        if (retval == null) {
            retval = (DBGenomeItem)((Object)db.getHoldingGenome().getGene(this.myItemID_));
        }
        return retval;
    }

    public String toString() {
        return "GeneInstance:  backing = " + this.getBacking() + " instance = " + this.instanceID_ + " activity = " + this.activityLevel_ + " activity = " + this.activity_ + " override = " + this.nameOverride_;
    }

    public String getDisplayString(Genome genome, boolean typePreface) {
        String retval;
        String groupName;
        GenomeInstance gi = (GenomeInstance)genome;
        GroupMembership member = gi.getNodeGroupMembership(this);
        String groupID = member.mainGroups.isEmpty() ? null : (String)member.mainGroups.iterator().next();
        String string = groupName = groupID == null ? "" : gi.getGroup(groupID).getInheritedDisplayName(gi);
        if (typePreface) {
            String format = ResourceManager.getManager().getString("ncreate.importFormatForInstance");
            String typeDisplay = DBNode.mapTypeToDisplay(this.nodeType_);
            retval = MessageFormat.format(format, typeDisplay, this.getName(), groupName);
        } else {
            String format = ResourceManager.getManager().getString("ncreate.importFormatForInstanceNoType");
            retval = MessageFormat.format(format, this.getName(), groupName);
        }
        return retval;
    }

    public Iterator regionIterator() {
        return ((DBGene)this.getBacking()).regionIterator();
    }

    public int getNumRegions() {
        return ((DBGene)this.getBacking()).getNumRegions();
    }

    public int getEvidenceLevel() {
        return ((DBGene)this.getBacking()).getEvidenceLevel();
    }

    public int getPadCount() {
        return ((DBGene)this.getBacking()).getPadCount();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(GENE_TAG_);
        out.print(" ref=\"");
        out.print(this.getBacking().getID());
        out.print("\" instance=\"");
        out.print(this.instanceID_);
        if (this.activity_ != 0) {
            out.print("\" activity=\"");
            out.print(GeneInstance.mapActivityTypes(this.activity_));
        }
        if (this.activityLevel_ != null) {
            out.print("\" activityLevel=\"");
            out.print(this.activityLevel_);
        }
        if (this.nameOverride_ != null) {
            out.print("\" name=\"");
            out.print(CharacterEntityMapper.mapEntities(this.nameOverride_, false));
        }
        if (!this.urls_.isEmpty() || this.description_ != null) {
            out.println("\" >");
            new CommonGenomeItemCode().writeDescUrlToXML(out, ind, this.urls_, this.description_, "nodeInstance");
            ind.indent();
            out.print("</");
            out.print(GENE_TAG_);
            out.println(">");
        } else {
            out.println("\" />");
        }
    }

    public static GeneInstance buildFromXML(Genome genome, Attributes attrs) throws IOException {
        String ref = null;
        String instance = null;
        String activity = null;
        String activityLevelStr = null;
        String name = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("ref")) {
                    ref = val;
                    continue;
                }
                if (key.equals("instance")) {
                    instance = val;
                    continue;
                }
                if (key.equals("activity")) {
                    activity = val;
                    continue;
                }
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("activityLevel")) continue;
                activityLevelStr = val;
            }
        }
        DBGene backing = (DBGene)((GenomeInstance)genome).getGenome().getGene(ref);
        return new GeneInstance((DBGenomeItem)backing, instance, activityLevelStr, activity, name);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(GENE_TAG_);
        return retval;
    }

    protected GeneInstance() {
    }
}

