/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.Indenter;

public interface Genome
extends NetOverlayOwner {
    public Genome getStrippedGenomeCopy();

    public boolean isEmpty();

    public String getName();

    public String getID();

    public GenomeChange addGene(Gene var1);

    public Iterator getGeneIterator();

    public Gene getGene(String var1);

    public int getGeneCount();

    public int getFullNodeCount();

    public int getLinkageCount();

    public GenomeChange addNode(Node var1);

    public GenomeChange replaceNode(Node var1);

    public GenomeChange replaceGene(Gene var1);

    public GenomeChange changeNodeType(String var1, int var2);

    public GenomeChange[] resolvePadChanges(String var1, NodeProperties.PadLimits var2);

    public GenomeChange[] installPadChanges(Map var1, Map var2);

    public GenomeChange changeNodeName(String var1, String var2);

    public GenomeChange changeGeneName(String var1, String var2);

    public GenomeChange changeGeneEvidence(String var1, int var2);

    public GenomeChange changeGeneSize(String var1, int var2);

    public GenomeChange changeNodeSize(String var1, int var2);

    public GenomeChange changeNodeURLs(String var1, List var2);

    public GenomeChange changeNodeDescription(String var1, String var2);

    public GenomeChange changeGeneRegions(String var1, List var2);

    public Iterator getNodeIterator();

    public Iterator getAllNodeIterator();

    public Node getNode(String var1);

    public GenomeChange removeNode(String var1);

    public GenomeChange addLinkage(Linkage var1);

    public GenomeChange removeLinkage(String var1);

    public GenomeChange replaceLinkageProperties(String var1, String var2, int var3, int var4);

    public Iterator getLinkageIterator();

    public Linkage getLinkage(String var1);

    public GenomeChange changeLinkageTarget(Linkage var1, int var2);

    public GenomeChange changeLinkageSource(Linkage var1, int var2);

    public GenomeChange changeLinkageSourceNode(Linkage var1, String var2, int var3);

    public GenomeChange changeLinkageTargetNode(Linkage var1, String var2, int var3);

    public GenomeChange changeLinkageURLs(String var1, List var2);

    public GenomeChange changeLinkageDescription(String var1, String var2);

    public ImageChange[] setGenomeImage(String var1);

    public ImageChange dropGenomeImage();

    public String getGenomeImage();

    public String getLongName();

    public String getDescription();

    public Set hasLinkTargetPadCollisions();

    public PadCalculatorToo.PadResult getNodePadRequirements(Node var1);

    public boolean rootDisplayNameIsUnique(String var1);

    public Set getNodeTargets(String var1);

    public Set getNodeSources(String var1);

    public int getTargetCount(String var1);

    public int getSourceCount(String var1);

    public int getInboundLinkCount(String var1);

    public int getOutboundLinkCount(String var1);

    public Set getOutboundLinks(String var1);

    public int getLinkCount(String var1, String var2);

    public Integer getSourcePad(String var1);

    public void writeXML(PrintWriter var1, Indenter var2);

    public void writeSIF(PrintWriter var1);

    public boolean canWriteSBML();

    public void writeSBML(PrintWriter var1, Indenter var2);

    public void changeUndo(GenomeChange var1);

    public void changeRedo(GenomeChange var1);

    public void imageChangeUndo(ImageChange var1);

    public void imageChangeRedo(ImageChange var1);

    public String getNextNoteKey();

    public void addNote(Note var1);

    public GenomeChange addNoteWithExistingLabel(Note var1);

    public GenomeChange changeNote(Note var1, String var2, String var3, boolean var4);

    public GenomeChange removeNote(String var1);

    public Iterator getNoteIterator();

    public Note getNote(String var1);

    public List getNamesToRoot();
}

