/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.cmd.PadCalculatorToo;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.CommonGenomeCode;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.Gene;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeChange;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.genome.NetworkOverlayOwnerChange;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.genome.SifSupport;
import org.systemsbiology.biotapestry.nav.ImageChange;
import org.systemsbiology.biotapestry.nav.ImageManager;
import org.systemsbiology.biotapestry.ui.NodeProperties;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePair;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.systemsbiology.biotapestry.util.UniqueLabeller;
import org.xml.sax.Attributes;

public class GenomeInstance
implements Genome,
Cloneable {
    protected String vfgParentID_;
    protected String name_;
    private String id_;
    protected String longName_;
    private String description_;
    protected String imgKey_;
    protected HashMap genes_;
    protected HashMap nodes_;
    protected HashMap links_;
    protected TreeMap groups_;
    protected HashMap notes_;
    protected boolean timed_;
    protected int minTime_;
    protected int maxTime_;
    private int uniqueGroupSuffix_;
    private UniqueLabeller labels_;
    private HashMap netOverlays_;
    private static final String KEY_PREF_ = "-ZZ-0";
    public static final int LEGACY_MODE = 0;
    public static final int ALWAYS_MAIN_GROUP = 1;
    public static final int MAIN_GROUP_AS_FALLBACK = 2;

    public GenomeInstance(String name, String id, String vfgParentID, boolean timed, int minTime, int maxTime) {
        this.name_ = name;
        this.id_ = id;
        this.vfgParentID_ = vfgParentID;
        this.genes_ = new HashMap();
        this.nodes_ = new HashMap();
        this.links_ = new HashMap();
        this.groups_ = new TreeMap();
        this.notes_ = new HashMap();
        this.uniqueGroupSuffix_ = 1;
        this.timed_ = timed;
        this.minTime_ = minTime;
        this.maxTime_ = maxTime;
        this.labels_ = new UniqueLabeller();
        this.labels_.setFixedPrefix(this.id_ + KEY_PREF_);
        this.imgKey_ = null;
        this.netOverlays_ = new HashMap();
    }

    public GenomeInstance(String name, String id, String vfgParentID) {
        this(name, id, vfgParentID, false, -1, -1);
    }

    public GenomeInstance(GenomeInstance other, String newName, String newParent, String newID, Map groupIDMap, Map noteIDMap, Map ovrIDMap, Map modIDMap, Map modLinkIDMap, List imageChanges) {
        Group groupCopy;
        Group otherGroup;
        String grID;
        ImageChange ichange;
        this.name_ = newName;
        this.id_ = newID;
        this.vfgParentID_ = newParent;
        this.timed_ = other.timed_;
        this.minTime_ = other.minTime_;
        this.maxTime_ = other.maxTime_;
        this.imgKey_ = other.imgKey_;
        if (this.imgKey_ != null && (ichange = ImageManager.getMgr().registerImageUsage(this.imgKey_)) != null) {
            ichange.genomeKey = newID;
            imageChanges.add(ichange);
        }
        if (other.longName_ != null) {
            this.longName_ = other.longName_;
        }
        if (other.description_ != null) {
            this.description_ = other.description_;
        }
        this.genes_ = new HashMap();
        Iterator git = other.genes_.keySet().iterator();
        while (git.hasNext()) {
            String gID = (String)git.next();
            this.genes_.put(gID, new GeneInstance((GeneInstance)other.genes_.get(gID)));
        }
        this.nodes_ = new HashMap();
        Iterator nit = other.nodes_.keySet().iterator();
        while (nit.hasNext()) {
            String nID = (String)nit.next();
            this.nodes_.put(nID, new NodeInstance((NodeInstance)other.nodes_.get(nID)));
        }
        this.links_ = new HashMap();
        Iterator lit = other.links_.keySet().iterator();
        while (lit.hasNext()) {
            String lID = (String)lit.next();
            this.links_.put(lID, new LinkageInstance((LinkageInstance)other.links_.get(lID)));
        }
        DBGenome rootGenome = (DBGenome)Database.getDB().getGenome();
        this.groups_ = new TreeMap();
        Iterator grit = other.groups_.keySet().iterator();
        while (grit.hasNext()) {
            grID = (String)grit.next();
            otherGroup = (Group)other.groups_.get(grID);
            if (otherGroup.isASubset(other)) continue;
            groupCopy = otherGroup.getMappedCopy(rootGenome, other, groupIDMap);
            this.groups_.put(groupCopy.getID(), groupCopy);
        }
        grit = other.groups_.keySet().iterator();
        while (grit.hasNext()) {
            grID = (String)grit.next();
            otherGroup = (Group)other.groups_.get(grID);
            if (!otherGroup.isASubset(other)) continue;
            groupCopy = otherGroup.getMappedCopy(rootGenome, other, groupIDMap);
            this.groups_.put(groupCopy.getID(), groupCopy);
        }
        this.netOverlays_ = new HashMap();
        Iterator noit = other.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            String newOvID = rootGenome.getNextKey();
            NetworkOverlay nextOver = (NetworkOverlay)other.netOverlays_.get(noID);
            ovrIDMap.put(noID, newOvID);
            NetworkOverlay newCopy = new NetworkOverlay(nextOver, newOvID, groupIDMap, null, modIDMap, modLinkIDMap);
            this.netOverlays_.put(newOvID, newCopy);
        }
        this.labels_ = other.labels_.mappedPrefixCopy(other.id_ + KEY_PREF_, this.id_ + KEY_PREF_);
        this.notes_ = new HashMap();
        Iterator ntit = other.notes_.keySet().iterator();
        while (ntit.hasNext()) {
            String ntID = (String)ntit.next();
            String myNtID = UniqueLabeller.mapKeyPrefix(ntID, other.id_ + KEY_PREF_, this.id_ + KEY_PREF_, null);
            Note oldNote = (Note)other.notes_.get(ntID);
            noteIDMap.put(ntID, myNtID);
            this.notes_.put(myNtID, new Note(oldNote, myNtID));
        }
        this.uniqueGroupSuffix_ = other.uniqueGroupSuffix_;
    }

    public Object clone() {
        try {
            GenomeInstance retval = (GenomeInstance)super.clone();
            retval.genes_ = new HashMap();
            Iterator git = this.genes_.keySet().iterator();
            while (git.hasNext()) {
                String gID = (String)git.next();
                retval.genes_.put(gID, ((GeneInstance)this.genes_.get(gID)).clone());
            }
            retval.nodes_ = new HashMap();
            Iterator nit = this.nodes_.keySet().iterator();
            while (nit.hasNext()) {
                String nID = (String)nit.next();
                retval.nodes_.put(nID, ((NodeInstance)this.nodes_.get(nID)).clone());
            }
            retval.links_ = new HashMap();
            Iterator lit = this.links_.keySet().iterator();
            while (lit.hasNext()) {
                String lID = (String)lit.next();
                retval.links_.put(lID, ((LinkageInstance)this.links_.get(lID)).clone());
            }
            retval.netOverlays_ = new HashMap();
            Iterator nmit = this.netOverlays_.keySet().iterator();
            while (nmit.hasNext()) {
                String nmID = (String)nmit.next();
                retval.netOverlays_.put(nmID, ((NetworkOverlay)this.netOverlays_.get(nmID)).clone());
            }
            retval.notes_ = new HashMap();
            Iterator noit = this.notes_.keySet().iterator();
            while (noit.hasNext()) {
                String noID = (String)noit.next();
                retval.notes_.put(noID, ((Note)this.notes_.get(noID)).clone());
            }
            retval.groups_ = new TreeMap();
            Iterator grit = this.groups_.keySet().iterator();
            while (grit.hasNext()) {
                String grID = (String)grit.next();
                retval.groups_.put(grID, ((Group)this.groups_.get(grID)).clone());
            }
            retval.labels_ = (UniqueLabeller)this.labels_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void fixupLegacyIONodeActivities(List changeList) {
        Iterator anit = this.getAllNodeIterator();
        while (anit.hasNext()) {
            NodeInstance ni = (NodeInstance)anit.next();
            if (!ni.fixupLegacyIOActivityBounds(this)) continue;
            changeList.add(ni.getName());
        }
    }

    public boolean haveProxyDecendant() {
        Database db = Database.getDB();
        Iterator pit = db.getDynamicProxyIterator();
        while (pit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)pit.next();
            if (!dip.instanceIsAncestor(this)) continue;
            return true;
        }
        return false;
    }

    public void fixupLegacyIOHourBoundsFromProxies(int minInit, int maxInit, List changeList) {
        ArrayList<DynamicInstanceProxy> kidProxies = new ArrayList<DynamicInstanceProxy>();
        Database db = Database.getDB();
        Iterator pit = db.getDynamicProxyIterator();
        while (pit.hasNext()) {
            DynamicInstanceProxy dip = (DynamicInstanceProxy)pit.next();
            if (!dip.instanceIsAncestor(this)) continue;
            kidProxies.add(dip);
        }
        if (kidProxies.isEmpty()) {
            return;
        }
        int minChildTime = minInit;
        int maxChildTime = maxInit;
        int size = kidProxies.size();
        for (int i = 0; i < size; ++i) {
            int max;
            DynamicInstanceProxy dip = (DynamicInstanceProxy)kidProxies.get(i);
            int min = dip.getMinimumTime();
            if (min < minChildTime) {
                minChildTime = min;
            }
            if ((max = dip.getMaximumTime()) <= maxChildTime) continue;
            maxChildTime = max;
        }
        this.timed_ = true;
        this.minTime_ = minChildTime;
        this.maxTime_ = maxChildTime;
        changeList.add(this.getName());
    }

    public void fixupLegacyIOHourBoundsFromParents(List changeList) {
        GenomeInstance rootParent = this.getVfgParentRoot();
        if (rootParent != null && rootParent.hasTimeBounds()) {
            this.timed_ = true;
            this.minTime_ = rootParent.getMinTime();
            this.maxTime_ = rootParent.getMaxTime();
            changeList.add(this.getName());
        }
    }

    public Genome getStrippedGenomeCopy() {
        GenomeInstance retval = new GenomeInstance(this.name_, this.id_, this.vfgParentID_);
        retval.notes_ = this.notes_;
        retval.longName_ = this.longName_;
        retval.description_ = this.description_;
        retval.labels_ = new UniqueLabeller(this.labels_);
        retval.uniqueGroupSuffix_ = this.uniqueGroupSuffix_;
        retval.timed_ = this.timed_;
        retval.minTime_ = this.minTime_;
        retval.maxTime_ = this.maxTime_;
        retval.netOverlays_ = new HashMap();
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            NetworkOverlay stripped = nextOver.getMemberStrippedOverlay();
            retval.netOverlays_.put(noID, stripped);
        }
        return retval;
    }

    public void recoverMappedModuleMembers(Genome oldGenome, Map oldNodeToNew, Map oldGroupToNew) {
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            NetworkOverlay oldOver = oldGenome.getNetworkOverlay(noID);
            nextOver.recoverMappedMembersAndGroups(oldOver, oldNodeToNew, oldGroupToNew);
        }
    }

    public void fillMapsForGroupExtraction(String grpID, Map keyMap) {
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            nextOver.fillMapForGroupExtraction(grpID, keyMap, this.overlayModeForOwner(), this.id_);
        }
    }

    public void getModulesAttachedToGroup(String grpID, Set attached) {
        Iterator noit = this.netOverlays_.keySet().iterator();
        while (noit.hasNext()) {
            String noID = (String)noit.next();
            NetworkOverlay nextOver = (NetworkOverlay)this.netOverlays_.get(noID);
            nextOver.getModulesAttachedToGroup(grpID, 1, this.id_, attached);
        }
    }

    public boolean isEmpty() {
        return this.genes_.size() == 0 && this.nodes_.size() == 0 && this.links_.size() == 0 && this.groups_.size() == 0 && this.notes_.size() == 0;
    }

    public DBGenome getGenome() {
        return (DBGenome)Database.getDB().getGenome();
    }

    public GenomeInstance getVfgParent() {
        return this.vfgParentID_ == null ? null : (GenomeInstance)Database.getDB().getGenome(this.vfgParentID_);
    }

    public GenomeInstance getVfgParentRoot() {
        if (this.vfgParentID_ == null) {
            return null;
        }
        GenomeInstance lastParent = this.getVfgParent();
        GenomeInstance parentvfg;
        while ((parentvfg = lastParent.getVfgParent()) != null) {
            lastParent = parentvfg;
        }
        return lastParent;
    }

    public boolean isAncestor(GenomeInstance child) {
        GenomeInstance lastGI = child;
        while (lastGI != null) {
            if (lastGI == this) {
                return true;
            }
            lastGI = lastGI.getVfgParent();
        }
        return false;
    }

    public String getName() {
        return this.name_;
    }

    public String getID() {
        return this.id_;
    }

    public String getLongName() {
        return this.longName_;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean hasTimeBounds() {
        return this.timed_;
    }

    public int getMinTime() {
        if (!this.timed_) {
            throw new IllegalStateException();
        }
        return this.minTime_;
    }

    public int getMaxTime() {
        if (!this.timed_) {
            throw new IllegalStateException();
        }
        return this.maxTime_;
    }

    public GenomeChange setTimes(int minTime, int maxTime) {
        GenomeChange retval = new GenomeChange();
        retval.genomeKey = this.getID();
        retval.timedOld = this.timed_;
        retval.minTimeOld = this.minTime_;
        retval.maxTimeOld = this.maxTime_;
        this.timed_ = true;
        this.minTime_ = minTime;
        this.maxTime_ = maxTime;
        retval.timedNew = this.timed_;
        retval.minTimeNew = this.minTime_;
        retval.maxTimeNew = this.maxTime_;
        retval.timeChanged = retval.timedOld != retval.timedNew || retval.timedNew && (retval.minTimeOld != retval.minTimeNew || retval.maxTimeOld != retval.maxTimeNew);
        return retval;
    }

    public GenomeChange dropTimes() {
        GenomeChange retval = new GenomeChange();
        retval.genomeKey = this.getID();
        retval.timedOld = this.timed_;
        retval.minTimeOld = this.minTime_;
        retval.maxTimeOld = this.maxTime_;
        this.timed_ = false;
        this.minTime_ = -1;
        this.maxTime_ = -1;
        retval.timedNew = this.timed_;
        retval.minTimeNew = this.minTime_;
        retval.maxTimeNew = this.maxTime_;
        retval.timeChanged = retval.timedOld != retval.timedNew || retval.timedNew && (retval.minTimeOld != retval.minTimeNew || retval.maxTimeOld != retval.maxTimeNew);
        return retval;
    }

    public GenomeChange setProperties(String name, String longName, String desc, boolean isTimeBounded, int minTime, int maxTime) {
        GenomeChange retval = new GenomeChange();
        retval.genomeKey = this.getID();
        retval.descOld = this.description_;
        retval.longNameOld = this.longName_;
        retval.nameOld = this.name_;
        retval.timedOld = this.timed_;
        retval.minTimeOld = this.minTime_;
        retval.maxTimeOld = this.maxTime_;
        this.longName_ = longName;
        this.name_ = name;
        this.description_ = desc;
        this.timed_ = isTimeBounded;
        this.minTime_ = minTime;
        this.maxTime_ = maxTime;
        retval.descNew = this.description_;
        retval.longNameNew = this.longName_;
        retval.nameNew = this.name_;
        retval.timedNew = this.timed_;
        retval.minTimeNew = this.minTime_;
        retval.maxTimeNew = this.maxTime_;
        retval.timeChanged = retval.timedOld != retval.timedNew || retval.timedNew && (retval.minTimeOld != retval.minTimeNew || retval.maxTimeOld != retval.maxTimeNew);
        return retval;
    }

    public void appendLongName(String longName) {
        this.longName_ = this.longName_ == null ? longName : this.longName_.concat(longName);
        this.longName_ = CharacterEntityMapper.unmapEntities(this.longName_, false);
    }

    public void appendDescription(String description) {
        this.description_ = this.description_ == null ? description : this.description_.concat(description);
        this.description_ = CharacterEntityMapper.unmapEntities(this.description_, false);
    }

    public GenomeChange addGene(Gene gene) {
        GenomeChange retval = new GenomeChange();
        this.genes_.put(gene.getID(), gene);
        retval.gOrig = null;
        retval.gNew = gene;
        retval.genomeKey = this.getID();
        return retval;
    }

    public boolean rootDisplayNameIsUnique(String nodeID) {
        return ((DBGenome)Database.getDB().getGenome()).rootDisplayNameIsUnique(nodeID);
    }

    public void importNewGeneInstance(String id) {
    }

    public Set getNodeInstances(String backingID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator git = this.getAllNodeIterator();
        while (git.hasNext()) {
            Node node = (Node)git.next();
            if (!GenomeItemInstance.getBaseID(node.getID()).equals(backingID)) continue;
            retval.add(node.getID());
        }
        return retval;
    }

    public int getTargetCount(String nodeID) {
        Set targs = this.getNodeTargets(nodeID);
        return targs.size();
    }

    public int getSourceCount(String nodeID) {
        Set srcs = this.getNodeSources(nodeID);
        return srcs.size();
    }

    public int getOutboundLinkCount(String nodeID) {
        return new CommonGenomeCode().getOutboundLinkCount(this, nodeID);
    }

    public Set getOutboundLinks(String nodeID) {
        return new CommonGenomeCode().getOutboundLinks(this, nodeID);
    }

    public int getInboundLinkCount(String nodeID) {
        return new CommonGenomeCode().getInboundLinkCount(this, nodeID);
    }

    public Iterator getGeneIterator() {
        return this.genes_.values().iterator();
    }

    public Iterator getSortedGeneIterator() {
        TreeSet sorted = new TreeSet(new NodeComparator());
        sorted.addAll(this.genes_.values());
        return sorted.iterator();
    }

    public int getGeneCount() {
        return this.genes_.size();
    }

    public int getFullNodeCount() {
        return this.genes_.size() + this.nodes_.size();
    }

    public int getLinkageCount() {
        return this.links_.size();
    }

    public Gene getGene(String key) {
        return (Gene)this.genes_.get(key);
    }

    public int getNextNodeInstanceNumber(String nodeKey) {
        int geneCount;
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        int nodeCount = this.getNextInstanceNumberCore(nodeKey, this.nodes_, null);
        return nodeCount > (geneCount = this.getNextInstanceNumberCore(nodeKey, this.genes_, null)) ? nodeCount : geneCount;
    }

    private int getMaxNodeInstanceNumber(String nodeKey) {
        int geneCount;
        int nodeCount = this.getNextInstanceNumberCore(nodeKey, this.nodes_, null);
        return nodeCount > (geneCount = this.getNextInstanceNumberCore(nodeKey, this.genes_, null)) ? nodeCount : geneCount;
    }

    public int getNextLinkInstanceNumber(String linkKey) {
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        return this.getNextInstanceNumberCore(linkKey, this.links_, null);
    }

    public int getNextLinkInstanceNumberWithExclusion(String linkKey, Set exclude) {
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        return this.getNextInstanceNumberCore(linkKey, this.links_, exclude);
    }

    private int getNextInstanceNumberCore(String key, Map map, Set exclude) {
        TreeSet<Integer> sorted = new TreeSet<Integer>();
        if (exclude != null) {
            sorted.addAll(exclude);
        }
        String testPrefix = key.concat(":");
        Iterator keys = map.keySet().iterator();
        while (keys.hasNext()) {
            String nextKey = (String)keys.next();
            if (!nextKey.startsWith(testPrefix)) continue;
            String instance = nextKey.substring(testPrefix.length());
            try {
                Integer val = Integer.valueOf(instance);
                sorted.add(val);
            }
            catch (NumberFormatException ex) {
                throw new IllegalStateException();
            }
        }
        int retval = sorted.size() == 0 ? 0 : (Integer)sorted.last() + 1;
        return retval;
    }

    public GenomeChange addNode(Node node) {
        GenomeChange retval = new GenomeChange();
        this.nodes_.put(node.getID(), node);
        retval.nOrig = null;
        retval.nNew = node;
        retval.genomeKey = this.getID();
        return retval;
    }

    public Iterator getNodeIterator() {
        return this.nodes_.values().iterator();
    }

    public Iterator getAllNodeIterator() {
        HashSet allSet = new HashSet(this.nodes_.values());
        allSet.addAll(this.genes_.values());
        return allSet.iterator();
    }

    public Node getNode(String key) {
        Node retval = (Node)this.nodes_.get(key);
        if (retval != null) {
            return retval;
        }
        return (Node)this.genes_.get(key);
    }

    public GenomeChange removeNode(String key) {
        GenomeChange retval = new GenomeChange();
        Node rem = (Node)this.nodes_.get(key);
        if (rem != null) {
            this.nodes_.remove(key);
            retval.nOrig = rem;
            retval.nNew = null;
        } else {
            retval.gOrig = (Gene)this.genes_.get(key);
            this.genes_.remove(key);
            retval.gNew = null;
        }
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange replaceNode(Node node) {
        GenomeChange retval = new GenomeChange();
        retval.nOrig = (Node)this.nodes_.get(node.getID());
        retval.nNew = node;
        this.nodes_.put(node.getID(), node);
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange replaceGene(Gene gene) {
        GenomeChange retval = new GenomeChange();
        retval.gOrig = (Gene)this.genes_.get(gene.getID());
        retval.gNew = gene;
        this.genes_.put(gene.getID(), gene);
        retval.genomeKey = this.getID();
        return retval;
    }

    public Integer getSourcePad(String nodeID) {
        return new CommonGenomeCode().getSourcePad(this, nodeID);
    }

    public GenomeChange changeNodeType(String nodeID, int type) {
        GenomeChange retval = new GenomeChange();
        retval.genomeKey = this.getID();
        if (((DBGenome)Database.getDB().getGenome()).getNode(GenomeItemInstance.getBaseID(nodeID)).getNodeType() != type) {
            throw new IllegalArgumentException();
        }
        Node existing = this.getNode(nodeID);
        if (type == 4) {
            if (existing.getNodeType() == 4) {
                retval.gOrig = new GeneInstance((GeneInstance)existing);
                retval.gNew = new GeneInstance((GeneInstance)existing);
                this.genes_.put(nodeID, new GeneInstance((GeneInstance)retval.gNew));
            } else {
                retval.nOrig = new NodeInstance((NodeInstance)existing);
                retval.gNew = new GeneInstance((NodeInstance)existing);
                this.nodes_.remove(nodeID);
                this.genes_.put(nodeID, new GeneInstance((GeneInstance)retval.gNew));
            }
        } else if (existing.getNodeType() == 4) {
            retval.gOrig = new GeneInstance((GeneInstance)existing);
            retval.nNew = new NodeInstance((NodeInstance)existing);
            retval.nNew.setNodeType(type);
            this.genes_.remove(nodeID);
            this.nodes_.put(nodeID, new NodeInstance((NodeInstance)retval.nNew));
        } else {
            retval.nOrig = new NodeInstance((NodeInstance)existing);
            retval.nNew = new NodeInstance((NodeInstance)existing);
            retval.nNew.setNodeType(type);
            this.nodes_.put(nodeID, new NodeInstance((NodeInstance)retval.nNew));
        }
        return retval;
    }

    public int getLinkCount(String srcNodeID, String trgNodeID) {
        return new CommonGenomeCode().getLinkCount(this, srcNodeID, trgNodeID);
    }

    public GenomeChange[] resolvePadChanges(String nodeID, NodeProperties.PadLimits padLimits) {
        return new CommonGenomeCode().resolvePadChanges(this, nodeID, padLimits);
    }

    public GenomeChange[] installPadChanges(Map launchPads, Map landingPads) {
        return new CommonGenomeCode().installPadChanges(this, launchPads, landingPads);
    }

    public GenomeChange[] revertPadsToRoot(String nodeID) {
        ArrayList<GenomeChange> retList = new ArrayList<GenomeChange>();
        Database db = Database.getDB();
        DBGenome genome = (DBGenome)db.getGenome();
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            int basePad;
            Linkage link = (Linkage)lit.next();
            String src = link.getSource();
            String trg = link.getTarget();
            if (!src.equals(nodeID) && !trg.equals(nodeID)) continue;
            Integer newLaunch = null;
            Integer newLand = null;
            String baseID = GenomeItemInstance.getBaseID(link.getID());
            Linkage baseLink = genome.getLinkage(baseID);
            if (src.equals(nodeID)) {
                basePad = baseLink.getLaunchPad();
                if (link.getLaunchPad() != basePad) {
                    newLaunch = new Integer(basePad);
                }
            }
            if (trg.equals(nodeID)) {
                basePad = baseLink.getLandingPad();
                if (link.getLandingPad() != basePad) {
                    newLand = new Integer(basePad);
                }
            }
            if (newLaunch == null && newLand == null) continue;
            GenomeChange retval = new GenomeChange();
            retval.genomeKey = this.getID();
            retval.lOrig = new LinkageInstance((LinkageInstance)link);
            if (newLaunch != null) {
                link.setLaunchPad(newLaunch);
            }
            if (newLand != null) {
                link.setLandingPad(newLand);
            }
            retval.lNew = new LinkageInstance((LinkageInstance)link);
            retList.add(retval);
        }
        return retList.toArray(new GenomeChange[retList.size()]);
    }

    public GenomeChange changeNodeName(String nodeID, String name) {
        return ((DBGenome)Database.getDB().getGenome()).changeNodeName(GenomeItemInstance.getBaseID(nodeID), name);
    }

    public GenomeChange changeGeneName(String geneID, String name) {
        return ((DBGenome)Database.getDB().getGenome()).changeGeneName(GenomeItemInstance.getBaseID(geneID), name);
    }

    public GenomeChange changeGeneEvidence(String geneID, int evidence) {
        return ((DBGenome)Database.getDB().getGenome()).changeGeneEvidence(GenomeItemInstance.getBaseID(geneID), evidence);
    }

    public GenomeChange changeGeneSize(String geneID, int pads) {
        return ((DBGenome)Database.getDB().getGenome()).changeGeneSize(GenomeItemInstance.getBaseID(geneID), pads);
    }

    public GenomeChange changeNodeSize(String nodeID, int pads) {
        return ((DBGenome)Database.getDB().getGenome()).changeNodeSize(GenomeItemInstance.getBaseID(nodeID), pads);
    }

    public GenomeChange changeNodeURLs(String nodeID, List urls) {
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeNodeURLs(nodeID, urls);
    }

    public GenomeChange changeLinkageURLs(String linkID, List urls) {
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeLinkageURLs(linkID, urls);
    }

    public GenomeChange changeNodeDescription(String nodeID, String desc) {
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeNodeDescription(nodeID, desc);
    }

    public GenomeChange changeLinkageDescription(String linkID, String desc) {
        if (this.vfgParentID_ != null) {
            throw new IllegalStateException();
        }
        return new CommonGenomeCode(this, this.nodes_, this.genes_, this.links_).changeLinkageDescription(linkID, desc);
    }

    public GenomeChange changeGeneRegions(String geneID, List newRegions) {
        return ((DBGenome)Database.getDB().getGenome()).changeGeneRegions(GenomeItemInstance.getBaseID(geneID), newRegions);
    }

    public ImageChange[] setGenomeImage(String imgKey) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        ImageChange[] retval = cgc.setGenomeImageSupport(this, imgKey, this.imgKey_);
        this.imgKey_ = imgKey;
        return retval;
    }

    public ImageChange dropGenomeImage() {
        CommonGenomeCode cgc = new CommonGenomeCode();
        ImageChange retval = cgc.dropGenomeImageSupport(this, this.imgKey_);
        this.imgKey_ = null;
        return retval;
    }

    public String getGenomeImage() {
        return this.imgKey_;
    }

    public void imageChangeUndo(ImageChange undo) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        this.imgKey_ = cgc.imageChangeUndoSupport(this, undo);
    }

    public void imageChangeRedo(ImageChange redo) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        this.imgKey_ = cgc.imageChangeRedoSupport(this, redo);
    }

    public GenomeChange addLinkage(Linkage link) {
        GenomeChange retval = new GenomeChange();
        this.links_.put(link.getID(), link);
        retval.lOrig = null;
        retval.lNew = link;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageTarget(Linkage link, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (LinkageInstance)link.clone();
        retval.lNew = (LinkageInstance)link.clone();
        retval.lNew.setLandingPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageSource(Linkage link, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (LinkageInstance)link.clone();
        retval.lNew = (LinkageInstance)link.clone();
        retval.lNew.setLaunchPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageSourceNode(Linkage link, String srcID, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setSource(srcID);
        retval.lNew.setLaunchPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange changeLinkageTargetNode(Linkage link, String trgID, int targNum) {
        String id = link.getID();
        GenomeChange retval = new GenomeChange();
        if (this.links_.get(id) != link) {
            throw new IllegalArgumentException();
        }
        retval.lOrig = (Linkage)link.clone();
        retval.lNew = (Linkage)link.clone();
        retval.lNew.setTarget(trgID);
        retval.lNew.setLandingPad(targNum);
        this.links_.put(id, retval.lNew.clone());
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange[] syncAllLinkagePads(Set groupsToSync) {
        ArrayList<GenomeChange> changes = new ArrayList<GenomeChange>();
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            LinkageInstance link = (LinkageInstance)lit.next();
            String id = link.getID();
            boolean doSource = true;
            boolean doTarget = true;
            if (groupsToSync != null) {
                GroupTuple tup = this.getCrossRegionTuple(id);
                doSource = groupsToSync.contains(tup.getSourceGroup());
                doTarget = groupsToSync.contains(tup.getTargetGroup());
            }
            if (!doSource && !doTarget) continue;
            GenomeChange retval = new GenomeChange();
            retval.lOrig = (LinkageInstance)link.clone();
            LinkageInstance newLink = (LinkageInstance)link.clone();
            retval.lNew = newLink;
            newLink.syncLaunchPads(doSource, doTarget);
            this.links_.put(id, retval.lNew.clone());
            retval.genomeKey = this.getID();
            changes.add(retval);
        }
        return changes.toArray(new GenomeChange[changes.size()]);
    }

    public GenomeChange replaceLinkageProperties(String linkID, String name, int sign, int targetLevel) {
        return ((DBGenome)Database.getDB().getGenome()).replaceLinkageProperties(GenomeItemInstance.getBaseID(linkID), name, sign, targetLevel);
    }

    public GenomeChange replaceLinkageInstanceActivity(String linkID, int activity, double level) {
        GenomeChange retval = new GenomeChange();
        retval.lOrig = (Linkage)this.links_.get(linkID);
        retval.lNew = (Linkage)retval.lOrig.clone();
        ((LinkageInstance)retval.lNew).setActivity(activity);
        if (activity == 2) {
            ((LinkageInstance)retval.lNew).setActivityLevel(level);
        }
        this.links_.put(linkID, retval.lNew);
        retval.genomeKey = this.getID();
        return retval;
    }

    public Iterator getLinkageIterator() {
        return this.links_.values().iterator();
    }

    public Linkage getLinkage(String key) {
        return (Linkage)this.links_.get(key);
    }

    public GenomeChange removeLinkage(String key) {
        GenomeChange retval = new GenomeChange();
        retval.lOrig = (Linkage)this.links_.get(key);
        this.links_.remove(key);
        retval.lNew = null;
        retval.genomeKey = this.getID();
        return retval;
    }

    public Set returnLinkInstanceIDsForBacking(String backingID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            LinkageInstance lnk = (LinkageInstance)lit.next();
            String backing = lnk.getBacking().getID();
            if (!backing.equals(backingID)) continue;
            retval.add(lnk.getID());
        }
        return retval;
    }

    public boolean haveBridgingInstance(String backingID, String testSrcID, String testTrgID) {
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            LinkageInstance lnk = (LinkageInstance)lit.next();
            String backing = lnk.getBacking().getID();
            if (!backing.equals(backingID)) continue;
            String srcChk = lnk.getSource();
            String trgChk = lnk.getTarget();
            if (!srcChk.equals(testSrcID) || !trgChk.equals(testTrgID)) continue;
            return true;
        }
        return false;
    }

    public boolean isCrossRegionLink(String linkID) {
        Linkage lnk = this.getLinkage(linkID);
        String src = lnk.getSource();
        String trg = lnk.getTarget();
        Iterator git = this.getGroupIterator();
        String srcGrp = null;
        String trgGrp = null;
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (group.isASubset(this)) continue;
            if (group.isInGroup(src, this)) {
                srcGrp = group.getID();
            }
            if (group.isInGroup(trg, this)) {
                trgGrp = group.getID();
            }
            if (srcGrp == null || trgGrp == null) continue;
            break;
        }
        return !srcGrp.equals(trgGrp);
    }

    public GroupTuple getCrossRegionTuple(String linkID) {
        Linkage lnk = this.getLinkage(linkID);
        String src = lnk.getSource();
        String trg = lnk.getTarget();
        Iterator git = this.getGroupIterator();
        String srcGrp = null;
        String trgGrp = null;
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (group.isASubset(this)) continue;
            if (group.isInGroup(src, this)) {
                srcGrp = group.getID();
            }
            if (group.isInGroup(trg, this)) {
                trgGrp = group.getID();
            }
            if (srcGrp == null || trgGrp == null) continue;
            break;
        }
        return new GroupTuple(srcGrp, trgGrp);
    }

    public GroupTuple getRegionTuple(String linkID) {
        Linkage lnk = this.getLinkage(linkID);
        String src = lnk.getSource();
        String trg = lnk.getTarget();
        Iterator git = this.getGroupIterator();
        String srcGrp = null;
        String trgGrp = null;
        while (git.hasNext() && (srcGrp == null || trgGrp == null)) {
            Group group = (Group)git.next();
            if (group.isASubset(this)) continue;
            if (group.isInGroup(src, this)) {
                srcGrp = group.getID();
            }
            if (!group.isInGroup(trg, this)) continue;
            trgGrp = group.getID();
        }
        return new GroupTuple(srcGrp, trgGrp);
    }

    public NetworkOverlayOwnerChange addNetworkOverlay(NetworkOverlay nmView) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.addNetworkOverlay(nmView);
    }

    public void addNetworkOverlayAndKey(NetworkOverlay nmView) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        cgc.addNetworkOverlayAndKey(nmView);
    }

    public void addNetworkModuleAndKey(String overlayKey, NetModule module) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        cgc.addNetworkModuleAndKey(overlayKey, module);
    }

    public NetworkOverlayChange addNetworkModuleLinkage(String overlayKey, NetModuleLinkage linkage) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.addNetworkModuleLinkage(overlayKey, linkage);
    }

    public NetworkOverlayChange removeNetworkModuleLinkage(String overlayKey, String linkageKey) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.removeNetworkModuleLinkage(overlayKey, linkageKey);
    }

    public NetworkOverlayChange modifyNetModuleLinkage(String overlayKey, String linkKey, int newSign) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.modifyNetModuleLinkage(overlayKey, linkKey, newSign);
    }

    public void addNetworkModuleLinkageAndKey(String overlayKey, NetModuleLinkage linkage) throws IOException {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        cgc.addNetworkModuleLinkageAndKey(overlayKey, linkage);
    }

    public NetworkOverlayOwnerChange removeNetworkOverlay(String key) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.removeNetworkOverlay(key);
    }

    public NetworkOverlay getNetworkOverlay(String key) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.getNetworkOverlay(key);
    }

    public Iterator getNetworkOverlayIterator() {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.getNetworkOverlayIterator();
    }

    public int getNetworkOverlayCount() {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.getNetworkOverlayCount();
    }

    public int getNetworkModuleCount() {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.getNetworkModuleCount();
    }

    public NetworkOverlayChange addNetworkModule(String overlayKey, NetModule module) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.addNetworkModule(overlayKey, module);
    }

    public NetworkOverlayChange[] removeNetworkModule(String overlayKey, String moduleKey) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.removeNetworkModule(overlayKey, moduleKey);
    }

    public NetModuleChange addMemberToNetworkModule(String overlayKey, NetModule module, String nodeID) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.addMemberToNetworkModule(overlayKey, module, nodeID);
    }

    public NetModuleChange deleteMemberFromNetworkModule(String overlayKey, NetModule module, String nodeID) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.deleteMemberFromNetworkModule(overlayKey, module, nodeID);
    }

    public Map findMatchingNetworkModules(int searchMode, String key, NameValuePair nvPair) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.findMatchingNetworkModules(searchMode, key, nvPair);
    }

    public Map findModulesOwnedByGroup(String groupID) {
        return this.findModulesOwnedByGroupGuts(groupID, this.netOverlays_);
    }

    protected Map findModulesOwnedByGroupGuts(String groupID, Map netOverlays) {
        HashMap retval = new HashMap();
        Iterator nokit = netOverlays.keySet().iterator();
        while (nokit.hasNext()) {
            String noKey = (String)nokit.next();
            NetworkOverlay novr = (NetworkOverlay)netOverlays.get(noKey);
            HashSet<String> retSet = null;
            Iterator nmit = novr.getModuleIterator();
            while (nmit.hasNext()) {
                NetModule nmod = (NetModule)nmit.next();
                String grp = nmod.getGroupAttachment();
                if (grp == null || !grp.equals(groupID)) continue;
                if (retSet == null) {
                    retSet = new HashSet<String>();
                    retval.put(noKey, retSet);
                }
                retSet.add(nmod.getID());
            }
        }
        return retval;
    }

    public String getFirstViewPreference(TaggedSet modChoice, TaggedSet revChoice) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        return cgc.getFirstViewPreference(modChoice, revChoice);
    }

    public int overlayModeForOwner() {
        return 1;
    }

    public void overlayChangeUndo(NetworkOverlayOwnerChange undo) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        cgc.overlayChangeUndo(undo);
    }

    public void overlayChangeRedo(NetworkOverlayOwnerChange redo) {
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        cgc.overlayChangeRedo(redo);
    }

    public GroupMembership getNodeGroupMembership(Node node) {
        GroupMembership retval = new GroupMembership();
        Iterator grit = this.getGroupIterator();
        while (grit.hasNext()) {
            Group group = (Group)grit.next();
            if (!group.isInGroup(node.getID(), this)) continue;
            if (group.isASubset(this)) {
                retval.subGroups.add(group.getID());
                continue;
            }
            retval.mainGroups.add(group.getID());
        }
        return retval;
    }

    public GroupMembership getLinkGroupMembership(LinkageInstance link) {
        NodeInstance src = (NodeInstance)this.getNode(link.getSource());
        GroupMembership retval = this.getNodeGroupMembership(src);
        NodeInstance trg = (NodeInstance)this.getNode(link.getTarget());
        GroupMembership trgMemb = this.getNodeGroupMembership(trg);
        retval.mainGroups.addAll(trgMemb.mainGroups);
        retval.subGroups.addAll(trgMemb.subGroups);
        int mainSize = retval.mainGroups.size();
        return retval;
    }

    public Group getGroupForNode(String nodeID, int mainFallbackMode) {
        if (mainFallbackMode == 0) {
            return this.getGroupForNodeLegacy(nodeID);
        }
        if (mainFallbackMode == 1) {
            Iterator git = this.getGroupIterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (group.isASubset(this) || !group.isInGroup(nodeID, this)) continue;
                return group;
            }
            return null;
        }
        Group theGroup = this.getGroupForNodeLegacy(nodeID);
        if (theGroup == null) {
            theGroup = this.getGroupForNode(nodeID, 1);
        }
        return theGroup;
    }

    private Group getGroupForNodeLegacy(String nodeID) {
        Iterator git = this.getGroupIterator();
        while (git.hasNext()) {
            String parentID;
            Group parent;
            String subset;
            Group group = (Group)git.next();
            if (group.getActiveSubset() != null || !(group.isASubset(this) ? (subset = (parent = this.getGroup(parentID = group.getParentGroup(this))).getActiveSubset()) != null && subset.equals(group.getID()) && group.isInGroup(nodeID, this) : group.isInGroup(nodeID, this))) continue;
            return group;
        }
        return null;
    }

    public List getSubgroupsForGroup(String groupID) {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.getVfgParent() == null) {
            Iterator git = this.getGroupIterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                String pID = group.getParentID();
                if (pID == null || !pID.equals(groupID)) continue;
                retval.add(group.getID());
            }
        } else {
            List potentials = this.getVfgParentRoot().getSubgroupsForGroup(Group.getBaseID(groupID));
            Iterator git = this.getGroupIterator();
            while (git.hasNext()) {
                Group group = (Group)git.next();
                if (!potentials.contains(Group.getBaseID(group.getID()))) continue;
                retval.add(group.getID());
            }
        }
        return retval;
    }

    public Set getAllSubsets() {
        HashSet<String> retval = new HashSet<String>();
        Iterator git = this.getGroupIterator();
        while (git.hasNext()) {
            Group group = (Group)git.next();
            if (!group.isASubset(this)) continue;
            retval.add(group.getID());
        }
        return retval;
    }

    public String getInheritedGroupName(String groupID) {
        Group group = this.getGroup(groupID);
        String retval = group.getName();
        if (retval != null) {
            return retval;
        }
        Group rootGroup = this.getVfgParentRoot().getGroup(Group.getBaseID(groupID));
        return rootGroup.getName();
    }

    public int getInstanceForNodeInGroup(String backingNodeID, String groupID) {
        Group group = this.getGroup(groupID);
        Iterator mit = group.getMemberIterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            String nodeID = mem.getID();
            if (!GenomeItemInstance.getBaseID(nodeID).equals(backingNodeID)) continue;
            return GenomeItemInstance.getInstanceID(nodeID);
        }
        return -1;
    }

    public Set getNewConnectionTuples(String backingKey) {
        HashSet<GroupTuple> retval = new HashSet<GroupTuple>();
        DBLinkage link = (DBLinkage)((DBGenome)Database.getDB().getGenome()).getLinkage(backingKey);
        String backingID = link.getID();
        String sourceID = link.getSource();
        String targID = link.getTarget();
        int srcMax = this.getMaxNodeInstanceNumber(sourceID);
        int trgMax = this.getMaxNodeInstanceNumber(targID);
        for (int i = 0; i < srcMax; ++i) {
            String testSrcID = GenomeItemInstance.getCombinedID(sourceID, Integer.toString(i));
            if (this.getNode(testSrcID) == null) continue;
            for (int j = 0; j < trgMax; ++j) {
                String testTrgID = GenomeItemInstance.getCombinedID(targID, Integer.toString(j));
                if (this.getNode(testTrgID) == null || this.haveBridgingInstance(backingID, testSrcID, testTrgID)) continue;
                Group srcGroup = this.getGroupForNode(testSrcID, 0);
                Group trgGroup = this.getGroupForNode(testTrgID, 0);
                if (srcGroup == null || trgGroup == null) {
                    throw new IllegalStateException();
                }
                GroupTuple tuple = new GroupTuple(srcGroup.getID(), trgGroup.getID());
                retval.add(tuple);
            }
        }
        return retval;
    }

    public GenomeChange addGroup(Group group) {
        String id = group.getID();
        if (this.groups_.get(id) != null) {
            System.err.println("Already have a group: " + id);
            throw new IllegalArgumentException();
        }
        if (this.vfgParentID_ == null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(id);
        }
        GenomeChange retval = new GenomeChange();
        this.groups_.put(id, group);
        retval.grOrig = null;
        retval.grNew = group;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange addGroupWithExistingLabel(Group group) {
        String id = group.getID();
        if (this.groups_.get(id) != null) {
            throw new IllegalArgumentException();
        }
        GenomeChange retval = new GenomeChange();
        this.groups_.put(id, group);
        retval.grOrig = null;
        retval.grNew = group;
        retval.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange[] removeEmptyGroup(String key) {
        GenomeChange chng;
        Group group = (Group)this.groups_.get(key);
        if (!group.isInherited() && group.getMemberCount() != 0) {
            throw new IllegalStateException();
        }
        Set subs = group.getSubsets(this);
        int size = subs.size() + 1;
        GenomeChange[] retval = new GenomeChange[size];
        Iterator subit = subs.iterator();
        int count = 0;
        while (subit.hasNext()) {
            GenomeChange chng2;
            String subID = (String)subit.next();
            retval[count] = chng2 = new GenomeChange();
            chng2.grOrig = (Group)this.groups_.get(subID);
            this.groups_.remove(subID);
            if (this.vfgParentID_ == null) {
                ((DBGenome)Database.getDB().getGenome()).removeKey(subID);
            }
            chng2.grNew = null;
            chng2.genomeKey = this.getID();
            ++count;
        }
        retval[count] = chng = new GenomeChange();
        this.groups_.remove(key);
        if (this.vfgParentID_ == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(key);
        }
        chng.grOrig = group;
        chng.grNew = null;
        chng.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange removeGroupNoChecks(String key) {
        GenomeChange chng = new GenomeChange();
        Group group = (Group)this.groups_.get(key);
        this.groups_.remove(key);
        if (this.vfgParentID_ == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(key);
        }
        chng.grOrig = group;
        chng.grNew = null;
        chng.genomeKey = this.getID();
        return chng;
    }

    public GenomeChange[] removeStrippedGroup(String key) {
        GenomeChange chng;
        Group group = (Group)this.groups_.get(key);
        if (!group.isInherited() && group.getMemberCount() != 0) {
            throw new IllegalStateException();
        }
        Set subs = group.getSubsets(this);
        int size = subs.size() + 1;
        GenomeChange[] retval = new GenomeChange[size];
        Iterator subit = subs.iterator();
        int count = 0;
        while (subit.hasNext()) {
            GenomeChange chng2;
            String subID = (String)subit.next();
            retval[count] = chng2 = new GenomeChange();
            chng2.grOrig = (Group)this.groups_.get(subID);
            this.groups_.remove(subID);
            if (this.vfgParentID_ == null) {
                ((DBGenome)Database.getDB().getGenome()).removeKey(subID);
            }
            chng2.grNew = null;
            chng2.genomeKey = this.getID();
            ++count;
        }
        retval[count] = chng = new GenomeChange();
        this.groups_.remove(key);
        if (this.vfgParentID_ == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(key);
        }
        chng.grOrig = group;
        chng.grNew = null;
        chng.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange[] removeSubGroup(String key) {
        GenomeChange chng;
        Group group = (Group)this.groups_.get(key);
        if (!group.isASubset(this)) {
            throw new IllegalArgumentException();
        }
        Iterator grit = this.groups_.values().iterator();
        GenomeChange[] retval = null;
        while (grit.hasNext()) {
            GenomeChange chng2;
            Group grpChk = (Group)grit.next();
            String active = grpChk.getActiveSubset();
            if (active == null || !active.equals(key)) continue;
            retval = new GenomeChange[2];
            retval[0] = chng2 = new GenomeChange();
            chng2.grOrig = new Group(grpChk);
            grpChk.setActiveSubset(null);
            chng2.grNew = new Group(grpChk);
            chng2.genomeKey = this.getID();
            break;
        }
        if (retval == null) {
            retval = new GenomeChange[1];
        }
        retval[retval.length - 1] = chng = new GenomeChange();
        this.groups_.remove(key);
        if (this.vfgParentID_ == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(key);
        }
        chng.grOrig = group;
        chng.grNew = null;
        chng.genomeKey = this.getID();
        return retval;
    }

    public GenomeChange[] activateSubGroup(String parentKey, String subKey) {
        GenomeChange chng;
        GenomeInstance topInstance = this.getVfgParentRoot();
        if (topInstance == null) {
            throw new IllegalStateException();
        }
        Group topParent = topInstance.getGroup(Group.getBaseID(parentKey));
        Group topSub = topInstance.getGroup(Group.getBaseID(subKey));
        if (topSub == null || topParent == null) {
            throw new IllegalArgumentException();
        }
        Set subsets = topParent.getSubsets(topInstance);
        if (!subsets.contains(topSub.getID())) {
            throw new IllegalArgumentException();
        }
        GenomeInstance parentInstance = this.getVfgParent();
        int genCount = parentInstance.getGeneration();
        String startID = Group.buildInheritedID(subKey, genCount);
        Group newGroup = new Group(startID, true, null);
        Group parentGroup = (Group)this.groups_.get(parentKey);
        GenomeChange[] retval = new GenomeChange[]{this.addGroupWithExistingLabel(newGroup), chng = new GenomeChange()};
        chng.grOrig = new Group(parentGroup);
        parentGroup.setActiveSubset(newGroup.getID());
        chng.grNew = new Group(parentGroup);
        chng.genomeKey = this.getID();
        return retval;
    }

    public String getNextKey() {
        return this.labels_.getNextLabel();
    }

    public Iterator getGroupIterator() {
        return this.groups_.values().iterator();
    }

    public Iterator getGroupReverseIterator() {
        TreeMap tempCopy = (TreeMap)this.groups_.clone();
        ArrayList valList = new ArrayList();
        while (!tempCopy.isEmpty()) {
            Object key = tempCopy.lastKey();
            valList.add(tempCopy.get(key));
            tempCopy.remove(key);
        }
        return valList.iterator();
    }

    public Iterator getGroupIteratorFromList(List groupOrder) {
        int numG = groupOrder.size();
        Group[] realGroups = new Group[numG];
        Iterator git = this.getGroupIterator();
        block0: while (git.hasNext()) {
            Group grp = (Group)git.next();
            String base = Group.getBaseID(grp.getID());
            for (int i = 0; i < numG; ++i) {
                String gKey = (String)groupOrder.get(i);
                if (!gKey.equals(base)) continue;
                realGroups[i] = grp;
                continue block0;
            }
        }
        ArrayList<Group> retvalBase = new ArrayList<Group>();
        for (int i = 0; i < numG; ++i) {
            if (realGroups[i] == null) continue;
            retvalBase.add(realGroups[i]);
        }
        return retvalBase.iterator();
    }

    public boolean hasAGroup() {
        return this.groups_.size() > 0;
    }

    public int groupCount() {
        return this.groups_.size();
    }

    public Group getGroup(String key) {
        return (Group)this.groups_.get(key);
    }

    public Set getGroupsForOverlayRendering() {
        return this.vfgParentID_ == null ? null : new HashSet(this.groups_.keySet());
    }

    public String getNextNoteKey() {
        return new CommonGenomeCode(this, this.notes_, this.labels_).getNextNoteKey();
    }

    public void addNote(Note note) {
        new CommonGenomeCode(this, this.notes_, this.labels_).addNote(note);
    }

    public GenomeChange addNoteWithExistingLabel(Note note) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).addNoteWithExistingLabel(note);
    }

    public GenomeChange changeNote(Note note, String newLabel, String newText, boolean isInteractive) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).changeNote(note, newLabel, newText, isInteractive);
    }

    public GenomeChange removeNote(String key) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).removeNote(key);
    }

    public Iterator getNoteIterator() {
        return new CommonGenomeCode(this, this.notes_, this.labels_).getNoteIterator();
    }

    public Note getNote(String key) {
        return new CommonGenomeCode(this, this.notes_, this.labels_).getNote(key);
    }

    protected void noteChangeUndo(GenomeChange undo) {
        new CommonGenomeCode(this, this.notes_, this.labels_).noteChangeUndo(undo);
    }

    protected void noteChangeRedo(GenomeChange undo) {
        new CommonGenomeCode(this, this.notes_, this.labels_).noteChangeRedo(undo);
    }

    public boolean groupNameInUse(String name) {
        return this.groupNameInUse(name, null);
    }

    public boolean groupNameInUse(String name, String exceptionID) {
        if (name == null) {
            return true;
        }
        Iterator groups = this.getGroupIterator();
        while (groups.hasNext()) {
            String gn;
            Group g = (Group)groups.next();
            if (exceptionID != null && g.getID().equals(exceptionID) || !((gn = g.getName()) == null ? DataUtil.keysEqual("", name) : DataUtil.keysEqual(gn, name))) continue;
            return true;
        }
        return false;
    }

    public String getUniqueGroupName() {
        String tryName;
        ResourceManager rMan = ResourceManager.getManager();
        String format = rMan.getString("group.defaultNameFormat");
        do {
            Integer suffix = new Integer(this.uniqueGroupSuffix_++);
            tryName = MessageFormat.format(format, suffix);
            if (!format.equals(tryName)) continue;
            throw new IllegalStateException();
        } while (this.groupNameInUse(tryName));
        return tryName;
    }

    public int getGeneration() {
        if (this.vfgParentID_ == null) {
            return 0;
        }
        return this.getVfgParent().getGeneration() + 1;
    }

    public Set getNodeTargets(String nodeID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.links_.values().iterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getSource().equals(nodeID)) continue;
            retval.add(lnk.getTarget());
        }
        return retval;
    }

    public Set getNodeSources(String nodeID) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.links_.values().iterator();
        while (lit.hasNext()) {
            Linkage lnk = (Linkage)lit.next();
            if (!lnk.getTarget().equals(nodeID)) continue;
            retval.add(lnk.getSource());
        }
        return retval;
    }

    public Set hasLinkTargetPadCollisions() {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit1 = this.getLinkageIterator();
        while (lit1.hasNext()) {
            Linkage link1 = (Linkage)lit1.next();
            String link1Targ = link1.getTarget();
            int link1Pad = link1.getLandingPad();
            Iterator lit2 = this.getLinkageIterator();
            while (lit2.hasNext()) {
                int link2Pad;
                String link2Targ;
                Linkage link2 = (Linkage)lit2.next();
                if (link1 == link2 || !link1Targ.equals(link2Targ = link2.getTarget()) || link1Pad != (link2Pad = link2.getLandingPad())) continue;
                retval.add(link1.getID());
                retval.add(link2.getID());
            }
        }
        return retval;
    }

    public PadCalculatorToo.PadResult getNodePadRequirements(Node whichNode) {
        CommonGenomeCode cgc = new CommonGenomeCode();
        return cgc.getNodePadRequirements(this, whichNode);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<genomeInstance ");
        out.print("name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.print("\" id=\"");
        out.print(this.id_);
        if (this.vfgParentID_ != null) {
            out.print("\" vfgParent=\"");
            out.print(this.vfgParentID_);
        }
        if (this.timed_) {
            out.print("\" minTime=\"");
            out.print(this.minTime_);
            out.print("\" maxTime=\"");
            out.print(this.maxTime_);
        }
        if (this.imgKey_ != null) {
            out.print("\" image=\"");
            out.print(this.imgKey_);
        }
        out.println("\" >");
        ind.up().indent();
        if (this.longName_ != null) {
            out.print("<longName>");
            out.print(CharacterEntityMapper.mapEntities(this.longName_, false));
            out.println("</longName>");
        } else {
            out.println("<longName />");
        }
        ind.indent();
        if (this.description_ != null) {
            out.print("<description>");
            out.print(CharacterEntityMapper.mapEntities(this.description_, false));
            out.println("</description>");
        } else {
            out.println("<description />");
        }
        ind.indent();
        out.println("<nodeInstances>");
        this.writeNodes(out, ind);
        this.writeGenes(out, ind);
        ind.down().indent();
        out.println("</nodeInstances>");
        this.writeLinks(out, ind);
        this.writeGroups(out, ind);
        CommonGenomeCode cgc = new CommonGenomeCode((NetOverlayOwner)this, 1, this.netOverlays_);
        cgc.writeOverlaysToXML(out, ind);
        this.writeNotes(out, ind);
        ind.down().indent();
        out.println("</genomeInstance>");
    }

    public void writeSIF(PrintWriter out) {
        SifSupport ssup = new SifSupport(this);
        ssup.writeSIF(out);
    }

    public boolean canWriteSBML() {
        return false;
    }

    public void writeSBML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<model ");
        out.print("name=\"");
        out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        out.println("\" >");
        ind.up().indent();
        out.println("<listOfCompartments>");
        ind.up().indent();
        out.println("<compartment name=\"FG\" />");
        ind.down().indent();
        out.println("</listOfCompartments>");
        ind.down().indent();
        out.println("</model>");
    }

    public String checkOneHopSource(String nodeID) {
        String retval = null;
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            LinkageInstance link = (LinkageInstance)lit.next();
            String target = link.getTarget();
            if (!target.equals(nodeID)) continue;
            String source = link.getSource();
            if (retval != null && !retval.equals(source)) {
                return null;
            }
            retval = source;
        }
        return retval;
    }

    public void changeUndo(GenomeChange undo) {
        if (undo.gOrig != null && undo.nNew != null || undo.nOrig != null && undo.gNew != null) {
            this.typeChangeUndo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeUndo(undo);
        } else if (undo.nOrig != null || undo.nNew != null) {
            this.nodeChangeUndo(undo);
        } else if (undo.lOrig != null || undo.lNew != null) {
            this.linkChangeUndo(undo);
        } else if (undo.grOrig != null || undo.grNew != null) {
            this.groupChangeUndo(undo);
        } else if (undo.ntOrig != null || undo.ntNew != null) {
            this.noteChangeUndo(undo);
        } else if (undo.descOld != null || undo.descNew != null || undo.nameOld != null || undo.nameNew != null || undo.longNameOld != null || undo.longNameNew != null) {
            this.propChangeUndo(undo);
            if (undo.timeChanged) {
                this.timeChangeUndo(undo);
            }
        } else if (undo.timeChanged) {
            this.timeChangeUndo(undo);
        }
    }

    public void changeRedo(GenomeChange undo) {
        if (undo.gOrig != null && undo.nNew != null || undo.nOrig != null && undo.gNew != null) {
            this.typeChangeRedo(undo);
        } else if (undo.gOrig != null || undo.gNew != null) {
            this.geneChangeRedo(undo);
        } else if (undo.nOrig != null || undo.nNew != null) {
            this.nodeChangeRedo(undo);
        } else if (undo.lOrig != null || undo.lNew != null) {
            this.linkChangeRedo(undo);
        } else if (undo.grOrig != null || undo.grNew != null) {
            this.groupChangeRedo(undo);
        } else if (undo.ntOrig != null || undo.ntNew != null) {
            this.noteChangeRedo(undo);
        } else if (undo.descOld != null || undo.descNew != null || undo.nameOld != null || undo.nameNew != null || undo.longNameOld != null || undo.longNameNew != null) {
            this.propChangeRedo(undo);
            if (undo.timeChanged) {
                this.timeChangeRedo(undo);
            }
        } else if (undo.timeChanged) {
            this.timeChangeRedo(undo);
        }
    }

    public List getNamesToRoot() {
        ArrayList<String> retval = new ArrayList<String>();
        retval.add(this.name_);
        for (GenomeInstance parent = this.getVfgParent(); parent != null; parent = parent.getVfgParent()) {
            retval.add(parent.getName());
        }
        Genome top = Database.getDB().getGenome();
        retval.add(top.getName());
        Collections.reverse(retval);
        return retval;
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("genomeInstance");
        return retval;
    }

    public static String descriptionKeyword() {
        return "description";
    }

    public static String longNameKeyword() {
        return "longName";
    }

    public static GenomeInstance buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("genomeInstance")) {
            return null;
        }
        String name = null;
        String id = null;
        String parentVfg = null;
        String minTimeStr = null;
        String maxTimeStr = null;
        String imgKey = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("vfgParent")) {
                    parentVfg = val;
                    continue;
                }
                if (key.equals("minTime")) {
                    minTimeStr = val;
                    continue;
                }
                if (key.equals("maxTime")) {
                    maxTimeStr = val;
                    continue;
                }
                if (!key.equals("image")) continue;
                imgKey = val;
            }
        }
        if (name == null || id == null) {
            throw new IOException();
        }
        boolean isTimed = false;
        int minTime = -1;
        int maxTime = -1;
        if (minTimeStr != null || maxTimeStr != null) {
            if (minTimeStr == null || maxTimeStr == null) {
                throw new IOException();
            }
            try {
                minTime = Integer.parseInt(minTimeStr);
                maxTime = Integer.parseInt(maxTimeStr);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            if (minTime > maxTime || minTime < 0 || maxTime < 0) {
                throw new IOException();
            }
            isTimed = true;
        }
        Database db = Database.getDB();
        Genome dbg = db.getGenome();
        GenomeInstance retval = new GenomeInstance(name, id, parentVfg, isTimed, minTime, maxTime);
        if (imgKey != null) {
            retval.imgKey_ = imgKey;
        }
        return retval;
    }

    public boolean hasZeroOrOneInstancePerNode() {
        return this.hasZeroOrOneInstancePerNodeAfterAdditions(null, null);
    }

    public boolean hasZeroOrOneInstancePerNodeAfterAdditions(List newGenes, List newNodes) {
        String baseID;
        Node node;
        HashSet<String> seen = new HashSet<String>();
        Iterator git = this.getGeneIterator();
        while (git.hasNext()) {
            Node node2 = (Node)git.next();
            String baseID2 = GenomeItemInstance.getBaseID(node2.getID());
            if (seen.contains(baseID2)) {
                return false;
            }
            seen.add(baseID2);
        }
        Iterator nit = this.getNodeIterator();
        while (nit.hasNext()) {
            node = (Node)nit.next();
            baseID = GenomeItemInstance.getBaseID(node.getID());
            if (seen.contains(baseID)) {
                return false;
            }
            seen.add(baseID);
        }
        if (newGenes != null) {
            git = newGenes.iterator();
            while (git.hasNext()) {
                node = (Node)git.next();
                baseID = GenomeItemInstance.getBaseID(node.getID());
                if (seen.contains(baseID)) {
                    return false;
                }
                seen.add(baseID);
            }
        }
        if (newNodes != null) {
            nit = newNodes.iterator();
            while (nit.hasNext()) {
                node = (Node)nit.next();
                baseID = GenomeItemInstance.getBaseID(node.getID());
                if (seen.contains(baseID)) {
                    return false;
                }
                seen.add(baseID);
            }
        }
        return true;
    }

    public boolean isRootInstance() {
        return this.vfgParentID_ == null;
    }

    protected GenomeInstance() {
    }

    private void typeChangeUndo(GenomeChange undo) {
        if (undo.nOrig != null && undo.gNew != null) {
            this.nodes_.put(undo.nOrig.getID(), undo.nOrig);
            this.genes_.remove(undo.gNew.getID());
        } else if (undo.gOrig != null && undo.nNew != null) {
            this.genes_.put(undo.gOrig.getID(), undo.gOrig);
            this.nodes_.remove(undo.nNew.getID());
        }
    }

    private void typeChangeRedo(GenomeChange undo) {
        if (undo.nOrig != null && undo.gNew != null) {
            this.genes_.put(undo.gNew.getID(), undo.gNew);
            this.nodes_.remove(undo.nOrig.getID());
        } else if (undo.gOrig != null && undo.nNew != null) {
            this.nodes_.put(undo.nNew.getID(), undo.nNew);
            this.genes_.remove(undo.gOrig.getID());
        }
    }

    private void nodeChangeUndo(GenomeChange undo) {
        if (undo.nOrig != null && undo.nNew != null) {
            this.nodes_.put(undo.nOrig.getID(), undo.nOrig);
        } else if (undo.nOrig == null) {
            this.nodes_.remove(undo.nNew.getID());
        } else {
            this.nodes_.put(undo.nOrig.getID(), undo.nOrig);
        }
    }

    private void nodeChangeRedo(GenomeChange undo) {
        if (undo.nOrig != null && undo.nNew != null) {
            this.nodes_.put(undo.nNew.getID(), undo.nNew);
        } else if (undo.nOrig == null) {
            this.nodes_.put(undo.nNew.getID(), undo.nNew);
        } else {
            this.nodes_.remove(undo.nOrig.getID());
        }
    }

    private void geneChangeUndo(GenomeChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.put(undo.gOrig.getID(), undo.gOrig);
        } else if (undo.gOrig == null) {
            this.genes_.remove(undo.gNew.getID());
        } else {
            this.genes_.put(undo.gOrig.getID(), undo.gOrig);
        }
    }

    private void geneChangeRedo(GenomeChange undo) {
        if (undo.gOrig != null && undo.gNew != null) {
            this.genes_.put(undo.gNew.getID(), undo.gNew);
        } else if (undo.gOrig == null) {
            this.genes_.put(undo.gNew.getID(), undo.gNew);
        } else {
            this.genes_.remove(undo.gOrig.getID());
        }
    }

    private void linkChangeUndo(GenomeChange undo) {
        if (undo.lOrig != null && undo.lNew != null) {
            this.links_.put(undo.lOrig.getID(), undo.lOrig);
        } else if (undo.lOrig == null) {
            this.links_.remove(undo.lNew.getID());
        } else {
            this.links_.put(undo.lOrig.getID(), undo.lOrig);
        }
    }

    private void linkChangeRedo(GenomeChange undo) {
        if (undo.lOrig != null && undo.lNew != null) {
            this.links_.put(undo.lNew.getID(), undo.lNew);
        } else if (undo.lOrig == null) {
            this.links_.put(undo.lNew.getID(), undo.lNew);
        } else {
            this.links_.remove(undo.lOrig.getID());
        }
    }

    protected void groupChangeUndo(GenomeChange undo) {
        if (undo.grOrig != null && undo.grNew != null) {
            String id = undo.grOrig.getID();
            this.groups_.put(id, undo.grOrig);
        } else if (undo.grOrig == null) {
            this.groups_.remove(undo.grNew.getID());
            if (this.vfgParentID_ == null) {
                ((DBGenome)Database.getDB().getGenome()).removeKey(undo.grNew.getID());
            }
        } else {
            String id = undo.grOrig.getID();
            this.groups_.put(id, undo.grOrig);
            if (this.vfgParentID_ == null) {
                ((DBGenome)Database.getDB().getGenome()).addKey(id);
            }
        }
    }

    protected void groupChangeRedo(GenomeChange undo) {
        if (undo.grOrig != null && undo.grNew != null) {
            String id = undo.grNew.getID();
            this.groups_.put(id, undo.grNew);
        } else if (undo.grOrig == null) {
            String id = undo.grNew.getID();
            this.groups_.put(id, undo.grNew);
            if (this.vfgParentID_ == null) {
                ((DBGenome)Database.getDB().getGenome()).addKey(id);
            }
        } else {
            this.groups_.remove(undo.grOrig.getID());
            if (this.vfgParentID_ == null) {
                ((DBGenome)Database.getDB().getGenome()).removeKey(undo.grOrig.getID());
            }
        }
    }

    private void propChangeUndo(GenomeChange undo) {
        this.longName_ = undo.longNameOld;
        this.name_ = undo.nameOld;
        this.description_ = undo.descOld;
    }

    private void propChangeRedo(GenomeChange undo) {
        this.longName_ = undo.longNameNew;
        this.name_ = undo.nameNew;
        this.description_ = undo.descNew;
    }

    private void timeChangeUndo(GenomeChange undo) {
        if (undo.timeChanged) {
            this.timed_ = undo.timedOld;
            this.minTime_ = undo.minTimeOld;
            this.maxTime_ = undo.maxTimeOld;
        }
    }

    private void timeChangeRedo(GenomeChange undo) {
        if (undo.timeChanged) {
            this.timed_ = undo.timedNew;
            this.minTime_ = undo.minTimeNew;
            this.maxTime_ = undo.maxTimeNew;
        }
    }

    private void writeNodes(PrintWriter out, Indenter ind) {
        TreeSet sorted = new TreeSet(new NodeComparator());
        sorted.addAll(this.nodes_.values());
        Iterator nodes = sorted.iterator();
        ind.up();
        int currNodeType = -1;
        while (nodes.hasNext()) {
            NodeInstance n = (NodeInstance)nodes.next();
            int nodeType = n.getNodeType();
            if (nodeType != currNodeType) {
                if (currNodeType != -1) {
                    ind.down().indent();
                    out.println("</" + this.mapNodeType(currNodeType) + ">");
                }
                ind.indent();
                out.println("<" + this.mapNodeType(nodeType) + ">");
                currNodeType = nodeType;
                ind.up();
            }
            n.writeXML(out, ind);
        }
        if (currNodeType != -1) {
            ind.down().indent();
            out.println("</" + this.mapNodeType(currNodeType) + ">");
        }
    }

    private void writeGenes(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<geneInstances>");
        TreeSet sorted = new TreeSet(new NodeComparator());
        sorted.addAll(this.genes_.values());
        Iterator genes = sorted.iterator();
        ind.up();
        while (genes.hasNext()) {
            GeneInstance g = (GeneInstance)genes.next();
            g.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</geneInstances>");
    }

    private void writeLinks(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<linkInstances>");
        TreeSet sorted = new TreeSet(new LinkComparator());
        sorted.addAll(this.links_.values());
        Iterator links = sorted.iterator();
        ind.up();
        while (links.hasNext()) {
            LinkageInstance lnk = (LinkageInstance)links.next();
            lnk.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</linkInstances>");
    }

    private void writeGroups(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<groups>");
        Iterator groups = this.getGroupIterator();
        ind.up();
        while (groups.hasNext()) {
            Group g = (Group)groups.next();
            g.writeXML(out, ind, false);
        }
        ind.down().indent();
        out.println("</groups>");
    }

    private void writeNotes(PrintWriter out, Indenter ind) {
        ind.indent();
        out.println("<notes>");
        Iterator notes = this.getNoteIterator();
        ind.up();
        while (notes.hasNext()) {
            Note n = (Note)notes.next();
            n.writeXML(out, ind, false);
        }
        ind.down().indent();
        out.println("</notes>");
    }

    private String mapNodeType(int nodeType) {
        switch (nodeType) {
            case 1: {
                return "bareInstances";
            }
            case 2: {
                return "boxInstances";
            }
            case 3: {
                return "bubbleInstances";
            }
            case 4: {
                return "geneInstances";
            }
            case 5: {
                return "intercelInstances";
            }
            case 6: {
                return "slashInstances";
            }
            case 7: {
                return "diamondInstances";
            }
        }
        return null;
    }

    public static class GroupTuple
    implements Comparable {
        private String srcGroup_;
        private String trgGroup_;

        public GroupTuple(String srcGroup, String trgGroup) {
            if (srcGroup == null || trgGroup == null) {
                throw new IllegalArgumentException();
            }
            this.srcGroup_ = srcGroup;
            this.trgGroup_ = trgGroup;
        }

        public int compareTo(Object o) {
            GroupTuple other = (GroupTuple)o;
            boolean iMatch = this.srcGroup_.equalsIgnoreCase(this.trgGroup_);
            boolean heMatches = other.srcGroup_.equalsIgnoreCase(other.trgGroup_);
            if (iMatch && !heMatches) {
                return -1;
            }
            if (!iMatch && heMatches) {
                return 1;
            }
            if (iMatch && heMatches) {
                return this.srcGroup_.compareToIgnoreCase(other.srcGroup_);
            }
            int srcResult = this.srcGroup_.compareToIgnoreCase(other.srcGroup_);
            if (srcResult != 0) {
                return srcResult;
            }
            return this.trgGroup_.compareToIgnoreCase(other.trgGroup_);
        }

        public String getSourceGroup() {
            return this.srcGroup_;
        }

        public String getTargetGroup() {
            return this.trgGroup_;
        }

        public int hashCode() {
            return this.srcGroup_.hashCode() * 3 + this.trgGroup_.hashCode();
        }

        public String toString() {
            return "GroupTuple : " + this.srcGroup_ + " -> " + this.trgGroup_;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof GroupTuple)) {
                return false;
            }
            GroupTuple otherGT = (GroupTuple)other;
            if (!this.srcGroup_.equals(otherGT.srcGroup_)) {
                return false;
            }
            return this.trgGroup_.equals(otherGT.trgGroup_);
        }
    }

    class LinkComparator
    implements Comparator {
        LinkComparator() {
        }

        public int compare(Object o1, Object o2) {
            LinkageInstance link1 = (LinkageInstance)o1;
            LinkageInstance link2 = (LinkageInstance)o2;
            int srcCompare = link1.getSource().compareTo(link2.getSource());
            int trgCompare = link1.getTarget().compareTo(link2.getTarget());
            if (srcCompare == 0) {
                if (trgCompare == 0) {
                    return link1.getID().compareTo(link2.getID());
                }
                return trgCompare;
            }
            return srcCompare;
        }
    }

    class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            int type2;
            NodeInstance node1 = (NodeInstance)o1;
            NodeInstance node2 = (NodeInstance)o2;
            int type1 = node1.getNodeType();
            if (type1 == (type2 = node2.getNodeType())) {
                return node1.getID().compareTo(node2.getID());
            }
            return type1 > type2 ? 1 : -1;
        }
    }
}

