/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.GeneInstance;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.Group;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.LinkageInstance;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.genome.Note;
import org.systemsbiology.biotapestry.nav.NavTree;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.xml.sax.Attributes;

public class GenomeInstanceFactory
extends AbstractFactoryClient {
    private static final int NONE_ = 0;
    private static final int LONG_NAME_ = 1;
    private static final int DESCRIPTION_ = 2;
    private static final int NOTE_ = 3;
    private static final int NODE_DESCRIPTION_ = 4;
    private static final int NODE_URL_ = 5;
    private static final int LINK_DESCRIPTION_ = 6;
    private static final int LINK_URL_ = 7;
    private GenomeInstance currGI_;
    private Group currGroup_;
    private Note currNote_;
    private NodeInstance currNode_;
    private LinkageInstance currLink_;
    private int charTarget_;
    private Set genomeKeys_ = GenomeInstance.keywordsOfInterest();
    private Set geneKeys_ = GeneInstance.keywordsOfInterest();
    private Set nodeKeys_ = NodeInstance.keywordsOfInterest();
    private Set linkKeys_ = LinkageInstance.keywordsOfInterest();
    private Set groupKeys_ = Group.keywordsOfInterest(false);
    private Set noteKeys_ = Note.keywordsOfInterest(false);
    private Set groupMemberKeys_ = GroupMember.keywordsOfInterest();
    private String descripKey_ = GenomeInstance.descriptionKeyword();
    private String longNameKey_ = GenomeInstance.longNameKeyword();
    private String nodeDescripKey_;
    private String nodeUrlKeyword_;
    private String linkDescripKey_ = LinkageInstance.descriptionKeyword();
    private String linkUrlKeyword_ = LinkageInstance.urlKeyword();
    private StringBuffer descBuf_;
    private StringBuffer urlBuf_;

    public GenomeInstanceFactory() {
        super(new FactoryWhiteboard());
        this.nodeDescripKey_ = NodeInstance.descriptionKeyword();
        this.nodeUrlKeyword_ = NodeInstance.urlKeyword();
        FactoryWhiteboard whiteboard = (FactoryWhiteboard)this.sharedWhiteboard_;
        whiteboard.genomeType = 1;
        this.installWorker(new NetworkOverlay.NetOverlayWorker(whiteboard), new MyGlue());
        this.myKeys_.addAll(this.genomeKeys_);
        this.descBuf_ = new StringBuffer();
        this.urlBuf_ = new StringBuffer();
    }

    protected void localFinishElement(String elemName) {
        if (this.charTarget_ == 4) {
            if (!elemName.equals(this.nodeDescripKey_)) {
                throw new IllegalStateException();
            }
            this.currNode_.appendDescription(this.descBuf_.toString());
        } else if (this.charTarget_ == 5) {
            if (!elemName.equals(this.nodeUrlKeyword_)) {
                throw new IllegalStateException();
            }
            this.currNode_.addUrl(this.urlBuf_.toString());
        } else if (this.charTarget_ == 6) {
            if (!elemName.equals(this.linkDescripKey_)) {
                throw new IllegalStateException();
            }
            this.currLink_.appendDescription(this.descBuf_.toString());
        } else if (this.charTarget_ == 7) {
            if (!elemName.equals(this.linkUrlKeyword_)) {
                throw new IllegalStateException();
            }
            this.currLink_.addUrl(this.urlBuf_.toString());
        }
        this.charTarget_ = 0;
    }

    protected void localProcessCharacters(char[] chars, int start, int length) {
        String nextString = new String(chars, start, length);
        switch (this.charTarget_) {
            case 0: {
                break;
            }
            case 1: {
                this.currGI_.appendLongName(nextString);
                break;
            }
            case 2: {
                this.currGI_.appendDescription(nextString);
                break;
            }
            case 3: {
                this.currNote_.appendToNote(nextString);
                break;
            }
            case 4: 
            case 6: {
                this.descBuf_.append(nextString);
                break;
            }
            case 5: 
            case 7: {
                this.urlBuf_.append(nextString);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
        if (this.genomeKeys_.contains(elemName)) {
            GenomeInstance gi = GenomeInstance.buildFromXML(elemName, attrs);
            if (gi != null) {
                Database db = Database.getDB();
                db.addGenomeInstance(gi.getID(), gi);
                this.currGI_ = gi;
                ((FactoryWhiteboard)this.sharedWhiteboard_).genome = gi;
                NavTree tree = db.getNavTree();
                GenomeInstance parent = gi.getVfgParent();
                String parentID = parent == null ? null : parent.getID();
                tree.addNode(gi.getName(), parentID, gi.getID());
                return gi;
            }
            return null;
        }
        if (this.descripKey_.equals(elemName)) {
            this.charTarget_ = 2;
        } else if (this.longNameKey_.equals(elemName)) {
            this.charTarget_ = 1;
        } else if (this.geneKeys_.contains(elemName)) {
            this.currNode_ = GeneInstance.buildFromXML(this.currGI_, attrs);
            this.currGI_.addGene((GeneInstance)this.currNode_);
        } else if (this.nodeKeys_.contains(elemName)) {
            this.currNode_ = NodeInstance.buildFromXML(this.currGI_, elemName, attrs);
            this.currGI_.addNode(this.currNode_);
        } else if (this.linkKeys_.contains(elemName)) {
            this.currLink_ = LinkageInstance.buildFromXML(this.currGI_, attrs);
            this.currGI_.addLinkage(this.currLink_);
        } else if (this.linkDescripKey_.equals(elemName)) {
            this.charTarget_ = 6;
            this.descBuf_.setLength(0);
        } else if (this.linkUrlKeyword_.equals(elemName)) {
            this.charTarget_ = 7;
            this.urlBuf_.setLength(0);
        } else if (this.nodeDescripKey_.equals(elemName)) {
            this.charTarget_ = 4;
            this.descBuf_.setLength(0);
        } else if (this.nodeUrlKeyword_.equals(elemName)) {
            this.charTarget_ = 5;
            this.urlBuf_.setLength(0);
        } else if (this.groupKeys_.contains(elemName)) {
            Group newGroup = Group.buildFromXML(elemName, attrs);
            if (newGroup != null) {
                this.currGroup_ = newGroup;
                this.currGI_.addGroup(this.currGroup_);
            }
        } else if (this.noteKeys_.contains(elemName)) {
            Note newNote = Note.buildFromXML(elemName, attrs);
            if (newNote != null) {
                this.charTarget_ = 3;
                this.currNote_ = newNote;
                this.currGI_.addNote(this.currNote_);
            }
        } else if (this.groupMemberKeys_.contains(elemName)) {
            GroupMember newMember = GroupMember.buildFromXML(attrs);
            this.currGroup_.addMember(newMember, this.currGI_.getID());
        }
        return null;
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            Genome genome = board.genome;
            NetworkOverlay netOvr = board.netOvr;
            if (netOvr != null) {
                genome.addNetworkOverlayAndKey(netOvr);
            }
            return null;
        }
    }
}

