/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.util.Comparator;
import java.util.HashSet;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.GenomeItem;

public abstract class GenomeItemInstance
implements GenomeItem,
Cloneable {
    public static final int ACTIVITY_NOT_SET = -1;
    public static final int ACTIVE = 0;
    public static final int INACTIVE = 1;
    public static final int VARIABLE = 2;
    protected static final int NUM_BASE_ACTIVITY_LEVELS = 3;
    protected String myItemID_;
    protected String instanceID_;

    public GenomeItemInstance() {
    }

    public GenomeItemInstance(GenomeItemInstance other) {
        this.myItemID_ = other.myItemID_;
        this.instanceID_ = other.instanceID_;
    }

    public GenomeItemInstance(GenomeItemInstance other, int instance) {
        this.myItemID_ = other.myItemID_;
        this.instanceID_ = Integer.toString(instance);
    }

    public GenomeItemInstance(DBGenomeItem backing, int instance) {
        this.myItemID_ = backing.getID();
        this.instanceID_ = Integer.toString(instance);
    }

    public GenomeItemInstance(DBGenomeItem backing, String instance) {
        this.myItemID_ = backing.getID();
        this.instanceID_ = instance;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void setName(String name) {
        this.getBacking().setName(name);
    }

    public String getName() {
        return this.getBacking().getName();
    }

    public String getID() {
        return this.myItemID_ + ":" + this.instanceID_;
    }

    public String getInstance() {
        return this.instanceID_;
    }

    public abstract DBGenomeItem getBacking();

    public String toString() {
        return "GenomeItemInstance: backing = " + this.myItemID_ + " instance = " + this.instanceID_;
    }

    public static String getCombinedID(String id, String instance) {
        return id + ":" + instance;
    }

    public static boolean isBaseID(String id) {
        return id.indexOf(":") == -1;
    }

    public static String getBaseID(String id) {
        int index = id.indexOf(":");
        if (index == -1) {
            return id;
        }
        return id.substring(0, index);
    }

    public static int getInstanceID(String id) {
        String retvalStr = id.substring(id.indexOf(":") + 1);
        try {
            return Integer.parseInt(retvalStr);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException();
        }
    }

    public static class DBAndInstanceConsistentComparator
    implements Comparator {
        public int compare(Object first, Object second) {
            String secondBase;
            String firstBase;
            String firstID = (String)first;
            String secondID = (String)second;
            boolean isFirstBase = GenomeItemInstance.isBaseID(firstID);
            boolean isSecondBase = GenomeItemInstance.isBaseID(secondID);
            if (isFirstBase && isSecondBase) {
                return firstID.compareTo(secondID);
            }
            int firstInst = -1000;
            if (isFirstBase) {
                firstBase = firstID;
            } else {
                firstBase = GenomeItemInstance.getBaseID(firstID);
                firstInst = GenomeItemInstance.getInstanceID(firstID);
            }
            int secondInst = -1000;
            if (isSecondBase) {
                secondBase = secondID;
            } else {
                secondBase = GenomeItemInstance.getBaseID(secondID);
                secondInst = GenomeItemInstance.getInstanceID(secondID);
            }
            int baseComp = firstBase.compareTo(secondBase);
            if (baseComp != 0) {
                return baseComp;
            }
            return secondInst - firstInst;
        }
    }

    public static class ActivityTracking {
        public Integer parentActivity;
        public double parentActivityLevel;
        public HashSet childActivities;
        public double maxChildLevel;
    }

    public static class ActivityState {
        public int activityState;
        public Double activityLevel;

        public ActivityState(int activityState, double activityLevel) {
            this.activityState = activityState;
            this.activityLevel = activityState == 2 ? new Double(activityLevel) : null;
        }
    }
}

