/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.DynamicGenomeInstance;
import org.systemsbiology.biotapestry.genome.DynamicInstanceProxy;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItem;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.GroupChange;
import org.systemsbiology.biotapestry.genome.GroupMember;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.ui.IRenderer;
import org.systemsbiology.biotapestry.ui.freerender.GroupFree;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class Group
implements GenomeItem,
Cloneable {
    private static IRenderer freeRender_ = new GroupFree();
    private String id_;
    private String name_;
    private IRenderer renderer_;
    private HashSet members_;
    private String ref_;
    private boolean inherited_;
    private String activeSubset_;
    private boolean usingParent_;
    private String parentID_;

    public Group(Group other) {
        this.id_ = other.id_;
        this.name_ = other.name_;
        this.renderer_ = other.renderer_;
        this.members_ = new HashSet();
        Iterator mit = other.members_.iterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            this.members_.add(new GroupMember(mem));
        }
        this.ref_ = other.ref_;
        this.inherited_ = other.inherited_;
        this.activeSubset_ = other.activeSubset_;
        this.usingParent_ = other.usingParent_;
        this.parentID_ = other.parentID_;
    }

    public Group(Group other, String newID) {
        this.id_ = newID;
        this.name_ = other.name_;
        this.renderer_ = other.renderer_;
        this.members_ = new HashSet();
        Iterator mit = other.members_.iterator();
        while (mit.hasNext()) {
            GroupMember mem = (GroupMember)mit.next();
            this.members_.add(new GroupMember(mem));
        }
        this.ref_ = other.ref_;
        this.inherited_ = other.inherited_;
        this.activeSubset_ = other.activeSubset_;
        this.usingParent_ = other.usingParent_;
        this.parentID_ = other.parentID_;
    }

    public Group(String id, String name) {
        this(id, name, freeRender_, null);
    }

    public Group(String id, String name, String parentID) {
        this(id, name, freeRender_, parentID);
    }

    public Group(String id, String name, IRenderer renderer, String parentID) {
        this.id_ = id.trim();
        this.name_ = name;
        this.renderer_ = renderer;
        this.members_ = new HashSet();
        this.inherited_ = false;
        this.activeSubset_ = null;
        this.usingParent_ = false;
        this.parentID_ = parentID;
    }

    public Group(String ref, String usingParent, String activeSubset, IRenderer renderer) {
        this.id_ = ref + ":0";
        this.ref_ = ref;
        this.renderer_ = renderer;
        this.inherited_ = true;
        this.activeSubset_ = activeSubset;
        this.members_ = new HashSet();
        this.usingParent_ = Boolean.valueOf(usingParent);
        this.parentID_ = null;
    }

    public Group(String ref, boolean usingParent, String activeSubset) {
        this.id_ = ref + ":0";
        this.ref_ = ref;
        this.renderer_ = freeRender_;
        this.inherited_ = true;
        this.activeSubset_ = activeSubset;
        this.members_ = new HashSet();
        this.usingParent_ = usingParent;
        this.parentID_ = null;
    }

    public Object clone() {
        try {
            Group retval = (Group)super.clone();
            retval.members_ = new HashSet();
            Iterator mit = this.members_.iterator();
            while (mit.hasNext()) {
                GroupMember mem = (GroupMember)mit.next();
                retval.members_.add(mem.clone());
            }
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public Group getMappedCopy(DBGenome rootGenome, GenomeInstance oldGi, Map groupIDMap) {
        int generation = oldGi.getGeneration();
        Group retval = new Group(this);
        boolean iAmInherited = this.isInherited();
        boolean iAmASubset = this.isASubset(oldGi);
        if (!iAmInherited) {
            retval.id_ = rootGenome.getNextKey();
            groupIDMap.put(this.id_, retval.id_);
            if (iAmASubset) {
                retval.parentID_ = (String)groupIDMap.get(this.parentID_);
                if (retval.parentID_ == null) {
                    throw new IllegalStateException();
                }
            }
            if (this.activeSubset_ != null || this.usingParent_) {
                throw new IllegalStateException();
            }
        } else {
            String myBase;
            String retBase;
            retval.ref_ = (String)groupIDMap.get(this.ref_);
            if (retval.ref_ == null) {
                retval.ref_ = this.ref_;
            }
            if ((retBase = (String)groupIDMap.get(myBase = Group.getBaseID(this.id_))) == null) {
                retBase = myBase;
            }
            retval.id_ = Group.buildInheritedID(retBase, generation);
            groupIDMap.put(this.id_, retval.id_);
            if (this.activeSubset_ != null) {
                String myAsBase = Group.getBaseID(this.activeSubset_);
                String retAsBase = (String)groupIDMap.get(myAsBase);
                if (retAsBase == null) {
                    retAsBase = myAsBase;
                }
                retval.activeSubset_ = Group.buildInheritedID(retAsBase, generation);
            }
        }
        return retval;
    }

    public Group getMappedCopy(DBGenome rootGenome, DynamicInstanceProxy dpi, Map groupIDMap) {
        DynamicGenomeInstance gi = dpi.getAnInstance();
        return this.getMappedCopy(rootGenome, gi, groupIDMap);
    }

    public Group copyForProxy() {
        return new Group(this);
    }

    public String getID() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public String getDisplayName() {
        return this.name_ == null || this.name_.trim().equals("") ? ResourceManager.getManager().getString("groupName.noName") : this.name_;
    }

    public IRenderer getRenderer() {
        return this.renderer_;
    }

    public String getReference() {
        if (!this.inherited_) {
            System.err.println(this);
            throw new IllegalArgumentException();
        }
        return this.ref_;
    }

    public String getActiveSubset() {
        return this.activeSubset_;
    }

    public void setActiveSubset(String activeSubset) {
        this.activeSubset_ = activeSubset;
    }

    public boolean isUsingParent() {
        return this.usingParent_;
    }

    public boolean isInherited() {
        return this.inherited_;
    }

    public String getParentID() {
        return this.parentID_;
    }

    public boolean isASubset(GenomeInstance gi) {
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        return rootGroup.parentID_ != null;
    }

    public boolean isASubset(DynamicInstanceProxy dpi) {
        GenomeInstance gi = dpi.getStaticVfgParent();
        return this.isASubset(gi);
    }

    public boolean isASubsetOf(String parentID, GenomeInstance gi) {
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        return rootGroup.parentID_ != null && rootGroup.parentID_.equals(Group.getBaseID(parentID));
    }

    public String getParentGroup(GenomeInstance gi) {
        int generation = gi.getGeneration();
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        String parent = rootGroup.parentID_;
        if (parent == null) {
            return null;
        }
        return Group.buildInheritedID(parent, generation);
    }

    public Set getSubsets(GenomeInstance gi) {
        return this.getSubsetGuts(gi.getGroupIterator(), gi);
    }

    public Set getSubsets(DynamicInstanceProxy dpi) {
        GenomeInstance gi = dpi.getVfgParent();
        return this.getSubsetGuts(dpi.getGroupIterator(), gi);
    }

    public Set getSubsetGuts(Iterator grit, GenomeInstance gi) {
        HashSet<String> retval = new HashSet<String>();
        while (grit.hasNext()) {
            Group group = (Group)grit.next();
            if (!group.isASubsetOf(this.id_, gi)) continue;
            retval.add(group.getID());
        }
        return retval;
    }

    public GroupChange addMember(GroupMember member, String genomeKey) {
        GroupChange retval = new GroupChange();
        retval.genomeKey = genomeKey;
        retval.groupKey = this.id_;
        retval.grmNew = member;
        retval.grmOrig = null;
        this.members_.add(member);
        return retval;
    }

    public GroupChange removeMember(String memberID, String genomeKey) {
        GroupChange retval = new GroupChange();
        retval.genomeKey = genomeKey;
        retval.groupKey = this.id_;
        retval.grmNew = null;
        Iterator gmit = this.getMemberIterator();
        while (gmit.hasNext()) {
            GroupMember gm = (GroupMember)gmit.next();
            if (!gm.getID().equals(memberID)) continue;
            retval.grmOrig = gm;
            this.members_.remove(gm);
            return retval;
        }
        return retval;
    }

    public Iterator getMemberIterator() {
        return this.members_.iterator();
    }

    public int getMemberCount() {
        return this.members_.size();
    }

    public boolean inheritedIsEmpty(GenomeInstance gi) {
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        Iterator gmit = rootGroup.getMemberIterator();
        while (gmit.hasNext()) {
            GroupMember gm = (GroupMember)gmit.next();
            if (gir == null) {
                return false;
            }
            if (gi.getNode(gm.getID()) == null) continue;
            return false;
        }
        return true;
    }

    public Group getGroupInParent(GenomeInstance gi) {
        GenomeInstance parent = gi.getVfgParent();
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        String baseGrpID = Group.getBaseID(this.id_);
        int genCount = parent.getGeneration();
        String inherit = Group.buildInheritedID(baseGrpID, genCount);
        Group parentGroup = parent.getGroup(inherit);
        return parentGroup;
    }

    public boolean isInGroup(String itemID, GenomeInstance gi) {
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        Iterator gmit = rootGroup.getMemberIterator();
        while (gmit.hasNext()) {
            GroupMember gm = (GroupMember)gmit.next();
            if (!gm.getID().equals(itemID)) continue;
            return true;
        }
        return false;
    }

    public Node getInstanceInGroup(String baseID, GenomeInstance gi) {
        GenomeInstance gir = gi.getVfgParentRoot();
        GenomeInstance wgi = gir == null ? gi : gir;
        Group rootGroup = wgi.getGroup(Group.getBaseID(this.id_));
        Iterator gmit = rootGroup.getMemberIterator();
        while (gmit.hasNext()) {
            GroupMember gm = (GroupMember)gmit.next();
            if (!GenomeItemInstance.getBaseID(gm.getID()).equals(baseID)) continue;
            return gi.getNode(gm.getID());
        }
        return null;
    }

    public String getInheritedDisplayName(GenomeInstance gi) {
        if (!this.inherited_) {
            return this.getDisplayName();
        }
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        return rootGroup.getDisplayName();
    }

    public String getInheritedTrueName(GenomeInstance gi) {
        if (!this.inherited_) {
            return this.getName();
        }
        GenomeInstance gir = gi.getVfgParentRoot();
        gi = gir == null ? gi : gir;
        Group rootGroup = gi.getGroup(Group.getBaseID(this.id_));
        return rootGroup.getName();
    }

    public boolean instanceIsInGroup(String itemID) {
        Iterator gmit = this.getMemberIterator();
        while (gmit.hasNext()) {
            GroupMember gm = (GroupMember)gmit.next();
            if (!GenomeItemInstance.getBaseID(gm.getID()).equals(itemID)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Group: id = " + this.id_ + "name = " + this.name_ + " members = " + this.members_ + " ref = " + this.ref_ + " inherited = " + this.inherited_ + " activeSubset =" + this.activeSubset_ + " usingParent = " + this.usingParent_ + " parentID = " + this.parentID_;
    }

    public void writeXML(PrintWriter out, Indenter ind, boolean forDynamic) {
        ind.indent();
        out.print(forDynamic ? "<dpGroup " : "<group ");
        if (this.inherited_) {
            out.print("ref=\"");
            out.print(this.ref_);
            out.print("\" inherited=\"true");
            if (this.usingParent_) {
                out.print("\" usingParent=\"true");
            }
            if (this.activeSubset_ != null) {
                out.print("\" activeSubset=\"");
                out.print(this.activeSubset_);
            }
            out.println("\" />");
        } else {
            out.print("id=\"");
            out.print(this.id_);
            if (this.name_ != null) {
                out.print("\" name=\"");
                out.print(CharacterEntityMapper.mapEntities(this.name_, false));
            }
            if (this.parentID_ != null) {
                out.print("\" parent=\"");
                out.print(this.parentID_);
            }
            out.println("\" >");
            ind.up().indent();
            out.println("<members>");
            Iterator mi = this.members_.iterator();
            ind.up();
            while (mi.hasNext()) {
                GroupMember mem = (GroupMember)mi.next();
                mem.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</members>");
            ind.down().indent();
            out.println(forDynamic ? "</dpGroup> " : "</group>");
        }
    }

    public void changeUndo(GroupChange undo) {
        if (undo.grmOrig != null && undo.grmNew != null) {
            Iterator gmit = this.getMemberIterator();
            while (gmit.hasNext()) {
                GroupMember gm = (GroupMember)gmit.next();
                if (!gm.getID().equals(undo.grmNew.getID())) continue;
                this.members_.remove(gm);
                break;
            }
            this.members_.add(undo.grmOrig);
        } else if (undo.grmOrig == null) {
            Iterator gmit = this.getMemberIterator();
            while (gmit.hasNext()) {
                GroupMember gm = (GroupMember)gmit.next();
                if (!gm.getID().equals(undo.grmNew.getID())) continue;
                this.members_.remove(gm);
                return;
            }
        } else {
            this.members_.add(undo.grmOrig);
        }
    }

    public void changeRedo(GroupChange redo) {
        if (redo.grmOrig != null && redo.grmNew != null) {
            Iterator gmit = this.getMemberIterator();
            while (gmit.hasNext()) {
                GroupMember gm = (GroupMember)gmit.next();
                if (!gm.getID().equals(redo.grmOrig.getID())) continue;
                this.members_.remove(gm);
                break;
            }
            this.members_.add(redo.grmNew);
        } else if (redo.grmOrig == null) {
            this.members_.add(redo.grmNew);
        } else {
            Iterator gmit = this.getMemberIterator();
            while (gmit.hasNext()) {
                GroupMember gm = (GroupMember)gmit.next();
                if (!gm.getID().equals(redo.grmOrig.getID())) continue;
                this.members_.remove(gm);
                return;
            }
        }
    }

    public static Set keywordsOfInterest(boolean forDynamic) {
        HashSet<String> retval = new HashSet<String>();
        if (forDynamic) {
            retval.add("dpGroup");
        } else {
            retval.add("group");
            retval.add("members");
        }
        return retval;
    }

    public static Group buildFromXML(String elemName, Attributes attrs) throws IOException {
        if (!elemName.equals("group") && !elemName.equals("dpGroup")) {
            return null;
        }
        String id = null;
        String name = null;
        String ref = null;
        String inherited = null;
        String usingParent = null;
        String activeSubset = null;
        String parentID = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (key.equals("ref")) {
                    ref = val;
                    continue;
                }
                if (key.equals("inherited")) {
                    inherited = val;
                    continue;
                }
                if (key.equals("usingParent")) {
                    usingParent = val;
                    continue;
                }
                if (key.equals("activeSubset")) {
                    activeSubset = val;
                    continue;
                }
                if (!key.equals("parent")) continue;
                parentID = val;
            }
        }
        if (inherited == null && ref == null && id == null) {
            throw new IOException();
        }
        boolean isInherited = Boolean.valueOf(inherited);
        if (isInherited) {
            return new Group(ref, usingParent, activeSubset, freeRender_);
        }
        return new Group(id, name, freeRender_, parentID);
    }

    public static String getBaseID(String id) {
        int ind = id.indexOf(":");
        return ind == -1 ? id : id.substring(0, ind);
    }

    public static String buildInheritedID(String id, int generation) {
        StringBuffer buf = new StringBuffer();
        buf.append(Group.getBaseID(id));
        for (int i = 0; i < generation; ++i) {
            buf.append(":0");
        }
        return buf.toString();
    }

    public static String removeGeneration(String id) {
        int last = id.lastIndexOf(":0");
        return last == -1 ? id : id.substring(0, last);
    }

    public static String addGeneration(String id) {
        return id + ":0";
    }

    private Group() {
    }
}

