/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class GroupMember
implements Cloneable {
    private String id_;

    public GroupMember(GroupMember other) {
        this.id_ = other.id_;
    }

    public GroupMember(String id) {
        this.id_ = id.trim();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getID() {
        return this.id_;
    }

    public String toString() {
        return "GroupMember: id = " + this.id_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<member ");
        out.print("ref=\"");
        out.print(this.id_);
        out.println("\" />");
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("member");
        return retval;
    }

    public static GroupMember buildFromXML(Attributes attrs) throws IOException {
        String id = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (!key.equals("ref")) continue;
                id = val;
            }
        }
        if (id == null) {
            throw new IOException();
        }
        return new GroupMember(id);
    }

    private GroupMember() {
    }
}

