/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class InternalFunction
extends DBGenomeItem {
    private static final String AND_TAG_ = "AND";
    private static final String OR_TAG_ = "OR";
    protected int functionType_;
    public static final int AND_FUNCTION = 0;
    public static final int OR_FUNCTION = 1;

    public InternalFunction(InternalFunction other) {
        super(other);
        this.functionType_ = other.functionType_;
    }

    public InternalFunction(int functionType, String id) {
        super(null, id);
        this.functionType_ = functionType;
    }

    public InternalFunction(String function, String id) throws IOException {
        super(null, id);
        if (function == null) {
            throw new IOException();
        }
        if (function.equals(AND_TAG_)) {
            this.functionType_ = 0;
        } else if (function.equals(OR_TAG_)) {
            this.functionType_ = 1;
        } else {
            throw new IOException();
        }
    }

    public Object clone() {
        InternalFunction retval = (InternalFunction)super.clone();
        return retval;
    }

    public int getFunctionType() {
        return this.functionType_;
    }

    public String toString() {
        return "InternalFunction: id = " + this.id_ + " type = " + this.getTag();
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<internalFunction id=\"");
        out.print(this.id_);
        out.print("\" type=\"");
        out.print(this.getTag());
        out.println("\" />");
    }

    public static InternalFunction buildFromXML(Genome genome, Attributes attrs) throws IOException {
        String id = null;
        String func = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (!key.equals("type")) continue;
                func = val;
            }
        }
        return new InternalFunction(func, id);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("internalFunction");
        return retval;
    }

    protected InternalFunction() {
    }

    private String getTag() {
        switch (this.functionType_) {
            case 0: {
                return AND_TAG_;
            }
            case 1: {
                return OR_TAG_;
            }
        }
        throw new IllegalStateException();
    }
}

