/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.util.Indenter;
import org.xml.sax.Attributes;

public class InternalLink
extends DBGenomeItem {
    private String src_;
    private String targ_;
    private int sign_;
    private int tpad_;
    private String signTag_;
    private int spad_;
    public static final int NEGATIVE = -1;
    public static final int NONE = 0;
    public static final int POSITIVE = 1;

    public InternalLink(InternalLink other) {
        super(other);
        this.src_ = other.src_;
        this.targ_ = other.targ_;
        this.sign_ = other.sign_;
        this.signTag_ = other.signTag_;
        this.tpad_ = other.tpad_;
        this.spad_ = other.spad_;
    }

    public InternalLink(String id, String src, String targ, int sign, int tpad, int spad) {
        super(null, id);
        this.src_ = src;
        this.targ_ = targ;
        this.sign_ = sign;
        this.signTag_ = this.sign_ == -1 ? "-" : (this.sign_ == 1 ? "+" : null);
        this.tpad_ = tpad;
        this.spad_ = spad;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InternalLink(String id, String src, String targ, String sign, String tpad, String spad) throws IOException {
        super(null, id);
        if (src == null || targ == null) {
            throw new IOException();
        }
        this.src_ = (src = src.trim()).equals("parent") ? null : src;
        targ = targ.trim();
        String string = this.targ_ = targ.equals("parent") ? null : targ;
        if (sign != null) {
            if ((sign = sign.trim()).equals("+")) {
                this.sign_ = 1;
            } else if (sign.equals("-")) {
                this.sign_ = -1;
            } else {
                if (!sign.equals("")) throw new IOException();
                this.sign_ = 0;
            }
        } else {
            this.sign_ = 0;
        }
        this.signTag_ = sign;
        this.tpad_ = 0;
        if (tpad != null) {
            try {
                this.tpad_ = Integer.parseInt(tpad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.spad_ = 0;
        if (spad == null) return;
        try {
            this.spad_ = Integer.parseInt(spad);
            return;
        }
        catch (NumberFormatException nfe) {
            throw new IOException();
        }
    }

    public Object clone() {
        InternalLink retval = (InternalLink)super.clone();
        return retval;
    }

    public String getSource() {
        return this.src_;
    }

    public String getTarget() {
        return this.targ_;
    }

    public int getSign() {
        return this.sign_;
    }

    public int getLandingPad() {
        return this.tpad_;
    }

    public int getLaunchPad() {
        return this.spad_;
    }

    public void setLandingPad(int landingPad) {
        this.tpad_ = landingPad;
    }

    public void setLaunchPad(int launchPad) {
        this.spad_ = launchPad;
    }

    public String toString() {
        return "InternalLink: id = " + this.id_ + " source = " + this.src_ + " target = " + this.targ_ + " sign = " + this.sign_ + " spad = " + this.spad_ + " tpad = " + this.tpad_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<internalLink id=\"");
        out.print(this.id_);
        out.print("\" src=\"");
        out.print(this.src_ == null ? "parent" : this.src_);
        out.print("\" targ=\"");
        out.print(this.targ_ == null ? "parent" : this.targ_);
        if (this.signTag_ != null) {
            out.print("\" sign=\"");
            out.print(this.signTag_);
        }
        out.print("\" targPad=\"");
        out.print(this.tpad_);
        out.print("\" srcPad=\"");
        out.print(this.spad_);
        out.println("\" />");
    }

    public static InternalLink buildFromXML(Genome genome, Attributes attrs) throws IOException {
        String id = null;
        String src = null;
        String targ = null;
        String sign = null;
        String tpad = null;
        String spad = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("id")) {
                    id = val;
                    continue;
                }
                if (key.equals("src")) {
                    src = val;
                    continue;
                }
                if (key.equals("targ")) {
                    targ = val;
                    continue;
                }
                if (key.equals("sign")) {
                    sign = val;
                    continue;
                }
                if (key.equals("targPad")) {
                    tpad = val;
                    continue;
                }
                if (!key.equals("srcPad")) continue;
                spad = val;
            }
        }
        return new InternalLink(id, src, targ, sign, tpad, spad);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("internalLink");
        return retval;
    }

    protected InternalLink() {
    }
}

