/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.CommonGenomeItemCode;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.DBLinkage;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.Linkage;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.genome.NodeInstance;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class LinkageInstance
extends GenomeItemInstance
implements Linkage {
    public static final int USE_SOURCE = 3;
    private static final int NUM_ACTIVITY_LEVELS_ = 4;
    private static final String INACTIVE_STR_ = "inactive";
    private static final String ACTIVE_STR_ = "active";
    private static final String VARIABLE_STR_ = "variable";
    private static final String SOURCE_STR_ = "source";
    private static final int NO_PAD_ = -100000;
    private String src_;
    private String targ_;
    private int pad_;
    private int lpad_;
    protected Double activityLevel_;
    protected int activity_;
    private String description_;
    private ArrayList urls_;

    public LinkageInstance(LinkageInstance other) {
        super(other);
        this.src_ = other.src_;
        this.targ_ = other.targ_;
        this.pad_ = other.pad_;
        this.lpad_ = other.lpad_;
        this.activityLevel_ = other.activityLevel_;
        this.activity_ = other.activity_;
        this.description_ = other.description_;
        this.urls_ = (ArrayList)other.urls_.clone();
    }

    public LinkageInstance(LinkageInstance other, int newInstance, int srcInstance, int trgInstance) {
        super(other, newInstance);
        this.src_ = LinkageInstance.getCombinedID(LinkageInstance.getBaseID(other.src_), Integer.toString(srcInstance));
        this.targ_ = LinkageInstance.getCombinedID(LinkageInstance.getBaseID(other.targ_), Integer.toString(trgInstance));
        this.pad_ = other.pad_;
        this.lpad_ = other.lpad_;
        this.activityLevel_ = other.activityLevel_;
        this.activity_ = other.activity_;
        this.description_ = other.description_;
        this.urls_ = (ArrayList)other.urls_.clone();
    }

    public LinkageInstance(DBLinkage backing, int instance, int srcInstance, int trgInstance) {
        super((DBGenomeItem)backing, instance);
        this.src_ = LinkageInstance.getCombinedID(backing.getSource(), Integer.toString(srcInstance));
        this.targ_ = LinkageInstance.getCombinedID(backing.getTarget(), Integer.toString(trgInstance));
        this.pad_ = backing.getLandingPad();
        this.lpad_ = backing.getLaunchPad();
        this.activityLevel_ = null;
        this.activity_ = 0;
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    public LinkageInstance(DBGenomeItem backing, String instance, String src, String targ, String pad, String lpad, String activityLevel, String activityType) throws IOException {
        super(backing, instance);
        this.src_ = src.trim();
        this.targ_ = targ.trim();
        this.pad_ = -100000;
        if (pad != null) {
            try {
                this.pad_ = Integer.parseInt(pad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        this.lpad_ = -100000;
        if (lpad != null) {
            try {
                this.lpad_ = Integer.parseInt(lpad);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        }
        try {
            this.activity_ = activityType != null ? LinkageInstance.mapActivityTypeTag(activityType) : 0;
        }
        catch (IllegalArgumentException ex) {
            throw new IOException();
        }
        if (this.activity_ == 2) {
            if (activityLevel == null) {
                throw new IOException();
            }
            try {
                this.activityLevel_ = new Double(activityLevel);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        } else {
            this.activityLevel_ = null;
        }
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    public Object clone() {
        LinkageInstance retval = (LinkageInstance)super.clone();
        retval.urls_ = (ArrayList)this.urls_.clone();
        return retval;
    }

    public DBGenomeItem getBacking() {
        return (DBGenomeItem)((Object)Database.getDB().getGenome().getLinkage(this.myItemID_));
    }

    public String getSource() {
        return this.src_;
    }

    public void setSource(String src) {
        this.src_ = src;
    }

    public void setTarget(String targ) {
        this.targ_ = targ;
    }

    public String getTarget() {
        return this.targ_;
    }

    public int getSign() {
        return ((Linkage)((Object)this.getBacking())).getSign();
    }

    public int getLandingPad() {
        return this.pad_;
    }

    public int getLaunchPad() {
        return this.lpad_;
    }

    public void setLandingPad(int landingPad) {
        this.pad_ = landingPad;
    }

    public void setLaunchPad(int launchPad) {
        this.lpad_ = launchPad;
    }

    public void syncLaunchPads(boolean doSource, boolean doTarget) {
        Linkage backing = (Linkage)((Object)this.getBacking());
        if (doTarget) {
            this.pad_ = backing.getLandingPad();
        }
        if (doSource) {
            this.lpad_ = backing.getLaunchPad();
        }
    }

    public int getTargetLevel() {
        return ((Linkage)((Object)this.getBacking())).getTargetLevel();
    }

    public void setSign(int newSign) {
        ((Linkage)((Object)this.getBacking())).setSign(newSign);
    }

    public void setTargetLevel(int newTarget) {
        ((Linkage)((Object)this.getBacking())).setTargetLevel(newTarget);
    }

    public int getActivity(GenomeInstance gi) {
        if (this.activity_ != 3) {
            return this.activity_;
        }
        NodeInstance ni = (NodeInstance)gi.getNode(this.src_);
        switch (ni.getActivity()) {
            case 1: {
                return 1;
            }
            case 0: 
            case 3: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    public GenomeItemInstance.ActivityTracking calcActivityBounds(GenomeInstance gi) {
        GenomeItemInstance.ActivityTracking retval = new GenomeItemInstance.ActivityTracking();
        Database db = Database.getDB();
        retval.parentActivity = null;
        retval.parentActivityLevel = Double.NEGATIVE_INFINITY;
        retval.childActivities = null;
        retval.maxChildLevel = Double.NEGATIVE_INFINITY;
        GenomeInstance parent = gi.getVfgParent();
        if (parent != null) {
            LinkageInstance parentLink = (LinkageInstance)parent.getLinkage(this.getID());
            int parentAct = parentLink.getActivity(parent);
            retval.parentActivity = new Integer(parentAct);
            if (parentAct == 2) {
                retval.parentActivityLevel = parentLink.getActivityLevel(parent);
            }
        }
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            double kidActivityLevel;
            LinkageInstance kidLinkage;
            GenomeInstance giKid = (GenomeInstance)git.next();
            if (giKid == gi || !gi.isAncestor(giKid) || (kidLinkage = (LinkageInstance)giKid.getLinkage(this.getID())) == null) continue;
            if (retval.childActivities == null) {
                retval.childActivities = new HashSet();
            }
            int kidActivity = kidLinkage.getActivitySetting();
            retval.childActivities.add(new Integer(kidActivity));
            if (kidActivity != 2 || !((kidActivityLevel = kidLinkage.getActivityLevel(giKid)) > retval.maxChildLevel)) continue;
            retval.maxChildLevel = kidActivityLevel;
        }
        return retval;
    }

    public int getActivitySetting() {
        return this.activity_;
    }

    public void setActivity(int activity) {
        this.activity_ = activity;
        if (this.activity_ != 2) {
            this.activityLevel_ = null;
        }
    }

    public double getActivityLevel(GenomeInstance gi) {
        int srcActivity;
        if (this.activity_ == 2) {
            return this.activityLevel_;
        }
        if (this.activity_ == 3 && (srcActivity = this.getActivity(gi)) == 2) {
            NodeInstance ni = (NodeInstance)gi.getNode(this.src_);
            return ni.getActivityLevel();
        }
        throw new IllegalStateException();
    }

    public void setActivityLevel(double activity) {
        if (this.activity_ != 2) {
            throw new IllegalStateException();
        }
        if (activity < 0.0 || activity > 1.0) {
            throw new IllegalArgumentException();
        }
        this.activityLevel_ = new Double(activity);
    }

    public String getDisplayString(Genome genome, boolean typePreface) {
        Node srcNode = genome.getNode(this.src_);
        Node trgNode = genome.getNode(this.targ_);
        String format = DBLinkage.mapSignToDisplay(this.getSign());
        String linkMsg = MessageFormat.format(format, srcNode.getDisplayString(genome, typePreface), trgNode.getDisplayString(genome, typePreface));
        return linkMsg;
    }

    public String getDisplayStringGroupOnly(GenomeInstance gi) {
        NodeInstance srcNode = (NodeInstance)gi.getNode(this.src_);
        NodeInstance trgNode = (NodeInstance)gi.getNode(this.targ_);
        String format = DBLinkage.mapSignToDisplay(this.getSign());
        String linkMsg = MessageFormat.format(format, srcNode.getDisplayStringGroupOnly(gi), trgNode.getDisplayStringGroupOnly(gi));
        return linkMsg;
    }

    public String toString() {
        return "LinkageInstance: backing = " + this.getBacking() + " instance = " + this.instanceID_ + " source = " + this.src_ + " target = " + this.targ_ + " pad = " + this.pad_ + " lpad = " + this.lpad_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<linkInstance ");
        out.print("src=\"");
        out.print(this.src_);
        out.print("\" targ=\"");
        out.print(this.targ_);
        out.print("\" ref=\"");
        out.print(this.getBacking().getID());
        out.print("\" targPad=\"");
        out.print(this.pad_);
        out.print("\" launchPad=\"");
        out.print(this.lpad_);
        out.print("\" instance=\"");
        out.print(this.instanceID_);
        if (this.activity_ != 0) {
            out.print("\" activity=\"");
            out.print(LinkageInstance.mapActivityTypes(this.activity_));
        }
        if (this.activityLevel_ != null) {
            out.print("\" activityLevel=\"");
            out.print(this.activityLevel_);
        }
        if (!this.urls_.isEmpty() || this.description_ != null) {
            out.println("\" >");
            new CommonGenomeItemCode().writeDescUrlToXML(out, ind, this.urls_, this.description_, "linkInstance");
            ind.indent();
            out.println("</linkInstance>");
        } else {
            out.println("\" />");
        }
    }

    public Iterator getURLs() {
        return this.urls_.iterator();
    }

    public int getURLCount() {
        return this.urls_.size();
    }

    public void addUrl(String url) {
        this.urls_.add(url);
    }

    public void setAllUrls(List urls) {
        this.urls_.clear();
        this.urls_.addAll(urls);
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public void appendDescription(String description) {
        this.description_ = this.description_ == null ? description : this.description_.concat(description);
        this.description_ = CharacterEntityMapper.unmapEntities(this.description_, false);
    }

    public static LinkageInstance buildFromXML(Genome genome, Attributes attrs) throws IOException {
        boolean legacyActive;
        String ref = null;
        String instance = null;
        String src = null;
        String targ = null;
        String pad = null;
        String lpad = null;
        String active = null;
        String activity = null;
        String activityLevelStr = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("ref")) {
                    ref = val;
                    continue;
                }
                if (key.equals("instance")) {
                    instance = val;
                    continue;
                }
                if (key.equals("src")) {
                    src = val;
                    continue;
                }
                if (key.equals("targ")) {
                    targ = val;
                    continue;
                }
                if (key.equals("targPad")) {
                    pad = val;
                    continue;
                }
                if (key.equals("launchPad")) {
                    lpad = val;
                    continue;
                }
                if (key.equals(ACTIVE_STR_)) {
                    active = val;
                    continue;
                }
                if (key.equals("activity")) {
                    activity = val;
                    continue;
                }
                if (!key.equals("activityLevel")) continue;
                activityLevelStr = val;
            }
        }
        if (active != null && !(legacyActive = Boolean.valueOf(active).booleanValue())) {
            activity = INACTIVE_STR_;
        }
        DBLinkage backing = (DBLinkage)((GenomeInstance)genome).getGenome().getLinkage(ref);
        return new LinkageInstance(backing, instance, src, targ, pad, lpad, activityLevelStr, activity);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add("linkInstance");
        return retval;
    }

    public static String descriptionKeyword() {
        return "linkInstanceFreeText";
    }

    public static String urlKeyword() {
        return "linkInstanceURL";
    }

    public static Vector getActivityChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 4; ++i) {
            retval.add(LinkageInstance.activityTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent activityTypeForCombo(int activityType) {
        return new ChoiceContent(ResourceManager.getManager().getString("lprop." + LinkageInstance.mapActivityTypes(activityType)), activityType);
    }

    public static String mapActivityTypes(int activityType) {
        switch (activityType) {
            case 1: {
                return INACTIVE_STR_;
            }
            case 0: {
                return ACTIVE_STR_;
            }
            case 3: {
                return SOURCE_STR_;
            }
            case 2: {
                return VARIABLE_STR_;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapActivityTypeTag(String activityTag) {
        if (activityTag.equalsIgnoreCase(INACTIVE_STR_)) {
            return 1;
        }
        if (activityTag.equalsIgnoreCase(ACTIVE_STR_)) {
            return 0;
        }
        if (activityTag.equalsIgnoreCase(SOURCE_STR_)) {
            return 3;
        }
        if (activityTag.equalsIgnoreCase(VARIABLE_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static boolean activityLevelAllowedInChild(int parentActivity, int childActivity) {
        switch (parentActivity) {
            case 0: {
                return true;
            }
            case 1: {
                return childActivity == 1;
            }
            case 2: {
                return childActivity == 2 || childActivity == 1;
            }
            case 3: {
                return childActivity == 3 || childActivity == 1;
            }
        }
        throw new IllegalArgumentException();
    }

    protected LinkageInstance() {
    }
}

