/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.NetModuleChange;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlay;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.DataUtil;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.NameValuePairList;
import org.xml.sax.Attributes;

public class NetModule
implements Cloneable {
    private String id_;
    private String name_;
    private String desc_;
    private String attachedToGroup_;
    private HashSet members_;
    private TreeSet tags_;
    private NameValuePairList nvPairs_;

    public NetModule(NetModule other) {
        this.id_ = other.id_;
        this.name_ = other.name_;
        this.desc_ = other.desc_;
        this.attachedToGroup_ = other.attachedToGroup_;
        this.members_ = new HashSet();
        Iterator mit = other.members_.iterator();
        while (mit.hasNext()) {
            NetModuleMember mem = (NetModuleMember)mit.next();
            this.members_.add(mem.clone());
        }
        this.tags_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.tags_.addAll(other.tags_);
        this.nvPairs_ = (NameValuePairList)other.nvPairs_.clone();
    }

    public NetModule(NetModule other, String newID) {
        this.id_ = newID;
        this.name_ = other.name_;
        this.desc_ = other.desc_;
        this.attachedToGroup_ = other.attachedToGroup_;
        this.members_ = new HashSet();
        Iterator mit = other.members_.iterator();
        while (mit.hasNext()) {
            NetModuleMember mem = (NetModuleMember)mit.next();
            this.members_.add(mem.clone());
        }
        this.tags_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.tags_.addAll(other.tags_);
        this.nvPairs_ = (NameValuePairList)other.nvPairs_.clone();
    }

    public NetModule(NetModule other, String newID, Map groupMap, Map nodeMap) {
        this.id_ = newID;
        this.name_ = other.name_;
        this.desc_ = other.desc_;
        if (other.attachedToGroup_ != null && groupMap != null) {
            this.attachedToGroup_ = (String)groupMap.get(other.attachedToGroup_);
            if (this.attachedToGroup_ == null) {
                throw new IllegalStateException();
            }
        } else {
            this.attachedToGroup_ = other.attachedToGroup_;
        }
        this.members_ = new HashSet();
        Iterator mit = other.members_.iterator();
        while (mit.hasNext()) {
            NetModuleMember mem = (NetModuleMember)mit.next();
            NetModuleMember newMem = nodeMap != null ? new NetModuleMember(mem, nodeMap) : (NetModuleMember)mem.clone();
            this.members_.add(newMem);
        }
        this.tags_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.tags_.addAll(other.tags_);
        this.nvPairs_ = (NameValuePairList)other.nvPairs_.clone();
    }

    public NetModule(String id, String name, String desc, String groupAttach) {
        this.id_ = id;
        this.name_ = name;
        this.desc_ = desc;
        this.attachedToGroup_ = groupAttach;
        this.members_ = new HashSet();
        this.tags_ = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        this.nvPairs_ = new NameValuePairList();
    }

    public Object clone() {
        try {
            NetModule retval = (NetModule)super.clone();
            retval.members_ = new HashSet();
            Iterator mit = this.members_.iterator();
            while (mit.hasNext()) {
                NetModuleMember mem = (NetModuleMember)mit.next();
                retval.members_.add(mem.clone());
            }
            retval.tags_ = (TreeSet)this.tags_.clone();
            retval.nvPairs_ = (NameValuePairList)this.nvPairs_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public void dropAllMembers() {
        this.members_.clear();
    }

    public String getID() {
        return this.id_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getName() {
        return this.name_;
    }

    public void setDescription(String desc) {
        this.desc_ = desc;
    }

    public String getDescription() {
        return this.desc_;
    }

    public String getGroupAttachment() {
        return this.attachedToGroup_;
    }

    public void setGroupAttachment(String groupAttachment) {
        this.attachedToGroup_ = groupAttachment;
    }

    public NetModuleChange detachFromGroup(String noOwnerKey, int ownerMode, String overlayKey) {
        if (this.attachedToGroup_ == null) {
            return null;
        }
        NetModuleChange retval = new NetModuleChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = overlayKey;
        retval.moduleKey = this.id_;
        retval.nmmNew = null;
        retval.nmmOrig = null;
        retval.nameChange = false;
        retval.descChange = false;
        retval.detachedGroup = this.attachedToGroup_;
        this.attachedToGroup_ = null;
        return retval;
    }

    public NetModuleChange changeNameAndDescription(String name, String desc, String noOwnerKey, int ownerMode, String overlayKey) {
        NetModuleChange retval = new NetModuleChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = overlayKey;
        retval.moduleKey = this.id_;
        retval.nmmNew = null;
        retval.nmmOrig = null;
        retval.nameOrig = this.name_;
        retval.nameNew = this.name_ = name;
        retval.descOrig = this.desc_;
        retval.descNew = this.desc_ = desc;
        retval.nameChange = true;
        retval.descChange = true;
        return retval;
    }

    public void addMember(NetModuleMember member) {
        this.members_.add(member);
    }

    public NetModuleChange addMember(NetModuleMember member, String noOwnerKey, int ownerMode, String overlayKey) {
        NetModuleChange retval = new NetModuleChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = overlayKey;
        retval.moduleKey = this.id_;
        retval.nmmNew = (NetModuleMember)member.clone();
        retval.nmmOrig = null;
        this.members_.add(member);
        return retval;
    }

    public NetModuleChange removeMember(String memberID, String noOwnerKey, int ownerMode, String overlayKey) {
        NetModuleChange retval = new NetModuleChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = overlayKey;
        retval.moduleKey = this.id_;
        retval.nmmNew = null;
        Iterator gmit = this.getMemberIterator();
        while (gmit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)gmit.next();
            if (!nmm.getID().equals(memberID)) continue;
            retval.nmmOrig = (NetModuleMember)nmm.clone();
            this.members_.remove(nmm);
            return retval;
        }
        return retval;
    }

    void addTag(String tag) {
        this.tags_.add(tag);
    }

    public NetModuleChange replaceAllTags(SortedSet allTags, String noOwnerKey, int ownerMode, String overlayKey) {
        NetModuleChange retval = new NetModuleChange();
        retval.tagsOrig = (TreeSet)this.tags_.clone();
        this.tags_.clear();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = overlayKey;
        retval.moduleKey = this.id_;
        retval.tagsNew = new TreeSet(allTags);
        this.tags_.addAll(allTags);
        return retval;
    }

    public boolean isATag(String tag) {
        return DataUtil.containsKey(this.tags_, tag);
    }

    public boolean isAMember(String nodeID) {
        Iterator gmit = this.getMemberIterator();
        while (gmit.hasNext()) {
            NetModuleMember nmm = (NetModuleMember)gmit.next();
            if (!nmm.getID().equals(nodeID)) continue;
            return true;
        }
        return false;
    }

    public Iterator getMemberIterator() {
        return this.members_.iterator();
    }

    public int getMemberCount() {
        return this.members_.size();
    }

    public Iterator getTagIterator() {
        return this.tags_.iterator();
    }

    public int getTagCount() {
        return this.tags_.size();
    }

    public NameValuePairList getNVPairs() {
        return this.nvPairs_;
    }

    void setNVPairs(NameValuePairList nvpl) {
        this.nvPairs_ = nvpl;
    }

    public NetModuleChange replaceAllNVPairs(NameValuePairList nvpl, String noOwnerKey, int ownerMode, String overlayKey) {
        NetModuleChange retval = new NetModuleChange();
        retval.nvplOrig = (NameValuePairList)this.nvPairs_.clone();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = overlayKey;
        retval.moduleKey = this.id_;
        retval.nvplNew = (NameValuePairList)nvpl.clone();
        this.nvPairs_ = nvpl;
        return retval;
    }

    public String toString() {
        return "NetModule: id = " + this.id_ + "name = " + this.name_ + " desc = " + this.desc_ + " members = " + this.members_ + " tags = " + this.tags_ + " nvPairs = " + this.nvPairs_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<netModule id=\"");
        out.print(this.id_);
        if (this.name_ != null) {
            out.print("\" name=\"");
            out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        }
        if (this.attachedToGroup_ != null) {
            out.print("\" group=\"");
            out.print(this.attachedToGroup_);
        }
        if (this.members_.size() == 0 && this.tags_.size() == 0 && this.nvPairs_.size() == 0 && (this.desc_ == null || this.desc_.trim().equals(""))) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up();
        if (this.desc_ != null && !this.desc_.trim().equals("")) {
            ind.indent();
            out.print("<descrip>");
            out.print(CharacterEntityMapper.mapEntities(this.desc_, false));
            out.println("</descrip>");
        }
        if (this.members_.size() != 0) {
            ind.indent();
            out.println("<modMembers>");
            Iterator mi = this.members_.iterator();
            ind.up();
            while (mi.hasNext()) {
                NetModuleMember mem = (NetModuleMember)mi.next();
                mem.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</modMembers>");
        }
        if (this.tags_.size() != 0) {
            ind.indent();
            out.println("<modTags>");
            Iterator ti = this.tags_.iterator();
            ind.up();
            while (ti.hasNext()) {
                ind.indent();
                String tag = (String)ti.next();
                out.print("<modTag>");
                out.print(CharacterEntityMapper.mapEntities(tag, false));
                out.println("</modTag>");
            }
            ind.down().indent();
            out.println("</modTags>");
        }
        if (this.nvPairs_.size() != 0) {
            this.nvPairs_.writeXML(out, ind);
        }
        ind.down().indent();
        out.println("</netModule>");
    }

    public void changeUndo(NetModuleChange undo) {
        if (undo.tagsOrig != null && undo.tagsNew != null) {
            this.tags_.clear();
            this.tags_.addAll(undo.tagsOrig);
        } else {
            if (undo.nmmOrig != null && undo.nmmNew != null) {
                throw new IllegalArgumentException();
            }
            if (undo.nmmOrig == null && undo.nmmNew != null) {
                this.members_.remove(undo.nmmNew);
            } else if (undo.nmmOrig != null && undo.nmmNew == null) {
                this.members_.add(undo.nmmOrig.clone());
            } else if (undo.detachedGroup != null) {
                this.attachedToGroup_ = undo.detachedGroup;
            } else {
                if (undo.nameChange) {
                    this.name_ = undo.nameOrig;
                }
                if (undo.descChange) {
                    this.desc_ = undo.descOrig;
                }
            }
        }
    }

    public void changeRedo(NetModuleChange redo) {
        if (redo.tagsOrig != null && redo.tagsNew != null) {
            this.tags_.clear();
            this.tags_.addAll(redo.tagsNew);
        } else {
            if (redo.nmmOrig != null && redo.nmmNew != null) {
                throw new IllegalArgumentException();
            }
            if (redo.nmmOrig == null && redo.nmmNew != null) {
                this.members_.add(redo.nmmNew.clone());
            } else if (redo.nmmOrig != null && redo.nmmNew == null) {
                this.members_.remove(redo.nmmOrig);
            } else if (redo.detachedGroup != null) {
                this.attachedToGroup_ = null;
            } else {
                if (redo.nameChange) {
                    this.name_ = redo.nameNew;
                }
                if (redo.descChange) {
                    this.desc_ = redo.descNew;
                }
            }
        }
    }

    private NetModule() {
    }

    public static class FullModuleKey
    implements Cloneable {
        public int ownerType;
        public String ownerKey;
        public String ovrKey;
        public String modKey;

        public FullModuleKey(int ownerType, String ownerKey, String ovrKey, String modKey) {
            this.ownerType = ownerType;
            this.ownerKey = ownerKey;
            this.ovrKey = ovrKey;
            this.modKey = modKey;
        }

        public String toString() {
            return "FullModuleKey owner = " + this.ownerType + " " + this.ownerKey + " " + this.ovrKey + " " + this.modKey;
        }

        public int hashCode() {
            return this.ownerKey.hashCode() + this.ovrKey.hashCode() + (this.modKey == null ? 0 : this.modKey.hashCode()) + this.ownerType;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof FullModuleKey)) {
                return false;
            }
            FullModuleKey otherFMK = (FullModuleKey)other;
            if (this.modKey == null ? otherFMK.modKey != null : !this.modKey.equals(otherFMK.modKey)) {
                return false;
            }
            if (!this.ovrKey.equals(otherFMK.ovrKey)) {
                return false;
            }
            if (!this.ownerKey.equals(otherFMK.ownerKey)) {
                return false;
            }
            return this.ownerType == otherFMK.ownerType;
        }

        public Object clone() {
            try {
                return (FullModuleKey)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException();
            }
        }
    }

    public static class MyNVGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetModule currMod = board.netMod;
            currMod.setNVPairs((NameValuePairList)kidObj);
            return null;
        }
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetOverlayOwner owner = board.genome != null ? board.genome : board.prox;
            String ownerID = owner.getID();
            int ownerType = board.genomeType;
            NetworkOverlay netOvr = board.netOvr;
            NetModule currMod = board.netMod;
            currMod.addMember((NetModuleMember)kidObj, ownerID, ownerType, netOvr.getID());
            return null;
        }
    }

    public static class NetModuleWorker
    extends AbstractFactoryClient {
        private StringBuffer charBuf_;

        public NetModuleWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("netModule");
            this.installWorker(new NetModuleMember.NetModuleMemberWorker(whiteboard), new MyGlue());
            this.installWorker(new NameValuePairList.NameValPairListWorker(whiteboard), new MyNVGlue());
            this.charBuf_ = new StringBuffer();
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetModule retval = null;
            if (elemName.equals("netModule")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.netMod = this.buildFromXML(elemName, attrs);
            } else if (elemName.equals("descrip")) {
                this.charBuf_.setLength(0);
            } else if (elemName.equals("modTag")) {
                this.charBuf_.setLength(0);
            }
            return retval;
        }

        protected void localFinishElement(String elemName) throws IOException {
            if (elemName.equals("descrip")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                board.netMod.setDescription(CharacterEntityMapper.unmapEntities(this.charBuf_.toString(), false));
            } else if (elemName.equals("modTag")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                board.netMod.addTag(CharacterEntityMapper.unmapEntities(this.charBuf_.toString(), false));
            }
        }

        protected void localProcessCharacters(char[] chars, int start, int length) {
            String nextString = new String(chars, start, length);
            this.charBuf_.append(nextString);
        }

        private NetModule buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "netModule", "id", true);
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "netModule", "name", true);
            String groupID = AttributeExtractor.extractAttribute(elemName, attrs, "netModule", "group", false);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return new NetModule(id, name, null, groupID);
        }
    }
}

