/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.ui.freerender.NetModuleLinkageFree;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class NetModuleLinkage
implements Cloneable {
    public static final int NEGATIVE = -1;
    public static final int NONE = 0;
    public static final int POSITIVE = 1;
    private static final int NUM_SIGNS_ = 3;
    public static final int DEFAULT_SIGN_INDEX = 2;
    public static final String NEGATIVE_STR = "negative";
    public static final String NONE_STR = "neutral";
    public static final String POSITIVE_STR = "positive";
    private static NetModuleLinkageFree freeRender_ = new NetModuleLinkageFree();
    private String id_;
    private int sign_;
    private String srcModuleID_;
    private String trgModuleID_;

    public NetModuleLinkage(NetModuleLinkage other) {
        this.id_ = other.id_;
        this.sign_ = other.sign_;
        this.srcModuleID_ = other.srcModuleID_;
        this.trgModuleID_ = other.trgModuleID_;
    }

    public NetModuleLinkage(NetModuleLinkage other, String newID) {
        this.id_ = newID;
        this.sign_ = other.sign_;
        this.srcModuleID_ = other.srcModuleID_;
        this.trgModuleID_ = other.trgModuleID_;
    }

    public NetModuleLinkage(NetModuleLinkage other, String newID, Map moduleMap) {
        this.id_ = newID;
        this.sign_ = other.sign_;
        this.srcModuleID_ = (String)moduleMap.get(other.srcModuleID_);
        this.trgModuleID_ = (String)moduleMap.get(other.trgModuleID_);
        if (this.srcModuleID_ == null || this.trgModuleID_ == null) {
            throw new IllegalStateException();
        }
    }

    public NetModuleLinkage(String id, String srcModuleID, String trgModuleID, int sign) {
        this.id_ = id;
        this.sign_ = sign;
        this.srcModuleID_ = srcModuleID;
        this.trgModuleID_ = trgModuleID;
    }

    public Object clone() {
        try {
            NetModuleLinkage retval = (NetModuleLinkage)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public String getID() {
        return this.id_;
    }

    public String getSource() {
        return this.srcModuleID_;
    }

    public String getTarget() {
        return this.trgModuleID_;
    }

    public int getSign() {
        return this.sign_;
    }

    public void setSign(int sign) {
        this.sign_ = sign;
    }

    public NetModuleLinkageFree getRenderer() {
        return freeRender_;
    }

    public String toString() {
        return "NetModuleLinkage: id = " + this.id_ + " sign = " + this.sign_ + " src = " + this.srcModuleID_ + " trg = " + this.trgModuleID_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<netModuleLink id=\"");
        out.print(this.id_);
        out.print("\" sign=\"");
        out.print(NetModuleLinkage.mapToSignTag(this.sign_));
        out.print("\" src=\"");
        out.print(this.srcModuleID_);
        out.print("\" trg=\"");
        out.print(this.trgModuleID_);
        out.println("\" />");
    }

    public static Vector getLinkSigns() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = -1; i <= 1; ++i) {
            retval.add(NetModuleLinkage.signForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent signForCombo(int sign) {
        return new ChoiceContent(NetModuleLinkage.mapSignToDisplay(sign), sign);
    }

    public static String mapSignToDisplay(int sign) {
        String signTag = NetModuleLinkage.mapToSignTag(sign);
        return ResourceManager.getManager().getString("nModLink." + signTag);
    }

    public static String mapToSignTag(int val) {
        switch (val) {
            case -1: {
                return NEGATIVE_STR;
            }
            case 0: {
                return NONE_STR;
            }
            case 1: {
                return POSITIVE_STR;
            }
        }
        throw new IllegalStateException();
    }

    public static int mapFromSignTag(String tag) {
        if (tag.equals(NEGATIVE_STR)) {
            return -1;
        }
        if (tag.equals(NONE_STR)) {
            return 0;
        }
        if (tag.equals(POSITIVE_STR)) {
            return 1;
        }
        throw new IllegalArgumentException();
    }

    private NetModuleLinkage() {
    }

    public static class NetModuleLinkageWorker
    extends AbstractFactoryClient {
        public NetModuleLinkageWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("netModuleLink");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetModuleLinkage retval = null;
            if (elemName.equals("netModuleLink")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.netModLink = this.buildFromXML(elemName, attrs);
            }
            return retval;
        }

        private NetModuleLinkage buildFromXML(String elemName, Attributes attrs) throws IOException {
            int sign;
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "netModuleLink", "id", true);
            String src = AttributeExtractor.extractAttribute(elemName, attrs, "netModuleLink", "src", true);
            String signTag = AttributeExtractor.extractAttribute(elemName, attrs, "netModuleLink", "sign", true);
            String trg = AttributeExtractor.extractAttribute(elemName, attrs, "netModuleLink", "trg", true);
            try {
                sign = NetModuleLinkage.mapFromSignTag(signTag);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException();
            }
            return new NetModuleLinkage(id, src, trg, sign);
        }
    }
}

