/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.DBGenome;
import org.systemsbiology.biotapestry.genome.FactoryWhiteboard;
import org.systemsbiology.biotapestry.genome.NetModule;
import org.systemsbiology.biotapestry.genome.NetModuleLinkage;
import org.systemsbiology.biotapestry.genome.NetModuleMember;
import org.systemsbiology.biotapestry.genome.NetOverlayOwner;
import org.systemsbiology.biotapestry.genome.NetworkOverlayChange;
import org.systemsbiology.biotapestry.parser.AbstractFactoryClient;
import org.systemsbiology.biotapestry.parser.GlueStick;
import org.systemsbiology.biotapestry.ui.freerender.NetOverlayFree;
import org.systemsbiology.biotapestry.util.AttributeExtractor;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.TaggedSet;
import org.xml.sax.Attributes;

public class NetworkOverlay
implements Cloneable {
    public static final int DB_GENOME = 0;
    public static final int GENOME_INSTANCE = 1;
    public static final int DYNAMIC_PROXY = 2;
    private static NetOverlayFree freeRender_ = new NetOverlayFree();
    private String id_;
    private String name_;
    private String desc_;
    private ArrayList modules_;
    private ArrayList linkages_;
    private TaggedSet firstViewMods_;
    private TaggedSet firstViewRevs_;

    public NetworkOverlay(NetworkOverlay other) {
        this.id_ = other.id_;
        this.name_ = other.name_;
        this.desc_ = other.desc_;
        this.modules_ = new ArrayList();
        Iterator mit = other.modules_.iterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            this.modules_.add(mod.clone());
        }
        this.linkages_ = new ArrayList();
        Iterator lit = other.linkages_.iterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            this.linkages_.add(link.clone());
        }
        this.firstViewMods_ = other.firstViewMods_ == null ? null : (TaggedSet)other.firstViewMods_.clone();
        this.firstViewRevs_ = other.firstViewRevs_ == null ? null : (TaggedSet)other.firstViewRevs_.clone();
    }

    public NetworkOverlay(NetworkOverlay other, String newID) {
        this.id_ = newID;
        this.name_ = other.name_;
        this.desc_ = other.desc_;
        this.modules_ = new ArrayList();
        Iterator mit = other.modules_.iterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            this.modules_.add(mod.clone());
        }
        this.linkages_ = new ArrayList();
        Iterator lit = other.linkages_.iterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            this.linkages_.add(link.clone());
        }
        this.firstViewMods_ = other.firstViewMods_ == null ? null : (TaggedSet)other.firstViewMods_.clone();
        this.firstViewRevs_ = other.firstViewRevs_ == null ? null : (TaggedSet)other.firstViewRevs_.clone();
    }

    public NetworkOverlay(NetworkOverlay other, String newID, Map groupMap, Map nodeMap, Map modIDMap, Map linkIDMap) {
        String mapModID;
        String modID;
        Iterator fit;
        this.id_ = newID;
        this.name_ = other.name_;
        this.desc_ = other.desc_;
        this.modules_ = new ArrayList();
        Iterator mit = other.modules_.iterator();
        DBGenome rootGenome = (DBGenome)Database.getDB().getGenome();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String newModID = rootGenome.getNextKey();
            modIDMap.put(mod.getID(), newModID);
            NetModule newMod = new NetModule(mod, newModID, groupMap, nodeMap);
            this.modules_.add(newMod);
        }
        this.linkages_ = new ArrayList();
        Iterator lit = other.linkages_.iterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            String newLinkID = rootGenome.getNextKey();
            linkIDMap.put(link.getID(), newLinkID);
            NetModuleLinkage newLink = new NetModuleLinkage(link, newLinkID, modIDMap);
            this.linkages_.add(newLink);
        }
        TaggedSet taggedSet = this.firstViewMods_ = other.firstViewMods_ == null ? null : new TaggedSet();
        if (this.firstViewMods_ != null) {
            this.firstViewMods_.tag = other.firstViewMods_.tag;
            fit = other.firstViewMods_.set.iterator();
            while (fit.hasNext()) {
                modID = (String)fit.next();
                mapModID = (String)modIDMap.get(modID);
                this.firstViewMods_.set.add(mapModID);
            }
        }
        TaggedSet taggedSet2 = this.firstViewRevs_ = other.firstViewRevs_ == null ? null : new TaggedSet();
        if (this.firstViewRevs_ != null) {
            this.firstViewRevs_.tag = other.firstViewRevs_.tag;
            fit = other.firstViewRevs_.set.iterator();
            while (fit.hasNext()) {
                modID = (String)fit.next();
                mapModID = (String)modIDMap.get(modID);
                this.firstViewRevs_.set.add(mapModID);
            }
        }
    }

    public NetworkOverlay(String id, String name, String desc) {
        this.id_ = id;
        this.name_ = name;
        this.desc_ = desc;
        this.modules_ = new ArrayList();
        this.linkages_ = new ArrayList();
        this.firstViewMods_ = null;
        this.firstViewRevs_ = null;
    }

    public NetworkOverlayChange setAsFirstView(TaggedSet firstView, TaggedSet firstRev, String noOwnerKey, int ownerMode) {
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmNew = null;
        retval.nmOrig = null;
        retval.nameChange = false;
        retval.descChange = false;
        retval.firstViewChanged = true;
        retval.firstViewModOrig = this.firstViewMods_ == null ? null : (TaggedSet)this.firstViewMods_.clone();
        this.firstViewMods_ = firstView == null ? null : (TaggedSet)firstView.clone();
        this.firstViewMods_.tag = -1;
        retval.firstViewModNew = this.firstViewMods_ == null ? null : (TaggedSet)this.firstViewMods_.clone();
        retval.firstViewRevOrig = this.firstViewRevs_ == null ? null : (TaggedSet)this.firstViewRevs_.clone();
        this.firstViewRevs_ = firstRev == null ? null : (TaggedSet)firstRev.clone();
        this.firstViewRevs_.tag = -1;
        retval.firstViewRevNew = this.firstViewRevs_ == null ? null : (TaggedSet)this.firstViewRevs_.clone();
        return retval;
    }

    public void loadForFirstViewMods(TaggedSet firstViewMods) {
        this.firstViewMods_ = firstViewMods;
        this.firstViewRevs_ = new TaggedSet();
    }

    public void loadForFirstViewRevs(TaggedSet firstViewRevs) {
        this.firstViewRevs_ = firstViewRevs;
    }

    public boolean getFirstViewState(TaggedSet firstView, TaggedSet firstViewRevs) {
        if (this.firstViewMods_ == null) {
            return false;
        }
        firstView.tag = this.firstViewMods_.tag;
        firstView.set.clear();
        firstView.set.addAll(this.firstViewMods_.set);
        firstViewRevs.tag = this.firstViewRevs_.tag;
        firstViewRevs.set.clear();
        firstViewRevs.set.addAll(this.firstViewRevs_.set);
        return true;
    }

    public NetworkOverlayChange clearAsFirstView(String noOwnerKey, int ownerMode) {
        this.firstViewMods_ = null;
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmNew = null;
        retval.nmOrig = null;
        retval.nameChange = false;
        retval.descChange = false;
        retval.firstViewChanged = true;
        retval.firstViewModOrig = this.firstViewMods_ == null ? null : (TaggedSet)this.firstViewMods_.clone();
        retval.firstViewRevOrig = this.firstViewRevs_ == null ? null : (TaggedSet)this.firstViewRevs_.clone();
        this.firstViewMods_ = null;
        retval.firstViewModNew = null;
        retval.firstViewRevNew = null;
        return retval;
    }

    public Object clone() {
        try {
            NetworkOverlay retval = (NetworkOverlay)super.clone();
            retval.modules_ = new ArrayList();
            Iterator mit = this.modules_.iterator();
            while (mit.hasNext()) {
                NetModule mem = (NetModule)mit.next();
                retval.modules_.add(mem.clone());
            }
            retval.linkages_ = new ArrayList();
            Iterator lit = this.linkages_.iterator();
            while (lit.hasNext()) {
                NetModuleLinkage link = (NetModuleLinkage)lit.next();
                retval.linkages_.add(link.clone());
            }
            retval.firstViewMods_ = this.firstViewMods_ == null ? null : (TaggedSet)this.firstViewMods_.clone();
            retval.firstViewRevs_ = this.firstViewRevs_ == null ? null : (TaggedSet)this.firstViewRevs_.clone();
            return retval;
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException();
        }
    }

    public NetworkOverlay getMemberStrippedOverlay() {
        NetworkOverlay retval = new NetworkOverlay(this.id_, this.name_, this.desc_);
        Iterator mit = this.modules_.iterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            NetModule newMod = (NetModule)mod.clone();
            newMod.dropAllMembers();
            newMod.setGroupAttachment(null);
            retval.modules_.add(newMod);
        }
        retval.firstViewMods_ = this.firstViewMods_ == null ? null : (TaggedSet)this.firstViewMods_.clone();
        retval.firstViewRevs_ = this.firstViewRevs_ == null ? null : (TaggedSet)this.firstViewRevs_.clone();
        Iterator lit = this.linkages_.iterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            retval.linkages_.add(link.clone());
        }
        return retval;
    }

    public void recoverMappedMembersAndGroups(NetworkOverlay legacy, Map oldNodeToNew, Map oldGroupToNew) {
        Iterator mit = legacy.modules_.iterator();
        while (mit.hasNext()) {
            NetModule legMod = (NetModule)mit.next();
            String modID = legMod.getID();
            NetModule myMod = this.getModule(modID);
            Iterator memit = legMod.getMemberIterator();
            while (memit.hasNext()) {
                NetModuleMember nmm = (NetModuleMember)memit.next();
                String oldID = nmm.getID();
                String newID = (String)oldNodeToNew.get(oldID);
                if (newID == null) continue;
                NetModuleMember nmmNew = new NetModuleMember(newID);
                myMod.addMember(nmmNew);
            }
            String legacyGroup = legMod.getGroupAttachment();
            if (legacyGroup == null) continue;
            String newGroup = (String)oldGroupToNew.get(legacyGroup);
            myMod.setGroupAttachment(newGroup);
        }
    }

    public boolean fillMapForGroupExtraction(String grpID, Map extractMap, int ownerMode, String ownerID) {
        boolean retval = false;
        Iterator mit = this.modules_.iterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String mga = mod.getGroupAttachment();
            if (mga == null || !mga.equals(grpID)) continue;
            retval = true;
            String modID = mod.getID();
            NetModule.FullModuleKey fullKey = new NetModule.FullModuleKey(ownerMode, ownerID, this.id_, modID);
            extractMap.put(fullKey, fullKey);
        }
        return retval;
    }

    public void getModulesAttachedToGroup(String grpID, int ownerType, String ownerKey, Set attached) {
        Iterator mit = this.modules_.iterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            String mga = mod.getGroupAttachment();
            if (mga == null || !mga.equals(grpID)) continue;
            NetModule.FullModuleKey fullKey = new NetModule.FullModuleKey(ownerType, ownerKey, this.id_, mod.getID());
            attached.add(fullKey);
        }
    }

    public String getID() {
        return this.id_;
    }

    public String getName() {
        return this.name_;
    }

    public void setDescription(String desc) {
        this.desc_ = desc;
    }

    public String getDescription() {
        return this.desc_;
    }

    public NetworkOverlayChange changeNameAndDescription(String name, String desc, String noOwnerKey, int ownerMode) {
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmNew = null;
        retval.nmOrig = null;
        retval.nameOrig = this.name_;
        retval.nameNew = this.name_ = name;
        retval.descOrig = this.desc_;
        retval.descNew = this.desc_ = desc;
        retval.nameChange = true;
        retval.descChange = true;
        return retval;
    }

    public NetworkOverlayChange addNetModule(NetModule module, String noOwnerKey, int ownerMode) {
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmNew = (NetModule)module.clone();
        retval.nmOrig = null;
        retval.index = this.modules_.size();
        this.modules_.add(module);
        return retval;
    }

    public NetworkOverlayChange[] removeNetModule(String moduleID, String noOwnerKey, int ownerMode) {
        ArrayList<NetworkOverlayChange> changes = new ArrayList<NetworkOverlayChange>();
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmNew = null;
        Iterator gmit = this.getModuleIterator();
        int count = 0;
        while (gmit.hasNext()) {
            NetModule nm = (NetModule)gmit.next();
            if (nm.getID().equals(moduleID)) {
                retval.nmOrig = (NetModule)nm.clone();
                this.modules_.remove(nm);
                retval.index = count;
                changes.add(retval);
                break;
            }
            ++count;
        }
        if (!changes.isEmpty() && this.firstViewMods_ != null) {
            TaggedSet revisedMods = (TaggedSet)this.firstViewMods_.clone();
            TaggedSet revisedRevs = (TaggedSet)this.firstViewRevs_.clone();
            boolean doit = false;
            if (this.firstViewMods_.set.contains(moduleID)) {
                revisedMods.set.remove(moduleID);
                doit = true;
            }
            if (this.firstViewRevs_.set.contains(moduleID)) {
                revisedRevs.set.remove(moduleID);
                doit = true;
            }
            if (doit) {
                changes.add(this.setAsFirstView(revisedMods, revisedRevs, noOwnerKey, ownerMode));
            }
        }
        NetworkOverlayChange[] retvalArray = new NetworkOverlayChange[changes.size()];
        return changes.toArray(retvalArray);
    }

    public NetModule getModule(String id) {
        Iterator mit = this.modules_.iterator();
        while (mit.hasNext()) {
            NetModule mod = (NetModule)mit.next();
            if (!id.equals(mod.getID())) continue;
            return mod;
        }
        return null;
    }

    public Iterator getModuleIterator() {
        return this.modules_.iterator();
    }

    public int getModuleCount() {
        return this.modules_.size();
    }

    public NetworkOverlayChange addNetModuleLinkage(NetModuleLinkage link, String noOwnerKey, int ownerMode) {
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmlNew = (NetModuleLinkage)link.clone();
        retval.nmlOrig = null;
        retval.index = this.linkages_.size();
        this.linkages_.add(link);
        return retval;
    }

    public NetworkOverlayChange removeNetModuleLinkage(String linkID, String noOwnerKey, int ownerMode) {
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        retval.nmlNew = null;
        Iterator glit = this.getLinkageIterator();
        int count = 0;
        while (glit.hasNext()) {
            NetModuleLinkage nml = (NetModuleLinkage)glit.next();
            if (nml.getID().equals(linkID)) {
                retval.nmlOrig = (NetModuleLinkage)nml.clone();
                this.linkages_.remove(nml);
                retval.index = count;
                return retval;
            }
            ++count;
        }
        return retval;
    }

    public NetworkOverlayChange modifyNetModuleLinkage(String linkID, String noOwnerKey, int ownerMode, int newSign) {
        NetworkOverlayChange retval = new NetworkOverlayChange();
        retval.noOwnerKey = noOwnerKey;
        retval.ownerMode = ownerMode;
        retval.overlayKey = this.id_;
        Iterator glit = this.getLinkageIterator();
        int count = 0;
        while (glit.hasNext()) {
            NetModuleLinkage nml = (NetModuleLinkage)glit.next();
            if (nml.getID().equals(linkID)) {
                retval.nmlOrig = (NetModuleLinkage)nml.clone();
                nml.setSign(newSign);
                retval.index = count;
                retval.nmlNew = (NetModuleLinkage)nml.clone();
                return retval;
            }
            ++count;
        }
        return null;
    }

    public void getNetModuleLinkagesForModule(String moduleID, Set inLinks, Set outLinks) {
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            if (link.getSource().equals(moduleID)) {
                outLinks.add(link.getID());
            }
            if (!link.getTarget().equals(moduleID)) continue;
            inLinks.add(link.getID());
        }
    }

    public Set getNetModuleLinkagesBetweenModules(Set moduleIDs) {
        HashSet<String> retval = new HashSet<String>();
        Iterator lit = this.getLinkageIterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            String srcID = link.getSource();
            String trgID = link.getTarget();
            if (!moduleIDs.contains(srcID) || !moduleIDs.contains(trgID)) continue;
            retval.add(link.getID());
        }
        return retval;
    }

    public boolean linkIsFeedback(String linkID) {
        NetModuleLinkage link = this.getLinkage(linkID);
        return link.getSource().equals(link.getTarget());
    }

    public NetModuleLinkage getLinkage(String id) {
        Iterator lit = this.linkages_.iterator();
        while (lit.hasNext()) {
            NetModuleLinkage link = (NetModuleLinkage)lit.next();
            if (!id.equals(link.getID())) continue;
            return link;
        }
        return null;
    }

    public Iterator getLinkageIterator() {
        return this.linkages_.iterator();
    }

    public NetOverlayFree getRenderer() {
        return freeRender_;
    }

    public String toString() {
        return "NetOverlay: id = " + this.id_ + " name = " + this.name_ + " desc = " + this.desc_ + " modules = " + this.modules_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<netOverlay id=\"");
        out.print(this.id_);
        if (this.name_ != null) {
            out.print("\" name=\"");
            out.print(CharacterEntityMapper.mapEntities(this.name_, false));
        }
        if (this.modules_.size() == 0 && (this.desc_ == null || this.desc_.trim().equals(""))) {
            out.println("\" />");
            return;
        }
        out.println("\" >");
        ind.up();
        if (this.desc_ != null && !this.desc_.trim().equals("")) {
            ind.indent();
            out.print("<descrip>");
            out.print(CharacterEntityMapper.mapEntities(this.desc_, false));
            out.println("</descrip>");
        }
        if (this.modules_.size() != 0) {
            ind.indent();
            out.println("<netModules>");
            Iterator mi = this.modules_.iterator();
            ind.up();
            while (mi.hasNext()) {
                NetModule mod = (NetModule)mi.next();
                mod.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</netModules>");
        }
        if (this.linkages_.size() != 0) {
            ind.indent();
            out.println("<netModuleLinks>");
            Iterator li = this.linkages_.iterator();
            ind.up();
            while (li.hasNext()) {
                NetModuleLinkage link = (NetModuleLinkage)li.next();
                link.writeXML(out, ind);
            }
            ind.down().indent();
            out.println("</netModuleLinks>");
        }
        if (this.firstViewMods_ != null) {
            ind.indent();
            if (this.firstViewMods_.set.isEmpty()) {
                out.println("<startupMods/>");
            } else {
                out.println("<startupMods>");
                ind.up();
                this.firstViewMods_.writeXML(out, ind);
                ind.down().indent();
                out.println("</startupMods>");
            }
            ind.indent();
            if (this.firstViewRevs_.set.isEmpty()) {
                out.println("<startupViz/>");
            } else {
                out.println("<startupViz>");
                ind.up();
                this.firstViewRevs_.writeXML(out, ind);
                ind.down().indent();
                out.println("</startupViz>");
            }
        }
        ind.down().indent();
        out.println("</netOverlay>");
    }

    public void changeUndo(NetworkOverlayChange undo) {
        if (undo.nmOrig != null && undo.nmNew != null) {
            throw new IllegalArgumentException();
        }
        if (undo.nmOrig == null && undo.nmNew != null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(undo.nmNew.getID());
            this.modules_.remove(undo.index);
        } else if (undo.nmOrig != null && undo.nmNew == null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(undo.nmOrig.getID());
            this.modules_.add(undo.index, undo.nmOrig.clone());
        } else if (undo.nmlOrig != null && undo.nmlNew != null) {
            this.linkages_.set(undo.index, undo.nmlOrig.clone());
        } else if (undo.nmlOrig == null && undo.nmlNew != null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(undo.nmlNew.getID());
            this.linkages_.remove(undo.index);
        } else if (undo.nmlOrig != null && undo.nmlNew == null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(undo.nmlOrig.getID());
            this.linkages_.add(undo.index, undo.nmlOrig.clone());
        } else if (undo.firstViewChanged) {
            this.firstViewMods_ = undo.firstViewModOrig == null ? null : (TaggedSet)undo.firstViewModOrig.clone();
            this.firstViewRevs_ = undo.firstViewRevOrig == null ? null : (TaggedSet)undo.firstViewRevOrig.clone();
        } else {
            if (undo.nameChange) {
                this.name_ = undo.nameOrig;
            }
            if (undo.descChange) {
                this.desc_ = undo.descOrig;
            }
        }
    }

    public void changeRedo(NetworkOverlayChange redo) {
        if (redo.nmOrig != null && redo.nmNew != null) {
            throw new IllegalArgumentException();
        }
        if (redo.nmOrig == null && redo.nmNew != null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(redo.nmNew.getID());
            this.modules_.add(redo.index, redo.nmNew.clone());
        } else if (redo.nmOrig != null && redo.nmNew == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(redo.nmOrig.getID());
            this.modules_.remove(redo.index);
        } else if (redo.nmlOrig != null && redo.nmlNew != null) {
            this.linkages_.set(redo.index, redo.nmlNew.clone());
        } else if (redo.nmlOrig == null && redo.nmlNew != null) {
            ((DBGenome)Database.getDB().getGenome()).addKey(redo.nmlNew.getID());
            this.linkages_.add(redo.index, redo.nmlNew.clone());
        } else if (redo.nmlOrig != null && redo.nmlNew == null) {
            ((DBGenome)Database.getDB().getGenome()).removeKey(redo.nmlOrig.getID());
            this.linkages_.remove(redo.index);
        } else if (redo.firstViewChanged) {
            this.firstViewMods_ = redo.firstViewModNew == null ? null : (TaggedSet)redo.firstViewModNew.clone();
            this.firstViewRevs_ = redo.firstViewRevNew == null ? null : (TaggedSet)redo.firstViewRevNew.clone();
        } else {
            if (redo.nameChange) {
                this.name_ = redo.nameNew;
            }
            if (redo.descChange) {
                this.desc_ = redo.descNew;
            }
        }
    }

    private NetworkOverlay() {
    }

    public static class MyTSFVGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetOverlayOwner owner = board.genome != null ? board.genome : board.prox;
            NetworkOverlay netOvr = board.netOvr;
            NetModuleLinkage currLink = board.netModLink;
            TaggedSet tSet = board.currentTaggedSet;
            netOvr.loadForFirstViewRevs(tSet);
            return null;
        }
    }

    public static class MyTSFMGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetOverlayOwner owner = board.genome != null ? board.genome : board.prox;
            NetworkOverlay netOvr = board.netOvr;
            NetModuleLinkage currLink = board.netModLink;
            TaggedSet tSet = board.currentTaggedSet;
            netOvr.loadForFirstViewMods(tSet);
            return null;
        }
    }

    public static class FirstVizWorker
    extends AbstractFactoryClient {
        public FirstVizWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("startupViz");
            this.installWorker(new TaggedSet.TaggedSetWorker(whiteboard), new MyTSFVGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }

    public static class FirstModWorker
    extends AbstractFactoryClient {
        public FirstModWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("startupMods");
            this.installWorker(new TaggedSet.TaggedSetWorker(whiteboard), new MyTSFMGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            return null;
        }
    }

    public static class MyLinkageGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetOverlayOwner owner = board.genome != null ? board.genome : board.prox;
            NetworkOverlay netOvr = board.netOvr;
            NetModuleLinkage currLink = board.netModLink;
            owner.addNetworkModuleLinkageAndKey(netOvr.getID(), currLink);
            return null;
        }
    }

    public static class MyGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            FactoryWhiteboard board = (FactoryWhiteboard)optionalArgs;
            NetOverlayOwner owner = board.genome != null ? board.genome : board.prox;
            NetworkOverlay netOvr = board.netOvr;
            NetModule currMod = board.netMod;
            owner.addNetworkModuleAndKey(netOvr.getID(), currMod);
            return null;
        }
    }

    public static class NetOverlayWorker
    extends AbstractFactoryClient {
        private StringBuffer charBuf_;

        public NetOverlayWorker(FactoryWhiteboard whiteboard) {
            super(whiteboard);
            this.myKeys_.add("netOverlay");
            this.installWorker(new NetModule.NetModuleWorker(whiteboard), new MyGlue());
            this.installWorker(new NetModuleLinkage.NetModuleLinkageWorker(whiteboard), new MyLinkageGlue());
            this.installWorker(new FirstModWorker(whiteboard), null);
            this.installWorker(new FirstVizWorker(whiteboard), null);
            this.charBuf_ = new StringBuffer();
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            NetworkOverlay retval = null;
            if (elemName.equals("netOverlay")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                retval = board.netOvr = this.buildFromXML(elemName, attrs);
            } else if (elemName.equals("descrip")) {
                this.charBuf_.setLength(0);
            }
            return retval;
        }

        protected void localFinishElement(String elemName) throws IOException {
            if (elemName.equals("descrip")) {
                FactoryWhiteboard board = (FactoryWhiteboard)this.sharedWhiteboard_;
                board.netOvr.setDescription(CharacterEntityMapper.unmapEntities(this.charBuf_.toString(), false));
            }
        }

        protected void localProcessCharacters(char[] chars, int start, int length) {
            String nextString = new String(chars, start, length);
            this.charBuf_.append(nextString);
        }

        private NetworkOverlay buildFromXML(String elemName, Attributes attrs) throws IOException {
            String id = AttributeExtractor.extractAttribute(elemName, attrs, "netOverlay", "id", true);
            String name = AttributeExtractor.extractAttribute(elemName, attrs, "netOverlay", "name", true);
            name = CharacterEntityMapper.unmapEntities(name, false);
            return new NetworkOverlay(id, name, null);
        }
    }
}

