/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biotapestry.genome;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.systemsbiology.biotapestry.db.Database;
import org.systemsbiology.biotapestry.genome.CommonGenomeItemCode;
import org.systemsbiology.biotapestry.genome.DBGenomeItem;
import org.systemsbiology.biotapestry.genome.DBNode;
import org.systemsbiology.biotapestry.genome.Genome;
import org.systemsbiology.biotapestry.genome.GenomeInstance;
import org.systemsbiology.biotapestry.genome.GenomeItemInstance;
import org.systemsbiology.biotapestry.genome.GroupMembership;
import org.systemsbiology.biotapestry.genome.Node;
import org.systemsbiology.biotapestry.util.CharacterEntityMapper;
import org.systemsbiology.biotapestry.util.ChoiceContent;
import org.systemsbiology.biotapestry.util.Indenter;
import org.systemsbiology.biotapestry.util.ResourceManager;
import org.xml.sax.Attributes;

public class NodeInstance
extends GenomeItemInstance
implements Node {
    public static final int VESTIGIAL = 3;
    private static final int NUM_ACTIVITY_LEVELS_ = 4;
    private static final String BARE_TAG_ = "bareInstance";
    private static final String BOX_TAG_ = "boxInstance";
    private static final String BUBBLE_TAG_ = "bubbleInstance";
    private static final String INTERCELL_TAG_ = "intercelInstance";
    private static final String SLASH_TAG_ = "slashInstance";
    private static final String DIAMOND_TAG_ = "diamondInstance";
    private static final String INACTIVE_STR_ = "inactive";
    private static final String ACTIVE_STR_ = "active";
    private static final String VESTIGIAL_STR_ = "vestigial";
    private static final String VARIABLE_STR_ = "variable";
    protected int nodeType_;
    protected Double activityLevel_;
    protected int activity_;
    protected String nameOverride_;
    protected String description_;
    protected ArrayList urls_;

    public NodeInstance(NodeInstance other) {
        super(other);
        this.nodeType_ = other.nodeType_;
        this.activityLevel_ = other.activityLevel_;
        this.activity_ = other.activity_;
        this.nameOverride_ = other.nameOverride_;
        this.description_ = other.description_;
        this.urls_ = (ArrayList)other.urls_.clone();
    }

    public NodeInstance(NodeInstance other, int instance) {
        super(other, instance);
        this.nodeType_ = other.nodeType_;
        this.activityLevel_ = other.activityLevel_;
        this.activity_ = other.activity_;
        this.nameOverride_ = other.nameOverride_;
        this.description_ = other.description_;
        this.urls_ = (ArrayList)other.urls_.clone();
    }

    public NodeInstance(DBGenomeItem backing, int nodeType, int instance, Double activityLevel, int activity) {
        super(backing, instance);
        this.nodeType_ = nodeType;
        this.activityLevel_ = activityLevel;
        this.activity_ = activity;
        this.nameOverride_ = null;
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    public NodeInstance(DBGenomeItem backing, String elemName, String instance, String activityLevel, String activityType, String nameOverride) throws IOException {
        super(backing, instance);
        this.nameOverride_ = nameOverride;
        try {
            if (elemName != null) {
                this.nodeType_ = NodeInstance.mapFromElem(elemName);
            }
            this.activity_ = activityType != null ? NodeInstance.mapActivityTypeTag(activityType) : 0;
        }
        catch (IllegalArgumentException ex) {
            throw new IOException();
        }
        if (this.activity_ == 2) {
            if (activityLevel == null) {
                throw new IOException();
            }
            try {
                this.activityLevel_ = new Double(activityLevel);
            }
            catch (NumberFormatException nfe) {
                throw new IOException();
            }
        } else {
            this.activityLevel_ = null;
        }
        this.description_ = null;
        this.urls_ = new ArrayList();
    }

    public boolean fixupLegacyIOActivityBounds(GenomeInstance gi) {
        GenomeItemInstance.ActivityTracking nat = this.calcActivityBounds(gi);
        boolean retval = false;
        if (nat.parentActivity != null) {
            int parentNodeActivityVal = nat.parentActivity;
            if (!NodeInstance.activityLevelAllowedInChild(parentNodeActivityVal, this.getActivity())) {
                this.setActivity(parentNodeActivityVal);
                retval = true;
            }
            if (this.getActivity() == 2 && nat.parentActivityLevel != Double.NEGATIVE_INFINITY && this.getActivityLevel() > nat.parentActivityLevel) {
                this.setActivityLevel(nat.parentActivityLevel);
                retval = true;
            }
        }
        return retval;
    }

    public GenomeItemInstance.ActivityTracking calcActivityBounds(GenomeInstance gi) {
        Database db = Database.getDB();
        GenomeItemInstance.ActivityTracking retval = new GenomeItemInstance.ActivityTracking();
        retval.parentActivity = null;
        retval.parentActivityLevel = Double.NEGATIVE_INFINITY;
        retval.childActivities = null;
        retval.maxChildLevel = Double.NEGATIVE_INFINITY;
        GenomeInstance parent = gi.getVfgParent();
        if (parent != null) {
            NodeInstance parentNode = (NodeInstance)parent.getNode(this.getID());
            int parentAct = parentNode.getActivity();
            retval.parentActivity = new Integer(parentAct);
            if (parentAct == 2) {
                retval.parentActivityLevel = parentNode.getActivityLevel();
            }
        }
        Iterator git = db.getInstanceIterator();
        while (git.hasNext()) {
            double kidNodeActivityLevel;
            NodeInstance kidNode;
            GenomeInstance giKid = (GenomeInstance)git.next();
            if (giKid == gi || !gi.isAncestor(giKid) || (kidNode = (NodeInstance)giKid.getNode(this.getID())) == null) continue;
            if (retval.childActivities == null) {
                retval.childActivities = new HashSet();
            }
            int kidNodeActivity = kidNode.getActivity();
            retval.childActivities.add(new Integer(kidNodeActivity));
            if (kidNodeActivity != 2 || !((kidNodeActivityLevel = kidNode.getActivityLevel()) > retval.maxChildLevel)) continue;
            retval.maxChildLevel = kidNodeActivityLevel;
        }
        return retval;
    }

    public Object clone() {
        NodeInstance retval = (NodeInstance)super.clone();
        retval.urls_ = (ArrayList)this.urls_.clone();
        return retval;
    }

    public DBGenomeItem getBacking() {
        Database db = Database.getDB();
        DBGenomeItem retval = (DBGenomeItem)((Object)db.getGenome().getNode(this.myItemID_));
        if (retval == null) {
            retval = (DBGenomeItem)((Object)db.getHoldingGenome().getNode(this.myItemID_));
        }
        return retval;
    }

    public String getName() {
        if (this.nameOverride_ == null) {
            return super.getName();
        }
        return this.nameOverride_;
    }

    public void setNodeType(int type) {
        if (((DBNode)this.getBacking()).getNodeType() != type) {
            throw new IllegalStateException();
        }
        this.nodeType_ = type;
    }

    public String getRootName() {
        return this.getBacking().getName();
    }

    public String getOverrideName() {
        return this.nameOverride_;
    }

    public void overrideName(String name) {
        this.nameOverride_ = name;
    }

    public int getNodeType() {
        return this.nodeType_;
    }

    public int getActivity() {
        return this.activity_;
    }

    public void setActivity(int activity) {
        this.activity_ = activity;
        if (this.activity_ != 2) {
            this.activityLevel_ = null;
        }
    }

    public double getActivityLevel() {
        if (this.activity_ != 2 || this.activityLevel_ == null) {
            throw new IllegalStateException();
        }
        return this.activityLevel_;
    }

    public void setActivityLevel(double activity) {
        if (this.activity_ != 2) {
            throw new IllegalStateException();
        }
        if (activity < 0.0 || activity > 1.0) {
            throw new IllegalArgumentException();
        }
        this.activityLevel_ = new Double(activity);
    }

    public Iterator getURLs() {
        return this.urls_.iterator();
    }

    public int getURLCount() {
        return this.urls_.size();
    }

    public void setAllUrls(List urls) {
        this.urls_.clear();
        this.urls_.addAll(urls);
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public String getDisplayString(Genome genome, boolean typePreface) {
        GenomeInstance gi = (GenomeInstance)genome;
        GroupMembership member = gi.getNodeGroupMembership(this);
        String groupID = member.mainGroups.isEmpty() ? null : (String)member.mainGroups.iterator().next();
        String groupName = groupID == null ? "" : gi.getGroup(groupID).getInheritedDisplayName(gi);
        String format = ResourceManager.getManager().getString("ncreate.importFormatForInstance");
        String typeDisplay = DBNode.mapTypeToDisplay(this.nodeType_);
        String nodeMsg = MessageFormat.format(format, typeDisplay, this.getName(), groupName);
        return nodeMsg;
    }

    public String getDisplayStringGroupOnly(GenomeInstance gi) {
        GroupMembership member = gi.getNodeGroupMembership(this);
        String groupID = member.mainGroups.isEmpty() ? null : (String)member.mainGroups.iterator().next();
        String groupName = groupID == null ? "" : gi.getGroup(groupID).getInheritedDisplayName(gi);
        String format = ResourceManager.getManager().getString("ncreate.importFormatForInstanceGroup");
        String nodeMsg = MessageFormat.format(format, groupName);
        return nodeMsg;
    }

    public int getPadCount() {
        return ((DBNode)this.getBacking()).getPadCount();
    }

    public void addUrl(String url) {
        this.urls_.add(url);
    }

    public void appendDescription(String description) {
        this.description_ = this.description_ == null ? description : this.description_.concat(description);
        this.description_ = CharacterEntityMapper.unmapEntities(this.description_, false);
    }

    public String toString() {
        return "NodeInstance: type = " + NodeInstance.mapToElem(this.nodeType_) + " backing = " + this.getBacking() + " instance = " + this.instanceID_ + " activity = " + this.activityLevel_ + " activity = " + this.activity_ + " override = " + this.nameOverride_;
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        ind.indent();
        out.print("<");
        out.print(NodeInstance.mapToElem(this.nodeType_));
        out.print(" ref=\"");
        out.print(this.getBacking().getID());
        out.print("\" instance=\"");
        out.print(this.instanceID_);
        if (this.activity_ != 0) {
            out.print("\" activity=\"");
            out.print(NodeInstance.mapActivityTypes(this.activity_));
        }
        if (this.activityLevel_ != null) {
            out.print("\" activityLevel=\"");
            out.print(this.activityLevel_);
        }
        if (this.nameOverride_ != null) {
            out.print("\" name=\"");
            out.print(CharacterEntityMapper.mapEntities(this.nameOverride_, false));
        }
        if (!this.urls_.isEmpty() || this.description_ != null) {
            out.println("\" >");
            new CommonGenomeItemCode().writeDescUrlToXML(out, ind, this.urls_, this.description_, "nodeInstance");
            ind.indent();
            out.print("</");
            out.print(NodeInstance.mapToElem(this.nodeType_));
            out.println(">");
        } else {
            out.println("\" />");
        }
    }

    public static NodeInstance buildFromXML(Genome genome, String elemName, Attributes attrs) throws IOException {
        String ref = null;
        String instance = null;
        String activity = null;
        String activityLevelStr = null;
        String name = null;
        if (attrs != null) {
            int count = attrs.getLength();
            for (int i = 0; i < count; ++i) {
                String key = attrs.getQName(i);
                if (key == null) continue;
                String val = attrs.getValue(i);
                if (key.equals("ref")) {
                    ref = val;
                    continue;
                }
                if (key.equals("instance")) {
                    instance = val;
                    continue;
                }
                if (key.equals("activity")) {
                    activity = val;
                    continue;
                }
                if (key.equals("name")) {
                    name = CharacterEntityMapper.unmapEntities(val, false);
                    continue;
                }
                if (!key.equals("activityLevel")) continue;
                activityLevelStr = val;
            }
        }
        DBNode backing = (DBNode)((GenomeInstance)genome).getGenome().getNode(ref);
        return new NodeInstance(backing, elemName, instance, activityLevelStr, activity, name);
    }

    public static Set keywordsOfInterest() {
        HashSet<String> retval = new HashSet<String>();
        retval.add(BARE_TAG_);
        retval.add(BOX_TAG_);
        retval.add(BUBBLE_TAG_);
        retval.add(INTERCELL_TAG_);
        retval.add(SLASH_TAG_);
        retval.add(DIAMOND_TAG_);
        return retval;
    }

    public static String descriptionKeyword() {
        return "nodeInstanceFreeText";
    }

    public static String urlKeyword() {
        return "nodeInstanceURL";
    }

    public static Vector getActivityChoices() {
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        for (int i = 0; i < 4; ++i) {
            retval.add(NodeInstance.activityTypeForCombo(i));
        }
        return retval;
    }

    public static ChoiceContent activityTypeForCombo(int activityType) {
        return new ChoiceContent(ResourceManager.getManager().getString("nprop." + NodeInstance.mapActivityTypes(activityType)), activityType);
    }

    protected static String mapActivityTypes(int activityType) {
        switch (activityType) {
            case 1: {
                return INACTIVE_STR_;
            }
            case 0: {
                return ACTIVE_STR_;
            }
            case 3: {
                return VESTIGIAL_STR_;
            }
            case 2: {
                return VARIABLE_STR_;
            }
        }
        throw new IllegalStateException();
    }

    protected static int mapActivityTypeTag(String activityTag) {
        if (activityTag.equalsIgnoreCase(INACTIVE_STR_)) {
            return 1;
        }
        if (activityTag.equalsIgnoreCase(ACTIVE_STR_)) {
            return 0;
        }
        if (activityTag.equalsIgnoreCase(VESTIGIAL_STR_)) {
            return 3;
        }
        if (activityTag.equalsIgnoreCase(VARIABLE_STR_)) {
            return 2;
        }
        throw new IllegalArgumentException();
    }

    public static boolean activityLevelAllowedInChild(int parentActivity, int childActivity) {
        switch (parentActivity) {
            case 0: {
                return true;
            }
            case 1: {
                return childActivity == 1;
            }
            case 2: {
                return childActivity == 2 || childActivity == 1;
            }
            case 3: {
                return childActivity == 3 || childActivity == 1;
            }
        }
        throw new IllegalArgumentException();
    }

    protected NodeInstance() {
    }

    private static int mapFromElem(String elemTag) {
        if (elemTag == null) {
            throw new IllegalArgumentException();
        }
        if (elemTag.equals(BARE_TAG_)) {
            return 1;
        }
        if (elemTag.equals(BOX_TAG_)) {
            return 2;
        }
        if (elemTag.equals(BUBBLE_TAG_)) {
            return 3;
        }
        if (elemTag.equals(INTERCELL_TAG_)) {
            return 5;
        }
        if (elemTag.equals(SLASH_TAG_)) {
            return 6;
        }
        if (elemTag.equals(DIAMOND_TAG_)) {
            return 7;
        }
        throw new IllegalArgumentException();
    }

    private static String mapToElem(int nodeType) {
        switch (nodeType) {
            case 1: {
                return BARE_TAG_;
            }
            case 2: {
                return BOX_TAG_;
            }
            case 3: {
                return BUBBLE_TAG_;
            }
            case 5: {
                return INTERCELL_TAG_;
            }
            case 6: {
                return SLASH_TAG_;
            }
            case 7: {
                return DIAMOND_TAG_;
            }
        }
        throw new IllegalStateException();
    }
}

